/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.form.modules.index;

import com.seeyon.apps.index.bo.AuthorizationInfo;
import com.seeyon.apps.index.bo.IndexInfo;
import com.seeyon.apps.index.manager.IndexEnable;
import com.seeyon.ctp.cap.api.bean.CAPFormBean;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.form.modules.index.FormIndex4UnFlow;
import com.seeyon.ctp.form.modules.index.FormIndexModuleType;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormIndex4Form
implements IndexEnable {
    private static final Log log = CtpLogFactory.getLog(FormIndex4Form.class);
    private FormCacheManager formCacheManager;
    private CAPFormManager capFormManager;

    public CAPFormManager getCapFormManager() {
        return this.capFormManager;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public Integer getAppEnumKey() {
        return ApplicationCategoryEnum.form.getKey();
    }

    public IndexInfo getIndexInfo(Long id) throws BusinessException {
        Long formId;
        CAPFormBean capFormBean;
        FormIndex4UnFlow formIndex4UnFlow = (FormIndex4UnFlow)AppContext.getBean((String)"formIndex4UnFlow");
        Map map = formIndex4UnFlow.findFormIndexModuleType(id, true);
        IndexInfo info = new IndexInfo();
        IndexInfo info4Null = new IndexInfo();
        info4Null.setEntityID(id.longValue());
        info4Null.setAppType(ApplicationCategoryEnum.form);
        info4Null.setTitle(String.valueOf(id));
        AuthorizationInfo ai = new AuthorizationInfo();
        ArrayList<Long> authList = new ArrayList<Long>();
        authList.add(AppContext.currentUserId());
        ai.setOwner(authList);
        info4Null.setAuthorizationInfo(ai);
        if (map == null) {
            log.info((Object)("\u5168\u6587\u68c0\u7d22\u5165\u5e93\u5f02\u5e38\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002Id=" + id));
            return info4Null;
        }
        String formIdStr = String.valueOf(map.get("formId"));
        if (Strings.isBlank((String)formIdStr) || "null".equals(formIdStr)) {
            formIdStr = "0";
        }
        if (null == (capFormBean = this.capFormManager.getForm(formId = Long.valueOf(formIdStr)))) {
            log.info((Object)("\u5168\u6587\u68c0\u7d22\u5165\u5e93\u5f02\u5e38\uff0c\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002formId = " + formId));
            return info4Null;
        }
        FormIndexModuleType formIndex = (FormIndexModuleType)map.get("formIndex");
        int moduleType = (Integer)map.get("moduleType");
        if (formIndex != null) {
            info = (IndexInfo)formIndex.getIndexInfo(id, ModuleType.getEnumByKey((int)moduleType));
        }
        return info;
    }

    public Integer findIndexResumeCount(Date starDate, Date endDate) throws BusinessException {
        int count = 0;
        MainbodyManager contentManager = (MainbodyManager)AppContext.getBean((String)"ctpMainbodyManager");
        FormIndex4UnFlow formIndex4UnFlow = (FormIndex4UnFlow)AppContext.getBean((String)"formIndex4UnFlow");
        List typeList = formIndex4UnFlow.getAllModuleType();
        for (ModuleType type : typeList) {
            List list = contentManager.getContentListByCreateTime(type, MainbodyType.FORM.getKey(), starDate, endDate);
            if (list == null || list.isEmpty()) continue;
            count += list.size();
        }
        return count;
    }

    public List<Long> findIndexResumeIDList(Date starDate, Date endDate, Integer firstRow, Integer pageSize) throws BusinessException {
        ArrayList<Long> resultList = new ArrayList<Long>();
        MainbodyManager contentManager = (MainbodyManager)AppContext.getBean((String)"ctpMainbodyManager");
        List contentList = new LinkedList();
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        ArrayList<Integer> queryType = new ArrayList<Integer>();
        queryType.add(ModuleType.collaboration.getKey());
        queryType.add(ModuleType.unflowBasic.getKey());
        queryType.add(ModuleType.unflowInfo.getKey());
        param.put("moduleType", queryType);
        param.put("contentType", Integer.valueOf(MainbodyType.FORM.getKey()));
        param.put("starDate", starDate);
        param.put("endDate", endDate);
        int page = firstRow / pageSize + 1;
        FlipInfo flipInfo = new FlipInfo(page, pageSize.intValue());
        contentList = contentManager.getContentListByFlipInfo(flipInfo, param);
        for (CtpContentAll contentAll : contentList) {
            resultList.add(contentAll.getModuleId());
        }
        return resultList;
    }

    public Map<String, Object> findSourceInfo(Long id) throws BusinessException {
        FormIndex4UnFlow formIndex4UnFlow = (FormIndex4UnFlow)AppContext.getBean((String)"formIndex4UnFlow");
        Map map = formIndex4UnFlow.findFormIndexModuleType(id, true);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        FormIndexModuleType formIndex = (FormIndexModuleType)map.get("formIndex");
        if (formIndex != null) {
            resultMap = formIndex.findSourceInfo(id);
        }
        return resultMap;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public boolean isShowIndexSummary(Long id, Map<String, String> extendProperties) throws BusinessException {
        String formType = extendProperties.get("formType");
        if (formType != null) {
            return !"unFlow".equals(formType) && !"cap4UnflowForm".equals(formType);
        }
        FormIndex4UnFlow formIndex4UnFlow = (FormIndex4UnFlow)AppContext.getBean((String)"formIndex4UnFlow");
        Map map = formIndex4UnFlow.findFormIndexModuleType(id, true);
        FormIndexModuleType formIndex = (FormIndexModuleType)map.get("formIndex");
        if (formIndex != null) {
            return formIndex.isShowIndexSummary();
        }
        return true;
    }
}

