/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.portal.portlet;

import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.portlet.ImageLayout;
import com.seeyon.ctp.portal.portlet.ImagePortletLayout;
import com.seeyon.ctp.portal.portlet.PortletConstants;
import com.seeyon.ctp.portal.portlet.SubCategory;
import com.seeyon.ctp.portal.portlet.manager.BaseAbstractPortletCategory;
import com.seeyon.ctp.portal.space.bo.PortalCustomizeMenuParam;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.dao.PrivilegeCache;
import com.seeyon.ctp.privilege.enums.PrivMenuTypeEnums;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class MenuCategory
extends BaseAbstractPortletCategory {
    private static final Log LOGGER = CtpLogFactory.getLog(MenuCategory.class);
    private PrivilegeMenuManager privilegeMenuManager;
    private OrgManager orgManager;
    private PrivilegeCache privilegeCache;
    private com.seeyon.ctp.form.modules.business.BusinessManager businessManager;
    private BusinessManager businessManager4;

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setPrivilegeCache(PrivilegeCache privilegeCache) {
        this.privilegeCache = privilegeCache;
    }

    public void setBusinessManager(com.seeyon.ctp.form.modules.business.BusinessManager businessManager) {
        this.businessManager = businessManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public String getCategoryId() {
        return "BusinessAppCategory";
    }

    public String getCategoryName() {
        return ResourceUtil.getString((String)"desk.metro.business");
    }

    public Integer getCategoryOrder() {
        return 3;
    }

    public boolean isAllowUsed(Map<String, Object> param) {
        String spaceType = ParamUtil.getString(param, (String)"spaceType");
        return !"before_login".equals(spaceType) && !AppContext.isGroupAdmin();
    }

    public SubCategory getSubCategory(Map<String, Object> params) {
        SubCategory ctgPortlet = new SubCategory();
        try {
            User user = AppContext.getCurrentUser();
            String spaceType = ParamUtil.getString(params, (String)"spaceType");
            if ("m3mobile,weixinmobile".contains(spaceType)) {
                ctgPortlet.addSubCategorys(new String[]{"mobileBusiness", ResourceUtil.getString((String)"desk.metro.business")});
            }
            if (AppContext.isAdministrator()) {
                List<PrivMenuBO> menus = this.getAllBusinessMenuForAdmin(user.getLoginAccount());
                for (PrivMenuBO m : menus) {
                    if (!"1".equals(m.getExt2())) continue;
                    ctgPortlet.addSubCategorys(new String[]{m.getId().toString(), m.getName()});
                }
                return ctgPortlet;
            }
            List menuList = this.privilegeMenuManager.getBusinessMenuByMember(user.getId(), user.getAccountId());
            Collections.sort(menuList, new Comparator<PrivMenuBO>(){

                @Override
                public int compare(PrivMenuBO o1, PrivMenuBO o2) {
                    return o1.getSortid() - o2.getSortid();
                }
            });
            for (PrivMenuBO menu : menuList) {
                if (menu.getExt12() != null && menu.getExt12() == 17) continue;
                String[] category = new String[]{menu.getId().toString(), menu.getName()};
                ctgPortlet.addSubCategorys(category);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return ctgPortlet;
    }

    public List<ImagePortletLayout> getPortletDeskDatas(String subCategroyKey, Map<String, Object> params) {
        ArrayList<ImagePortletLayout> layouts = new ArrayList<ImagePortletLayout>();
        User user = AppContext.getCurrentUser();
        String spaceType = ParamUtil.getString(params, (String)"spaceType");
        try {
            if ("mobileBusiness".equals(subCategroyKey)) {
                if (user.isAdministrator()) {
                    List<PrivMenuBO> menus = this.getAllBusinessMenuForAdmin(user.getLoginAccount());
                    for (PrivMenuBO m : menus) {
                        if (!"1".equals(m.getExt2())) continue;
                        layouts.add(this.getImagePortletLayout(subCategroyKey, m, 0));
                    }
                } else {
                    List menuList = this.privilegeMenuManager.getBusinessMenuByMember(user.getId(), user.getAccountId());
                    Collections.sort(menuList, new Comparator<PrivMenuBO>(){

                        @Override
                        public int compare(PrivMenuBO o1, PrivMenuBO o2) {
                            return o1.getSortid() - o2.getSortid();
                        }
                    });
                    int i = 0;
                    for (PrivMenuBO menu : menuList) {
                        String shortName;
                        V3xOrgAccount account;
                        Long memberAccountId;
                        V3xOrgMember member;
                        if (!"1".equals(menu.getExt2())) continue;
                        ImagePortletLayout layout = this.getImagePortletLayout(subCategroyKey, menu, i);
                        Long createuserid = menu.getCreateuserid();
                        if (createuserid != null && (member = this.orgManager.getMemberById(createuserid)) != null && (memberAccountId = member.getOrgAccountId()) != null && memberAccountId != AppContext.currentAccountId() && (account = this.orgManager.getAccountById(memberAccountId)) != null && Strings.isNotBlank((String)(shortName = account.getShortName()))) {
                            layout.setDisplayName(layout.getDisplayName() + "(" + shortName + ")");
                            layout.setPortletName(layout.getPortletName() + "(" + shortName + ")");
                        }
                        layouts.add(layout);
                        ++i;
                    }
                }
                return layouts;
            }
            if (AppContext.isAdministrator()) {
                Long menuId = Long.valueOf(subCategroyKey);
                PrivMenuBO topMenus = this.privilegeCache.getMenuById(menuId);
                List<PrivMenuBO> subMenus = this.getChildMenus(topMenus);
                if (subMenus == null || subMenus.size() == 0) {
                    return layouts;
                }
                int j = 0;
                for (PrivMenuBO menu : subMenus) {
                    if (menu.getExt12().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey() || menu.getExt12().intValue() == Enums.SourceType.SOURCE_TYPE_PARENT.getKey() || menu.getExt12().intValue() == Enums.SourceType.SOURCE_TYPE_ROOT.getKey()) continue;
                    ImagePortletLayout layout = this.getImagePortletLayout(subCategroyKey, menu, j);
                    layouts.add(layout);
                    ++j;
                }
                return layouts;
            }
            List<PrivMenuBO> subMenus = null;
            List menuList = this.privilegeMenuManager.getBusinessMenuByMember(user.getId(), user.getAccountId());
            for (PrivMenuBO menu : menuList) {
                if (!menu.getId().toString().equals(subCategroyKey)) continue;
                if (menu.getType() != null && menu.getType().intValue() == PrivMenuTypeEnums.businessCap4Menu.getKey()) {
                    subMenus = this.businessManager4.checkMenuAuth(menu.getId());
                    break;
                }
                subMenus = this.businessManager.checkMenuAuth(menu.getId());
                break;
            }
            if (Strings.isNotEmpty(subMenus)) {
                int j = 0;
                for (PrivMenuBO menu : subMenus) {
                    if (spaceType.indexOf("m3mobile") > -1 && menu.getExt12() != null && menu.getExt12() == 17 || !Strings.isNotBlank((String)menu.getResourceNavurl())) continue;
                    ImagePortletLayout layout = this.getImagePortletLayout(subCategroyKey, menu, j);
                    layouts.add(layout);
                    ++j;
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return layouts;
    }

    private List<PrivMenuBO> getAllBusinessMenuForAdmin(Long accoutId) throws BusinessException {
        List<PrivMenuBO> list = Collections.emptyList();
        List roles = this.orgManager.getAllRolesByBond(accoutId, new OrgConstants.ROLE_BOND[]{OrgConstants.ROLE_BOND.BUSINESS});
        if (Strings.isNotEmpty((Collection)roles)) {
            Long[] roleIds = new Long[roles.size()];
            for (int i = 0; i < roles.size(); ++i) {
                roleIds[i] = ((V3xOrgRole)roles.get(i)).getId();
            }
            list = new ArrayList<PrivMenuBO>(this.privilegeCache.getMenuByRoleFonEntity(roleIds));
            Collections.sort(list, new Comparator<PrivMenuBO>(){

                @Override
                public int compare(PrivMenuBO o1, PrivMenuBO o2) {
                    return o1.getSortid() - o2.getSortid();
                }
            });
        }
        return list;
    }

    private ImagePortletLayout getImagePortletLayout4Business(String id, String name) {
        ImagePortletLayout layout = new ImagePortletLayout();
        layout.setId(id + "|mobileBusiness|" + this.getCategoryId());
        layout.setCategory(this.getCategoryId());
        layout.setSubCategory("mobileBusiness");
        layout.setPortletId(id);
        layout.setDisplayName(name);
        layout.setPortletName(name);
        layout.setPluginId("formBiz");
        layout.setOrder(0);
        layout.setSize(PortletConstants.PortletSize.middle.ordinal());
        ImageLayout image = new ImageLayout();
        image.setImageUrl("vp-businesssolutionsgen");
        ArrayList<ImageLayout> images = new ArrayList<ImageLayout>();
        images.add(image);
        layout.setImageLayouts(images);
        return layout;
    }

    private List<PrivMenuBO> getChildMenus(PrivMenuBO menu) {
        ArrayList<PrivMenuBO> allMenu = new ArrayList<PrivMenuBO>();
        if (menu == null) {
            return allMenu;
        }
        List items = menu.getPrivMenuBOItems();
        if (Strings.isNotEmpty((Collection)items)) {
            for (PrivMenuBO item : items) {
                allMenu.add(item);
                List subItems = item.getPrivMenuBOItems();
                if (!Strings.isNotEmpty((Collection)items)) continue;
                allMenu.addAll(subItems);
            }
        } else {
            allMenu.add(menu);
        }
        return allMenu;
    }

    private ImagePortletLayout getImagePortletLayout(String parentId, PrivMenuBO menuBO, int order) {
        String[] strs;
        String MenuType;
        ImagePortletLayout layout = new ImagePortletLayout();
        layout.setId(menuBO.getId() + "|" + parentId + "|" + this.getCategoryId());
        layout.setCategory(this.getCategoryId());
        layout.setSubCategory(parentId);
        layout.setDisplayName(menuBO.getName());
        layout.setPortletName(menuBO.getName());
        layout.setResourceCode(menuBO.getResourceCode());
        layout.setPluginId("formBiz");
        layout.setOrder(order);
        layout.setPortletId(menuBO.getId().toString());
        Integer ext12 = menuBO.getExt12();
        PrivMenuBO targetMenu = null;
        if (ext12 != null && ext12 == 20 && Strings.isNotBlank((String)parentId) && Strings.isDigits((String)parentId) && (targetMenu = this.privilegeCache.getMenuById(Long.valueOf(parentId))) != null) {
            layout.setDisplayName(targetMenu.getName());
            layout.setPortletName(targetMenu.getName());
        }
        String url = menuBO.getResourceNavurl();
        String mUrl = "";
        if ("mobileBusiness".equals(parentId)) {
            url = null;
            mUrl = menuBO.getType() != null && menuBO.getType().intValue() == PrivMenuTypeEnums.businessCap4Menu.getKey() ? "cap4BizMenuId|" + menuBO.getId() + "|" + menuBO.getName() : "bizMenuId|" + menuBO.getId() + "|" + menuBO.getName();
        } else {
            mUrl = "businessMenu|{\"id\":\"" + menuBO.getId() + "\",\"name\":\"" + menuBO.getName() + "\",\"sourceId\":\"" + menuBO.getExt17() + "\",\"sourceType\":\"" + menuBO.getExt12() + "\",\"formAppmainId\":\"" + menuBO.getExt18() + "\",\"menuType\":\"" + menuBO.getType() + "\",\"flowMenuType\":\"" + menuBO.getExt14() + "\" }";
        }
        layout.setPortletUrl(url);
        layout.setPortletUrlType("newWindow".equals(menuBO.getTarget()) ? PortletConstants.UrlType.open.name() : PortletConstants.UrlType.workspace.name());
        layout.setMobileUrl(mUrl);
        layout.setSize(PortletConstants.PortletSize.middle.ordinal());
        ImageLayout image = new ImageLayout();
        String string = MenuType = menuBO.getExt12() == null ? "" : menuBO.getExt12().toString();
        if ("5".equals(MenuType)) {
            image.setImageUrl("vp-formstatistics");
        } else if ("6".equals(MenuType)) {
            image.setImageUrl("vp-formquery");
        } else if ("7".equals(MenuType) || "8".equals(MenuType) || "9".equals(MenuType) || "10".equals(MenuType) || "11".equals(MenuType) || "12".equals(MenuType) || "13".equals(MenuType) || "14".equals(MenuType)) {
            image.setImageUrl("vp-cultureconstruction");
        } else if ("4".equals(MenuType)) {
            image.setImageUrl("vp-doccenter");
        } else if ("1".equals(MenuType) || "2".equals(MenuType) || "3".equals(MenuType)) {
            image.setImageUrl("vp-newaffair");
        } else if ("1".equals(menuBO.getExt2()) && Strings.isNotBlank((String)menuBO.getIcon())) {
            if (menuBO.getIcon().indexOf("/fileUpload.do") > -1) {
                image.setImageUrl(menuBO.getIcon());
                strs = this.subStrUrl2FileId(menuBO.getIcon());
                image.setImageId(strs[0]);
                image.setCreateDate(strs[1]);
            } else {
                image.setImageUrl(menuBO.getIcon().indexOf("vp-") > -1 ? menuBO.getIcon() : "vp-businesssolutionsgen");
            }
        } else if (ext12 != null && ext12 == 20 && targetMenu != null) {
            if (targetMenu.getIcon().indexOf("/fileUpload.do") > -1) {
                image.setImageUrl(targetMenu.getIcon());
                strs = this.subStrUrl2FileId(targetMenu.getIcon());
                image.setImageId(strs[0]);
                image.setCreateDate(strs[1]);
            } else {
                image.setImageUrl(targetMenu.getIcon().indexOf("vp-") > -1 ? targetMenu.getIcon() : "vp-application");
            }
        } else {
            image.setImageUrl("vp-related");
        }
        image.setImageType(PortletConstants.ImageType.system);
        ArrayList<ImageLayout> images = new ArrayList<ImageLayout>();
        images.add(image);
        layout.setImageLayouts(images);
        return layout;
    }

    private String[] subStrUrl2FileId(String url) {
        String[] result = new String[2];
        try {
            if (Strings.isNotBlank((String)url)) {
                int endIndex11;
                String s2;
                String date;
                int startIndex11;
                int startIndex1 = url.indexOf("fileId=");
                String s1 = url.substring(startIndex1 + 7);
                int endIndex1 = s1.indexOf("&");
                if (endIndex1 > -1) {
                    result[0] = s1.substring(0, endIndex1);
                }
                if ((startIndex11 = url.indexOf("createDate=")) > -1 && (date = (s2 = url.substring(startIndex11 + 11)).substring(0, endIndex11 = s2.indexOf("&"))).matches("^(\\d{4})-(\\d{1,2})-(\\d{1,2})$")) {
                    result[1] = date;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            return result;
        }
        return result;
    }

    public ImagePortletLayout getPortletProperty(Map<String, Object> params) {
        String subCategoryKey = ParamUtil.getString(params, (String)"subCategory", (String)"");
        String portletId = ParamUtil.getString(params, (String)"portletId", (String)"");
        User user = AppContext.getCurrentUser();
        ImagePortletLayout layout = null;
        try {
            if ("mobileBusiness".equals(subCategoryKey)) {
                if (user.isAdministrator()) {
                    List<PrivMenuBO> menus = this.getAllBusinessMenuForAdmin(user.getLoginAccount());
                    for (PrivMenuBO m : menus) {
                        if (!m.getId().toString().equals(portletId)) continue;
                        layout = this.getImagePortletLayout4Business(m.getId().toString(), m.getName());
                    }
                } else {
                    List allBussinessMenuList = this.privilegeMenuManager.getAllBusinessMenuByMember(user.getId(), user.getAccountId());
                    for (PrivMenuBO menu : allBussinessMenuList) {
                        if (!menu.getId().toString().equals(portletId)) continue;
                        layout = this.getImagePortletLayout(subCategoryKey, menu, 0);
                    }
                }
                return layout;
            }
            if (AppContext.isAdministrator()) {
                Long menuId = Long.valueOf(subCategoryKey);
                PrivMenuBO topMenus = this.privilegeCache.getMenuById(menuId);
                List<PrivMenuBO> subMenus = this.getChildMenus(topMenus);
                if (subMenus.size() == 0) {
                    return layout;
                }
                for (PrivMenuBO menu : subMenus) {
                    if (!menu.getId().toString().equals(portletId)) continue;
                    layout = this.getImagePortletLayout(subCategoryKey, menu, 0);
                }
                return layout;
            }
            List<Object> subMenus = null;
            Long subMenuId = Long.parseLong(portletId);
            PrivMenuBO targetMenu = this.privilegeCache.getMenuById(subMenuId);
            if (null != targetMenu) {
                ArrayList<PrivMenuBO> list = new ArrayList<PrivMenuBO>();
                list.add(targetMenu);
                Long appMenuId = Long.parseLong(subCategoryKey);
                subMenus = targetMenu.getType() != null && targetMenu.getType().intValue() == PrivMenuTypeEnums.businessCap4Menu.getKey() ? this.businessManager4.checkMenuAuthForShortCut(appMenuId, list) : this.businessManager.checkMenuAuthForShortCut(appMenuId, list);
            }
            if (Strings.isNotEmpty(subMenus)) {
                for (PrivMenuBO menu : subMenus) {
                    if (!menu.getId().toString().equals(portletId) || !Strings.isNotBlank((String)menu.getResourceNavurl())) continue;
                    layout = this.getImagePortletLayout(subCategoryKey, menu, 0);
                }
            }
            return layout;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public int getPortletTipNumber(String portletId) {
        return -1;
    }

    public int getPortletTipNumber(Map<String, Object> params) {
        return -1;
    }

    public Map<String, List<ImagePortletLayout>> getMobilePortlets(String string) {
        HashMap<String, List<ImagePortletLayout>> result = new HashMap<String, List<ImagePortletLayout>>();
        ArrayList<ImagePortletLayout> layouts = new ArrayList<ImagePortletLayout>();
        try {
            User user = AppContext.getCurrentUser();
            List menuList = this.privilegeMenuManager.getBusinessMenuByMember(user.getId(), user.getAccountId());
            int i = 0;
            for (PrivMenuBO menu : menuList) {
                if (!"1".equals(menu.getExt2())) continue;
                Object checkFirstMenuResult = null;
                checkFirstMenuResult = menu.getType() != null && menu.getType().intValue() == PrivMenuTypeEnums.businessCap4Menu.getKey() ? this.businessManager4.findBizConfigByMenuId(menu.getId()) : this.businessManager.findBizConfigByMenuId(menu.getId());
                if (checkFirstMenuResult == null) continue;
                ImagePortletLayout layout = this.getImagePortletLayout("mobileBusiness", menu, i);
                layouts.add(layout);
                ++i;
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"\u79fb\u52a8\u7aef\u78c1\u8d34\u5b9a\u5236\u5e94\u7528\u83b7\u53d6\u51fa\u9519\uff01", (Throwable)e);
        }
        result.put("2", layouts);
        return result;
    }

    public Map<String, ImagePortletLayout> doBatchAuthCheck(PortalCustomizeMenuParam authParam) {
        String categoryId = authParam.getCategoryId();
        Set subCategorySet = authParam.getSubCategorySet();
        Set portletIdSet = authParam.getPortletIdSet();
        Map subCateGory2PortletIdsMap = authParam.getSubCateGory2PortletIdsMap();
        String spaceType = authParam.getSpaceType();
        HashMap<String, ImagePortletLayout> imagePortletLayoutMap = new HashMap<String, ImagePortletLayout>();
        User user = AppContext.getCurrentUser();
        try {
            if (subCategorySet.contains("mobileBusiness")) {
                String subCategoryKey = "mobileBusiness";
                Set subCateGory2PortletIds = (Set)subCateGory2PortletIdsMap.get(subCategoryKey);
                if (null != subCateGory2PortletIds && !subCateGory2PortletIds.isEmpty()) {
                    if (user.isAdministrator()) {
                        List<PrivMenuBO> menus = this.getAllBusinessMenuForAdmin(user.getLoginAccount());
                        for (PrivMenuBO m : menus) {
                            String portletId = m.getId().toString();
                            if (!subCateGory2PortletIds.contains(portletId)) continue;
                            ImagePortletLayout layout = this.getImagePortletLayout4Business(m.getId().toString(), m.getName());
                            imagePortletLayoutMap.put(portletId, layout);
                        }
                    } else {
                        List allBussinessMenuList = this.privilegeMenuManager.getAllBusinessMenuByMember(user.getId(), user.getAccountId());
                        for (PrivMenuBO menu : allBussinessMenuList) {
                            String portletId = menu.getId().toString();
                            if (!subCateGory2PortletIds.contains(portletId)) continue;
                            ImagePortletLayout layout = this.getImagePortletLayout(subCategoryKey, menu, 0);
                            imagePortletLayoutMap.put(portletId, layout);
                        }
                    }
                }
            } else if (AppContext.isAdministrator()) {
                for (String subCategoryKey : subCategorySet) {
                    Long menuId;
                    PrivMenuBO topMenus;
                    List<PrivMenuBO> subMenus;
                    Set subCateGory2PortletIds = (Set)subCateGory2PortletIdsMap.get(subCategoryKey);
                    if (null == subCateGory2PortletIds || subCateGory2PortletIds.isEmpty() || null == (subMenus = this.getChildMenus(topMenus = this.privilegeCache.getMenuById(menuId = Long.valueOf(subCategoryKey)))) || subMenus.isEmpty()) continue;
                    for (PrivMenuBO menu : subMenus) {
                        String portletId = menu.getId().toString();
                        if (!subCateGory2PortletIds.contains(portletId)) continue;
                        ImagePortletLayout layout = this.getImagePortletLayout(subCategoryKey, menu, 0);
                        imagePortletLayoutMap.put(portletId, layout);
                    }
                }
            } else {
                Map<String, ImagePortletLayout> imagePortletLayoutMapCap4;
                Map imagePortletLayoutMapCap3;
                HashSet<Integer> menuTypeCap3 = new HashSet<Integer>();
                HashSet<Integer> menuTypeCap4 = new HashSet<Integer>();
                HashMap<String, ArrayList<PrivMenuBO>> mapListCap3 = new HashMap<String, ArrayList<PrivMenuBO>>();
                HashMap<String, List<PrivMenuBO>> mapListCap4 = new HashMap<String, List<PrivMenuBO>>();
                for (String subCategoryKey : subCategorySet) {
                    Set subCateGory2PortletIds = (Set)subCateGory2PortletIdsMap.get(subCategoryKey);
                    for (String portletId : subCateGory2PortletIds) {
                        Long subMenuId = Long.parseLong(portletId);
                        PrivMenuBO targetMenu = this.privilegeCache.getMenuById(subMenuId);
                        if (null == targetMenu) continue;
                        if (targetMenu.getType() != null && targetMenu.getType().intValue() == PrivMenuTypeEnums.businessCap4Menu.getKey()) {
                            ArrayList<PrivMenuBO> listCap4 = (ArrayList<PrivMenuBO>)mapListCap4.get(subCategoryKey);
                            if (null == listCap4) {
                                listCap4 = new ArrayList<PrivMenuBO>();
                            }
                            listCap4.add(targetMenu);
                            mapListCap4.put(subCategoryKey, listCap4);
                            menuTypeCap4.add(targetMenu.getExt12());
                            continue;
                        }
                        ArrayList<PrivMenuBO> listCap3 = (ArrayList<PrivMenuBO>)mapListCap3.get(subCategoryKey);
                        if (null == listCap3) {
                            listCap3 = new ArrayList<PrivMenuBO>();
                        }
                        listCap3.add(targetMenu);
                        mapListCap3.put(subCategoryKey, listCap3);
                        menuTypeCap3.add(targetMenu.getExt12());
                    }
                }
                if (null != mapListCap3 && !mapListCap3.isEmpty() && null != (imagePortletLayoutMapCap3 = this.businessManager.checkMenuAuthBatch(menuTypeCap3, mapListCap3))) {
                    imagePortletLayoutMap.putAll(imagePortletLayoutMapCap3);
                }
                if (null != mapListCap4 && !mapListCap4.isEmpty() && null != (imagePortletLayoutMapCap4 = this.businessManager4.checkMenuAuthBatch(menuTypeCap4, mapListCap4))) {
                    imagePortletLayoutMap.putAll(imagePortletLayoutMapCap4);
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return imagePortletLayoutMap;
    }
}

