/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.portal.portlet;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.portal.portlet.BasePortlet;
import com.seeyon.ctp.portal.portlet.ImageLayout;
import com.seeyon.ctp.portal.portlet.ImagePortletLayout;
import com.seeyon.ctp.portal.portlet.PortletConstants;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuPortlet
implements BasePortlet {
    private static final Log LOGGER = LogFactory.getLog(MenuPortlet.class);
    private PrivilegeMenuManager privilegeMenuManager;

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public String getId() {
        return "customizeMenus";
    }

    public List<ImagePortletLayout> getData() {
        return Collections.emptyList();
    }

    public ImagePortletLayout getPortlet(String portletId) {
        User user = AppContext.getCurrentUser();
        if (!user.isAdmin()) {
            try {
                List menuList = this.privilegeMenuManager.getBusinessMenuByMember(user.getId(), user.getAccountId());
                HashMap<String, PrivMenuBO> menuMap = new HashMap<String, PrivMenuBO>();
                for (PrivMenuBO menu : menuList) {
                    menuMap.clear();
                    this.getChildMenus(menu, menuMap);
                    String subCategroyKey = menu.getId().toString();
                    if (!menuMap.containsKey(portletId)) continue;
                    ImagePortletLayout layout = this.getImagePortletLayout(subCategroyKey, (PrivMenuBO)menuMap.get(portletId), 0);
                    return layout;
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private void getChildMenus(PrivMenuBO menu, Map<String, PrivMenuBO> menuMap) {
        List items = menu.getPrivMenuBOItems();
        if (Strings.isNotEmpty((Collection)items)) {
            for (PrivMenuBO item : items) {
                menuMap.put(item.getId().toString(), item);
                List subItems = item.getPrivMenuBOItems();
                if (!Strings.isNotEmpty((Collection)subItems)) continue;
                for (PrivMenuBO sub : subItems) {
                    menuMap.put(sub.getId().toString(), sub);
                }
            }
        }
    }

    private ImagePortletLayout getImagePortletLayout(String parentId, PrivMenuBO menuBO, int order) {
        String MenuType;
        ImagePortletLayout layout = new ImagePortletLayout();
        layout.setId(menuBO.getId() + "|" + parentId + "|BusinessAppCategory");
        layout.setCategory("BusinessAppCategory");
        layout.setSubCategory(parentId);
        layout.setDisplayName(menuBO.getName());
        layout.setPortletName(menuBO.getName());
        layout.setResourceCode(menuBO.getResourceCode());
        layout.setPluginId("formBiz");
        layout.setOrder(order);
        layout.setPortletId(menuBO.getId().toString());
        String url = menuBO.getResourceNavurl();
        String mUrl = "businessMenu|" + menuBO.getId() + "|" + menuBO.getExt12() + "|" + menuBO.getExt17();
        if ("mobileBusiness".equals(parentId)) {
            url = null;
            mUrl = "bizMenuId|" + menuBO.getId();
        }
        layout.setPortletUrl(url);
        layout.setPortletUrlType("newWindow".equals(menuBO.getTarget()) ? PortletConstants.UrlType.open.name() : PortletConstants.UrlType.workspace.name());
        layout.setMobileUrl(mUrl);
        layout.setSize(PortletConstants.PortletSize.middle.ordinal());
        ImageLayout image = new ImageLayout();
        String string = MenuType = menuBO.getExt12() == null ? "" : menuBO.getExt12().toString();
        if ("5".equals(MenuType)) {
            image.setImageUrl("vp-formstatistics");
        } else if ("6".equals(MenuType)) {
            image.setImageUrl("vp-formquery");
        } else if ("7".equals(MenuType) || "8".equals(MenuType) || "9".equals(MenuType) || "10".equals(MenuType) || "11".equals(MenuType) || "12".equals(MenuType) || "13".equals(MenuType) || "14".equals(MenuType)) {
            image.setImageUrl("vp-cultureconstruction");
        } else if ("4".equals(MenuType)) {
            image.setImageUrl("vp-doccenter");
        } else if ("1".equals(MenuType) || "2".equals(MenuType) || "3".equals(MenuType)) {
            image.setImageUrl("vp-newaffair");
        } else {
            image.setImageUrl("vp-related");
        }
        image.setImageType(PortletConstants.ImageType.system);
        ArrayList<ImageLayout> images = new ArrayList<ImageLayout>();
        images.add(image);
        layout.setImageLayouts(images);
        return layout;
    }

    public int getDataCount(String portletId) {
        return -1;
    }

    public boolean isAllowDataUsed(String portletId) {
        return true;
    }

    public boolean isAllowUsed() {
        return true;
    }
}

