/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.seeyon.cap4.form.bean.button.Button;
import com.seeyon.cap4.form.bean.button.CommonBtn;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.plugin.FormPluginParamBean;
import com.seeyon.cap4.form.modules.index.UnflowFormIndex;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.service.CAPBatchOperationService;
import com.seeyon.cap4.template.service.CAPConditionService;
import com.seeyon.cap4.template.service.CAPFormDataListService;
import com.seeyon.cap4.template.service.CAPFormDataOpenService;
import com.seeyon.cap4.template.service.CAPFormDataService;
import com.seeyon.cap4.template.service.CAPFormDataSignatureService;
import com.seeyon.cap4.template.service.CAPFormPluginService;
import com.seeyon.cap4.template.service.CAPFormRelationService;
import com.seeyon.cap4.template.service.CAPFormToCollService;
import com.seeyon.cap4.template.service.CAPFormToUnflowService;
import com.seeyon.cap4.template.service.CAPImportService;
import com.seeyon.cap4.template.service.CAPScreenCaptureService;
import com.seeyon.cap4.template.service.ServiceProxy;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceLoader;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.rest.resources.BaseResource;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.RestInterfaceAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;

@Path(value="cap4/form")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CAP4FormResource
extends BaseResource {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormResource.class);
    CAPFormDataService capFormDataService = (CAPFormDataService)AppContext.getBean((String)"capFormDataService");
    CAPFormDataOpenService capFormDataOpenService = (CAPFormDataOpenService)AppContext.getBean((String)"capFormDataOpenService");
    CAPFormDataSignatureService capFormDataSignatureService = (CAPFormDataSignatureService)AppContext.getBean((String)"capFormDataSignatureService");
    CAPBatchOperationService capBatchOperationService = (CAPBatchOperationService)AppContext.getBean((String)"capBatchOperationService");
    CAPScreenCaptureService capScreenCaptureService = (CAPScreenCaptureService)AppContext.getBean((String)"capScreenCaptureService");
    CAPFormToCollService capFormToCollService = (CAPFormToCollService)AppContext.getBean((String)"capFormToCollService");
    CAPFormRelationService capFormRelationService = (CAPFormRelationService)AppContext.getBean((String)"capFormRelationService");
    CAPFormToUnflowService capFormToUnflowService = (CAPFormToUnflowService)AppContext.getBean((String)"capFormToUnflowService");
    CAPConditionService capConditionService = (CAPConditionService)AppContext.getBean((String)"capConditionService");
    CAPFormPluginService capFormPluginService = (CAPFormPluginService)AppContext.getBean((String)"capFormPluginService");
    CAPFormDataListService capFormDataListService = (CAPFormDataListService)AppContext.getBean((String)"capFormDataListService");
    CAP4FormDesignManager cap4FormDesignManager = (CAP4FormDesignManager)AppContext.getBean((String)"cap4FormDesignManager");
    CAPImportService capImportService = (CAPImportService)AppContext.getBean((String)"capImportService");

    @POST
    @Path(value="getWhitePlugins")
    public Response getWhitePlugins(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormPluginService, "getWhitePlugins", params));
    }

    @POST
    @Path(value="getConfigedPlugins")
    public Response getConfigedPlugins(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormPluginService, "getConfigedPlugins", params));
    }

    @POST
    @Path(value="saveConfigPlugins")
    public Response saveConfigPlugins(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormPluginService, "saveConfigPlugins", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="initFormPlugins")
    public Response initFormPlugins() {
        this.capFormPluginService.initFormPlugins();
        return this.success("");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="pluginScripts")
    public Response pluginScripts() {
        FormPluginParamBean paramBean = new FormPluginParamBean(AppContext.getRawRequest().getParameterMap());
        return Response.ok((Object)this.capFormPluginService.getFormPlugins4Document(paramBean)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="plugins/{version}")
    public Response plugins(@PathParam(value="version") String version) {
        FormPluginParamBean paramBean = new FormPluginParamBean();
        paramBean.setVersion(version);
        HttpServletRequest request = AppContext.getRawRequest();
        paramBean.setModuleId(request.getParameter("moduleId"));
        paramBean.setModuleType(request.getParameter("moduleType"));
        paramBean.setClient(request.getParameter("client"));
        return this.success(this.capFormPluginService.getFormPlugins(paramBean));
    }

    @POST
    @Path(value="copyFormData")
    public Response copyFormData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "copyFormData", params));
    }

    @POST
    @Path(value="getFormDataRightInfo")
    public Response getFormDataRightInfo(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "getFormDataRightInfo", params));
    }

    @POST
    @Path(value="refreshSubData")
    public Response refreshSubData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormRelationService, "refreshSubData", params));
    }

    @Deprecated
    @POST
    @Path(value="checkLock")
    public Response checkLock(Map<String, Object> params) {
        return this.success(this.capFormToUnflowService.checkLock(params));
    }

    @POST
    @Path(value="validUnflowOperation")
    public Response validUnflowOperation(Map<String, Object> params) {
        return this.success(this.capFormToUnflowService.validUnflowOperation(params));
    }

    @POST
    @Path(value="validBindButton")
    public Response validBindButton(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormToUnflowService, "checkButton", params));
    }

    @POST
    @Path(value="getToDoItems")
    public Response getToDoItems(Map<String, Object> params) {
        params.put("queryType", CAPBusinessEnum.DataListTypeEnum.FLOW_TO_DO.getValue());
        return this.success(ServiceProxy.invoke(this.capFormDataListService, "getList", params));
    }

    @POST
    @Path(value="getCAPFormUnFlowList")
    public Response getCAPFormUnFlowList(Map<String, Object> params) {
        params.put("queryType", CAPBusinessEnum.DataListTypeEnum.UN_FLOW.getValue());
        return this.success(ServiceProxy.invoke(this.capFormDataListService, "getList", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getCAPFormFieldCalcData")
    public Response getCAPFormFieldCalcData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormToUnflowService, "getFieldCalcData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getCAPFormFieldListData")
    public Response getCAPFormFieldListData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormToUnflowService, "getFieldDataList", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getExcelSheets/{fileId}")
    public Response getExcelSheets(@PathParam(value="fileId") String fileId) {
        return this.success(this.capBatchOperationService.getExcelSheets(fileId));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="importFormExcelDatas")
    public Response importFormExcelDatas(Map<String, Object> params) {
        return this.success(this.capImportService.readData(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="updateFormExcelDatas")
    public Response updateFormExcelDatas(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capImportService, "updateCacheDBData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getFormExcelDatas")
    public Response getFormExcelDatas(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capImportService, "readDataFromCacheDB", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transFormExcelDatas")
    public Response transFormExcelDatas(Map<String, Object> params) {
        if (CAPBusinessEnum.BatchOperationEnum.BATCH_UPDATE.getKey().equals(params.get("type"))) {
            return this.success(this.capBatchOperationService.transFormExcelDatas(params));
        }
        return this.success(this.capImportService.execute(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="exportUnflowExcel")
    public Response exportUnflowExcel(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.exportUnflowExcel(params, null));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="checkSubTableExportField")
    public Response checkSubTableExportField(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.checkSubTableExportField(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="deleteBatchOperationData")
    public Response deleteBatchOperationData(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.deleteBatchOperationData(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="updateBatchOperationData")
    public Response updateBatchOperationData(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.updateBatchOperationData(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="updateBatchRefreshData")
    public Response updateBatchRefreshData(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.updateBatchRefreshData(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="deleteTempData")
    public Response deleteTempData(Map<String, Object> params) {
        return this.success(this.capBatchOperationService.deleteTempData(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transDoForward")
    public Response transDoForward(Map<String, Object> params) {
        return this.success(this.capFormToCollService.transDoForward(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="deleteAffair")
    public Response deleteAffair(Map<String, Object> params) {
        return this.success(this.capFormToCollService.deleteAffair(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="takeBack")
    public Response takeBack(Map<String, Object> params) {
        return this.success(this.capFormToCollService.takeBack(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="checkTakeBack")
    public Response checkTakeBack(Map<String, Object> params) {
        return this.success(this.capFormToCollService.checkTakeBack(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transRepeal")
    public Response transRepeal(Map<String, Object> params) {
        return this.success(this.capFormToCollService.transRepeal(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="checkTransRepeal")
    public Response checkTransRepeal(Map<String, Object> params) {
        return this.success(this.capFormToCollService.checkTransRepeal(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transSendColl")
    public Response transSendColl(Map<String, Object> params) {
        return this.success(this.capFormToCollService.transSendColl(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="checkForwardPermission")
    public Response checkForwardPermission(Map<String, Object> params) {
        return this.success(this.capFormToCollService.checkForwardPermission(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="sendFromWait")
    public Response sendFromWait(Map<String, Object> params) {
        return this.success(this.capFormToCollService.sendFromWait(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="finishWorkItem")
    public Response finishWorkItem(Map<String, Object> params) {
        return this.success(this.capFormToCollService.finishWorkItem(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transStepBack")
    public Response transStepBack(Map<String, Object> params) {
        return this.success(this.capFormToCollService.transStepBack(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="dealSelectedRelationData")
    public Response dealSelectedRelationData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormRelationService, "dealSelectedRelationData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="cleanRelationData")
    public Response cleanRelationData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormRelationService, "cleanRelationData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getFormRelationDatas")
    public Response getFormRelationDatas(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormRelationService, "getFormRelationDatas", params));
    }

    @POST
    @Path(value="delFormData")
    public Response delFormData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormToUnflowService, "delFormData", params));
    }

    @POST
    @Path(value="setLockOrUnlock")
    public Response setLockOrUnlock(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormToUnflowService, "setLockOrUnlock", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="createOrEdit")
    public Response createOrEdit(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataOpenService, "createOrEditForm", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveOrUpdate")
    public Response save(Map<String, Object> params) {
        return this.success(this.capFormDataService.saveOrUpdateForm(params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="removeSessionFormCache/{contentDataId}")
    public Response removeSessionFormCache(@PathParam(value="contentDataId") String contentDataId) {
        return this.success(this.capFormDataService.removeSessionFormCache(contentDataId));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="removeSessionFormCache")
    public Response removeSessionFormCache() {
        HttpServletRequest request = AppContext.getRawRequest();
        String moduleId = request.getParameter("moduleId");
        String moduleType = request.getParameter("moduleType");
        String contentDataId = request.getParameter("contentDataId");
        return this.success(this.capFormDataService.removeSessionFormCache(contentDataId, moduleId, moduleType));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="calculate")
    public Response calculate(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "calculate", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="addOrDelDataSubBean")
    public Response addOrDelDataSubBean(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "addOrDelDataSubBean", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="validateSubTableAuth")
    public Response validateSubTableAuth(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "validateSubTableAuth", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="addOrDelAttachment")
    public Response addOrDelAttachment(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "addOrDelAttachment", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="doScreenCapture")
    public Response doScreenCapture(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capScreenCaptureService, "doScreenCapture", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getScreenCaptureImgBase64/{imgBase64Key}")
    public Response getScreenCaptureImgBase64(@PathParam(value="imgBase64Key") String imgBase64Key) {
        return this.success(this.capScreenCaptureService.getScreenCaptureImgBase64(imgBase64Key));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="doFormScreenCapture")
    public Response doFormScreenCapture(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capScreenCaptureService, "doFormDataContentScreenCapture", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="doFormScreenCapture4File")
    @Deprecated
    public Response doFormScreenCapture4File(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capScreenCaptureService, "doFormScreenCapture4File", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="screenCapture")
    public Response screenCapture(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataService, "screenCapture", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="findQueryParam4Index")
    public Response findSourceInfo4Index(Map<String, Object> params) throws BusinessException {
        Map<String, Object> indexMap;
        Long moduleId = ParamUtil.getLong(params, (String)"moduleId", (Long)0L);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        UnflowFormIndex unflowFormIndex = (UnflowFormIndex)AppContext.getBean((String)"unflowFormIndex");
        if (moduleId != null && moduleId != 0L && (indexMap = unflowFormIndex.findSourceInfo(moduleId)) != null && indexMap.size() != 0) {
            ModuleType type = (ModuleType)indexMap.get("moduleType");
            resultMap.put("moduleType", "" + type.getKey());
            resultMap.put("rightId", String.valueOf(indexMap.get("rightId")));
            resultMap.put("moduleId", String.valueOf(moduleId));
            resultMap.put("operateType", "2");
        }
        if (resultMap.size() == 0) {
            throw new BusinessException(ResourceUtil.getString((String)"form.exception.datanotexit"));
        }
        return this.success(resultMap);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getiSignatureProtectedData")
    public Response getiSignatureProtectedData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capFormDataSignatureService, "getiSignatureProtectedData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveLog")
    public Response saveLog(Map<String, Object> params) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(1);
        String type = String.valueOf(params.get("type"));
        String message = String.valueOf(params.get("message"));
        if (Strings.isBlank((String)type)) {
            type = "info";
        }
        if ("error".equals(type)) {
            LOGGER.error((Object)message);
        } else if ("debug".equals(type)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)message);
            }
        } else if ("warn".equals(type)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)message);
            }
        } else {
            LOGGER.info((Object)message);
        }
        result.put("success", true);
        return this.success(result);
    }

    @GET
    @Path(value="canUseBtns")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response canUseBtns(@QueryParam(value="formType") int formType) {
        Enums.FormType type = Enums.FormType.getEnumByKey((int)formType);
        List canUseBtnInfoMaps = FormFieldUtil.getCanUseBindBtns((Enums.FormType)type);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("canUseBtns", canUseBtnInfoMaps);
        return this.success(result);
    }

    @GET
    @Path(value="getCustomBtnList")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response getCustomBtnList() {
        HashMap result = new HashMap();
        ArrayList resultJsonObjs = new ArrayList();
        Map currentEnvBtns = FormFieldUtil.getCustomBtnMap();
        for (Button btn : currentEnvBtns.values()) {
            CommonBtn commonBtn = (CommonBtn)btn;
            HashMap<String, Object> btnInfo = new HashMap<String, Object>();
            btnInfo.put("name", commonBtn.getText());
            if (commonBtn.canUse(Enums.FormType.unFlowForm)) {
                btnInfo.put("deployed", 1);
            } else {
                btnInfo.put("deployed", 2);
            }
            resultJsonObjs.add(btnInfo);
        }
        result.put("result", resultJsonObjs);
        return this.success(result);
    }

    @GET
    @Path(value="reloadI18n")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response reloadI18n() {
        HashMap<String, String> result = new HashMap<String, String>();
        ResourceLoader.initResources();
        result.put("result", "true");
        return this.success(result);
    }

    @POST
    @Path(value="enumItems")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response getConditionEnumItems(Map<String, Object> params) {
        return this.success(this.capConditionService.getEnumItemResult((List)params.get("enumIds")));
    }

    @GET
    @Path(value="enumItem/{itemId}/tree")
    public Response getEnumTreeResult(@PathParam(value="itemId") Long itemId) {
        return this.success(this.capConditionService.getEnumTreeResult(itemId));
    }

    @POST
    @Path(value="exportView")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1SP1")
    public Response exportView(Map<String, Object> params) {
        Map<String, Object> resultMap = null;
        try {
            resultMap = this.cap4FormDesignManager.exportView(params);
            resultMap.put("success", true);
        }
        catch (BusinessException e) {
            resultMap = new HashMap<String, Object>();
            resultMap.put("success", false);
            resultMap.put("errorMsg", e.getMessage());
        }
        return this.success(resultMap);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="importView/{fileId}")
    public Response importView(@PathParam(value="fileId") String fileId) {
        Map<String, Object> resultMap = null;
        try {
            resultMap = this.cap4FormDesignManager.importView(fileId);
            resultMap.put("success", true);
        }
        catch (BusinessException e) {
            resultMap = new HashMap<String, Object>(2);
            resultMap.put("success", false);
            resultMap.put("errorMsg", e.getMessage());
        }
        return this.success(resultMap);
    }

    @POST
    @Path(value="importViewOrForm4Mall")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1SP1")
    public Response importViewOrForm4Mall(Map<String, Object> params) {
        Map<String, Object> resultMap = null;
        try {
            resultMap = this.cap4FormDesignManager.importViewOrForm4Mall(params);
            resultMap.put("success", true);
        }
        catch (BusinessException e) {
            resultMap = new HashMap<String, Object>();
            resultMap.put("success", false);
            resultMap.put("errorMsg", e.getMessage());
        }
        return this.success(resultMap);
    }
}

