/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import com.seeyon.ctp.rest.resources.BaseResource;
import com.seeyon.ctp.util.DateUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CAPBaseResource
extends BaseResource {
    protected Response success(Object o) {
        ImmutableMap entity = ImmutableMap.of((Object)"code", (Object)0, (Object)"data", (Object)o);
        return Response.ok((Object)this.toJSON(entity)).build();
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        });
        module.addSerializer(Timestamp.class, (JsonSerializer)new JsonSerializer<Timestamp>(){

            public void serialize(Timestamp timestamp, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(DateUtil.format((Date)timestamp, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        });
        mapper.registerModule((Module)module);
        return mapper;
    }
}

