/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.exception.NotAuthorizedException;
import com.seeyon.cap4.bizportal.param.BizPortalCollectLayoutParam;
import com.seeyon.cap4.bizportal.param.BizPortalFileListParam;
import com.seeyon.cap4.bizportal.param.BizPortalGoodsListParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceBatchAuthParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceConfigParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceRenameParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceResortParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceRestateParam;
import com.seeyon.cap4.bizportal.param.ElementDataSetBinding;
import com.seeyon.cap4.bizportal.service.BizPortalService;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.rest.resources.CAPBaseResource;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.springframework.core.io.Resource;

@Path(value="cap4/bizportal/{bizId}")
public class CAPBizPortalResource
extends CAPBaseResource {
    private static final Log logger = CtpLogFactory.getLog(CAPBizPortalResource.class);

    @Path(value="list")
    @GET
    public Response listBizPortalSpace(@PathParam(value="bizId") Long bizId, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="q") String condition) throws BusinessException {
        FlipInfo fi = new FlipInfo(page.intValue(), pageSize.intValue());
        HashMap param = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            param.put("name", condition);
        }
        return this.success(this.getBizPortalService().findBizPortalSpaces(bizId, fi, param));
    }

    @Path(value="list/{platform}")
    @GET
    public Response listAuthBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="platform") Integer platformCode) throws BusinessException {
        return this.success(this.getBizPortalService().listAuthBizPortalSpace(bizId, platformCode));
    }

    @Path(value="listAll/{platform}")
    @GET
    public Response listAuthAllPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="platform") Integer platformCode) throws BusinessException {
        return this.success(this.getBizPortalService().listAuthAllPortalSpace(bizId, platformCode));
    }

    @Path(value="{spaceId}/rename")
    @POST
    public Response renameBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="spaceId") Long spaceId, BizPortalSpaceRenameParam renameParam) throws BusinessException {
        return this.success(this.getBizPortalService().renameBizPortalSpace(bizId, spaceId, renameParam.getNewNme()));
    }

    @Path(value="{spaceId}/resort")
    @POST
    public Response resortBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="spaceId") Long spaceId, BizPortalSpaceResortParam resortParam) throws BusinessException {
        return this.success(this.getBizPortalService().resortBizPortalSpace(bizId, spaceId, resortParam.getNewSort()));
    }

    @Path(value="{spaceId}/restate")
    @POST
    public Response restateBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="spaceId") Long spaceId, BizPortalSpaceRestateParam restateParam) throws BusinessException {
        return this.success(this.getBizPortalService().restateBizPortalSpace(bizId, spaceId, restateParam.getNewState()));
    }

    @Path(value="{spaceId}/export")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    public Response exportBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="spaceId") Long spaceId) throws BusinessException {
        try {
            Pair<String, Resource> pair = this.getBizPortalService().getBizPortalSpacePackage(bizId, spaceId);
            Resource resource = (Resource)pair.getRight();
            String fileName = FileUtil.getDownloadFileName((HttpServletRequest)this.req, (String)((String)pair.getLeft() + ".bns"));
            return Response.ok((Object)resource.getInputStream()).header("Content-disposition", (Object)fileName).build();
        }
        catch (NotAuthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IOException e) {
            logger.error((Object)("\u5bfc\u51fa\u4e1a\u52a1\u7a7a\u95f4\u6a21\u677f\u51fa\u9519, bizId=" + bizId + ",spaceId=" + spaceId + ", userId=" + AppContext.currentUserId()), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="import/{fileId}")
    @POST
    public Response importBizPortalSpace(@PathParam(value="bizId") Long bizId, @PathParam(value="fileId") Long fileId) throws BusinessException {
        return this.success(this.getBizPortalService().importBizPortalSpace(bizId, fileId));
    }

    @Path(value="batchAuth")
    @POST
    public Response batchAuthBizPortalSpace(@PathParam(value="bizId") Long bizId, BizPortalSpaceBatchAuthParam batchAuthParam) throws BusinessException {
        return this.success(this.getBizPortalService().batchAuthBizPortalSpace(bizId, batchAuthParam));
    }

    @Path(value="batchDelete")
    @POST
    public Response batchDeleteBizPortalSpace(@PathParam(value="bizId") Long bizId, List<Long> spaceIds) throws BusinessException {
        return this.success(this.getBizPortalService().batchRemoveBizPortalSpace(bizId, spaceIds));
    }

    @Path(value="{configId}")
    @GET
    public Response getBizPortalSpaceConfig(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId) throws BusinessException {
        return this.success(this.getBizPortalService().getBizPortalSpaceConfig(bizId, configId));
    }

    @Path(value="{configId}/save")
    @POST
    public Response saveBizPortalSpaceConfig(@PathParam(value="bizId") Long bizId, Map<String, Object> params) throws BusinessException {
        return this.success(this.getBizPortalService().saveBizPortalSpaceConfig(bizId, BizPortalUtils.create(params, BizPortalSpaceConfigParam.class)));
    }

    @Path(value="{configId}/reset")
    @POST
    public Response resetInitialBizPortalSpaceConfig(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId) throws BusinessException {
        return this.success(this.getBizPortalService().resetInitialSpaceConfig(bizId, configId));
    }

    @Path(value="{configId}/theme/{themeId}/css/theme.css")
    @GET
    @Consumes(value={"text/css"})
    @Produces(value={"text/css"})
    public Response getBizPortalThemeCss(@PathParam(value="themeId") Long themeId) {
        try {
            Resource resource = this.getBizPortalService().getBizPortalThemeCss(themeId);
            if (resource != null && resource.exists()) {
                CacheControl cc = new CacheControl();
                cc.setNoTransform(true);
                cc.setMustRevalidate(false);
                cc.setNoCache(false);
                cc.setMaxAge(360000);
                Date lastModified = new Date(resource.lastModified());
                String etag = DateUtil.formatDateTime((Date)lastModified);
                EntityTag entityTag = new EntityTag(etag);
                Response.ResponseBuilder responseBuilder = this.request.evaluatePreconditions(lastModified, entityTag);
                if (responseBuilder != null) {
                    return responseBuilder.cacheControl(cc).build();
                }
                return Response.ok((Object)resource.getInputStream()).cacheControl(cc).lastModified(lastModified).expires(DateUtil.addYear((Date)new Date(), (int)1)).tag(etag).build();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u4e3b\u9898\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{configId}/layout/list")
    @GET
    public Response listBizPortalLayouts(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId) throws BusinessException {
        return this.success(this.getBizPortalService().listBizPortalLayouts(bizId, configId, this.uriInfo.getBaseUri().getPath()));
    }

    @Path(value="{configId}/layout/{layoutId}/cover")
    @GET
    @Consumes(value={"image/*"})
    @Produces(value={"image/png"})
    public Response getBizPortalLayoutCover(@PathParam(value="layoutId") Long layoutId) {
        try {
            Resource resource = this.getBizPortalService().getBizPortalLayoutCover(layoutId);
            if (resource.exists()) {
                CacheControl cc = new CacheControl();
                cc.setNoTransform(true);
                cc.setMustRevalidate(false);
                cc.setNoCache(false);
                cc.setMaxAge(360000);
                Date lastModified = new Date(resource.lastModified());
                String etag = DateUtil.formatDateTime((Date)lastModified);
                EntityTag entityTag = new EntityTag(etag);
                Response.ResponseBuilder responseBuilder = this.request.evaluatePreconditions(lastModified, entityTag);
                if (responseBuilder != null) {
                    return responseBuilder.cacheControl(cc).build();
                }
                return Response.ok((Object)resource.getInputStream(), (String)"image/png").cacheControl(cc).lastModified(lastModified).expires(DateUtil.addYear((Date)new Date(), (int)1)).tag(etag).build();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5e03\u5c40\u56fe\u7247\u51fa\u9519\uff1a", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{configId}/layout/{layoutId}")
    @GET
    public Response getBizPortalLayoutConfig(@PathParam(value="layoutId") Long layoutId) throws BusinessException {
        return this.success(this.getBizPortalService().getBizPortalLayoutConfig(layoutId));
    }

    @Path(value="{configId}/layout/collect")
    @POST
    public Response collectBizPortalLayout(BizPortalCollectLayoutParam layoutParam) throws BusinessException {
        return this.success(this.getBizPortalService().collectBizPortalLayout(layoutParam));
    }

    @Path(value="{configId}/layout/{layoutId}/remove")
    @POST
    public Response removeBizPortalLayout(@PathParam(value="layoutId") Long layoutId) throws BusinessException {
        return this.success(this.getBizPortalService().removeBizPortalLayout(layoutId));
    }

    @Path(value="goods/{goodsClass}")
    @GET
    public Response listGoods(@PathParam(value="bizId") Long bizId, @PathParam(value="goodsClass") String goodClass, @QueryParam(value="listType") Integer listType, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="orderKey") String orderKey, @QueryParam(value="order") String order, @QueryParam(value="q") String goodsName, @QueryParam(value="includeSubClass") String includeSubClass, @QueryParam(value="excludeSubClass") String excludeSubClass) throws BusinessException {
        BizPortalGoodsListParam listParam = new BizPortalGoodsListParam();
        listParam.setGoodsClass(goodClass);
        listParam.setListType(listType);
        listParam.setPage(page);
        listParam.setPageSize(pageSize);
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            listParam.setOrder(order);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderKey)) {
            listParam.setOrderKey(orderKey);
        }
        listParam.setIncludeSubClass(includeSubClass);
        listParam.setExcludeSubClass(excludeSubClass);
        listParam.setGoodsName(goodsName);
        return this.success(this.getBizPortalService().listGoods(bizId, listParam));
    }

    @Path(value="goods/{goodsClass}/{goodsId}")
    @POST
    public Response downloadGoods(@PathParam(value="bizId") Long bizId, @PathParam(value="goodsClass") String goodsKey, @PathParam(value="goodsId") String goodsId, @QueryParam(value="platform") Integer platformCode) throws BusinessException {
        return this.success(this.getBizPortalService().downloadGoods(bizId, goodsKey, goodsId, platformCode));
    }

    @Path(value="{configId}/section/{sectionId}")
    @GET
    public Response getBizPortalSectionConfig(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId) throws BusinessException {
        return this.success(this.getBizPortalService().getBizPortalSectionConfig(bizId, configId, sectionId));
    }

    @Path(value="{configId}/section/{snapshotId}/js/{jsName}")
    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/javascript"})
    public Response getBizPortalSectionJS(@PathParam(value="snapshotId") Long snapshotId, @PathParam(value="jsName") String jsName) {
        try {
            Resource resource = this.getBizPortalService().getBizPortalSectionJS(snapshotId, jsName);
            if (resource != null && resource.exists()) {
                CacheControl cc = new CacheControl();
                cc.setNoTransform(true);
                cc.setMustRevalidate(false);
                cc.setNoCache(false);
                cc.setMaxAge(360000);
                Date lastModified = new Date(resource.lastModified());
                String etag = DateUtil.formatDateTime((Date)lastModified);
                EntityTag entityTag = new EntityTag(etag);
                Response.ResponseBuilder responseBuilder = this.request.evaluatePreconditions(lastModified, entityTag);
                if (responseBuilder != null) {
                    return responseBuilder.cacheControl(cc).build();
                }
                return Response.ok((Object)resource.getInputStream()).cacheControl(cc).lastModified(lastModified).expires(DateUtil.addYear((Date)new Date(), (int)1)).tag(etag).build();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u680f\u76eeJS\u6587\u4ef6\u51fa\u9519\uff1a", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{configId}/section/{sectionId}/{elementId}/ds")
    @GET
    public Response findAvailableDataSourceProvider(@QueryParam(value="dataFormat") Integer dataFormat, @QueryParam(value="versions") String versions) throws BusinessException {
        return this.success(this.getBizPortalService().getAvailableDataSourceProviders(dataFormat, versions));
    }

    @Path(value="{configId}/section/{sectionId}/{elementId}/ds/{uuid}")
    @GET
    public Response getDataSetList(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, @PathParam(value="uuid") String uuid, @QueryParam(value="versions") String versions, @QueryParam(value="platform") Integer platformCode, @QueryParam(value="dataId") String dataId) throws BusinessException {
        return this.success(this.getBizPortalService().getDataSetList(bizId, configId, sectionId, uuid, dataId, versions, platformCode));
    }

    @Path(value="{configId}/section/{sectionId}/{elementId}/ds/{uuid}")
    @POST
    public Response getDataSetList(@PathParam(value="bizId") Long bizId, @PathParam(value="uuid") String uuid, @QueryParam(value="versions") String versions, @QueryParam(value="platform") Integer platformCode, Map<String, Object> map) throws BusinessException {
        return this.success(this.getBizPortalService().getDataSetList(bizId, uuid, versions, platformCode, BizPortalUtils.create(map, DataSetMetadata.class)));
    }

    @Path(value="{configId}/section/{sectionId}/ds/bind")
    @POST
    public Response bindDataSet(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, List<String> list) throws BusinessException {
        ArrayList bindings = Lists.newArrayListWithCapacity((int)list.size());
        for (String json : list) {
            bindings.add(JSONUtil.parseJSONString((String)json, ElementDataSetBinding.class));
        }
        return this.success(this.getBizPortalService().bindDataSet(bizId, configId, sectionId, bindings));
    }

    @Path(value="{configId}/section/{sectionId}/ds/unbind")
    @POST
    public Response unbindDataSet(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, List<Long> elementIds) throws BusinessException {
        return this.success(this.getBizPortalService().unbindDataSet(bizId, configId, sectionId, elementIds));
    }

    @Path(value="{configId}/section/{sectionId}/{elementId}/data")
    @GET
    public Response getElementData(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, @PathParam(value="elementId") Long elementId, @QueryParam(value="platform") Integer platformCode, @DefaultValue(value="default") @QueryParam(value="op") String op, @DefaultValue(value="{}") @QueryParam(value="q") String condition) throws BusinessException {
        return this.success(this.getBizPortalService().getElementData(bizId, configId, sectionId, elementId, platformCode, op, condition));
    }

    @Path(value="{configId}/section/{sectionId}/data")
    @GET
    public Response getSectionData(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, @QueryParam(value="platform") Integer platformCode) throws BusinessException {
        return this.success(this.getBizPortalService().getSectionData(bizId, configId, sectionId, platformCode));
    }

    @Path(value="import/{fileId}/sectionFile")
    @POST
    public Response importBizPortalSectionFile(@PathParam(value="bizId") Long bizId, @PathParam(value="fileId") Long fileId, @QueryParam(value="platform") Integer platformCode) throws BusinessException {
        return this.success(this.getBizPortalService().importBizPortalSectionFile(bizId, fileId, platformCode));
    }

    @Path(value="sectionFile/list/my")
    @GET
    public Response listMyBizPortalSectionFiles(@PathParam(value="bizId") Long bizId, @QueryParam(value="platform") Integer platformCode, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="q") String name) throws BusinessException {
        return this.success(this.getBizPortalService().listMyBizPortalSectionFiles(bizId, platformCode, BizPortalFileListParam.of(page, pageSize, name)));
    }

    @Path(value="sectionFile/list/others")
    @GET
    public Response listOthersBizPortalSectionFiles(@PathParam(value="bizId") Long bizId, @QueryParam(value="platform") Integer platformCode, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="q") String name) throws BusinessException {
        return this.success(this.getBizPortalService().listOthersBizPortalSectionFiles(bizId, platformCode, BizPortalFileListParam.of(page, pageSize, name)));
    }

    @Path(value="sectionFile/{fileId}")
    @POST
    public Response createBizPortalSection(@PathParam(value="bizId") Long bizId, @PathParam(value="fileId") Long fileId) throws BusinessException {
        return this.success(this.getBizPortalService().createBizPortalSection(bizId, fileId));
    }

    @Path(value="sectionFile/{fileId}")
    @GET
    public Response getBizPortalSectionFile(@PathParam(value="fileId") Long fileId) throws BusinessException {
        return this.success(this.getBizPortalService().getBizPortalSectionFile(fileId));
    }

    @Path(value="sectionFile/{fileId}/remove")
    @POST
    public Response deleteBizPortalSectionFile(@PathParam(value="fileId") Long fileId) throws BusinessException {
        return this.success(this.getBizPortalService().deleteBizPortalSectionFile(fileId));
    }

    @Path(value="{configId}/section/{sectionId}/versionInfo")
    @GET
    public Response getBizPortalSectionVersionInfo(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId) throws BusinessException {
        return this.success(this.getBizPortalService().getBizPortalSectionVersionInfo(bizId, configId, sectionId));
    }

    @Path(value="{configId}/section/{sectionId}/update/cloud/{goodsId}")
    @POST
    public Response updateBizPortalSection(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, @PathParam(value="goodsId") String goodsId) throws BusinessException {
        return this.success(this.getBizPortalService().updateBizPortalSection(bizId, configId, sectionId, goodsId));
    }

    @Path(value="{configId}/section/{sectionId}/update/snapshot/{snapshotId}")
    @POST
    public Response updateBizPortalSection(@PathParam(value="bizId") Long bizId, @PathParam(value="configId") Long configId, @PathParam(value="sectionId") Long sectionId, @PathParam(value="snapshotId") Long snapshotId) throws BusinessException {
        return this.success(this.getBizPortalService().updateBizPortalSection(bizId, configId, sectionId, snapshotId));
    }

    @Path(value="{configId}/appIds")
    @GET
    public Response listSpaceConfigAppId(@PathParam(value="configId") Long configId) throws BusinessException {
        return this.success(this.getBizPortalService().listSpaceConfigAppId(configId));
    }

    @Path(value="menuChecked")
    @GET
    public Response isCAPPortalMenuChecked(@PathParam(value="bizId") Long bizId) throws BusinessException {
        return this.success(this.getBizPortalService().isCAPPortalMenuChecked(bizId));
    }

    private BizPortalService getBizPortalService() {
        return (BizPortalService)AppContext.getBean((String)"bizPortalService");
    }
}

