/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.function.Predicate;
import com.seeyon.cap4.bizportal.manager.OrganizationAdapterManager;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgUnit;
import com.seeyon.ctp.rest.resources.CAPBaseResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

@Path(value="cap4/org")
public class CAPOrgResource
extends CAPBaseResource {
    private static final Log logger = CtpLogFactory.getLog(CAPOrgResource.class);

    private OrganizationAdapterManager getOrganizationAdapterManager() {
        return (OrganizationAdapterManager)AppContext.getBean((String)"organizationAdapterManager");
    }

    @GET
    @Path(value="account")
    public Response findAccessableAccounts() {
        try {
            User currentUser = AppContext.getCurrentUser();
            List<V3xOrgAccount> list = this.getOrganizationAdapterManager().findAccessableAccount(currentUser);
            DefaultDataSetList dataSetList = new DefaultDataSetList();
            HashSet accountIds = Sets.newHashSet();
            for (V3xOrgAccount account : list) {
                String parentId = account.getSuperior0().toString();
                DefaultDataSetList.Node branchNode = dataSetList.createBranchNode(account.getId().toString(), account.getName(), parentId);
                dataSetList.addNode(branchNode);
                accountIds.add(parentId);
            }
            for (DefaultDataSetList.Node node : dataSetList.getList()) {
                if (accountIds.contains(node.getId())) continue;
                node.setBranch(false);
            }
            HashMap current = Maps.newHashMap();
            current.put("accountId", currentUser.getLoginAccount());
            current.put("departmentId", currentUser.getDepartmentId());
            HashMap result = Maps.newHashMap();
            result.put("accountList", dataSetList);
            result.put("current", current);
            return this.success(result);
        }
        catch (BusinessException e) {
            logger.error((Object)"", (Throwable)e);
            return this.success(ServiceResult.internalError(e.getMessage()));
        }
    }

    @GET
    @Path(value="account/depts")
    public Response findDepartment(@QueryParam(value="accountId") Long accountId, final @QueryParam(value="q") String q) {
        OrganizationAdapterManager organizationAdapterManager = this.getOrganizationAdapterManager();
        User user = AppContext.getCurrentUser();
        if (accountId == null) {
            accountId = user.getAccountId();
        }
        try {
            V3xOrgUnit v3xOrgUnit = organizationAdapterManager.getV3xOrgUnit(accountId);
            DefaultDataSetList dataSetList = new DefaultDataSetList();
            DefaultDataSetList.Node branchNode = dataSetList.createBranchNode(v3xOrgUnit.getId().toString(), v3xOrgUnit.getName());
            dataSetList.addNode(branchNode);
            Predicate<V3xOrgDepartment> predicate = StringUtils.isNotEmpty((CharSequence)q) ? new Predicate<V3xOrgDepartment>(){

                @Override
                public boolean apply(V3xOrgDepartment input) {
                    return input.getName().contains(q);
                }
            } : new Predicate<V3xOrgDepartment>(){

                @Override
                public boolean apply(V3xOrgDepartment input) {
                    return true;
                }
            };
            List<V3xOrgDepartment> departments = organizationAdapterManager.findAccessableDepartment(user, accountId, predicate);
            HashSet superDeptIds = Sets.newHashSet();
            ArrayList validDepts = Lists.newArrayListWithCapacity((int)departments.size());
            for (V3xOrgDepartment dept : departments) {
                if (!dept.getIsInternal().booleanValue()) continue;
                validDepts.add(dept);
                superDeptIds.add(dept.getSuperior());
            }
            for (V3xOrgDepartment dept : validDepts) {
                boolean isLeaf;
                Long deptId = dept.getId();
                boolean bl = isLeaf = !superDeptIds.contains(deptId);
                if (isLeaf) {
                    dataSetList.addNode(dataSetList.createLeafNode(deptId.toString(), dept.getName(), dept.getSuperior().toString()));
                    continue;
                }
                dataSetList.addNode(dataSetList.createBranchNode(deptId.toString(), dept.getName(), dept.getSuperior().toString()));
            }
            return this.success(dataSetList);
        }
        catch (BusinessException e) {
            logger.error((Object)("accountId=" + accountId + ", q=" + q), (Throwable)e);
            return this.success(ServiceResult.internalError(e.getMessage()));
        }
    }
}

