/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.report.service.CAPReportService;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.rest.resources.CAPBaseResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;

@Path(value="cap4/report")
public class CAPReportResource
extends CAPBaseResource {
    private static final Log logger = CtpLogFactory.getLog(CAPReportResource.class);

    @Path(value="query/{id}")
    @GET
    public Response getQueryConfig(@PathParam(value="id") Long designId, @QueryParam(value="conditionId") Long conditionId, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="platform") Integer platformCode) throws BusinessException {
        page = page == null ? 1 : page;
        pageSize = pageSize == null ? 50 : pageSize;
        return this.success(this.getCAPReportService().getQueryConfig(designId, conditionId, page, pageSize, platformCode));
    }

    @Path(value="query/{id}/{platform}")
    @POST
    public Response getQueryDataList(@PathParam(value="id") Long designId, @PathParam(value="platform") Integer platformCode, Map<String, Object> params) throws BusinessException {
        return this.success(this.getCAPReportService().getQueryDataList(designId, platformCode, Command.of(params)));
    }

    @Path(value="export/{id}")
    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    public Response exportDataList(@PathParam(value="id") Long designId, Map<String, Object> params) throws BusinessException {
        if (designId == null) {
            logger.warn((Object)("\u65e0\u6548\u53c2\u6570, id=" + designId));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Long userId = AppContext.getCurrentUser().getId();
        try {
            Pair<String, File> pair = this.getCAPReportService().exportDataList(designId, userId, params);
            String fileName = (String)pair.getLeft();
            File file = (File)pair.getRight();
            FileInputStream is = new FileInputStream(file);
            return Response.ok((Object)is).header("Content-disposition", (Object)fileName).build();
        }
        catch (IOException e) {
            logger.error((Object)("\u5bfc\u51faExcel\u5931\u8d25, designId=" + designId + ", userId=" + userId));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private CAPReportService getCAPReportService() {
        return (CAPReportService)AppContext.getBean((String)"capReportService");
    }
}

