/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.seeyon.cap4.template.bean.GoodListParamBean;
import com.seeyon.cap4.template.bean.TemplatesParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.service.CAPTemplateDataService;
import com.seeyon.cap4.template.service.CAPTemplateDesignEditService;
import com.seeyon.cap4.template.service.CAPTemplateDesignMallService;
import com.seeyon.cap4.template.service.CAPTemplateDesignService;
import com.seeyon.cap4.template.service.ServiceProxy;
import com.seeyon.cap4.template.util.CAPBuildM3Util;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.rest.resources.BaseResource;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="cap4/template")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CAPTemplateResource
extends BaseResource {
    private CAPTemplateDesignService capTemplateDesignService = (CAPTemplateDesignService)AppContext.getBean((String)"capTemplateDesignService");
    private CAPTemplateDesignEditService capTemplateDesignEditService = (CAPTemplateDesignEditService)AppContext.getBean((String)"capTemplateDesignEditService");
    private CAPTemplateDesignMallService capTemplateDesignMallService = (CAPTemplateDesignMallService)AppContext.getBean((String)"capTemplateDesignMallService");
    private CAPTemplateDataService capTemplateDataService = (CAPTemplateDataService)AppContext.getBean((String)"capTemplateDataService");
    @Context
    private HttpServletResponse resp;

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveEditableTemplate")
    public Response saveEditableTemplate(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.saveEditableTemplate(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getCacheEditableConfigJSON")
    public Response getCacheEditableConfigJSON(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.getCacheEditableConfigJSON(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="restoreEditableTemplateToInitial")
    public Response restoreEditableTemplateToInitial(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.restoreToInitial(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="cancelEditTemplate")
    public Response cancelEditTemplate(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.cancelEditTemplate(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="removeCacheEditableConfigJSON")
    public Response removeCacheEditableConfigJSON(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.removeCacheEditableConfigJSON(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="putCacheEditableConfigJSON")
    public Response putCacheEditableConfigJSON(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.putCacheEditableConfigJSON(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getMobileTemplatesByMenuId")
    public Response getMobileTemplatesByMenuId(Map<String, Object> params) {
        return this.success(this.capTemplateDataService.getMobileTemplatesByMenuId(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getMobileTemplatesByPathId")
    public Response getMobileTemplatesByPathId(Map<String, Object> params) {
        return this.success(this.capTemplateDataService.getMobileTemplatesByPathId(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="autoMatchElementData")
    public Response autoMatchElementData(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "autoMatchElementData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="autoMatchEditableElementDataSource")
    public Response autoMatchEditableElementDataSource(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignEditService, "autoMatchElementData", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveElementName")
    public Response saveElementName(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.saveElementName(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="clearElementDataConfig")
    public Response clearElementDataConfig(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.clearElementDataConfig(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveFlowFieldConfig")
    public Response saveFlowFieldConfig(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.saveFlowFieldConfig(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getFlowFieldConfig")
    public Response getFlowFieldConfig(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getFlowFieldConfig(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getUnflowAndFlowTemplates")
    public Response getUnflowAndFlowTemplates(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getUnflowAndFlowTemplates(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getElementConfigTypes")
    public Response getElementConfigTypes(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getElementConfigTypes(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveElementConfigType")
    public Response saveElementConfigType(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.multiSaveElementConfigType(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getElements")
    public Response getElements(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getElements(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getElementsByColumnId")
    public Response getElementsByColumnId(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.getElementsByColumnId(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveElementByColumnId")
    public Response saveElementByColumnId(Map<String, Object> params) {
        return this.success(this.capTemplateDesignEditService.saveElementByColumnId(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getElementsList")
    public Response getElementsList(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getElementsByTemplateIds(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getElementsListByBizId")
    public Response getElementsListByBizId(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.getElementsByBizId(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="multiUpdateColumn")
    public Response multiUpdateColumn(Map<String, Object> params) {
        return this.success(this.capTemplateDesignService.multiUpdateColumnSingleField(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="updateColumns")
    public Response updateColumns(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignEditService, "updateColumns", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getColumnsByTemplateIds")
    public Response getColumnsByTemplateIds(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "getColumnsByTemplateIds", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getColumnsByTemplateId")
    public Response getColumnsByTemplateId(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignEditService, "getColumnsByTemplateId", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTemplateOrgAuth/{templateId}")
    public Response getTemplateOrgAuth(@PathParam(value="templateId") Long templateId) {
        return this.success(this.capTemplateDesignService.getTemplateOrgAuth(templateId));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveTemplateOrgAuth")
    public Response saveTemplateOrgAuth(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "multiSaveTemplateOrgAuth", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="multiDeleteTemplate")
    public Response multiDeleteTemplate(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "multiDeleteTemplate", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="multiUpdateTemplate")
    public Response multiUpdateTemplate(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "multiUpdateTemplateSingleField", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getCAPBusinessTemplates/{bizId}")
    public Response getCAPBusinessTemplates(@PathParam(value="bizId") Long bizId) {
        TemplatesParamBean bean = new TemplatesParamBean();
        bean.setBizId(bizId);
        bean.setTemplateType(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType());
        return this.success(this.capTemplateDesignService.getCAPBusinessTemplates(bean));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getCAPBusinessTemplates")
    public Response getCAPBusinessTemplates(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignService, "getCAPBusinessTemplates", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="downloadCustomCtrl")
    public Response downloadCustomCtrl(Map<String, Object> params) {
        params.put("downloadZipType", String.valueOf(CAPBusinessEnum.DownloadZipType.CUSTOM_CTRL.getType()));
        return this.success(ServiceProxy.invoke(this.capTemplateDesignMallService, "download", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="downloadCustomButton")
    public Response downloadCustomButton(Map<String, Object> params) {
        params.put("downloadZipType", String.valueOf(CAPBusinessEnum.DownloadZipType.CUSTOM_BIND_BUTTON.getType()));
        return this.success(ServiceProxy.invoke(this.capTemplateDesignMallService, "download", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="downloadColumn")
    @Deprecated
    public Response downloadColumn(Map<String, Object> params) {
        params.put("downloadZipType", String.valueOf(CAPBusinessEnum.DownloadZipType.COLUMN.getType()));
        return this.success(ServiceProxy.invoke(this.capTemplateDesignMallService, "download", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="downloadTemplate")
    @Deprecated
    public Response downloadTemplate(Map<String, Object> params) {
        params.put("downloadZipType", String.valueOf(CAPBusinessEnum.DownloadZipType.TEMPLATE.getType()));
        return this.success(ServiceProxy.invoke(this.capTemplateDesignMallService, "download", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="mallDownload")
    public Response mallDownload(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDesignMallService, "download", params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="buildM3AppsByBizId/{bizId}")
    public Response buildM3AppsByBizId(@PathParam(value="bizId") Long bizId) {
        return this.success(CAPBuildM3Util.buildM3AppsByBizId(bizId, false));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="autoUpdateTemplate")
    public Response autoUpdateTemplate() {
        return this.success(this.capTemplateDesignService.autoUpdateTemplate());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="show")
    public Response show(Map<String, Object> params) {
        Long goodId = ParamUtil.getLong(params, (String)"goodId");
        Integer flag = ParamUtil.getInt(params, (String)"flag");
        return this.success(this.capTemplateDesignMallService.getGoods(goodId, flag));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="list")
    public Response list(Map<String, Object> params) {
        GoodListParamBean bean = new GoodListParamBean();
        bean.setPage(ParamUtil.getInt(params, (String)"page", (int)1));
        bean.setPageSize(ParamUtil.getInt(params, (String)"pageSize", (int)20));
        bean.setListType(ParamUtil.getInt(params, (String)"listType", (int)CAPBusinessEnum.DownloadZipType.TEMPLATE.getType()));
        bean.setPlatform(ParamUtil.getInt(params, (String)"platform", (int)CAPBusinessEnum.Platform.PC.getType()));
        bean.setType(ParamUtil.getInt(params, (String)"type"));
        FlipInfo fi = new FlipInfo(bean.getPage().intValue(), bean.getPageSize().intValue());
        if (bean.getListType().intValue() == CAPBusinessEnum.DownloadZipType.TEMPLATE.getType()) {
            return this.success(this.capTemplateDesignMallService.getBusinessTemplateList(bean.getType(), bean.getPlatform(), fi));
        }
        if (bean.getListType().intValue() == CAPBusinessEnum.DownloadZipType.COLUMN.getType()) {
            return this.success(this.capTemplateDesignMallService.getBusinessColumnList(bean.getType(), bean.getPlatform(), fi));
        }
        return this.success(this.capTemplateDesignMallService.getBusinessCustomCtrlList(bean.getListType(), fi));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getDataByTemplateId/{templateId}")
    public Response getDataByTemplateId(@PathParam(value="templateId") String templateId) {
        return this.success(this.capTemplateDataService.getDataByTemplateId(templateId));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getDataByColumnIds")
    public Response getDataByColumnIds(Map<String, Object> params) {
        return this.success(ServiceProxy.invoke(this.capTemplateDataService, "getDataByColumnIds", params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getDataByElementIds")
    public Response getDataByElementIds(Map<String, Object> params) {
        return this.success(this.capTemplateDataService.getDataByElementIds(params));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getDataByRealParams")
    public Response getDataByRealParams(Map<String, Object> params) {
        return this.success(this.capTemplateDataService.getDataByRealParams(params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTemplatesByCurrentUser/{bizId}/{client}")
    public Response getTemplatesByCurrentUser(@PathParam(value="bizId") String bizId, @PathParam(value="client") String client) {
        return this.success(this.capTemplateDataService.getTemplatesByCurrentUser(bizId, client));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getCurrentUserInfo")
    public Response getCurrentUserInfo() {
        return this.success(this.capTemplateDataService.getCurrentUserInfo());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getMenusByBussId/{bussId}")
    public Response getMenusByBussId(@PathParam(value="bussId") String bussId, @QueryParam(value="platform") String platform) {
        return this.success(this.capTemplateDataService.getMenusByBussId(bussId, platform));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getDefaultTemplateDataById/{bussId}")
    public Response getDefaultTemplateDataById(@PathParam(value="bussId") String bussId, @QueryParam(value="platform") String platform) {
        return this.success(this.capTemplateDataService.getDefaultTemplateDatas(bussId, platform));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="getNearbyMap")
    public Response getNearbyMap(Map<String, Object> params) {
        return this.success(this.capTemplateDataService.getNearbyMap(params));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getMenuSettingsList/{bussId}")
    public Response getMenuSettingsList(@PathParam(value="bussId") String bussId, @QueryParam(value="platform") String platform) {
        return this.success(this.capTemplateDataService.getMenuSettingsList(bussId, platform));
    }
}

