/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.rest.resources;

import com.seeyon.cap4.form.logo.CAPLogoManager;
import com.seeyon.cap4.form.po.CAPLogo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.rest.resources.BaseResource;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.annotation.RestInterfaceAnnotation;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;

@Path(value="cap4/logo")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LogoResource
extends BaseResource {
    private static final Log LOG = CtpLogFactory.getLog(LogoResource.class);

    @GET
    @Path(value="all")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response getAllLogos() throws BusinessException {
        CAPLogoManager capLogoManager = (CAPLogoManager)AppContext.getBean((String)"capLogoManager");
        List<Map<String, Object>> allLogos = capLogoManager.getAllLogos();
        return this.success(allLogos);
    }

    @POST
    @Path(value="update")
    @RestInterfaceAnnotation(OpenExternal=RestInterfaceAnnotation.External.NO, StartVersion="V7.1")
    public Response updateLogo(Map<String, String> params) throws BusinessException, IOException {
        HashMap result = new HashMap();
        CAPLogoManager capLogoManager = (CAPLogoManager)AppContext.getBean((String)"capLogoManager");
        FileManager fileManager = (FileManager)AppContext.getBean((String)"fileManager");
        Long newFileUrl = Long.valueOf(params.get("newFileUrl"));
        Long oldUrl = Long.valueOf(params.get("oldFileUrl"));
        File newFile = fileManager.getFile(newFileUrl, new Date());
        CAPLogo capLogo = capLogoManager.findByFileUrl(oldUrl);
        Date createDate = capLogo.getCreateDate();
        File oldFile = fileManager.getFile(oldUrl, createDate);
        if (null == oldFile) {
            String folder = fileManager.getFolder(createDate, true);
            String path = folder + File.separator + oldUrl;
            oldFile = new File(path);
        } else {
            oldFile.deleteOnExit();
        }
        oldFile.createNewFile();
        FileUtil.copyFile((File)newFile, (File)oldFile);
        return this.success(result);
    }
}

