/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.workflow;

import com.seeyon.apps.project.api.ProjectApi;
import com.seeyon.apps.project.bo.ProjectBO;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.JoinOrgManagerDirect;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.workflow.bo.NodeBindFormOperationBO;
import com.seeyon.ctp.workflow.bo.NodeBindFormViewBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormBranchBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormBranchInBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormFieldBO;
import com.seeyon.ctp.workflow.bo.WorkflowFromBranchExtendBO;
import com.seeyon.ctp.workflow.wapi.WorkflowFormDataMapManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class CAP4WorkflowFormDataMapManagerImpl
implements WorkflowFormDataMapManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4WorkflowFormDataMapManagerImpl.class);
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4FormManager cap4FormManager;
    private JoinOrgManagerDirect joinOrgManagerDirect;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDataManager cap4FormDataManager;
    private OrgManager orgManager;

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public JoinOrgManagerDirect getJoinOrgManagerDirect() {
        return this.joinOrgManagerDirect;
    }

    public void setJoinOrgManagerDirect(JoinOrgManagerDirect joinOrgManagerDirect) {
        this.joinOrgManagerDirect = joinOrgManagerDirect;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public List<WorkflowFormBranchBO> getBranchAllFormFields(String formAppId) {
        return this.getFormFieldsForBranch(formAppId, null);
    }

    private List<FormFieldBean> getFieldBeanListByTableSort(FormBean formBean) {
        ArrayList<FormFieldBean> fieldBeanList = new ArrayList<FormFieldBean>();
        List tableList = formBean.getTableList();
        int index = 1;
        for (FormTableBean tempFormTableBean : tableList) {
            List temp = tempFormTableBean.getFields();
            String flag = "";
            if (!tempFormTableBean.isMainTable()) {
                flag = String.valueOf(index);
                ++index;
            }
            if (temp == null || temp.isEmpty()) continue;
            for (FormFieldBean tempf : temp) {
                fieldBeanList.add(tempf);
                tempf.putExtraAttr("NotMasterTableFlag", flag);
            }
        }
        return fieldBeanList;
    }

    private List<WorkflowFormBranchBO> getFormFieldsForBranch(String formAppId, String fieldName) {
        ArrayList<WorkflowFormBranchBO> vos = new ArrayList<WorkflowFormBranchBO>();
        List<String[]> fieldList = null;
        FormBean formBean = this.getCurrentEditingForm(formAppId);
        HashMap<String, FormFieldBean> name2FieldBean = new HashMap<String, FormFieldBean>();
        if (formBean != null) {
            List<FormFieldBean> fieldBeanList = this.getFieldBeanListByTableSort(formBean);
            if (Strings.isNotEmpty(fieldBeanList)) {
                for (FormFieldBean bean : fieldBeanList) {
                    name2FieldBean.put(bean.getName(), bean);
                }
            }
            fieldList = this.getDisplayFormField(fieldBeanList, formBean);
        }
        if (Strings.isNotEmpty(fieldList)) {
            for (String[] arr : fieldList) {
                FormFieldBean currentBean;
                String label = arr[0];
                String name = arr[1];
                FormFieldBean bean = (FormFieldBean)name2FieldBean.get(name);
                if (Strings.isNotBlank((String)fieldName) && !(currentBean = (FormFieldBean)name2FieldBean.get(fieldName)).getOwnerTableName().equalsIgnoreCase(bean.getOwnerTableName())) continue;
                WorkflowFormBranchBO vo = this.convert2BranchVO(bean);
                if (null != vo) {
                    vo.setComplexLabel(label);
                }
                vos.add(vo);
            }
        }
        return vos;
    }

    public List<WorkflowFormBranchBO> getBranchSlaveFormFields(String formApp, String fieldName) {
        return this.getFormFieldsForBranch(formApp, fieldName);
    }

    public List<WorkflowFormBranchBO> getBranchInExcludeFormFields(String formApp, String fieldName) {
        FormBean formBean = this.getCurrentEditingForm(formApp);
        List<FormFieldBean> slaveFieldList = null;
        List<String[]> slaveFieldDisplayList = null;
        List<WorkflowFormBranchBO> vos = null;
        if (formBean != null) {
            List fieldList = formBean.getAllFieldBeans();
            FormFieldBean targetFieldBean = this.getFormFieldBean(formBean, fieldName);
            slaveFieldList = this.getTheSameTypeFormField(fieldList, targetFieldBean, formBean);
            slaveFieldDisplayList = this.getDisplayFormField(slaveFieldList, formBean);
            vos = this.convert2WorkflowFormBranchVO(formBean, slaveFieldDisplayList);
        }
        return vos;
    }

    public WorkflowFormBranchInBO getBranchInFormFields(String formApp, String fieldName) throws Exception {
        String type = "";
        String typeText = "";
        boolean isCanSetByExtend = true;
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean currentFieldBean = null;
        List formFieldList = null;
        List<String[]> thisFormList = new ArrayList<String[]>();
        if (formBean != null && Strings.isNotBlank((String)fieldName)) {
            currentFieldBean = this.getFormFieldBean(formBean, fieldName);
            int externalType = 0;
            boolean isVjionField = false;
            formFieldList = formBean.getAllFieldBeans();
            if (currentFieldBean != null) {
                FormFieldComEnum realType = currentFieldBean.getInputTypeEnum();
                if (realType != null) {
                    type = realType.getKey();
                    typeText = realType.getText();
                }
                String ownerTableName = currentFieldBean.getOwnerTableName();
                FormFieldComEnum needType = null;
                switch (realType) {
                    case EXTEND_MEMBER: {
                        needType = FormFieldComEnum.EXTEND_MULTI_MEMBER;
                        break;
                    }
                    case EXTEND_ACCOUNT: {
                        needType = FormFieldComEnum.EXTEND_MULTI_ACCOUNT;
                        break;
                    }
                    case EXTEND_DEPARTMENT: {
                        needType = FormFieldComEnum.EXTEND_MULTI_DEPARTMENT;
                        break;
                    }
                    case EXTEND_POST: {
                        needType = FormFieldComEnum.EXTEND_MULTI_POST;
                        break;
                    }
                    case EXTEND_LEVEL: {
                        needType = FormFieldComEnum.EXTEND_MULTI_LEVEL;
                        break;
                    }
                    default: {
                        isCanSetByExtend = false;
                    }
                }
                externalType = currentFieldBean.getExternalType();
                isVjionField = externalType != OrgConstants.ExternalType.Inner.ordinal();
                ArrayList<FormFieldBean> sameTypeFieldList = new ArrayList<FormFieldBean>();
                if (isCanSetByExtend) {
                    for (FormFieldBean field : formFieldList) {
                        int externalType1;
                        if (field.getName().equals(currentFieldBean.getName()) || (externalType1 = field.getExternalType().intValue()) != externalType) continue;
                        FormFieldComEnum tempRealType = field.getInputTypeEnum();
                        if (!ownerTableName.equals(field.getOwnerTableName()) || !tempRealType.equals((Object)needType)) continue;
                        sameTypeFieldList.add(field);
                    }
                    thisFormList = this.getDisplayFormField(sameTypeFieldList, formBean);
                }
                WorkflowFormBranchInBO invo = new WorkflowFormBranchInBO();
                List<WorkflowFormBranchBO> vo = this.convert2WorkflowFormBranchVO(formBean, thisFormList);
                invo.setBranchVOs(vo);
                invo.setDisplay(currentFieldBean.getDisplay());
                invo.setExternalType(Integer.valueOf(externalType));
                invo.setRealInputType(type);
                return invo;
            }
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
        }
        throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
    }

    private FormBean getCurrentEditingForm(String formApp) {
        CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
        FormBean edittingFormBean = null;
        if (Strings.isNotBlank((String)formApp)) {
            Long formId = Long.parseLong(formApp);
            edittingFormBean = cap4FormManager.getForm(formId);
        } else {
            LOGGER.error((Object)("\u83b7\u53d6\u8868\u5355\u5b9a\u4e49\u5bf9\u8c61\u65f6\uff0c\u6ca1\u6709\u4f20\u9012\u8868\u5355id\uff0c\u5f53\u524d\u4f20\u5165\u503c\u4e3a\uff1a" + formApp));
        }
        return edittingFormBean;
    }

    private FormFieldBean getFormFieldBean(FormBean formBean, String fieldName) {
        FormFieldBean formFieldBean = formBean.getFieldBeanByDisplay(fieldName);
        if (null == formFieldBean) {
            formFieldBean = formBean.getFieldBeanByName(fieldName);
        }
        return formFieldBean;
    }

    public List<FormFieldBean> getTheSameTypeFormField(List<FormFieldBean> fieldBeanList, FormFieldBean fieldBean, FormBean currentFormBean) {
        ArrayList<FormFieldBean> resultList = new ArrayList<FormFieldBean>();
        if (fieldBeanList != null && fieldBeanList.size() > 0) {
            for (FormFieldBean field : fieldBeanList) {
                if (field.getName().equals(fieldBean.getName()) || !field.getOwnerTableName().equals(fieldBean.getOwnerTableName())) continue;
                FormFieldComEnum fieldRealType = field.getInputTypeEnum();
                if ((!Enums.FieldType.VARCHAR.getKey().equals(field.getFieldType().toUpperCase()) && !Enums.FieldType.LONGTEXT.getKey().equals(field.getFieldType().toUpperCase()) || !FormFieldComEnum.TEXT.equals((Object)fieldRealType) && !FormFieldComEnum.TEXTAREA.equals((Object)fieldRealType)) && !FormFieldComEnum.FLOWDEALOPITION.equals((Object)fieldRealType)) continue;
                resultList.add(field);
            }
        }
        return resultList;
    }

    public List<FormFieldBean> getTheSameTypeFormFieldNotText(List<FormFieldBean> fieldBeanList, FormFieldBean currentFieldBean, FormBean currentFormBean) {
        List<FormFieldBean> resultList = new ArrayList<FormFieldBean>();
        if (fieldBeanList != null && fieldBeanList.size() > 0) {
            boolean zhubiaoFlag = currentFieldBean.isMasterField();
            FormFieldBean sourceFieldBean = currentFieldBean;
            FormBean sourceFormBean = currentFormBean;
            FormFieldComEnum fieldTypeEnum = sourceFieldBean.getInputTypeEnum();
            fieldTypeEnum = currentFieldBean.getInputTypeEnum();
            int externalType = currentFieldBean.getExternalType();
            switch (fieldTypeEnum) {
                case TEXT: 
                case TEXTAREA: 
                case FLOWDEALOPITION: {
                    if (!Enums.FieldType.VARCHAR.getKey().equals(sourceFieldBean.getFieldType().toUpperCase()) && !Enums.FieldType.LONGTEXT.getKey().equals(sourceFieldBean.getFieldType().toUpperCase())) break;
                    resultList.add(sourceFieldBean);
                    resultList = this.getTheSameTypeFormField(fieldBeanList, currentFieldBean, currentFormBean);
                    break;
                }
                case EXTEND_DATE: {
                    for (FormFieldBean field : fieldBeanList) {
                        FormFieldComEnum tempType;
                        if (field.getName().equals(currentFieldBean.getName()) || !field.getOwnerTableName().equals(currentFieldBean.getOwnerTableName()) || zhubiaoFlag ^ field.isMasterField() || !FormFieldComEnum.EXTEND_DATE.equals((Object)(tempType = field.getInputTypeEnum()))) continue;
                        resultList.add(field);
                    }
                    break;
                }
                case EXTEND_DATETIME: {
                    for (FormFieldBean field : fieldBeanList) {
                        FormFieldComEnum tempType;
                        if (field.getName().equals(currentFieldBean.getName()) || !field.getOwnerTableName().equals(currentFieldBean.getOwnerTableName()) || zhubiaoFlag ^ field.isMasterField() || !FormFieldComEnum.EXTEND_DATETIME.equals((Object)(tempType = field.getInputTypeEnum()))) continue;
                        resultList.add(field);
                    }
                    break;
                }
                case EXTEND_MEMBER: 
                case EXTEND_DEPARTMENT: 
                case EXTEND_POST: {
                    for (FormFieldBean field : fieldBeanList) {
                        int externalType1 = field.getExternalType();
                        if (field.getName().equals(currentFieldBean.getName()) || !field.getOwnerTableName().equals(currentFieldBean.getOwnerTableName()) || zhubiaoFlag ^ field.isMasterField() || externalType1 != externalType || !fieldTypeEnum.equals((Object)field.getInputTypeEnum())) continue;
                        resultList.add(field);
                    }
                    break;
                }
                case EXTEND_ACCOUNT: 
                case EXTEND_LEVEL: 
                case SELECT: 
                case CHECKBOX: 
                case RADIO: {
                    for (FormFieldBean field : fieldBeanList) {
                        if (field.getName().equals(currentFieldBean.getName()) || !field.getOwnerTableName().equals(currentFieldBean.getOwnerTableName()) || zhubiaoFlag ^ field.isMasterField() || !fieldTypeEnum.equals((Object)field.getInputTypeEnum())) continue;
                        resultList.add(field);
                    }
                    break;
                }
            }
        }
        return resultList;
    }

    private String[] createFormDisplay(FormFieldBean field) {
        String[] fieldDisplayElem = new String[]{this.getFieldDisplayLabel(field), field.getName()};
        return fieldDisplayElem;
    }

    private String getFieldDisplayLabel(FormFieldBean field) {
        String masterTableLabel = ResourceUtil.getString((String)"form.base.mastertable.label");
        String slaveTableLabel = ResourceUtil.getString((String)"formoper.dupform.label");
        StringBuilder display = new StringBuilder();
        Object flag = field.getExtraAttr("NotMasterTableFlag");
        if (flag == null) {
            flag = "";
        }
        display.append('[');
        if (field.isMasterField()) {
            display.append(masterTableLabel);
        } else {
            display.append(field.getOwnerTableDisplay()).append(flag);
        }
        display.append(']');
        display.append(field.getDisplay());
        display.append('(');
        display.append(this.getInputType(field));
        display.append(')');
        return display.toString();
    }

    private String getFieldType(String fieldType) {
        String result = "";
        if (Enums.FieldType.VARCHAR.getKey().equals(fieldType)) {
            result = Enums.FieldType.VARCHAR.getText();
        } else if (Enums.FieldType.DECIMAL.getKey().equals(fieldType)) {
            result = Enums.FieldType.DECIMAL.getText();
        } else if (Enums.FieldType.TIMESTAMP.getKey().equals(fieldType)) {
            result = Enums.FieldType.TIMESTAMP.getText();
        } else if (Enums.FieldType.DATETIME.getKey().equals(fieldType)) {
            result = Enums.FieldType.DATETIME.getText();
        } else if (Enums.FieldType.LONGTEXT.getKey().equals(fieldType)) {
            result = Enums.FieldType.LONGTEXT.getText();
        }
        return result;
    }

    private String getInputType(FormFieldBean field) {
        String result = "";
        if (field != null && field.getInputTypeEnum() != null) {
            switch (field.getInputTypeEnum()) {
                case TEXT: 
                case TEXTAREA: {
                    result = this.getFieldType(field.getFieldType());
                    break;
                }
                default: {
                    result = field.getInputTypeEnum().getText();
                }
            }
        }
        return result;
    }

    public List<String[]> getDisplayFormField(List<FormFieldBean> fieldBeanList, FormBean currentFormBean) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (fieldBeanList != null && fieldBeanList.size() > 0) {
            block4: for (FormFieldBean field : fieldBeanList) {
                if (field == null || field.getInputTypeEnum() == null) continue;
                FormFieldComEnum myFormFileComEnum = field.getInputTypeEnum();
                switch (myFormFileComEnum) {
                    case EXTEND_ATTACHMENT: 
                    case EXTEND_DOCUMENT: 
                    case EXTEND_IMAGE: 
                    case MAP_MARKED: 
                    case MAP_LOCATE: 
                    case MAP_PHOTO: 
                    case LINE_NUMBER: {
                        continue block4;
                    }
                    case CUSTOM_CONTROL: {
                        FormFieldCustomCtrl customCtrl = (FormFieldCustomCtrl)field.getFieldCtrl();
                        if (!customCtrl.canInWorkFlowBranch() || customCtrl.getKey().equalsIgnoreCase(customCtrl.mappingStandardCtrlType())) continue block4;
                        field.putExtraAttr("relation", "");
                        field.putExtraAttr("realType", myFormFileComEnum.getKey());
                        result.add(this.createFormDisplay(field));
                        continue block4;
                    }
                }
                field.putExtraAttr("relation", "");
                field.putExtraAttr("realType", myFormFileComEnum.getKey());
                result.add(this.createFormDisplay(field));
            }
        }
        return result;
    }

    private WorkflowFormBranchBO convert2BranchVO(FormFieldBean field) {
        if (field == null) {
            return null;
        }
        WorkflowFormBranchBO vo = new WorkflowFormBranchBO();
        vo.setName(field.getName());
        vo.setDisplay(field.getDisplay());
        vo.setFieldType(field.getFieldType());
        if (field.isCustomerCtrl()) {
            vo.setInputType(((FormFieldCustomCtrl)field.getFieldCtrl()).mappingStandardCtrlType());
        } else {
            vo.setInputType(field.getInputType());
        }
        vo.setMasterField(field.isMasterField());
        vo.setSubField(field.isSubField());
        if (null != field.getExtraAttr("realType")) {
            vo.setRealInputType(field.getExtraAttr("realType").toString());
        }
        return vo;
    }

    private List<WorkflowFormBranchBO> convert2WorkflowFormBranchVO(FormBean formBean, List<String[]> slaveFieldDisplayList) {
        ArrayList<WorkflowFormBranchBO> vos = new ArrayList<WorkflowFormBranchBO>();
        ArrayList canBranchFormFields = new ArrayList();
        if (Strings.isNotEmpty(slaveFieldDisplayList)) {
            for (String[] arr : slaveFieldDisplayList) {
                String label = arr[0];
                String name = arr[1];
                FormFieldBean bean = formBean.getFieldBeanByName(name);
                WorkflowFormBranchBO vo = this.convert2BranchVO(bean);
                if (null != vo) {
                    vo.setComplexLabel(label);
                }
                vos.add(vo);
            }
        }
        return vos;
    }

    public WorkflowFromBranchExtendBO getBranchExtendFormFields(String formApp, String fieldName) throws Exception {
        EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        boolean isShowRadio = false;
        boolean isShowSameType = false;
        boolean isShowDisignerByUser = false;
        boolean isShowOperation = true;
        boolean isHasOtherNotEqualOperator = false;
        boolean isHasLevelOperator = false;
        boolean isCanSetByExtend = true;
        int externalType = 0;
        boolean isVjionField = false;
        String type = "";
        String typeText = "";
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean currentFieldBean = null;
        FormFieldBean sourceFieldBean = null;
        List formFieldList = null;
        List<String[]> thisFormList = new ArrayList<String[]>();
        List enumList = null;
        if (formBean != null && Strings.isNotBlank((String)fieldName)) {
            List systemDataFieldList = FormulaEnums.SystemDataField.getSystemDataFieldForExtend();
            if (systemDataFieldList.contains(fieldName)) {
                FormFieldBean sysFormField = new FormFieldBean();
                sysFormField.setDisplay(FormulaEnums.SystemDataField.getEnumByKey((String)fieldName).getText());
                sysFormField.setFieldType(Enums.FieldType.VARCHAR.getKey());
                if (FormulaEnums.SystemDataField.creator.getKey().equals(fieldName)) {
                    sysFormField.setInputType(FormFieldComEnum.EXTEND_MEMBER.getKey());
                } else if (FormulaEnums.SystemDataField.createDate.getKey().equals(fieldName) || FormulaEnums.SystemDataField.modify_date.getKey().equals(fieldName)) {
                    sysFormField.setInputType(FormFieldComEnum.EXTEND_DATE.getKey());
                }
                currentFieldBean = sysFormField;
            } else {
                currentFieldBean = this.getFormFieldBean(formBean, fieldName);
            }
            formFieldList = formBean.getAllFieldBeans();
            if (currentFieldBean != null) {
                FormFieldCustomCtrl formFieldCtrl;
                String standardCtrltype;
                FormFieldComEnum standardCtrltypeEnum;
                sourceFieldBean = currentFieldBean;
                externalType = currentFieldBean.getExternalType();
                FormFieldComEnum myFormFieldComEnum = sourceFieldBean.getInputTypeEnum();
                if (currentFieldBean.isCustomerCtrl() && (standardCtrltypeEnum = FormFieldComEnum.getEnumByKey((String)(standardCtrltype = (formFieldCtrl = (FormFieldCustomCtrl)currentFieldBean.getFieldCtrl()).mappingStandardCtrlType()))) != null) {
                    myFormFieldComEnum = standardCtrltypeEnum;
                }
                type = myFormFieldComEnum.getKey();
                typeText = myFormFieldComEnum.getText();
                switch (myFormFieldComEnum) {
                    case EXTEND_DATE: 
                    case EXTEND_DATETIME: {
                        isHasOtherNotEqualOperator = true;
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case EXTEND_MEMBER: {
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case EXTEND_ACCOUNT: {
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case EXTEND_DEPARTMENT: {
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case EXTEND_POST: {
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case EXTEND_LEVEL: {
                        isHasLevelOperator = true;
                        isShowDisignerByUser = true;
                        isShowSameType = true;
                        isShowRadio = true;
                        break;
                    }
                    case RADIO: 
                    case IMAGE_RADIO: {
                        isShowDisignerByUser = true;
                        enumList = enumManagerNew.getFirstLevelItemsByEmumId(Long.valueOf(sourceFieldBean.getEnumId()));
                        break;
                    }
                    case SELECT: 
                    case IMAGE_SELECT: {
                        isShowDisignerByUser = true;
                        if (sourceFieldBean.getIsFinalChild()) {
                            enumList = enumManagerNew.getLastCtpEnumItem(Long.valueOf(sourceFieldBean.getEnumId()));
                            break;
                        }
                        enumList = enumManagerNew.getCtpEnumItem(Long.valueOf(sourceFieldBean.getEnumId()), sourceFieldBean.getEnumLevel());
                        break;
                    }
                    case CHECKBOX: {
                        isShowDisignerByUser = true;
                        isShowOperation = false;
                        break;
                    }
                    default: {
                        isCanSetByExtend = false;
                    }
                }
                isVjionField = externalType != OrgConstants.ExternalType.Inner.ordinal();
                ArrayList<FormFieldBean> sameTypeFieldList = new ArrayList(0);
                if (isShowSameType) {
                    sameTypeFieldList = this.getTheSameTypeFormFieldNotText(formFieldList, currentFieldBean, formBean);
                    thisFormList = this.getDisplayFormField(sameTypeFieldList, formBean);
                }
                ArrayList<CtpEnumItem> return_enumList = null;
                if (null != enumList && !enumList.isEmpty()) {
                    return_enumList = new ArrayList<CtpEnumItem>();
                    for (int i = 0; i < enumList.size(); ++i) {
                        CtpEnumItem ctpItem = (CtpEnumItem)enumList.get(i);
                        if (ctpItem.getState() != 1) continue;
                        return_enumList.add(ctpItem);
                    }
                }
                List<WorkflowFormBranchBO> bos = this.convert2WorkflowFormBranchVO(formBean, thisFormList);
                WorkflowFromBranchExtendBO vo = new WorkflowFromBranchExtendBO();
                vo.setBranchBOs(bos);
                vo.setRelationEnumList(return_enumList);
                vo.setHasLevelOperator(isHasLevelOperator);
                vo.setHasOtherNotEqualOperator(isHasOtherNotEqualOperator);
                vo.setShowDisignerByUser(isShowDisignerByUser);
                vo.setShowOperation(isShowOperation);
                vo.setShowRadio(isShowRadio);
                vo.setShowSameType(isShowSameType);
                vo.setType(type);
                vo.setDisplay(currentFieldBean.getDisplay());
                vo.setVjoinField(isVjionField);
                vo.setExternalType(externalType);
                return vo;
            }
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
        }
        throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
    }

    public List<NodeBindFormViewBO> getNodeBindFormViewBOs(String formApp, String nodeId) {
        Long formId = Long.parseLong(formApp);
        FormBean edittingFormBean = this.cap4FormManager.getForm(formId);
        FormBean realEdittingFormBean = this.cap4FormManager.getEditingForm(formId);
        if (realEdittingFormBean != null && realEdittingFormBean.getId().toString().equals(formApp)) {
            edittingFormBean = realEdittingFormBean;
        }
        List operationList = null;
        operationList = "start".equals(nodeId) ? edittingFormBean.getNewFormAuthViewBeans() : edittingFormBean.getUpdateAndShowFormAuthViewBeans();
        return this.getNodeBindFormViewBOs(edittingFormBean, operationList);
    }

    private List<NodeBindFormViewBO> getNodeBindFormViewBOs(FormBean edittingFormBean, List<FormAuthViewBean> operationList) {
        LinkedHashMap<Long, NodeBindFormViewBO> nodeBindMutiFormViewMap = new LinkedHashMap<Long, NodeBindFormViewBO>();
        if (operationList != null && operationList.size() > 0) {
            for (FormAuthViewBean operation : operationList) {
                LinkedHashMap<Long, NodeBindFormOperationBO> operations;
                NodeBindFormOperationBO vo = new NodeBindFormOperationBO();
                FormViewBean viewBean = edittingFormBean.getFormView(operation.getFormViewId());
                vo.setId(String.valueOf(operation.getId()));
                vo.setName(operation.getExtraAttr("viewName") + "." + operation.getName());
                vo.setValue(operation.getFormViewId() + "|" + operation.getId());
                vo.setType(operation.getType());
                vo.setDefaultTag(String.valueOf(operation.isDefaultAuth()));
                NodeBindFormViewBO myBindMutiFormView = (NodeBindFormViewBO)nodeBindMutiFormViewMap.get(operation.getFormViewId());
                if (null != myBindMutiFormView) {
                    operations = myBindMutiFormView.getOperations();
                    if (null != operations.get(operation.getId())) continue;
                    operations.put(operation.getId(), vo);
                    myBindMutiFormView.setOperations((Map)operations);
                    continue;
                }
                myBindMutiFormView = new NodeBindFormViewBO();
                myBindMutiFormView.setId(Long.valueOf(operation.getFormViewId()));
                myBindMutiFormView.setFormName(String.valueOf(operation.getExtraAttr("viewName")));
                operations = new LinkedHashMap<Long, NodeBindFormOperationBO>();
                operations.put(operation.getId(), vo);
                myBindMutiFormView.setOperations(operations);
                String viewType = viewBean.getFormViewType();
                if (viewType.equals(Enums.ViewType.SeeyonForm.getText())) {
                    myBindMutiFormView.setCategory("CATEGORY_PC");
                } else {
                    myBindMutiFormView.setCategory("CATEGORY_MOBILE");
                }
                nodeBindMutiFormViewMap.put(operation.getFormViewId(), myBindMutiFormView);
            }
        }
        List<NodeBindFormViewBO> ret = null;
        Collection mutiformViews = nodeBindMutiFormViewMap.values();
        if (Strings.isNotEmpty(mutiformViews)) {
            ret = new ArrayList<NodeBindFormViewBO>(mutiformViews.size());
            for (NodeBindFormViewBO bo : mutiformViews) {
                ret.add(bo);
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public List<NodeBindFormViewBO> parseNodeBindFormViewBO(String formIdStr, String rightId) {
        String[] operations;
        if (StringUtil.checkNull((String)formIdStr) || StringUtil.checkNull((String)rightId)) {
            return null;
        }
        Long formId = Long.parseLong(formIdStr);
        FormBean edittingFormBean = this.cap4FormManager.getForm(formId);
        FormBean realEdittingFormBean = this.cap4FormManager.getEditingForm(formId);
        if (realEdittingFormBean != null && realEdittingFormBean.getId().toString().equals(formIdStr)) {
            edittingFormBean = realEdittingFormBean;
        }
        ArrayList<FormAuthViewBean> operationList = new ArrayList<FormAuthViewBean>();
        for (String operation : operations = FormUtil.paraseOperationIds((String)rightId)) {
            FormAuthViewBean authViewBean = edittingFormBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(operation)));
            FormViewBean viewBean = edittingFormBean.getFormView(authViewBean.getFormViewId());
            authViewBean.putExtraAttr("viewName", viewBean.getFormViewName());
            operationList.add(authViewBean);
        }
        return this.getNodeBindFormViewBOs(edittingFormBean, operationList);
    }

    public String getAppName() {
        return null;
    }

    public ApplicationCategoryEnum getCapType(String formApp) {
        return ApplicationCategoryEnum.cap4Form;
    }

    public String getLatestFormCondition(String conditionTitle, String formCondition, String oldFormAppId, String newFormAppId) {
        FormBean oldFormBean = null;
        FormBean newFormBean = null;
        if (Strings.isNotBlank((String)newFormAppId) && Long.parseLong(newFormAppId) != -1L && Strings.isNotBlank((String)oldFormAppId) && Long.parseLong(oldFormAppId) != -1L) {
            oldFormBean = this.cap4FormManager.getForm(Long.parseLong(oldFormAppId));
            newFormBean = this.getCurrentEditingForm(newFormAppId);
            FormBean currentFormBean = this.cap4FormManager.getEditingForm(Long.parseLong(newFormAppId));
            if (null != currentFormBean && String.valueOf(currentFormBean.getId()).equals(newFormAppId)) {
                newFormBean = currentFormBean;
            }
            if (!newFormAppId.equals(oldFormAppId) && oldFormBean != null && newFormBean != null) {
                Pattern pattern = Pattern.compile("\\{([^}]+)\\}");
                Matcher matcher = pattern.matcher(conditionTitle);
                HashMap<String, String> newFieldUuid2NameMap = new HashMap<String, String>();
                if (matcher.find()) {
                    do {
                        String displayName = matcher.group(1);
                        FormFieldBean newFieldBean = this.getFormFieldBean(newFormBean, displayName);
                        FormFieldBean oldFieldBean = this.getFormFieldBean(oldFormBean, displayName);
                        if (newFieldBean != null && oldFieldBean != null) {
                            FormFieldComEnum oldRealType = oldFieldBean.getInputTypeEnum();
                            FormFieldComEnum newRealType = newFieldBean.getInputTypeEnum();
                            String newFieldType = newFieldBean.getFieldType().toUpperCase();
                            String oldFieldType = oldFieldBean.getFieldType().toUpperCase();
                            switch (oldRealType) {
                                case TEXT: 
                                case TEXTAREA: {
                                    oldRealType = FormFieldComEnum.TEXT;
                                    break;
                                }
                            }
                            switch (newRealType) {
                                case TEXT: 
                                case TEXTAREA: {
                                    newRealType = FormFieldComEnum.TEXT;
                                    break;
                                }
                            }
                            if (newRealType.equals((Object)oldRealType) && oldFieldType.equals(newFieldType)) {
                                String newFieldUuid = UUIDLong.longUUID() + "_NEW";
                                newFieldUuid2NameMap.put(newFieldUuid, newFieldBean.getName());
                                LOGGER.info((Object)(oldFieldBean.getName() + "--->" + newFieldUuid + "--->" + newFieldBean.getName()));
                                LOGGER.info((Object)("condition1:=" + formCondition));
                                formCondition = formCondition.replaceAll(oldFieldBean.getName(), newFieldUuid);
                                LOGGER.info((Object)("condition2:=" + formCondition));
                                continue;
                            }
                            formCondition = "";
                            continue;
                        }
                        formCondition = "";
                    } while (matcher.find() && Strings.isNotBlank((String)formCondition));
                    LOGGER.info((Object)("condition3:=" + formCondition));
                    Set keys = newFieldUuid2NameMap.keySet();
                    for (String newFieldUuid : keys) {
                        String newFileName = (String)newFieldUuid2NameMap.get(newFieldUuid);
                        formCondition = formCondition.replaceAll(newFieldUuid, newFileName);
                    }
                    LOGGER.info((Object)("condition4:=" + formCondition));
                }
            }
        }
        return formCondition;
    }

    public String getLatestFormFieldNode(String displayName, String newFormAppId) {
        String fieldNodeInfo = "";
        String type = "";
        Long formId = -1L;
        if (Strings.isNotBlank((String)newFormAppId) && !(formId = Long.valueOf(Long.parseLong(newFormAppId))).equals(-1L)) {
            FormFieldBean fieldBean;
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            FormBean currentFormBean = this.cap4FormManager.getEditingForm(formId);
            if (null != currentFormBean && String.valueOf(currentFormBean.getId()).equals(newFormAppId)) {
                formBean = currentFormBean;
            }
            if (null != formBean && null != (fieldBean = this.getFormFieldBean(formBean, displayName))) {
                FormFieldComEnum typeEnum = fieldBean.getInputTypeEnum();
                switch (typeEnum) {
                    case EXTEND_MEMBER: {
                        type = typeEnum.getKey();
                        String ownerTableName = fieldBean.getOwnerTableName();
                        if (!ownerTableName.startsWith("formson_")) break;
                        type = FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey();
                        break;
                    }
                    case EXTEND_ACCOUNT: 
                    case EXTEND_DEPARTMENT: 
                    case EXTEND_MULTI_MEMBER: 
                    case EXTEND_MULTI_ACCOUNT: 
                    case EXTEND_MULTI_DEPARTMENT: {
                        type = typeEnum.getKey();
                        break;
                    }
                }
                if (Strings.isNotBlank((String)type)) {
                    type = type.substring(0, 1).toUpperCase() + type.substring(1);
                    String fieldName = fieldBean.getName();
                    String display = fieldBean.getDisplay();
                    fieldNodeInfo = type + "@" + fieldName + "#" + display;
                }
            }
        }
        return fieldNodeInfo;
    }

    public String getLatestFieldName(String fieldName, String oldFormAppStrId, String newFormAppStrId) {
        FormBean oldFormBean = null;
        FormBean newFormBean = null;
        if (Strings.isBlank((String)fieldName)) {
            return "";
        }
        if (Strings.isNotBlank((String)newFormAppStrId) && Strings.isNotBlank((String)oldFormAppStrId)) {
            Long newFormAppId = Long.parseLong(newFormAppStrId);
            Long oldFormAppId = Long.parseLong(oldFormAppStrId);
            if (newFormAppId != -1L && oldFormAppId != -1L) {
                oldFormBean = this.cap4FormCacheManager.getForm(oldFormAppId);
                newFormBean = this.cap4FormCacheManager.getForm(newFormAppId);
                FormBean currentFormBean = this.cap4FormManager.getEditingForm(newFormAppId);
                if (currentFormBean != null && String.valueOf(currentFormBean.getId()).equals(newFormAppStrId)) {
                    newFormBean = currentFormBean;
                }
                if (!newFormAppStrId.equals(oldFormAppStrId) && null != oldFormBean && null != newFormBean) {
                    FormFieldBean oldFieldBean = this.getFormFieldBean(oldFormBean, fieldName);
                    if (oldFieldBean == null) {
                        return "";
                    }
                    FormFieldBean newFieldBean = this.getFormFieldBean(newFormBean, oldFieldBean.getDisplay());
                    if (newFieldBean == null) {
                        return "";
                    }
                    return newFieldBean.getName();
                }
            }
        }
        return "";
    }

    public String[] getLatestFormInfo(String oldFormAppId, String formAppString, String viewId, String operationId) {
        if (Strings.isNotBlank((String)formAppString) && Long.parseLong(formAppString) != -1L) {
            List newOperationList;
            FormBean newFormBean = this.getCurrentEditingForm(formAppString);
            FormBean currentFormBean = this.cap4FormManager.getEditingForm(Long.parseLong(formAppString));
            if (null != currentFormBean && String.valueOf(currentFormBean.getId()).equals(formAppString)) {
                newFormBean = currentFormBean;
            }
            FormBean oldFormBean = this.cap4FormCacheManager.getForm(Long.parseLong(oldFormAppId));
            if (newFormBean != null && (newOperationList = newFormBean.getAllFormAuthViewBeans()) != null) {
                Long operationName = null;
                Long formName = null;
                Long formApp = null;
                if (operationId != null && Strings.isDigits((String)operationId)) {
                    operationName = Long.parseLong(operationId);
                }
                if (viewId != null && Strings.isDigits((String)viewId)) {
                    formName = Long.parseLong(viewId);
                }
                if (formAppString != null && Strings.isDigits((String)formAppString)) {
                    formApp = Long.parseLong(formAppString);
                }
                if (formName != null && operationName != null && formApp != null) {
                    FormAuthViewBean oldAuthViewBean = oldFormBean.getAuthViewBeanById(operationName);
                    FormViewBean oldFormViewBean = oldFormBean.getFormView(formName.longValue());
                    FormAuthViewBean newAuthViewBean = null;
                    if (oldAuthViewBean != null) {
                        if (Enums.FormAuthorizationType.add.getKey().equals(oldAuthViewBean.getType())) {
                            for (FormAuthViewBean operation : newOperationList) {
                                if (!Enums.FormAuthorizationType.add.getKey().equals(operation.getType()) || !operation.getName().equals(oldAuthViewBean.getName())) continue;
                                FormViewBean newFormViewBean = newFormBean.getFormView(operation.getFormViewId());
                                if (oldFormViewBean == null || newFormViewBean == null || newFormViewBean.getFormViewName() == null || !newFormViewBean.getFormViewName().equals(oldFormViewBean.getFormViewName()) || !newFormViewBean.getFormViewType().equals(oldFormViewBean.getFormViewType())) continue;
                                newAuthViewBean = operation;
                                break;
                            }
                        } else {
                            for (FormAuthViewBean operation : newOperationList) {
                                if (Enums.FormAuthorizationType.add.getKey().equals(operation.getType()) || !operation.getName().equals(oldAuthViewBean.getName())) continue;
                                FormViewBean newFormViewBean = newFormBean.getFormView(operation.getFormViewId());
                                if (oldFormViewBean == null || newFormViewBean == null || newFormViewBean.getFormViewName() == null || !newFormViewBean.getFormViewName().equals(oldFormViewBean.getFormViewName()) || !newFormViewBean.getFormViewType().equals(oldFormViewBean.getFormViewType())) continue;
                                newAuthViewBean = operation;
                                break;
                            }
                        }
                    }
                    if (newAuthViewBean != null) {
                        String[] formInfo = new String[]{String.valueOf(newAuthViewBean.getFormViewId()), newAuthViewBean.getId().toString()};
                        return formInfo;
                    }
                }
            }
        }
        return null;
    }

    public String getLatestOperationName(String formApp, String operationId) {
        try {
            long operationIdLong = Long.parseLong(operationId);
            String newOperationName = this.cap4FormCacheManager.getAuth(operationIdLong).getName();
            return newOperationName;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e.getMessage(), e);
            return operationId;
        }
    }

    public Long getLatestOperationId(Long formApp, Long operationName) {
        return operationName;
    }

    public Long getLatestFormViewId(String formApp, Long operationName, Long form) {
        FormAuthViewBean formAuthBean = this.cap4FormCacheManager.getAuth(operationName);
        if (null != formAuthBean) {
            form = formAuthBean.getFormViewId();
        }
        return form;
    }

    public String getLatestFormViewAndOprationName(String formApp, String operationId) {
        long formViewId;
        FormViewBean formViewBean;
        FormAuthViewBean favb;
        String display = "";
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formApp));
        if (formBean != null && (favb = this.cap4FormCacheManager.getAuth(Long.parseLong(operationId))) != null && (formViewBean = formBean.getFormView(formViewId = favb.getFormViewId())) != null) {
            display = formViewBean.getFormViewName() + "." + favb.getName();
        }
        return display;
    }

    public Map<Long, String[]> getFormMutilDisplayMap(String formApp, String operationm) {
        HashMap<Long, String[]> mutilDisplayMap = new HashMap<Long, String[]>();
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formApp));
        if (formBean != null && !StringUtil.checkNull((String)operationm) && !"undefined".equals(operationm)) {
            String[] operations = operationm.split("_");
            for (int i = 0; i < operations.length; ++i) {
                long formViewId;
                FormViewBean formViewBean;
                FormAuthViewBean favb;
                String formViewOperation = operations[i];
                if (!Strings.isNotBlank((String)formViewOperation)) continue;
                String[] viewAndOperation = formViewOperation.split("[.]");
                String operationId = viewAndOperation[0];
                if (viewAndOperation.length > 1) {
                    operationId = viewAndOperation[1];
                }
                if ((favb = this.cap4FormCacheManager.getAuth(Long.parseLong(operationId))) == null || (formViewBean = formBean.getFormView(formViewId = favb.getFormViewId())) == null) continue;
                String display1 = formViewBean.getFormViewName() + "." + favb.getName();
                String[] infos = new String[]{formViewBean.getFormViewName(), display1};
                mutilDisplayMap.put(formViewBean.getId(), infos);
            }
        }
        return mutilDisplayMap;
    }

    public List<String[]> getFormMutilDisplayList(String formApp, Map<Long, String[]> mutilDisplayMap) {
        ArrayList<String[]> mutilDisplayList = new ArrayList<String[]>();
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formApp));
        if (formBean != null) {
            List views = formBean.getFormViewList();
            for (FormViewBean formViewBean : views) {
                if (null == mutilDisplayMap.get(formViewBean.getId())) continue;
                mutilDisplayList.add(mutilDisplayMap.get(formViewBean.getId()));
            }
        }
        return mutilDisplayList;
    }

    public List<String[]> getFormDateFieldListForBranch(String s, String s1, String s2) {
        return null;
    }

    public String getFormDateFieldJsonForBranch(String s, String s1, String s2) throws Exception {
        return null;
    }

    public WorkflowFromBranchExtendBO getWorkflowBranchMultiExtendVO(String formApp, String fieldName) throws Exception {
        String type = "";
        boolean isCanSetByExtend = true;
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean currentFieldBean = null;
        List formFieldList = null;
        List<String[]> thisFormList = new ArrayList<String[]>();
        if (formBean != null && Strings.isNotBlank((String)fieldName)) {
            currentFieldBean = this.getFormFieldBean(formBean, fieldName);
            formFieldList = formBean.getAllFieldBeans();
            if (currentFieldBean != null) {
                FormFieldComEnum realType = formBean.getFieldBeanByName(fieldName).getInputTypeEnum();
                if (realType != null) {
                    type = realType.getKey();
                }
                String ownerTableName = currentFieldBean.getOwnerTableName();
                FormFieldComEnum needType = null;
                switch (realType) {
                    case EXTEND_MULTI_MEMBER: {
                        needType = FormFieldComEnum.EXTEND_MEMBER;
                        break;
                    }
                    case EXTEND_MULTI_ACCOUNT: {
                        needType = FormFieldComEnum.EXTEND_ACCOUNT;
                        break;
                    }
                    case EXTEND_MULTI_DEPARTMENT: {
                        needType = FormFieldComEnum.EXTEND_DEPARTMENT;
                        break;
                    }
                    case EXTEND_MULTI_POST: {
                        needType = FormFieldComEnum.EXTEND_POST;
                        break;
                    }
                    case EXTEND_MULTI_LEVEL: {
                        needType = FormFieldComEnum.EXTEND_LEVEL;
                        break;
                    }
                    default: {
                        isCanSetByExtend = false;
                    }
                }
                int externalType = currentFieldBean.getExternalType();
                ArrayList<FormFieldBean> sameTypeFieldList = new ArrayList<FormFieldBean>();
                if (isCanSetByExtend) {
                    for (FormFieldBean field : formFieldList) {
                        int externalType1;
                        if (field.getName().equals(currentFieldBean.getName()) || (externalType1 = field.getExternalType().intValue()) != externalType) continue;
                        FormFieldComEnum tempRealType = field.getInputTypeEnum();
                        if (!ownerTableName.equals(field.getOwnerTableName()) || !tempRealType.equals((Object)needType) && !tempRealType.equals((Object)realType)) continue;
                        sameTypeFieldList.add(field);
                    }
                    thisFormList = this.getDisplayFormField(sameTypeFieldList, formBean);
                }
                List<WorkflowFormBranchBO> bos = this.convert2WorkflowFormBranchVO(formBean, thisFormList);
                WorkflowFromBranchExtendBO vo = new WorkflowFromBranchExtendBO();
                vo.setBranchBOs(bos);
                vo.setCanSetByExtend(isCanSetByExtend);
                vo.setType(type);
                vo.setDisplay(currentFieldBean.getDisplay());
                return vo;
            }
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
        }
        throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8868\u5355\u63a7\u4ef6!");
    }

    public boolean isNewFormBean(Long aLong) {
        FormBean fb = this.cap4FormManager.getEditingForm(aLong);
        return fb != null;
    }

    public Map<String, WorkflowFormFieldBO> getFormFieldMap(String formApp) {
        Map<String, WorkflowFormFieldBO> fieldMap = this.getFormFieldMap(formApp, null, null, null, false);
        return fieldMap;
    }

    public boolean isFormOperationExist(String formApp, String formName, String operationName) {
        FormBean newFormBean = this.getCurrentEditingForm(formApp);
        if (null == newFormBean) {
            return false;
        }
        List operationList = newFormBean.getAllFormAuthViewBeans();
        boolean operationAndFormNameExist = false;
        Long formNameId = Long.parseLong(formName);
        Long operationNameId = Long.parseLong(operationName);
        for (FormAuthViewBean operation : operationList) {
            if (!operation.getId().equals(operationNameId) || !formNameId.equals(operation.getFormViewId())) continue;
            operationAndFormNameExist = true;
            break;
        }
        return operationAndFormNameExist;
    }

    public String getFormFieldOptionString(String formField, String formApp, boolean isExternalType) {
        FormBean edittingFormBean = this.cap4FormManager.getForm(Long.parseLong(formApp), true);
        StringBuilder buffer = new StringBuilder();
        if (null != edittingFormBean) {
            List list = edittingFormBean.getAllFieldBeans();
            for (FormFieldBean formFieldBean : list) {
                if (isExternalType && formFieldBean.getExternalType().intValue() == OrgConstants.ExternalType.Inner.ordinal() || !isExternalType && formFieldBean.getExternalType().intValue() != OrgConstants.ExternalType.Inner.ordinal() || !formFieldBean.isMasterField()) continue;
                switch (formFieldBean.getInputTypeEnum()) {
                    case EXTEND_ACCOUNT: 
                    case EXTEND_DEPARTMENT: 
                    case EXTEND_MULTI_ACCOUNT: 
                    case EXTEND_MULTI_DEPARTMENT: {
                        buffer.append("<option value='").append(formFieldBean.getName()).append("' formFieldType='").append(formFieldBean.getInputTypeEnum().getKey()).append("' title='").append(formFieldBean.getDisplay()).append("'>").append(formFieldBean.getDisplay()).append("[").append(formFieldBean.getInputTypeEnum().getText()).append("]</option>");
                    }
                }
            }
        }
        return buffer.toString();
    }

    public Set<String> isFormMustWrite(Long formAppId, Long operationId) {
        Set<String> isFormMustWrite = new HashSet<String>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formAppId);
        if (null != formBean) {
            isFormMustWrite = formBean.notNullableField(operationId.longValue());
        }
        return isFormMustWrite;
    }

    public Set<String> isFormMustWrite(Long formAppId, String formViewOperation) {
        return null;
    }

    private String getRealRightId(String rightId) {
        String[] rightArr;
        String realRightId = "";
        if (Strings.isNotBlank((String)rightId) && (realRightId = (rightArr = rightId.split("_"))[0]).contains(".")) {
            realRightId = realRightId.substring(realRightId.indexOf(".") + 1);
        }
        return realRightId;
    }

    public Map<String, Object> getFormValueMap(Long formAppId, Long masterId) {
        return this.getFormValueMap(formAppId, masterId, null);
    }

    public Map<String, Object> getFormValueMap(Long formAppId, Long masterId, String rightId) {
        FormDataMasterBean data = null;
        FormBean formBean = null;
        try {
            formBean = this.getCurrentEditingForm(String.valueOf(formAppId));
            if (formBean == null) {
                LOGGER.info((Object)("\u8868\u5355\u4e3a\u7a7a\uff0c\u8868\u5355id\uff1a" + formAppId));
                return new HashMap<String, Object>(1);
            }
            data = this.cap4FormManager.getSessioMasterDataBean(masterId);
            if (null == data) {
                data = this.cap4FormDataDAO.selectDataByMasterId(masterId, formBean, null);
                if (Strings.isNotBlank((String)(rightId = this.getRealRightId(rightId)))) {
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
                    this.cap4FormDataManager.calcAll(formBean, data, formAuthViewBean, false, false, false, true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.getFormValueMap(formBean, data);
    }

    private Map<String, Object> getFormValueMap(FormBean formBean, FormDataMasterBean data) {
        HashMap<String, Object> rowDataDisplayName = new HashMap<String, Object>();
        try {
            if (data != null) {
                rowDataDisplayName.put("formDataBean", data);
                rowDataDisplayName.put("formBean", formBean);
                Map displayMap = data.getAllDataMap();
                if (displayMap != null && displayMap.size() > 0) {
                    block10: for (Map.Entry entry : displayMap.entrySet()) {
                        String fieldName = (String)entry.getKey();
                        Object fieldVaue = entry.getValue();
                        if (fieldVaue != null && (fieldVaue.equals(0) || fieldVaue.equals(0))) {
                            fieldVaue = 0;
                        }
                        if (fieldVaue != null && (fieldVaue.equals(-0.0) || fieldVaue.equals(0.0))) {
                            fieldVaue = 0.0;
                        }
                        try {
                            FormFieldBean fieldBean = data.getFieldBeanByFieldName(fieldName);
                            if (fieldBean == null) continue;
                            String fieldNameKey = fieldBean.getName();
                            String displayName = fieldBean.getDisplay();
                            String displayNameKey = fieldBean.getDisplay().replaceAll("-", "6525302505919040842");
                            switch (fieldBean.getInputTypeEnum()) {
                                case SELECT: {
                                    Object[] enumValues;
                                    Object[] enumValues2;
                                    Object value;
                                    if (fieldBean.isMasterField()) {
                                        value = fieldVaue;
                                        if (fieldVaue == null || "".equals(fieldVaue) || "0".equals(fieldVaue)) {
                                            value = "";
                                        } else {
                                            enumValues2 = fieldBean.getDisplayValue(fieldVaue);
                                            value = enumValues2[0];
                                        }
                                        rowDataDisplayName.put(displayNameKey, value);
                                        rowDataDisplayName.put(displayName, value);
                                        rowDataDisplayName.put(fieldNameKey, value);
                                        break;
                                    }
                                    if (!(fieldVaue instanceof List)) continue block10;
                                    List fieldValueList = (List)fieldVaue;
                                    ArrayList<Object> newFieldValueList = new ArrayList<Object>();
                                    for (Object value2 : fieldValueList) {
                                        if (value2 == null || "".equals(value2) || "0".equals(value2)) {
                                            newFieldValueList.add("");
                                            continue;
                                        }
                                        enumValues = fieldBean.getDisplayValue(value2);
                                        newFieldValueList.add(enumValues[0]);
                                    }
                                    rowDataDisplayName.put(displayNameKey, newFieldValueList);
                                    rowDataDisplayName.put(displayName, newFieldValueList);
                                    rowDataDisplayName.put(fieldNameKey, newFieldValueList);
                                    break;
                                }
                                case CHECKBOX: {
                                    Object[] enumValues;
                                    Object[] enumValues2;
                                    Object value;
                                    if (fieldBean.isMasterField()) {
                                        value = fieldVaue;
                                        if (fieldVaue == null || "".equals(fieldVaue) || "0".equals(fieldVaue)) {
                                            value = "0";
                                        } else {
                                            enumValues2 = fieldBean.getDisplayValue(fieldVaue);
                                            value = enumValues2[2];
                                        }
                                        rowDataDisplayName.put(displayNameKey, value);
                                        rowDataDisplayName.put(displayName, value);
                                        rowDataDisplayName.put(fieldNameKey, value);
                                        break;
                                    }
                                    if (!(fieldVaue instanceof List)) continue block10;
                                    List fieldValueList = (List)fieldVaue;
                                    ArrayList<Object> newFieldValueList = new ArrayList();
                                    for (Object value2 : fieldValueList) {
                                        if (value2 == null || "".equals(value2) || "0".equals(value2)) {
                                            newFieldValueList.add("0");
                                            continue;
                                        }
                                        enumValues = fieldBean.getDisplayValue(value2);
                                        newFieldValueList.add(enumValues[2]);
                                    }
                                    rowDataDisplayName.put(displayNameKey, newFieldValueList);
                                    rowDataDisplayName.put(displayName, newFieldValueList);
                                    rowDataDisplayName.put(fieldNameKey, newFieldValueList);
                                    break;
                                }
                                case RADIO: {
                                    Object[] enumValues;
                                    Object[] enumValues2;
                                    Object value;
                                    if (fieldBean.isMasterField()) {
                                        value = fieldVaue;
                                        if (fieldVaue == null || "".equals(fieldVaue) || "0".equals(fieldVaue)) {
                                            value = "";
                                        } else {
                                            enumValues2 = fieldBean.getDisplayValue(fieldVaue);
                                            value = enumValues2[0];
                                        }
                                        rowDataDisplayName.put(displayNameKey, value);
                                        rowDataDisplayName.put(displayName, value);
                                        rowDataDisplayName.put(fieldNameKey, value);
                                        break;
                                    }
                                    if (!(fieldVaue instanceof List)) continue block10;
                                    List fieldValueList = (List)fieldVaue;
                                    ArrayList<Object> newFieldValueList = new ArrayList();
                                    for (Object value2 : fieldValueList) {
                                        if (value2 == null || "".equals(value2) || "0".equals(value2)) {
                                            newFieldValueList.add("");
                                            continue;
                                        }
                                        enumValues = fieldBean.getDisplayValue(value2);
                                        newFieldValueList.add(enumValues[0]);
                                    }
                                    rowDataDisplayName.put(displayNameKey, newFieldValueList);
                                    rowDataDisplayName.put(displayName, newFieldValueList);
                                    rowDataDisplayName.put(fieldNameKey, newFieldValueList);
                                    break;
                                }
                                case EXTEND_MULTI_MEMBER: {
                                    if (fieldVaue != null) {
                                        if (fieldBean.isMasterField() && fieldVaue instanceof String) {
                                            fieldVaue = fieldBean.getDisplayValue(fieldVaue)[0];
                                        } else if (fieldVaue instanceof List) {
                                            List fieldVaues = (List)fieldVaue;
                                            ArrayList<Object> newList = new ArrayList<Object>(fieldVaues.size());
                                            for (Object f : fieldVaues) {
                                                newList.add(fieldBean.getDisplayValue(f)[0]);
                                            }
                                            fieldVaue = newList;
                                        } else {
                                            LOGGER.warn((Object)("\u8868\u5355\u4e2d\u5b58\u5728\u4e0d\u5408\u6cd5\u7684\u6570\u636e  fieldNameKey=" + displayNameKey));
                                            fieldVaue = null;
                                        }
                                    }
                                    rowDataDisplayName.put(displayNameKey, fieldVaue);
                                    rowDataDisplayName.put(displayName, fieldVaue);
                                    rowDataDisplayName.put(fieldNameKey, fieldVaue);
                                    break;
                                }
                                default: {
                                    fieldVaue = this.giveDefaultValueToDecimalField(fieldBean, fieldVaue);
                                    rowDataDisplayName.put(displayNameKey, fieldVaue);
                                    rowDataDisplayName.put(displayName, fieldVaue);
                                    rowDataDisplayName.put(fieldNameKey, fieldVaue);
                                }
                            }
                        }
                        catch (BusinessException e) {
                            if (!fieldName.startsWith("field")) continue;
                            LOGGER.warn((Object)("\u8f6c\u6362\u8868\u5355\u8f93\u51fa\u51fa\u73b0\u5f02\u5e38\uff0cfieldName=" + fieldName));
                        }
                    }
                }
            } else {
                LOGGER.warn((Object)("\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5355\u6570\u636e\uff0cmasterId=" + (data == null ? "" : data.getId()) + ",formAppId=" + formBean.getId()));
            }
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"get form data error!");
        }
        return rowDataDisplayName;
    }

    private Object giveDefaultValueToDecimalField(FormFieldBean fieldBean, Object fieldVaue) {
        ArrayList<BigDecimal> returnValue = fieldVaue;
        if (fieldBean.getFieldType().equalsIgnoreCase(Enums.FieldType.DECIMAL.getKey())) {
            if (fieldVaue instanceof List) {
                List fieldValueList = fieldVaue;
                ArrayList<BigDecimal> newFieldValueList = new ArrayList<BigDecimal>();
                for (Object value : fieldValueList) {
                    BigDecimal newFieldValue = null;
                    if (StringUtil.checkNull((String)String.valueOf(value))) {
                        newFieldValue = new BigDecimal(0);
                    } else {
                        try {
                            newFieldValue = new BigDecimal(String.valueOf(value));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    newFieldValueList.add(newFieldValue);
                }
                returnValue = newFieldValueList;
            } else if (StringUtil.checkNull((String)String.valueOf(fieldVaue))) {
                returnValue = new BigDecimal(0);
            } else {
                try {
                    returnValue = new BigDecimal(String.valueOf(fieldVaue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return returnValue;
    }

    public boolean isFormOperationReadOnly(Long aLong, Long aLong1) {
        return false;
    }

    public boolean isFormOperationReadOnly(Long formAppId, String formViewOperation) {
        return false;
    }

    public List<Map<String, Object>> getWorkflowFormCustomFunctionParams(String s) {
        return null;
    }

    public String getFormName(Long aLong) {
        FormBean formBean = this.cap4FormCacheManager.getForm(aLong);
        String name = "";
        if (null != formBean) {
            name = formBean.getFormName();
        }
        return name;
    }

    public String getStartFormViewId(Long aLong) {
        return null;
    }

    public String getNormalFormViewId(long l) {
        return null;
    }

    public String getStartDefualtRightId(long formId) {
        String result = "";
        FormBean form = this.getCurrentEditingForm(String.valueOf(formId));
        if (form == null) {
            return result;
        }
        FormAuthViewBean pcAddAuth = form.getFirstPcAddAuth();
        FormAuthViewBean mbAddAuth = form.getFirstMbAddAuth();
        if (null != pcAddAuth) {
            result = pcAddAuth.getFormViewId() + "." + pcAddAuth.getId();
        } else {
            LOGGER.info((Object)("\u8868\u5355" + formId + "\u627e\u4e0d\u5230pc\u6bb5\u7684\u65b0\u589e\u6743\u9650"));
        }
        if (null != mbAddAuth) {
            result = result + "_" + mbAddAuth.getFormViewId() + "." + mbAddAuth.getId();
        } else {
            LOGGER.info((Object)("\u8868\u5355" + formId + "\u627e\u4e0d\u5230\u79fb\u52a8\u6bb5\u7684\u65b0\u589e\u6743\u9650"));
        }
        return result;
    }

    public String getNormalDefualtRightId(long formId) {
        String result = "";
        FormBean form = this.getCurrentEditingForm(String.valueOf(formId));
        if (form == null) {
            return result;
        }
        FormAuthViewBean pcAddAuth = form.getFirstPcNormalAuth();
        FormAuthViewBean mbAddAuth = form.getFirstMbNormalAuth();
        if (null != pcAddAuth) {
            result = pcAddAuth.getFormViewId() + "." + pcAddAuth.getId();
        } else {
            LOGGER.info((Object)("\u8868\u5355" + formId + "\u627e\u4e0d\u5230pc\u6bb5\u7684\u65b0\u589e\u6743\u9650"));
        }
        if (null != mbAddAuth) {
            result = result + "_" + mbAddAuth.getFormViewId() + "." + mbAddAuth.getId();
        } else {
            LOGGER.info((Object)("\u8868\u5355" + formId + "\u627e\u4e0d\u5230\u79fb\u52a8\u6bb5\u7684\u65b0\u589e\u6743\u9650"));
        }
        return result;
    }

    public boolean isForm(String s) {
        return false;
    }

    public boolean isCompareFieldParam(String s, String s1) {
        return false;
    }

    public int canBeFormFieldNode(String formApp, String fieldName) {
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean fieldBean = null;
        if (null != formBean) {
            fieldBean = this.getFormFieldBean(formBean, fieldName);
        }
        if (fieldBean == null) {
            return -1;
        }
        int result = 0;
        FormFieldComEnum formFieldComEnum = fieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case EXTEND_MEMBER: 
            case EXTEND_ACCOUNT: 
            case EXTEND_DEPARTMENT: 
            case EXTEND_POST: 
            case EXTEND_MULTI_MEMBER: 
            case EXTEND_MULTI_ACCOUNT: 
            case EXTEND_MULTI_DEPARTMENT: 
            case EXTEND_MULTI_POST: {
                result = 1;
            }
        }
        return result;
    }

    public int canBeDeadline(String formApp, String fieldName) {
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean fieldBean = null;
        if (null != formBean) {
            fieldBean = this.getFormFieldBean(formBean, fieldName);
        }
        if (fieldBean == null) {
            return -1;
        }
        int result = 0;
        FormFieldComEnum formFieldComEnum = fieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                result = 1;
            }
        }
        return result;
    }

    public int canBePostMatcherByFormField(String newFormApp, String fieldName) {
        FormBean formBean = this.getCurrentEditingForm(newFormApp);
        FormFieldBean fieldBean = this.getFormFieldBean(formBean, fieldName);
        if (null == fieldBean) {
            return -1;
        }
        int result = 0;
        if (!fieldBean.isMasterField()) {
            return 0;
        }
        FormFieldComEnum formFieldComEnum = fieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case EXTEND_MEMBER: 
            case EXTEND_ACCOUNT: 
            case EXTEND_DEPARTMENT: 
            case EXTEND_MULTI_MEMBER: 
            case EXTEND_MULTI_ACCOUNT: 
            case EXTEND_MULTI_DEPARTMENT: {
                result = 1;
            }
        }
        return result;
    }

    public int canBeFormFieldRoleNode(String formApp, String fieldName, String roleName) {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        FormBean formBean = this.getCurrentEditingForm(formApp);
        FormFieldBean fieldBean = this.getFormFieldBean(formBean, fieldName);
        if (fieldBean == null) {
            return -1;
        }
        int result = 0;
        FormFieldComEnum formFieldComEnum = fieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case EXTEND_MEMBER: 
            case EXTEND_MULTI_MEMBER: {
                result = 1;
                break;
            }
            case EXTEND_DEPARTMENT: 
            case EXTEND_MULTI_DEPARTMENT: {
                if ("AccountLeader".equals(roleName) || "ReciprocalRoleReporter".equals(roleName)) break;
                if ("DeptMember".equals(roleName)) {
                    result = 1;
                    break;
                }
                User user = AppContext.getCurrentUser();
                if (null == user) break;
                V3xOrgRole role = null;
                try {
                    if (Strings.isDigits((String)roleName)) {
                        role = orgManager.getRoleById(Long.valueOf(Long.parseLong(roleName)));
                    }
                    if (roleName.startsWith("Vjoin")) {
                        role = this.joinOrgManagerDirect.getRoleByCode(roleName, null);
                    }
                    if (null == role) {
                        role = orgManager.getRoleByName(roleName, user.getLoginAccount());
                    }
                    if (null == role || role.getBond() != OrgConstants.ROLE_BOND.DEPARTMENT.ordinal()) break;
                    result = 1;
                }
                catch (Throwable e) {
                    LOGGER.error((Object)e.getMessage(), e);
                }
                break;
            }
            case EXTEND_ACCOUNT: 
            case EXTEND_MULTI_ACCOUNT: {
                if ("AccountLeader".equals(roleName)) {
                    result = 1;
                    break;
                }
                User user = AppContext.getCurrentUser();
                if (null == user) break;
                V3xOrgRole role = null;
                try {
                    if (Strings.isDigits((String)roleName)) {
                        role = orgManager.getRoleById(Long.valueOf(Long.parseLong(roleName)));
                    }
                    if (null == role) {
                        role = orgManager.getRoleByName(roleName, user.getLoginAccount());
                    }
                    if (null == role || role.getBond() != OrgConstants.ROLE_BOND.ACCOUNT.ordinal()) break;
                    result = 1;
                    break;
                }
                catch (Throwable e) {
                    LOGGER.error((Object)e.getMessage(), e);
                }
            }
        }
        return result;
    }

    private String getCtpEnumItemShowValue(String third) {
        EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        try {
            CtpEnumItem item = null;
            String valueId = third.substring(1, third.length() - 1);
            if ("".equals(valueId.trim())) {
                third = "''";
            } else {
                String[] valueIdArr = valueId.split(",");
                String showValue = "\"";
                if (null != valueIdArr) {
                    for (int i = 0; i < valueIdArr.length; ++i) {
                        String valueIdTemp = valueIdArr[i];
                        if (Strings.isDigits((String)valueIdTemp)) {
                            item = enumManagerNew.getCtpEnumItem(Long.valueOf(Long.parseLong(valueIdTemp)));
                        } else {
                            LOGGER.warn((Object)("\u5206\u652f\u6761\u4ef6\u7ffb\u8bd1\uff0c\u679a\u4e3eid\u4e0d\u662f\u4e00\u4e2along\u578b\uff01id=" + valueId));
                        }
                        if (i == 0) {
                            if (item != null) {
                                showValue = showValue + item.getShowvalue();
                                continue;
                            }
                            showValue = showValue + valueIdTemp;
                            continue;
                        }
                        showValue = item != null ? showValue + "," + item.getShowvalue() : showValue + "," + valueIdTemp;
                    }
                    return showValue + "\"";
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"\u679a\u4e3e\u503c\u83b7\u53d6\u5f02\u5e38", e);
        }
        return third;
    }

    private String getFieldDisplayValue(FormFieldBean sourceFieldBean, String third) {
        try {
            String entityId = third.substring(1, third.length() - 1);
            if ("".equals(entityId.trim())) {
                third = "''";
            } else {
                Object[] temps = sourceFieldBean.getDisplayValue((Object)entityId);
                third = temps[1].toString();
            }
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"\u8868\u5355\u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38", e);
        }
        return third;
    }

    private String getPreWord(Long id, FormFieldComEnum type) {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        String result = "";
        if (id != null) {
            V3xOrgAccount account = null;
            try {
                account = orgManager.getAccountById(id);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"\u5206\u652f\u7ffb\u8bd1\u65f6\u67e5\u8be2\u5355\u4f4d\u5931\u8d25\uff01", (Throwable)e);
            }
            if (account != null && account.isGroup()) {
                result = ResourceUtil.getString((String)"workflow.branchGroup.0");
                switch (type) {
                    case EXTEND_POST: 
                    case EXTEND_MULTI_POST: {
                        result = ResourceUtil.getString((String)"workflow.branchGroup.4.4") + ":";
                        break;
                    }
                    case EXTEND_LEVEL: 
                    case EXTEND_MULTI_LEVEL: {
                        result = result + ResourceUtil.getString((String)"workflow.branchGroup.3") + ":";
                    }
                }
            }
        }
        return result;
    }

    public String getPostOrLevelFieldValueName(String orgentTypePost, String third, FormFieldComEnum inputTypeEnum) {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        try {
            String entityId = third.substring(1, third.length() - 1);
            if ("".equals(entityId.trim())) {
                third = "''";
            } else {
                V3xOrgEntity entity = orgManager.getEntity(orgentTypePost + "|" + entityId);
                if (entity != null) {
                    third = this.getPreWord(entity.getOrgAccountId(), inputTypeEnum) + entity.getName();
                    third = third + this.getNextWord(entity.getOrgAccountId());
                }
            }
        }
        catch (Throwable e) {
            LOGGER.info((Object)"\u7ec4\u7ec7\u6a21\u578b\u8868\u5355\u63a7\u4ef6\u503c\u89e3\u6790\u5f02\u5e38", e);
        }
        return third;
    }

    private String getNextWord(Long id) {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        String forth = "";
        if (id != null) {
            V3xOrgAccount account = null;
            try {
                account = orgManager.getAccountById(id);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"\u5355\u4f4d\u4fe1\u606f\u67e5\u627e\u5f02\u5e38", e);
            }
            if (account != null) {
                forth = account.isGroup() ? "" : "(" + account.getShortName() + ")";
            }
        }
        return forth;
    }

    private String getProjectName(String third) {
        ProjectApi projectManager = (ProjectApi)AppContext.getBean((String)"projectApi");
        try {
            String entityId = third.substring(1, third.length() - 1);
            if ("".equals(entityId.trim())) {
                third = "''";
            } else {
                ProjectBO pro = projectManager.getProject(Long.valueOf(Long.parseLong(entityId)));
                if (pro != null) {
                    third = pro.getProjectName();
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"\u9879\u76ee\u4fe1\u606f\u5b57\u6bb5\u67e5\u627e\u5f02\u5e38", e);
        }
        return third;
    }

    public String translateFormFieldValieDisplayInfo(String first, String third, String formApp) {
        FormBean sourceFormBean = this.getCurrentEditingForm(formApp);
        if (null != sourceFormBean) {
            FormFieldBean sourceFieldBean = this.getFormFieldBean(sourceFormBean, first);
            if (sourceFieldBean == null) {
                sourceFieldBean = this.getFormFieldBean(sourceFormBean, first.substring(1, first.length() - 1));
            }
            if (sourceFieldBean != null) {
                boolean needLoop = false;
                do {
                    needLoop = false;
                    switch (sourceFieldBean.getInputTypeEnum()) {
                        case SELECT: 
                        case RADIO: 
                        case IMAGE_RADIO: 
                        case IMAGE_SELECT: {
                            third = this.getCtpEnumItemShowValue(third);
                            break;
                        }
                        case EXTEND_MEMBER: 
                        case EXTEND_ACCOUNT: 
                        case EXTEND_DEPARTMENT: 
                        case CHECKBOX: 
                        case EXTEND_MULTI_MEMBER: 
                        case EXTEND_MULTI_ACCOUNT: 
                        case EXTEND_MULTI_DEPARTMENT: {
                            third = this.getFieldDisplayValue(sourceFieldBean, third);
                            break;
                        }
                        case EXTEND_POST: 
                        case EXTEND_MULTI_POST: {
                            third = this.getPostOrLevelFieldValueName("Post", third, sourceFieldBean.getInputTypeEnum());
                            break;
                        }
                        case EXTEND_LEVEL: 
                        case EXTEND_MULTI_LEVEL: {
                            third = this.getPostOrLevelFieldValueName("Level", third, sourceFieldBean.getInputTypeEnum());
                        }
                    }
                } while (needLoop);
            }
        }
        return third;
    }

    public Map<String, Boolean> getFormulaFunctionMethodsMap() {
        return null;
    }

    public String getFormulaFunctionContextKey() {
        return null;
    }

    private boolean getFieldTypeMatchResult(FormBean formBean, FormFieldBean field, List<String> fieldTypes) {
        if (null == fieldTypes || fieldTypes.isEmpty()) {
            return true;
        }
        if (field.getExternalType().intValue() != OrgConstants.ExternalType.Inner.ordinal()) {
            return false;
        }
        if (field.getExternalType().intValue() != OrgConstants.ExternalType.Inner.ordinal()) {
            return false;
        }
        if (field.getInputTypeEnum() != null) {
            FormFieldComEnum fieldInputTypeEnum = field.getInputTypeEnum();
            String fieldInputType = fieldInputTypeEnum.getKey();
            String fieldDbType = field.getFinalFieldType().toLowerCase();
            for (String myFieldType : fieldTypes) {
                if (myFieldType.indexOf(":") >= 0) {
                    String[] fieldTypeArr = myFieldType.split(":");
                    String myFieldInputType = fieldTypeArr[0];
                    String myFieldDbType = fieldTypeArr[1];
                    if (!myFieldInputType.equalsIgnoreCase(fieldInputType) || !myFieldDbType.equalsIgnoreCase(fieldDbType)) continue;
                    return true;
                }
                if (!myFieldType.equalsIgnoreCase(fieldInputType) && !myFieldType.contains(fieldDbType)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, WorkflowFormFieldBO> getFormFieldMap(String formApp, List<String> fieldTypes, String externalType, List<String> tableTypes, boolean distinct) {
        List<FormFieldBean> fieldList;
        FormBean formBean = this.getCurrentEditingForm(formApp);
        LinkedHashMap<String, WorkflowFormFieldBO> fieldMap = new LinkedHashMap<String, WorkflowFormFieldBO>();
        if (formBean != null && (fieldList = this.getFieldBeanListByTableSort(formBean)) != null && fieldList.size() > 0) {
            for (FormFieldBean field : fieldList) {
                boolean isFieldTypeMatched;
                FormFieldCustomCtrl customCtrl;
                if (field.isCustomerCtrl() && null != (customCtrl = (FormFieldCustomCtrl)field.getFieldCtrl()) && !customCtrl.canInMeetingTrigger()) continue;
                String tableName = field.getOwnerTableName();
                String tableType = "main";
                if (tableName.startsWith("formson_")) {
                    tableType = "son";
                }
                if (null != tableTypes && !tableTypes.isEmpty() && !tableTypes.contains(tableType) || !(isFieldTypeMatched = this.getFieldTypeMatchResult(formBean, field, fieldTypes))) continue;
                WorkflowFormFieldBO vo = new WorkflowFormFieldBO();
                vo.setDisplay(field.getDisplay());
                vo.setEnumId(Long.valueOf(field.getEnumId()));
                vo.setFieldName(field.getName());
                vo.setFieldType(field.getFieldType());
                vo.setInputType(field.getInputType());
                if (field.isCustomerCtrl()) {
                    FormFieldCustomCtrl formFieldCustomCtrl = (FormFieldCustomCtrl)field.getFieldCtrl();
                    vo.setInputType(formFieldCustomCtrl.mappingStandardCtrlType());
                }
                vo.setMasterField(field.isMasterField());
                vo.setName(field.getName());
                vo.setOwnerTableName(field.getOwnerTableName());
                String fieldDisplayLabel = this.getFieldDisplayLabel(field);
                vo.setFieldDisplayLabel(fieldDisplayLabel);
                String realType = field.getInputTypeEnum().getKey();
                vo.setRealType(realType);
                if (!distinct) {
                    fieldMap.put(field.getDisplay(), vo);
                }
                fieldMap.put(field.getName(), vo);
            }
        }
        return fieldMap;
    }

    public Map<String, String> getWFDynamicFormInfos(String baseFormAppId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (Strings.isBlank((String)baseFormAppId)) {
            return map;
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(baseFormAppId));
        if (formBean != null) {
            map.put("name", formBean.getFormName());
            long ownerId = formBean.getOwnerId();
            try {
                V3xOrgMember m = this.orgManager.getMemberById(Long.valueOf(ownerId));
                if (m != null) {
                    map.put("memberName", m.getName());
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public List<Map<String, Object>> findMatchBaseFormDatasByIds(Long baseFormAppId, Long formMasterId, List<String> retFormFields) {
        ArrayList<Map<String, Object>> retMap = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("id", formMasterId);
        String[] returnFeilds = null;
        returnFeilds = new String[retFormFields.size()];
        returnFeilds = retFormFields.toArray(returnFeilds);
        FlipInfo flipInfo = new FlipInfo();
        flipInfo.setNeedTotal(false);
        flipInfo.setPage(1);
        flipInfo.setSize(1000);
        List<FormDataMasterBean> list = null;
        try {
            FormBean formBean = this.cap4FormCacheManager.getForm(baseFormAppId);
            list = this.cap4FormDataDAO.selectMasterDataList(flipInfo, formBean.getMasterTableBean(), returnFeilds, where);
            HashMap<Long, Map<String, Object>> beanMap = new HashMap<Long, Map<String, Object>>();
            for (FormDataMasterBean bean : list) {
                Map<String, Object> valueMap = this.getFormValueMap(formBean, bean);
                valueMap.put("id", bean.getId());
                beanMap.put(bean.getId(), valueMap);
            }
            if (Strings.isNotEmpty(list)) {
                for (FormDataMasterBean bean : list) {
                    retMap.add((Map<String, Object>)beanMap.get(bean.getId()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    public boolean validateFormOperation(String formApp, String operationName) {
        if (Strings.isBlank((String)operationName)) {
            return false;
        }
        FormBean formBean = this.getCurrentEditingForm(formApp);
        String[] rights = FormUtil.paraseOperationIds((String)operationName);
        if (null == rights || formBean == null) {
            return false;
        }
        boolean hasPcAuth = false;
        boolean hasMbAuth = false;
        for (String right : rights) {
            FormAuthViewBean authViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(right)));
            FormViewBean viewBean = formBean.getFormView(authViewBean.getFormViewId());
            if (viewBean.isPc()) {
                hasPcAuth = true;
            } else {
                hasMbAuth = true;
            }
            if (hasPcAuth && hasMbAuth) break;
        }
        return hasMbAuth && hasPcAuth;
    }
}

