/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.workflow;

import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.service.FormManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.workflow.CAP4WorkflowFormDataMapManagerImpl;
import com.seeyon.ctp.workflow.WorkflowFormDataMapManagerImpl;
import com.seeyon.ctp.workflow.bo.NodeBindFormViewBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormBranchBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormBranchInBO;
import com.seeyon.ctp.workflow.bo.WorkflowFormFieldBO;
import com.seeyon.ctp.workflow.bo.WorkflowFromBranchExtendBO;
import com.seeyon.ctp.workflow.wapi.WorkflowFormDataMapManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class WorkflowFormDataCommonManagerImpl
implements WorkflowFormDataMapManager {
    private static final Log LOGGER = CtpLogFactory.getLog(WorkflowFormDataCommonManagerImpl.class);
    private FormManager formManager;
    private CAP4FormManager cap4FormManager;
    private FormCacheManager formCacheManager;

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public FormManager getFormManager() {
        return this.formManager;
    }

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    private String[] getBindFormOption(String formViewOperation) {
        String viewId = "";
        String operation = "";
        if (formViewOperation != null && !"".equals(formViewOperation)) {
            String[] viewAndOperation = formViewOperation.split("_");
            String[] bindViewAndOperation = viewAndOperation[0].split("[.]");
            if (bindViewAndOperation.length > 1) {
                viewId = bindViewAndOperation[0];
                operation = bindViewAndOperation[1];
            } else {
                operation = bindViewAndOperation[0];
            }
        }
        return new String[]{viewId, operation};
    }

    public String getAppName() {
        return ApplicationCategoryEnum.form.name();
    }

    public ApplicationCategoryEnum getCapType(String formId) {
        return this.getCapManager(formId).getCapType(formId);
    }

    public WorkflowFormDataMapManager getCapManager(String formApp) {
        CAP4WorkflowFormDataMapManagerImpl workflowFormDataMapManager = null;
        Long formId = Long.parseLong(formApp);
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormManager.getForm(formId);
        if (null != cap4FormBean) {
            workflowFormDataMapManager = (CAP4WorkflowFormDataMapManagerImpl)AppContext.getBean((String)"cap4WorkflowFormDataCommonManagerImpl");
        } else {
            FormBean cap3FormBean = this.formManager.getEditingForm(false);
            if (null == cap3FormBean) {
                cap3FormBean = this.formCacheManager.getForm(formId.longValue());
            }
            if (null != cap3FormBean) {
                workflowFormDataMapManager = (WorkflowFormDataMapManagerImpl)AppContext.getBean((String)"workflowFormDataMapManager");
            }
        }
        if (workflowFormDataMapManager == null) {
            LOGGER.error((Object)("\u8868\u5355\uff1a" + formApp + " \u5728\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\uff0c\u4e0d\u786e\u5b9a\u662f\u4ec0\u4e48\u7c7b\u578b, \u517c\u5bb9\u8bbe\u7f6e\u6210CAP3\u7684manager\u3002"));
            workflowFormDataMapManager = (WorkflowFormDataMapManagerImpl)AppContext.getBean((String)"workflowFormDataMapManager");
        }
        return workflowFormDataMapManager;
    }

    public List<WorkflowFormBranchBO> getBranchAllFormFields(String formAppId) {
        return this.getCapManager(formAppId).getBranchAllFormFields(formAppId);
    }

    public List<WorkflowFormBranchBO> getBranchInExcludeFormFields(String formAppId, String fieldName) {
        return this.getCapManager(formAppId).getBranchInExcludeFormFields(formAppId, fieldName);
    }

    public WorkflowFromBranchExtendBO getBranchExtendFormFields(String formApp, String fieldName) throws Exception {
        return this.getCapManager(formApp).getBranchExtendFormFields(formApp, fieldName);
    }

    public WorkflowFromBranchExtendBO getWorkflowBranchMultiExtendVO(String formApp, String fieldName) throws Exception {
        return this.getCapManager(formApp).getWorkflowBranchMultiExtendVO(formApp, fieldName);
    }

    public List<WorkflowFormBranchBO> getBranchSlaveFormFields(String formAppId, String fieldName) {
        return this.getCapManager(formAppId).getBranchSlaveFormFields(formAppId, fieldName);
    }

    public WorkflowFormBranchInBO getBranchInFormFields(String formApp, String fieldName) throws Exception {
        return this.getCapManager(formApp).getBranchInFormFields(formApp, fieldName);
    }

    public List<Map<String, Object>> findMatchBaseFormDatasByIds(Long baseFormAppId, Long formMasterId, List<String> retFormFields) {
        return this.getCapManager(String.valueOf(baseFormAppId)).findMatchBaseFormDatasByIds(baseFormAppId, formMasterId, retFormFields);
    }

    public String getLatestFormCondition(String conditionTitle, String formCondition, String oldFormAppId, String newFormAppId) {
        return this.getCapManager(oldFormAppId).getLatestFormCondition(conditionTitle, formCondition, oldFormAppId, newFormAppId);
    }

    public String getLatestFormFieldNode(String displayName, String newFormAppId) {
        return this.getCapManager(newFormAppId).getLatestFormFieldNode(displayName, newFormAppId);
    }

    public String getLatestFieldName(String fieldName, String oldFormAppId, String newFormAppId) {
        return this.getCapManager(oldFormAppId).getLatestFieldName(fieldName, oldFormAppId, newFormAppId);
    }

    public String[] getLatestFormInfo(String oldFormAppId, String formAppString, String formNameString, String operationNameString) {
        return this.getCapManager(oldFormAppId).getLatestFormInfo(oldFormAppId, formAppString, formNameString, operationNameString);
    }

    public String getLatestOperationName(String formApp, String operationName) {
        return this.getCapManager(formApp).getLatestOperationName(formApp, operationName);
    }

    public Long getLatestOperationId(Long formApp, Long operationName) {
        return this.getCapManager(String.valueOf(formApp)).getLatestOperationId(formApp, operationName);
    }

    public Long getLatestFormViewId(String formApp, Long operationName, Long form) {
        return this.getCapManager(formApp).getLatestFormViewId(formApp, operationName, form);
    }

    public String getLatestFormViewAndOprationName(String formApp, String operationId) {
        return this.getCapManager(formApp).getLatestFormViewAndOprationName(formApp, operationId);
    }

    public Map<Long, String[]> getFormMutilDisplayMap(String formApp, String operationm) {
        return this.getCapManager(formApp).getFormMutilDisplayMap(formApp, operationm);
    }

    public List<String[]> getFormMutilDisplayList(String formApp, Map<Long, String[]> mutilDisplayMap) {
        return this.getCapManager(formApp).getFormMutilDisplayList(formApp, mutilDisplayMap);
    }

    public List<String[]> getFormDateFieldListForBranch(String formApp, String formsonId, String type) {
        return this.getCapManager(formApp).getFormDateFieldListForBranch(formApp, formsonId, type);
    }

    public String getFormDateFieldJsonForBranch(String formApp, String formsonId, String type) throws Exception {
        return this.getCapManager(String.valueOf(formApp)).getFormDateFieldJsonForBranch(formApp, formsonId, type);
    }

    public boolean isNewFormBean(Long formApp) {
        return this.getCapManager(String.valueOf(formApp)).isNewFormBean(formApp);
    }

    public Map<String, WorkflowFormFieldBO> getFormFieldMap(String formApp) {
        if (Strings.isBlank((String)formApp) || "-1".equals(formApp)) {
            return new LinkedHashMap<String, WorkflowFormFieldBO>();
        }
        return this.getCapManager(formApp).getFormFieldMap(formApp);
    }

    public boolean isFormOperationExist(String formApp, String formName, String operationName) {
        return this.getCapManager(formApp).isFormOperationExist(formApp, formName, operationName);
    }

    public String getFormFieldOptionString(String formField, String formApp, boolean isExternalType) {
        return this.getCapManager(formApp).getFormFieldOptionString(formField, formApp, isExternalType);
    }

    public Set<String> isFormMustWrite(Long formAppId, Long operationId) {
        return this.getCapManager(String.valueOf(formAppId)).isFormMustWrite(formAppId, operationId);
    }

    public Set<String> isFormMustWrite(Long formAppId, String formViewOperation) {
        String[] bindViewOperation = this.getBindFormOption(formViewOperation);
        Set ret = null;
        if (Strings.isDigits((String)bindViewOperation[1])) {
            ret = this.getCapManager(String.valueOf(formAppId)).isFormMustWrite(formAppId, Long.valueOf(bindViewOperation[1]));
        } else {
            LOGGER.warn((Object)"\u83b7\u53d6\u8868\u5355\u8282\u64cd\u4f5c\u6743\u9650\u4e3a\u7a7a\uff0c \u4e0d\u6821\u9a8c\u8282\u70b9\u6743\u9650");
            ret = Collections.emptySet();
        }
        return ret;
    }

    public Map<String, Object> getFormValueMap(Long formAppId, Long masterId) {
        return this.getCapManager(String.valueOf(formAppId)).getFormValueMap(formAppId, masterId);
    }

    public Map<String, Object> getFormValueMap(Long formAppId, Long masterId, String rightId) {
        return this.getCapManager(String.valueOf(formAppId)).getFormValueMap(formAppId, masterId, rightId);
    }

    public boolean isFormOperationReadOnly(Long formAppId, Long operationId) {
        return this.getCapManager(String.valueOf(formAppId)).isFormOperationReadOnly(formAppId, operationId);
    }

    public boolean isFormOperationReadOnly(Long formAppId, String formViewOperation) {
        String[] bindViewOperation = this.getBindFormOption(formViewOperation);
        return this.getCapManager(String.valueOf(formAppId)).isFormOperationReadOnly(formAppId, Long.valueOf(bindViewOperation[1]));
    }

    public List<Map<String, Object>> getWorkflowFormCustomFunctionParams(String formApp) {
        return this.getCapManager(formApp).getWorkflowFormCustomFunctionParams(formApp);
    }

    public String getFormName(Long formAppId) {
        return this.getCapManager(String.valueOf(formAppId)).getFormName(formAppId);
    }

    public String getStartFormViewId(Long formAppId) {
        return this.getCapManager(String.valueOf(formAppId)).getStartFormViewId(formAppId);
    }

    public String getNormalFormViewId(long formAppId) {
        return this.getCapManager(String.valueOf(formAppId)).getNormalFormViewId(formAppId);
    }

    public String getStartDefualtRightId(long formId) {
        return this.getCapManager(String.valueOf(formId)).getStartDefualtRightId(formId);
    }

    public String getNormalDefualtRightId(long formId) {
        return this.getCapManager(String.valueOf(formId)).getNormalDefualtRightId(formId);
    }

    public boolean isForm(String formApp) {
        return this.getCapManager(formApp).isForm(formApp);
    }

    public boolean isCompareFieldParam(String fieldName, String formAppId) {
        return this.getCapManager(formAppId).isCompareFieldParam(fieldName, formAppId);
    }

    public int canBeFormFieldNode(String formApp, String fieldName) {
        return this.getCapManager(formApp).canBeFormFieldNode(formApp, fieldName);
    }

    public int canBeDeadline(String formApp, String fieldName) {
        return this.getCapManager(formApp).canBeDeadline(formApp, fieldName);
    }

    public int canBePostMatcherByFormField(String newFormApp, String fieldName) {
        return this.getCapManager(newFormApp).canBePostMatcherByFormField(newFormApp, fieldName);
    }

    public int canBeFormFieldRoleNode(String formApp, String fieldName, String roleName) {
        return this.getCapManager(formApp).canBeFormFieldRoleNode(formApp, fieldName, roleName);
    }

    public String translateFormFieldValieDisplayInfo(String first, String third, String formApp) {
        return this.getCapManager(formApp).translateFormFieldValieDisplayInfo(first, third, formApp);
    }

    public Map<String, Boolean> getFormulaFunctionMethodsMap() {
        WorkflowFormDataMapManagerImpl workflowFormDataMapManager = (WorkflowFormDataMapManagerImpl)AppContext.getBean((String)"workflowFormDataMapManager");
        return workflowFormDataMapManager.getFormulaFunctionMethodsMap();
    }

    public String getFormulaFunctionContextKey() {
        WorkflowFormDataMapManagerImpl workflowFormDataMapManager = (WorkflowFormDataMapManagerImpl)AppContext.getBean((String)"workflowFormDataMapManager");
        return workflowFormDataMapManager.getFormulaFunctionContextKey();
    }

    public Map<String, WorkflowFormFieldBO> getFormFieldMap(String formApp, List<String> fieldTypes, String externalType, List<String> tableTypes, boolean distinct) {
        return this.getCapManager(formApp).getFormFieldMap(formApp, fieldTypes, externalType, tableTypes, distinct);
    }

    public Map<String, String> getWFDynamicFormInfos(String baseFormAppId) {
        return this.getCapManager(baseFormAppId).getWFDynamicFormInfos(baseFormAppId);
    }

    public List<NodeBindFormViewBO> getNodeBindFormViewBOs(String formApp, String nodeId) {
        return this.getCapManager(formApp).getNodeBindFormViewBOs(formApp, nodeId);
    }

    public List<NodeBindFormViewBO> parseNodeBindFormViewBO(String formId, String rightId) {
        return this.getCapManager(formId).parseNodeBindFormViewBO(formId, rightId);
    }

    public boolean validateFormOperation(String formApp, String operationName) {
        return this.getCapManager(formApp).validateFormOperation(formApp, operationName);
    }
}

