/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp;

import com.seeyon.cdp.AbstractConnector;
import com.seeyon.cdp.Connector;
import com.seeyon.cdp.DataSender;
import com.seeyon.cdp.Queue;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.mq.ChannelTypeEnum;
import com.seeyon.ctp.common.mq.MQHandler;
import com.seeyon.ctp.common.mq.MapMessage;
import com.seeyon.ctp.common.mq.Message;
import com.seeyon.ctp.common.mq.MessageAckTypeEnum;
import com.seeyon.ctp.common.mq.MessageReceiver;
import com.seeyon.ctp.common.mq.ObjectMessage;
import com.seeyon.ctp.common.mq.TextMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;

public class CDPEmbeddedConnector
extends AbstractConnector
implements Connector {
    protected static final String QUEUE_NAME = "CDP";

    public CDPEmbeddedConnector() {
        this.isEnabled = "true".equals(SystemProperties.getInstance().getProperty("cdp.enabled"));
        if (this.isEnabled) {
            Queue.getInstance().start();
        }
    }

    private void initQueue() {
        MessageReceiver messageReceiver = new MessageReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Message message) {
                if (message instanceof TextMessage) {
                    AbstractConnector.LOG.debug((Object)(Thread.currentThread().getName() + " receive text message (" + message.getKey() + "):" + ((TextMessage)message).getText()));
                }
                if (message instanceof ObjectMessage) {
                    AbstractConnector.LOG.debug((Object)(Thread.currentThread().getName() + " receive object message(" + message.getKey() + "):" + ((ObjectMessage)message).getObject()));
                }
                if (message instanceof MapMessage) {
                    HashMap map = ((MapMessage)message).getMapData();
                    if (map.containsKey("type")) {
                        int type = (Integer)map.get("type");
                        DataSender dataSender = CDPEmbeddedConnector.this.getDataSender(type);
                        try {
                            dataSender.send(map);
                        }
                        catch (BusinessException e) {
                            AbstractConnector.LOG.error((Object)("send data error\uff1a" + e.getLocalizedMessage()), (Throwable)e);
                        }
                        catch (Exception e) {
                            AbstractConnector.LOG.error((Object)("send data error\uff1a" + e.getLocalizedMessage()));
                        }
                        finally {
                            if (message.getOriginMsg() != null) {
                                try {
                                    message.getOriginMsg().acknowledge();
                                }
                                catch (JMSException e) {
                                    AbstractConnector.LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                    } else {
                        AbstractConnector.LOG.error((Object)("unkown type,cannot send\uff1a" + map));
                    }
                    AbstractConnector.LOG.debug((Object)(Thread.currentThread().getName() + " receive map message(" + message.getKey() + "):" + map.get("name")));
                }
            }

            @Override
            public void processBatch(List<Message> messageList) {
                for (Message message : messageList) {
                    this.process(message);
                }
            }
        };
        try {
            MQHandler.subscribe(MessageAckTypeEnum.MANUAL_ACK, ChannelTypeEnum.QUEUE, QUEUE_NAME, messageReceiver);
        }
        catch (BusinessException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void push(int actionType2, HashMap<String, ? extends Serializable> data) {
        if (this.isEnabled) {
            HashMap<String, Serializable> record = new HashMap<String, Serializable>();
            record.put("type", Integer.valueOf(actionType2));
            record.put("createDate", Long.valueOf(System.currentTimeMillis()));
            record.put("operator", Long.valueOf(AppContext.currentUserId()));
            record.put("data", data);
            Queue.getInstance().add(record);
        }
    }
}

