/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp;

import com.seeyon.cdp.CDPAgent;
import com.seeyon.cdp.CDPEnums;
import com.seeyon.cdp.CDPUtil;
import com.seeyon.cdp.Registry;
import com.seeyon.cdp.RequestTrackingHandler;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CapabilityLogger;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.perfmon.PerfLogConfig;
import com.seeyon.ctp.monitor.perfmon.PerfmonMisc;
import com.seeyon.ctp.util.Strings;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.commons.logging.Log;

public class RequestTracker {
    private static final Log LOGGER = CtpLogFactory.getLog(RequestTracker.class);
    private static final String THREADLOCAL_KEY_START_TIME = "CTPHandlerInterceptor.startTime";
    private static final String THREADLOCAL_KEY_METHOD_NAME = "CTPHandlerInterceptor.methodName";
    private static final boolean isCDPEnabled = CDPAgent.isEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void track(HttpServletRequest request, Object handler) {
        block14: {
            try {
                String loginName;
                if (!CapabilityLogger.getInstance().isDebugEnabled()) break block14;
                Object startTime = AppContext.getThreadContext(THREADLOCAL_KEY_START_TIME);
                if (startTime == null) {
                    return;
                }
                long elapsedTime = System.currentTimeMillis() - (Long)startTime;
                if (elapsedTime < (long)PerfLogConfig.getSlowlaunchControllerTime()) break block14;
                try {
                    loginName = AppContext.currentUserLoginName();
                }
                catch (Exception e) {
                    loginName = "NOUSER";
                }
                String action = PerfmonMisc.getAopProxy(handler) + "." + AppContext.getThreadContext(THREADLOCAL_KEY_METHOD_NAME);
                if (action.startsWith("AjaxController")) {
                    String name = request.getParameter("managerName");
                    if (name != null) {
                        name = name.replaceAll(",", " ");
                        String managerMethod = request.getParameter("managerMethod");
                        if ("sectionManager".equalsIgnoreCase(name) && "doProjection".equals(managerMethod)) {
                            String arguments = request.getParameter("arguments");
                            if (arguments != null) {
                                int from = arguments.indexOf("sectionBeanId") + 16;
                                arguments = arguments.substring(from, arguments.indexOf(34, from));
                            }
                            action = name + ".pj(" + arguments + ")";
                        } else {
                            action = name + "." + managerMethod;
                        }
                    }
                } else if (action.startsWith("token/")) {
                    action = "token";
                }
                String reason = request.getParameter("reason");
                String ip = Strings.getRemoteAddr(request);
                String queryString = request.getQueryString();
                CapabilityLogger.getInstance().debug(ip + "," + loginName + "," + action + "," + elapsedTime + (PerfLogConfig.isRecordControllerParam() ? "," + queryString : "") + (reason != null ? "," + reason : ""));
                RequestTracker.send(request, ip, loginName, action, elapsedTime, queryString);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)"\u8f93\u51fa\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef", e);
            }
        }
    }

    public static void trackV3xAjax(HttpServletRequest request, String serviceName, String methodName, long startTime) {
        if (CapabilityLogger.getInstance().isDebugEnabled()) {
            User user = AppContext.getCurrentUser();
            String loginName = "NOUSER";
            if (user != null) {
                loginName = user.getLoginName();
            }
            long loadTime = System.currentTimeMillis() - startTime;
            String action = "[AJAX]" + serviceName + "." + methodName;
            String ip = Strings.getRemoteAddr(request);
            String queryString = request.getQueryString();
            CapabilityLogger.getInstance().debug(ip + "," + loginName + "," + action + "," + loadTime + "," + queryString);
            RequestTracker.send(request, ip, loginName, action, loadTime, queryString);
        }
    }

    public static void trackUserAgent(HttpServletRequest request, Long logonLogId) {
        if (isCDPEnabled && request != null) {
            String userAgent = request.getHeader("User-Agent");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userAgent", userAgent);
            map.put("logonLogId", logonLogId);
            CDPAgent.getConnectorInstance().push(CDPEnums.actionType.userAgent.getKey(), map);
        }
    }

    public static void trackRest(ContainerRequestContext request, HttpServletRequest req, String loginName, long dt) {
        if (CapabilityLogger.getInstance().isDebugEnabled()) {
            String ip = Strings.getRemoteAddr(req);
            String action = request.getUriInfo().getPath();
            if (action.startsWith("token/")) {
                action = "token";
            }
            String queryString = request.getUriInfo().getQueryParameters().toString();
            CapabilityLogger.getInstance().debug(ip + "," + loginName + "," + action + " " + request.getMethod().charAt(0) + "," + dt + (PerfLogConfig.isRecordControllerParam() ? "," + queryString : ""));
            if (isCDPEnabled) {
                CDPUtil.sendUserEvent(ip, loginName, action, dt, queryString);
            }
        }
    }

    private static void send(HttpServletRequest request, String ip, String loginName, String action, long loadTime, String queryString) {
        if (isCDPEnabled) {
            HashMap ctx = CDPUtil.buildUserEventContext(ip, loginName, action, loadTime, queryString);
            CDPUtil.sendUserEvent(ctx);
            for (RequestTrackingHandler handler : Registry.getInstance()) {
                handler.handle(request, ctx);
            }
        }
    }

    public static void addHandler(RequestTrackingHandler handler) throws BusinessException {
        Registry.getInstance().register(handler);
    }
}

