/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cdp.rule;

import com.seeyon.cdp.rule.Context;
import com.seeyon.cdp.rule.Execution;
import com.seeyon.cdp.rule.Rule;
import com.seeyon.cdp.rule.Scenario;
import com.seeyon.cdp.rule.ScenarioImpl;
import com.seeyon.cdp.rule.ScriptRule;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.event.EventThreadServer;
import com.seeyon.ctp.thread.ThreadManager;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;

public class RuleRuntime {
    private static final Log LOG = LogFactory.getLog(RuleRuntime.class);
    private static Map<String, Scenario> scenarioes = new ConcurrentHashMap<String, Scenario>();
    static final String THREAD_NAME = "Rule Execute";

    public static void execute(Scenario scenario, Context ctx) throws BusinessException {
        scenario.start(ctx);
    }

    public static void load(String basePath) throws IOException {
        String[] files;
        File dir = new File(basePath);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        ds.setIncludes(new String[]{"*.rl"});
        ds.scan();
        for (String rl : files = ds.getIncludedFiles()) {
            try {
                String json = FileUtils.readFileToString((File)new File(dir.getAbsolutePath() + File.separator + rl), (String)"UTF-8");
                Map rule = JSONUtil.parseJSONString(json, Map.class);
                String name = (String)rule.get("name");
                String script = (String)rule.get("rule");
                List executionNames = (List)rule.get("execution");
                Execution[] executions = new Execution[executionNames.size()];
                for (int i = 0; i < executionNames.size(); ++i) {
                    Class<?> clazz = Class.forName((String)executionNames.get(i));
                    executions[i] = (Execution)clazz.newInstance();
                }
                RuleRuntime.create(name, new ScriptRule(script), executions);
            }
            catch (Throwable e) {
                LOG.error((Object)("\u52a0\u8f7d\u89c4\u5219\u51fa\u9519\uff1a" + rl + " " + e.getLocalizedMessage()), e);
            }
        }
    }

    public static void execute(String scenarioName, Context ctx) throws BusinessException {
        Scenario scenario = RuleRuntime.getScenario(scenarioName);
        if (scenario == null) {
            throw new BusinessException("\u6307\u5b9a\u540d\u79f0\u7684\u573a\u666f\u4e0d\u5b58\u5728\uff1a" + scenarioName);
        }
        scenario.start(ctx);
    }

    public static Scenario getScenario(String name) {
        return scenarioes.get(name);
    }

    public static Scenario create(String name, Rule rule, Execution ... executions) throws BusinessException {
        if (RuleRuntime.getScenario(name) != null) {
            throw new BusinessException("\u6307\u5b9a\u540d\u79f0\u7684\u573a\u666f\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540d\u79f0\u3002");
        }
        Scenario scenario = RuleRuntime.createScenario(name, rule, executions);
        scenarioes.put(name, scenario);
        return scenario;
    }

    public static void schedule(String scenarioName, String cronExpression, String beanName) throws BusinessException {
    }

    private static Scenario createScenario(String name, Rule rule, Execution ... executions) {
        ScenarioImpl scenario = new ScenarioImpl(name, rule);
        for (Execution execution : executions) {
            scenario.bind(execution);
        }
        return scenario;
    }

    static {
        try {
            ThreadManager.startServer(THREAD_NAME, EventThreadServer.class, null, "\u89c4\u5219\u6267\u884c\u7ebf\u7a0b", 50);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

