/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cluster;

import com.seeyon.ctp.cluster.notification.NotificationFactory;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class NotificationListenerRegistry {
    private List<NotificationListener> listeners;
    private List<NotificationType> initNotifications = new ArrayList<NotificationType>();
    private static final Log logger = CtpLogFactory.getLog(NotificationListenerRegistry.class);

    public List<NotificationType> getInitNotifications() {
        return this.initNotifications;
    }

    public void setInitNotifications(List<NotificationType> initNotifications) {
        ArrayList<NotificationType> l = new ArrayList<NotificationType>();
        for (NotificationType oType : initNotifications) {
            if (oType instanceof NotificationType) {
                l.add(oType);
            }
            if (!(oType instanceof String)) continue;
            l.add(NotificationType.valueOf((String)((Object)oType)));
        }
        this.initNotifications = l;
    }

    public List<NotificationListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<NotificationListener> listeners) {
        this.listeners = listeners;
    }

    public void init() {
        NotificationFactory manager = NotificationManager.getInstance();
        for (NotificationListener l : this.listeners) {
            manager.register(l);
        }
        if (this.initNotifications != null) {
            this.initNotifications.add(NotificationType.PullAllOnlineUser);
            boolean isSendEnabled = manager.isSendEnabled();
            manager.enableSend(true);
            for (NotificationType type : this.initNotifications) {
                manager.send(type, null);
            }
            manager.enableSend(isSendEnabled);
        }
    }
}

