/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public final class BugPatchIndexManagerBean {
    private static final Log log = CtpLogFactory.getLog(BugPatchIndexManagerBean.class);
    private static BugPatchIndexManagerBean instance;
    private List<String> BUGS = new ArrayList<String>();
    private List<String> PATCHS = new ArrayList<String>();

    private BugPatchIndexManagerBean() {
    }

    private void init() {
        String F = File.separator;
        String patchDirFilepath = SystemEnvironment.getApplicationFolder() + F + "Patch";
        File patchDirFile = new File(patchDirFilepath);
        if (!patchDirFile.exists() || !patchDirFile.isDirectory()) {
            log.warn((Object)("\u6587\u4ef6\u5939[" + patchDirFilepath + "]\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6587\u4ef6\u5939"));
        } else {
            File[] patchFiles;
            for (File file : patchFiles = patchDirFile.listFiles()) {
                String name = file.getName();
                if (name.startsWith("BUG")) {
                    this.BUGS.add(name.substring(3));
                    continue;
                }
                if (!name.startsWith("Patch")) continue;
                this.PATCHS.add(name.substring(5));
            }
        }
    }

    public static BugPatchIndexManagerBean getInstance() {
        if (instance == null) {
            instance = new BugPatchIndexManagerBean();
            instance.init();
        }
        return instance;
    }

    public List<String> getBUGS() {
        return this.BUGS;
    }

    public List<String> getPATCHS() {
        return this.PATCHS;
    }
}

