/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate.domain;

import com.seeyon.ctp.common.authenticate.domain.IP;
import com.seeyon.ctp.common.authenticate.domain.IdentificationDog;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.util.Base64;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentificationDogManager {
    private static final Log log = LogFactory.getLog(IdentificationDogManager.class);
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(IdentificationDogManager.class);
    private CacheObject<Boolean> mustSystemUseDogLogin = cacheFactory.createObject("mustSystemUseDogLogin");
    private CacheMap<String, IdentificationDog> dogs = cacheFactory.createMap("Dogs");
    private CacheMap<String, SessionInfo> sessionIdMapDog = cacheFactory.createMap("SessionIdMapDog");
    private CacheSet<String> UserIdOfmustUseDogLogin = cacheFactory.createSet("UserIdOfmustUseDogLogin");
    private CacheSet<String> UserIdOfCanAccessMobile = cacheFactory.createSet("UserIdOfCanAccessMobile");
    private CacheSet<IP> noChekcIPs = cacheFactory.createSet("NoChekcIPs");
    private static IdentificationDogManager instance = new IdentificationDogManager();

    private IdentificationDogManager() {
        this.mustSystemUseDogLogin.set(false);
    }

    public static IdentificationDogManager getInstance() {
        return instance;
    }

    public Collection<IdentificationDog> all() {
        return this.dogs.values();
    }

    public IdentificationDog getDog(String id) {
        if (this.isBlank(id)) {
            return null;
        }
        return this.dogs.get(id);
    }

    public IdentificationDog getDogByEncodeId(String dogId) {
        if (this.isBlank(dogId)) {
            return null;
        }
        dogId = this.decodeString(dogId);
        return this.dogs.get(dogId);
    }

    public void setDog(String id, IdentificationDog dog) {
        this.dogs.put(id, dog);
    }

    public void removeDog(String id) {
        this.dogs.remove(id);
    }

    public void setSystemMustUseDogLogin(boolean p, Set<String> noCheckIPs) {
        this.mustSystemUseDogLogin.set(p);
        HashSet<IP> ips = new HashSet<IP>();
        for (String i : noCheckIPs) {
            ips.add(new IP(i));
        }
        this.noChekcIPs.replaceAll(ips);
    }

    public void addUserIdOfMustUseDogLogin(String loginName) {
        this.UserIdOfmustUseDogLogin.add(loginName);
    }

    public void addUserOfCanAccessMobile(String loginName) {
        this.UserIdOfCanAccessMobile.add(loginName);
    }

    public void removeUserIdOfMustUseDogLogin(String loginName) {
        this.UserIdOfmustUseDogLogin.remove(loginName);
    }

    public void removeUserOfCanAccessMobile(String loginName) {
        this.UserIdOfCanAccessMobile.remove(loginName);
    }

    public boolean isSystemMustUseDogLogin(String remoteIP) {
        if (!this.mustSystemUseDogLogin.get().booleanValue()) {
            return false;
        }
        log.info((Object)("remoteIP:" + remoteIP));
        for (IP ip : this.noChekcIPs.toSet()) {
            log.info((Object)("ip:" + ip));
            if (!ip.matching(remoteIP)) continue;
            return false;
        }
        return true;
    }

    public String newSessionId(String dogId, Long memberId, String username, String password) {
        SessionInfo s = new SessionInfo(username, memberId, password, dogId);
        this.sessionIdMapDog.put(s.getId(), s);
        return s.getId();
    }

    public SessionInfo getDogIdBySessionId(String sessionId) {
        if (this.isBlank(sessionId)) {
            return null;
        }
        sessionId = this.decodeString(sessionId);
        return this.sessionIdMapDog.remove(sessionId);
    }

    public boolean isMustUseDogLogin(String loginName) {
        return this.UserIdOfmustUseDogLogin.contains(loginName);
    }

    public boolean canAccessMobile(String loginName) {
        return this.UserIdOfCanAccessMobile.contains(loginName);
    }

    private boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public String decodeString(String encodeString) {
        char[] encodeStringCharArray = encodeString.toCharArray();
        int i = 0;
        while (i < encodeStringCharArray.length) {
            int n = i++;
            encodeStringCharArray[n] = (char)(encodeStringCharArray[n] + '\u0001');
        }
        try {
            new Base64();
            encodeString = new String(Base64.decode2String(new String(encodeStringCharArray)));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return encodeString;
    }

    public static class SessionInfo
    implements Serializable {
        private String id;
        private Long memberId;
        private String username;
        private String password;
        private String dogId;

        public SessionInfo(String username, Long memberId, String password, String dogId) {
            this.id = String.valueOf(UUID.randomUUID().getMostSignificantBits());
            this.memberId = memberId;
            this.username = username;
            this.password = password;
            this.dogId = dogId;
        }

        public SessionInfo() {
        }

        public String getId() {
            return this.id;
        }

        public Long getMemberId() {
            return this.memberId;
        }

        public void setMemberId(Long memberId) {
            this.memberId = memberId;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getDogId() {
            return this.dogId;
        }

        public void setDogId(String dogId) {
            this.dogId = dogId;
        }
    }
}

