/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.authenticate.domain;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.authenticate.domain.UserPrivilegeCheck;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.LRUStack;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class UserHelper {
    private static final String SPACESLIST = "spacesList";
    private static final String SPACEJSONSTR = "spaceJsonStr";
    public static final String USERROLES = "userRoles";
    public static final String OLD_DEFAULT_CSS_PATH = "/common/skin/dist/components/components_theme_default.css";
    public static final String NEW_DEFAULT_CSS_PATH = "/skin/dist/components/components_theme_default.css";
    private static Log LOGGER = CtpLogFactory.getLog(UserHelper.class);
    private static final String MENUS = "menus";
    private static final String MENUJSONSTR = "menuJsonStr";
    private static final String SHORTCUTS = "shortcuts";
    private static final String SHORTCUTSJSONSTR = "shortcutsJsonStr";
    private static UserPrivilegeCheck check;
    private static String resourceJsonStr;
    private static Set rolesSet;
    private static final String COMPONENT_CSS = "componentCss";
    private static final String OLD_COMPONENT_CSS = "oldComponentCss";

    public static void setMenus(List menus) {
        UserHelper.getCurrentUser().setProperty(MENUS, menus);
        UserHelper.getCurrentUser().setProperty(MENUJSONSTR, null);
    }

    public static String getMenuJsonStr() {
        List menus = (List)UserHelper.getCurrentUser().getProperty(MENUS);
        String menuJsonStr = (String)UserHelper.getCurrentUser().getProperty(MENUJSONSTR);
        if (menuJsonStr == null && menus != null && menus.size() > 0) {
            menuJsonStr = JSONUtil.toJSONString(menus);
            UserHelper.getCurrentUser().setProperty(MENUJSONSTR, menuJsonStr);
        }
        return menuJsonStr;
    }

    public static void setSpaces(List spaces) {
        UserHelper.getCurrentUser().setProperty(SPACESLIST, spaces);
        UserHelper.getCurrentUser().setProperty(SPACEJSONSTR, null);
    }

    private static User getCurrentUser() {
        return AppContext.getCurrentUser();
    }

    public static String getSpaceJsonStr() {
        List spacesList = (List)UserHelper.getCurrentUser().getProperty(SPACESLIST);
        String spaceJsonStr = (String)UserHelper.getCurrentUser().getProperty(SPACEJSONSTR);
        if (spaceJsonStr == null && spacesList != null) {
            spaceJsonStr = JSONUtil.toJSONString(spacesList);
            UserHelper.getCurrentUser().setProperty(SPACEJSONSTR, spaceJsonStr);
        }
        return spaceJsonStr;
    }

    public static void setShortcuts(List shortcuts) {
        UserHelper.getCurrentUser().setProperty(SHORTCUTS, shortcuts);
        UserHelper.getCurrentUser().setProperty(SHORTCUTSJSONSTR, null);
    }

    public static List getShortcuts() {
        return (List)UserHelper.getCurrentUser().getProperty(SHORTCUTS);
    }

    public static List getMenus() {
        return (List)UserHelper.getCurrentUser().getProperty(MENUS);
    }

    public static String getShortcutsJsonStr() {
        List shortcuts = (List)UserHelper.getCurrentUser().getProperty(SHORTCUTS);
        String shortcutsJsonStr = (String)UserHelper.getCurrentUser().getProperty(SHORTCUTSJSONSTR);
        if (shortcutsJsonStr == null && shortcuts != null && shortcuts.size() > 0) {
            shortcutsJsonStr = JSONUtil.toJSONString(shortcuts);
            UserHelper.getCurrentUser().setProperty(SHORTCUTSJSONSTR, shortcutsJsonStr);
        }
        return shortcutsJsonStr;
    }

    public static void pushRecentObj(String customizeKey, Object recentObj) {
        ArrayList<Object> recentObjs = new ArrayList<Object>();
        recentObjs.add(recentObj);
        UserHelper.pushRecentObjs(customizeKey, recentObjs);
    }

    public static void pushRecentObjs(String customizeKey, List recentObjs) {
        List recentCustomize = UserHelper.getRecentList(customizeKey);
        int capacity = 10;
        String capacityStr = UserHelper.getCurrentUser().getCustomize(customizeKey + "_capacity");
        if (Strings.isNotBlank(capacityStr)) {
            capacity = Integer.parseInt(capacityStr);
        }
        LRUStack recent = new LRUStack(capacity);
        recent.addAll(recentCustomize);
        recent.addAll(recentObjs);
        UserHelper.getCurrentUser().setCustomizeJson(customizeKey, recent);
    }

    public static List getRecentList(String customizeKey) {
        ArrayList recentCustomize = (ArrayList)UserHelper.getCurrentUser().getCustomizeJson(customizeKey);
        if (recentCustomize == null) {
            recentCustomize = new ArrayList(0);
        }
        return recentCustomize;
    }

    private static UserPrivilegeCheck getUserPrivilegeCheck() {
        if (check == null) {
            check = (UserPrivilegeCheck)AppContext.getBean("privilegeManager");
        }
        return check;
    }

    public static boolean hasMenuCode(String code) {
        try {
            return UserHelper.getUserPrivilegeCheck().hasMenuCode(code);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public static void setResourceJsonStr(String resourceJsonStr) {
        UserHelper.getCurrentUser().setProperty("resourceJsonStr", resourceJsonStr);
    }

    public static String getResourceJsonStr() {
        return (String)UserHelper.getCurrentUser().getProperty("resourceJsonStr");
    }

    public static Set getRolesSet() {
        return (Set)UserHelper.getCurrentUser().getProperty(USERROLES);
    }

    public static void setRolesSet(Set rolesSet) {
        UserHelper.getCurrentUser().setProperty(USERROLES, rolesSet);
    }

    public static boolean isFromMicroCollaboration(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return ua != null && (ua.toLowerCase().contains("micromessenger") || ua.toLowerCase().contains("dingtalk"));
    }

    public static boolean isIgnoreOnlineCheck(User user) {
        return "1".equals(user.getProperty("IgnoreOnlineCheck"));
    }

    public static void setComponentSkin(String componentSkin, String oldComponentSkin) {
        User user = UserHelper.getCurrentUser();
        if (user == null) {
            return;
        }
        if (!user.isAdmin()) {
            if (Strings.isNotBlank(componentSkin)) {
                user.setProperty(COMPONENT_CSS, componentSkin);
            }
            if (Strings.isNotBlank(oldComponentSkin)) {
                user.setProperty(OLD_COMPONENT_CSS, oldComponentSkin);
            }
        }
    }

    public static String getComponentSkin() {
        User user = UserHelper.getCurrentUser();
        String css = NEW_DEFAULT_CSS_PATH;
        if (user == null) {
            return css;
        }
        if (!user.isAdmin()) {
            Object obj = user.getProperty(COMPONENT_CSS);
            if (obj == null) {
                return css;
            }
            return (String)obj;
        }
        return css;
    }

    public static String getOldComponentSkin() {
        User user = UserHelper.getCurrentUser();
        String css = OLD_DEFAULT_CSS_PATH;
        if (user == null) {
            return css;
        }
        if (!user.isAdmin()) {
            Object obj = user.getProperty(OLD_COMPONENT_CSS);
            if (obj == null) {
                return css;
            }
            return (String)obj;
        }
        return css;
    }

    static {
        resourceJsonStr = null;
        rolesSet = null;
    }
}

