/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.GroupCacheable;

public class CacheStatistics {
    private int misses = 0;
    private int writeCount = 0;
    private int readCount = 0;
    private int deleteCount = 0;
    private int clearCount = 0;
    private long created = System.currentTimeMillis();
    private long lastUpdated = System.currentTimeMillis();
    private final GroupCacheable cache;

    public CacheStatistics(GroupCacheable cache) {
        this.cache = cache;
    }

    public int size() {
        return this.cache.size();
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public void write() {
        ++this.writeCount;
        this.updated();
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void updated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void read() {
        ++this.readCount;
    }

    public int getMisses() {
        return this.misses;
    }

    public void misses() {
        ++this.misses;
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public void delete() {
        ++this.deleteCount;
        this.updated();
    }

    public int getClearCount() {
        return this.clearCount;
    }

    public void clear() {
        ++this.clearCount;
    }

    public void resetStatistics() {
        this.misses = 0;
        this.writeCount = 0;
        this.readCount = 0;
        this.deleteCount = 0;
        this.clearCount = 0;
    }
}

