/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheEntry;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.IndexManager;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class GenericCacheMap<K extends Serializable, V extends Serializable>
extends IndexManager<K, V>
implements CacheMap<K, V> {
    private static final Log log = LogFactory.getLog(GenericCacheMap.class);
    private Map<K, CacheEntry<V>> data;
    private DataLoader<K> loader;

    public GenericCacheMap(String group, String name, CacheConfiguration config) {
        this(group, name, config, new ConcurrentHashMap());
    }

    public GenericCacheMap(String group, String name, CacheConfiguration config, Map<K, CacheEntry<V>> map) {
        super(group, name, config);
        this.data = map;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
        this.statistics.clear();
        this.sendNotification(null, null, CacheNotification.Action.Clear);
        this.clearIndex();
    }

    @Override
    public void put(K key, V value) {
        this.updateLocal(key, value);
        this.notifyUpdate(key);
    }

    private void updateLocal(K key, V value) {
        if (key == null) {
            return;
        }
        CacheEntry<V> entry = this.data.get(key);
        if (entry == null) {
            entry = new CacheEntry(this);
        }
        entry.setValue(value);
        this.data.put(key, entry);
        this.createIndex(key, value);
    }

    @Override
    public void notifyUpdate(K key) {
        Serializable value = null;
        if (this.loader == null) {
            value = (Serializable)this.get(key);
        }
        this.sendNotification((Serializable)key, value, CacheNotification.Action.Put);
        this.statistics.write();
    }

    @Override
    public void notifyUpdate(K[] keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], this.get(keys[i]));
        }
        this.sendNotification(map, null, CacheNotification.Action.PutAll);
    }

    @Override
    public void notifyUpdate(Collection<K> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        LinkedHashMap<Serializable, V> map = new LinkedHashMap<Serializable, V>();
        for (Serializable key : keys) {
            map.put(key, this.get(key));
        }
        this.sendNotification(map, null, CacheNotification.Action.PutAll);
    }

    @Override
    public void notifyUpdate(Serializable key, Serializable updateKey, CacheNotification.Action operation, Serializable content) {
        if (key == null || updateKey == null) {
            return;
        }
        CacheMapChange mapChange = new CacheMapChange(this.getName(), key, updateKey, operation, content);
        this.sendNotification(key, mapChange, operation);
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<V> entry = this.data.get(key);
        if (entry != null) {
            this.statistics.read();
            return entry.getValue();
        }
        this.statistics.misses();
        return null;
    }

    @Override
    public V remove(K key) {
        V result = null;
        CacheEntry<V> entry = this.data.remove(key);
        if (entry != null) {
            result = entry.getValue();
            this.removeIndex(key, result);
            this.statistics.delete();
        } else {
            log.debug((Object)("remove\u4e0d\u5b58\u5728\u7684key\uff1a" + this.getGroup() + ":" + this.getName()));
        }
        this.sendNotification((Serializable)key, null, CacheNotification.Action.Remove);
        return result;
    }

    @Override
    public boolean removeAll(Collection<K> keys) {
        if (keys == null || keys.size() == 0) {
            return false;
        }
        boolean result = false;
        for (Serializable k : keys) {
            this.statistics.delete();
            CacheEntry<V> value = this.data.remove(k);
            if (value == null) continue;
            this.removeIndex(k, value.getValue());
            result = true;
        }
        this.sendNotification(new ArrayList<K>(keys), null, CacheNotification.Action.RemoveAll);
        return result;
    }

    @Override
    public boolean contains(K key) {
        return this.data.containsKey(key);
    }

    @Override
    public Map<K, V> toMap() {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, CacheEntry<V>> entry : this.data.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        return new LinkedHashSet<K>(this.data.keySet());
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return GenericCacheMap.this.size();
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> ent : map.entrySet()) {
            this.updateLocal((Serializable)ent.getKey(), (Serializable)ent.getValue());
        }
        this.sendNotification((Serializable)((Object)map), null, CacheNotification.Action.PutAll);
        this.statistics.write();
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        this.data.clear();
        for (Map.Entry<K, V> ent : map.entrySet()) {
            this.updateLocal((Serializable)ent.getKey(), (Serializable)ent.getValue());
        }
        this.sendNotification((Serializable)((Object)map), null, CacheNotification.Action.ReplaceAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.loader != null) {
            GenericCacheMap genericCacheMap = this;
            synchronized (genericCacheMap) {
                this.loader.load();
            }
            this.sendNotification(null, null, CacheNotification.Action.Reload);
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdreload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void reload(K k) {
        if (this.loader != null) {
            this.loader.load(k);
            this.notifyUpdate(k);
        } else {
            log.error((Object)"\u7f13\u5b58\u6ca1\u6709\u8bbe\u7f6eDataLoader\uff0c\u4e0d\u80fdload\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ee3\u7801\u3002");
        }
    }

    @Override
    public void setDataLoader(DataLoader<K> loader) {
        this.loader = loader;
    }

    @Override
    public DataLoader<K> getDataLoader() {
        return this.loader;
    }

    class ValueIterator
    implements Iterator<V> {
        private Iterator<CacheEntry<V>> itr;

        ValueIterator() {
            this.itr = GenericCacheMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public V next() {
            return this.itr.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("CacheMap\u7684values\u662f\u53ea\u8bfb\u7684\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002");
        }
    }
}

