/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache;

import com.seeyon.ctp.common.cache.AbstractGroupCache;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import java.io.Serializable;

class GenericCacheObject<E extends Serializable>
extends AbstractGroupCache
implements CacheObject<E> {
    private E value = null;

    public GenericCacheObject(String group, String name, CacheConfiguration config) {
        super(group, name, config);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public void clear() {
        this.value = null;
        this.statistics.clear();
        this.sendNotification(null, null, CacheNotification.Action.Clear);
    }

    @Override
    public void set(E o) {
        this.value = o;
        this.statistics.write();
        this.notifyUpdate();
    }

    @Override
    public E get() {
        this.statistics.read();
        return this.value;
    }

    @Override
    public void notifyUpdate() {
        this.sendNotification(null, (Serializable)this.value, CacheNotification.Action.Set);
    }
}

