/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.loader;

import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMapDataLoader<K extends Serializable, V extends Serializable>
implements DataLoader<K> {
    private static final Log clusterLog = LogFactory.getLog(AbstractMapDataLoader.class);
    protected CacheMap<K, V> map;

    public AbstractMapDataLoader(CacheMap<K, V> map) {
        this.map = map;
    }

    protected abstract Map<K, V> loadLocal();

    protected abstract V loadLocal(K var1);

    @Override
    public void load() {
        this.map.replaceAll(this.loadLocal());
    }

    @Override
    public void load(K key) {
        V v = this.loadLocal(key);
        if (v != null) {
            this.map.put(key, v);
        } else {
            clusterLog.warn((Object)("key not found:" + key + " at " + this.map.getGroup() + "::" + this.map.getName()));
            this.map.remove(key);
        }
    }
}

