/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheStatistics;
import com.seeyon.ctp.common.cache.MapIndex;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.loader.DataLoader;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RedisCacheMap<K extends Serializable, V extends Serializable>
implements CacheMap<K, V> {
    private CacheMap<K, V> originMap = null;
    private boolean distributed;

    public RedisCacheMap(CacheMap<K, V> originMap, CacheConfiguration.CacheScope scope) {
        this.originMap = originMap;
        RedisHandler.initializeIfNecessary();
        this.distributed = CacheConfiguration.CacheScope.Global.equals((Object)scope);
        this.initDataIfNeed();
    }

    private void initDataIfNeed() {
        if (RedisHandler.isRedisEnabled() && RedisHandler.isReadOnly(this.getGroup())) {
            RedisHandler.initCacheFromRedis(this);
        }
    }

    public void initDataFromRedis() {
        RedisHandler.initCacheFromRedis(this);
    }

    @Override
    public void put(K key, V value) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.originMap.put(key, value);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.put(this.originMap.getGroup(), this.originMap.getName(), key, value);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.originMap.putAll(map);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.putAll(this.originMap.getGroup(), this.originMap.getName(), map);
        }
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.originMap.replaceAll(map);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.replaceAll(this.originMap.getGroup(), this.originMap.getName(), map);
        }
    }

    @Override
    public void notifyUpdate(K key) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        if (this.distributed && RedisHandler.canDispatch()) {
            this.put(key, this.get(key));
        }
    }

    @Override
    public void notifyUpdate(K[] keys) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        if (this.distributed && RedisHandler.canDispatch()) {
            HashMap<K, V> map = new HashMap<K, V>();
            for (K key : keys) {
                map.put(key, this.get(key));
            }
            this.putAll(map);
        }
    }

    @Override
    public void notifyUpdate(Collection<K> keys) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        if (this.distributed && RedisHandler.canDispatch()) {
            LinkedHashMap<Serializable, V> map = new LinkedHashMap<Serializable, V>();
            for (Serializable key : keys) {
                map.put(key, this.get(key));
            }
            this.putAll(map);
        }
    }

    @Override
    public void notifyUpdate(K key, Serializable updateKey, CacheNotification.Action operation, Serializable content) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        RedisHandler.publishMapChange(this.getGroup(), this.getName(), key, updateKey, operation, content);
    }

    @Override
    public V get(K key) {
        return this.originMap.get(key);
    }

    @Override
    public V remove(K key) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return this.originMap.get(key);
        }
        V v = this.originMap.remove(key);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.remove(this.originMap.getGroup(), this.originMap.getName(), key);
        }
        return v;
    }

    @Override
    public boolean removeAll(Collection<K> keys) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return true;
        }
        boolean flag = this.originMap.removeAll(keys);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.removeAll(this.originMap.getGroup(), this.originMap.getName(), keys);
        }
        return flag;
    }

    @Override
    public boolean contains(K key) {
        return this.originMap.contains(key);
    }

    @Override
    public Map<K, V> toMap() {
        return this.originMap.toMap();
    }

    @Override
    public Set<K> keySet() {
        return this.originMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.originMap.values();
    }

    @Override
    public void setDataLoader(DataLoader<K> loader) {
        this.originMap.setDataLoader(loader);
    }

    @Override
    public DataLoader<K> getDataLoader() {
        return this.originMap.getDataLoader();
    }

    @Override
    public void reload() {
        if (this.getDataLoader() != null) {
            this.originMap.reload();
            this.sendReloadNotification();
        }
    }

    @Override
    public void reload(K k) {
        if (this.getDataLoader() != null) {
            this.originMap.reload(k);
            this.sendReloadKeyNotification(k);
        }
    }

    @Override
    public void index(MapIndex<V> idx) {
        this.originMap.index(idx);
    }

    @Override
    public Collection<V> values(String indexName, Object o) {
        return this.originMap.values(indexName, o);
    }

    @Override
    public String getGroup() {
        return this.originMap.getGroup();
    }

    @Override
    public String getName() {
        return this.originMap.getName();
    }

    @Override
    public int size() {
        return this.originMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originMap.isEmpty();
    }

    @Override
    public void clear() {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.originMap.clear();
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.clear(this.originMap.getGroup(), this.originMap.getName());
        }
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.originMap.getStatistics();
    }

    @Override
    public void loadFromCacheCenter() {
        RedisHandler.initCacheFromRedis(this);
    }

    private void sendReloadNotification() {
        CacheNotification notification = new CacheNotification();
        notification.setGroup(this.getGroup());
        notification.setCacheName(this.getName());
        notification.setAction(CacheNotification.Action.Reload.ordinal());
        NotificationManager.getInstance().send(NotificationType.CacheChanged, notification);
    }

    private void sendReloadKeyNotification(K k) {
        CacheNotification notification = new CacheNotification();
        notification.setGroup(this.getGroup());
        notification.setCacheName(this.getName());
        notification.setAction(CacheNotification.Action.ReloadKey.ordinal());
        notification.setKey((Serializable)k);
        NotificationManager.getInstance().send(NotificationType.CacheChanged, notification);
    }
}

