/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.CacheStatistics;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RedisCacheSet<E extends Serializable>
implements CacheSet<E> {
    private CacheSet<E> origin;
    private boolean distributed;

    public RedisCacheSet(CacheSet<E> origin, CacheConfiguration.CacheScope scope) {
        this.origin = origin;
        RedisHandler.initializeIfNecessary();
        this.distributed = CacheConfiguration.CacheScope.Global.equals((Object)scope);
        this.initDataIfNeed();
    }

    private void initDataIfNeed() {
        if (RedisHandler.isRedisEnabled() && RedisHandler.isReadOnly(this.getGroup())) {
            RedisHandler.initCacheFromRedis(this);
        }
    }

    @Override
    public boolean contains(E o) {
        return this.origin.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.origin.iterator();
    }

    @Override
    public Set<E> toSet() {
        return this.origin.toSet();
    }

    @Override
    public boolean add(E o) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return false;
        }
        boolean flag = this.origin.add(o);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.add(this.origin.getGroup(), this.origin.getName(), o);
        }
        return flag;
    }

    @Override
    public boolean remove(E o) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return false;
        }
        boolean flag = this.origin.remove(o);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.removeSet(this.origin.getGroup(), this.origin.getName(), o);
        }
        return flag;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return false;
        }
        boolean flag = this.origin.addAll(c);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.addAll(this.origin.getGroup(), this.origin.getName(), c);
        }
        return flag;
    }

    @Override
    public void replaceAll(Collection<? extends E> set) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.origin.replaceAll(set);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.replaceAllSet(this.origin.getGroup(), this.origin.getName(), set);
        }
    }

    @Override
    public boolean removeAll(Collection<? extends E> c) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return false;
        }
        boolean flag = this.origin.removeAll(c);
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.removeAllSet(this.origin.getGroup(), this.origin.getName(), c);
        }
        return flag;
    }

    @Override
    public void notifyUpdate(E e) {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.add(e);
    }

    @Override
    public String getGroup() {
        return this.origin.getGroup();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public int size() {
        return this.origin.size();
    }

    @Override
    public boolean isEmpty() {
        return this.origin.isEmpty();
    }

    @Override
    public void clear() {
        if (RedisHandler.isReadOnly(this.getGroup())) {
            return;
        }
        this.origin.clear();
        if (this.distributed && RedisHandler.canDispatch()) {
            RedisHandler.clearSet(this.origin.getGroup(), this.origin.getName());
        }
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.origin.getStatistics();
    }

    @Override
    public void loadFromCacheCenter() {
        RedisHandler.initCacheFromRedis(this);
    }
}

