/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.cluster.notification.Notification;
import com.seeyon.ctp.cluster.notification.NotificationListener;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheMapChange;
import com.seeyon.ctp.common.cache.CacheObject;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.cache.GroupCacheable;
import com.seeyon.ctp.common.cache.cluster.CacheNotification;
import com.seeyon.ctp.common.cache.redis.RedisCacheMap;
import com.seeyon.ctp.common.cache.redis.RedisCacheObject;
import com.seeyon.ctp.common.cache.redis.RedisCacheSet;
import com.seeyon.ctp.common.cache.redis.RedisConfig;
import com.seeyon.ctp.common.cache.redis.RedisLinkedCacheMap;
import com.seeyon.ctp.common.cache.redis.RedisNotification;
import com.seeyon.ctp.common.cache.redis.RedisNotificationCodec;
import com.seeyon.ctp.common.cache.redis.RedisNotificationListener;
import com.seeyon.ctp.common.cache.redis.RedisSeeyonEventCodec;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.dubbo.SeeyonRemoteRequest;
import com.seeyon.ctp.event.DistributedEventHandler;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.util.TextEncoder;
import com.seeyon.ctp.util.UUIDGenerator;
import io.lettuce.core.Consumer;
import io.lettuce.core.RedisBusyException;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.api.async.RedisStreamAsyncCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.session.web.http.CTPDelegatingFilterProxy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class RedisHandler {
    private static Log log = CtpLogFactory.getLog(RedisHandler.class);
    private static RedisTemplate redisTemplate = null;
    private static RedisTemplate configRedisTemplate = null;
    private static RedisTemplate dubboRedisTemplate = null;
    private static RedisTemplate messageRedisTemplate = null;
    private static RedisStreamAsyncCommands<String, Event> streamPubCommands = null;
    private static RedisStreamAsyncCommands<String, Event> streamSubCommands = null;
    private static RedisPubSubAsyncCommands<String, RedisNotification> nPubCommands = null;
    private static RedisPubSubAsyncCommands<String, RedisNotification> nSubCommands = null;
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static boolean redisEnabled = "1".equals(SystemProperties.getInstance().getProperty("redis.enabled"));
    private static final Map<String, Boolean> readOnlyGoupNames = new ConcurrentHashMap<String, Boolean>();
    private static final ThreadLocal<Boolean> forceSave = new ThreadLocal();
    private static boolean canPublishCacheChange = false;
    private static final ThreadLocal<Boolean> canDispatching = new ThreadLocal();
    private static JedisConnectionFactory factory = null;
    private static final String MAP_PREFIX = "Map";
    private static final String SET_PREFIX = "Set";
    private static final String ZSET_PREFIX = "ZSet";
    private static final String SEQ_PREFIX = "Seq";
    private static final String OBJECT_PREFIX = "Object";
    private static final RedisNotificationListener notificationListener = new RedisNotificationListener();
    private static final String MSG_KEY = "d";
    private static final int MSG_MAX_LEN = 10000;
    public static final String APP_ID = SystemProperties.getInstance().getProperty("ctp.moduleName", "4095");
    private static final String ENDPOINT_ID = UUIDGenerator.getUUID();
    private static final String STREAM_KEY = Event.class.getCanonicalName();
    private static ExecutorService executorService = null;
    private static ExecutorService subscribeService = null;
    private static Set<String> needPassReqEvents = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initialize() {
        if (initialized.get()) {
            return;
        }
        redisEnabled = "1".equals(SystemProperties.getInstance().getProperty("redis.enabled"));
        if (redisEnabled) {
            String hostName = SystemProperties.getInstance().getProperty("redis.host", "127.0.0.1");
            int port = SystemProperties.getInstance().getIntegerProperty("redis.port", 6379);
            String password = SystemProperties.getInstance().getProperty("redis.password", "");
            password = TextEncoder.decode(password);
            System.setProperty("dubbo.redis.password", password);
            System.setProperty("dubbo.redis.url", "redis://" + hostName + ":" + port + "?db.index=1");
            String zipkinEnbaled = SystemProperties.getInstance().getProperty("ctp.zipkin.enabled", "0");
            if ("1".equals(zipkinEnbaled)) {
                System.setProperty("dubbo.provider.filter", "provider,tracing");
            } else {
                System.setProperty("dubbo.provider.filter", "provider");
            }
            try {
                factory = new JedisConnectionFactory();
                factory.setHostName(hostName);
                factory.setPort(port);
                factory.setPassword(password);
                factory.setUsePool(true);
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setMinIdle(5);
                poolConfig.setMaxTotal(20);
                factory.setPoolConfig(poolConfig);
                factory.afterPropertiesSet();
                RedisConnection conn = null;
                try {
                    conn = factory.getConnection();
                    if (conn == null || conn.isClosed()) {
                        throw new Exception("Redis\u8fde\u63a5\u5931\u8d25");
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)("\u521d\u59cb\u5316Redis\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684redis\u914d\u7f6e\u662f\u5426\u6b63\u786e [" + t.getLocalizedMessage() + "]"));
                redisEnabled = false;
                return;
            }
            redisTemplate = new RedisTemplate();
            redisTemplate.setConnectionFactory((RedisConnectionFactory)factory);
            redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            redisTemplate.afterPropertiesSet();
            JedisConnectionFactory configFactory = new JedisConnectionFactory();
            configFactory.setHostName(hostName);
            configFactory.setPort(port);
            configFactory.setPassword(password);
            configFactory.setUsePool(true);
            configFactory.setDatabase(3);
            JedisPoolConfig pConfig = new JedisPoolConfig();
            pConfig.setMinIdle(1);
            pConfig.setMaxTotal(5);
            configFactory.setPoolConfig(pConfig);
            configFactory.afterPropertiesSet();
            configRedisTemplate = new RedisTemplate();
            configRedisTemplate.setConnectionFactory((RedisConnectionFactory)configFactory);
            configRedisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            configRedisTemplate.afterPropertiesSet();
            JedisConnectionFactory dubboFactory = new JedisConnectionFactory();
            dubboFactory.setHostName(hostName);
            dubboFactory.setPort(port);
            dubboFactory.setPassword(password);
            dubboFactory.setUsePool(true);
            dubboFactory.setDatabase(1);
            JedisPoolConfig dConfig = new JedisPoolConfig();
            dConfig.setMinIdle(1);
            dConfig.setMaxTotal(3);
            dubboFactory.setPoolConfig(dConfig);
            dubboFactory.afterPropertiesSet();
            dubboRedisTemplate = new RedisTemplate();
            dubboRedisTemplate.setConnectionFactory((RedisConnectionFactory)dubboFactory);
            StringRedisSerializer serializer = new StringRedisSerializer();
            dubboRedisTemplate.setKeySerializer((RedisSerializer)serializer);
            dubboRedisTemplate.setHashKeySerializer((RedisSerializer)serializer);
            dubboRedisTemplate.setHashValueSerializer((RedisSerializer)serializer);
            dubboRedisTemplate.afterPropertiesSet();
            JedisConnectionFactory messageFactory = new JedisConnectionFactory();
            messageFactory.setHostName(hostName);
            messageFactory.setPort(port);
            messageFactory.setPassword(password);
            messageFactory.setUsePool(true);
            messageFactory.setDatabase(5);
            JedisPoolConfig mConfig = new JedisPoolConfig();
            mConfig.setMinIdle(1);
            mConfig.setMaxTotal(3);
            messageFactory.setPoolConfig(mConfig);
            messageFactory.afterPropertiesSet();
            messageRedisTemplate = new RedisTemplate();
            messageRedisTemplate.setConnectionFactory((RedisConnectionFactory)messageFactory);
            StringRedisSerializer mSerializer = new StringRedisSerializer();
            messageRedisTemplate.setKeySerializer((RedisSerializer)mSerializer);
            messageRedisTemplate.setValueSerializer((RedisSerializer)mSerializer);
            messageRedisTemplate.afterPropertiesSet();
            RedisHandler.initReadOnlyGroupNames();
            RedisHandler.initStreamChannel(hostName, port, password);
            RedisHandler.initAsynThreadForStream();
            RedisHandler.subAllNotifications();
        } else {
            log.warn((Object)" ------------ \u5f53\u524d\u542f\u52a8\u6a21\u5f0f\uff1a\u666e\u901a\u6a21\u5f0f\uff08\u975e\u5fae\u670d\u52a1\u6a21\u5f0f\uff09------------");
        }
        initialized.set(true);
    }

    public static synchronized void addNeedPassReqEvent(String eventName) {
        RedisHandler.initializeIfNecessary();
        needPassReqEvents.add(eventName);
    }

    public static synchronized void addNeedPassReqEvent(Set<String> eventNames) {
        RedisHandler.initializeIfNecessary();
        needPassReqEvents.addAll(eventNames);
    }

    public static Set<String> getNeedPassReqEvents() {
        return needPassReqEvents;
    }

    private static void initAsynThreadForStream() {
        subscribeService = Executors.newSingleThreadExecutor();
        executorService = Executors.newFixedThreadPool(10);
    }

    private static void initStreamChannel(String hostName, int port, String password) {
        RedisURI redisURI = RedisURI.create((String)hostName, (int)port);
        redisURI.setPassword(password);
        redisURI.setDatabase(2);
        RedisClient client = RedisClient.create((RedisURI)redisURI);
        RedisSeeyonEventCodec codec = new RedisSeeyonEventCodec();
        streamPubCommands = client.connect((RedisCodec)codec).async();
        streamSubCommands = client.connect((RedisCodec)codec).async();
        RedisNotificationCodec nCodec = new RedisNotificationCodec();
        StatefulRedisPubSubConnection pubConnection = client.connectPubSub((RedisCodec)nCodec);
        StatefulRedisPubSubConnection subConnection = client.connectPubSub((RedisCodec)nCodec);
        final DistributedEventHandler handler = new DistributedEventHandler();
        subConnection.addListener((RedisPubSubListener)new RedisPubSubAdapter<String, RedisNotification>(){

            public void message(String channel, RedisNotification message) {
                if (message == null) {
                    return;
                }
                if (ENDPOINT_ID.equals(message.getSource())) {
                    return;
                }
                RedisHandler.asynProcessEvent(handler, message);
            }
        });
        nPubCommands = pubConnection.async();
        nSubCommands = subConnection.async();
        try {
            RedisFuture groupCreateFuture = streamPubCommands.xgroupCreate(XReadArgs.StreamOffset.latest((Object)STREAM_KEY), (Object)APP_ID);
            log.info((Object)("create Stream [" + STREAM_KEY + "].group[" + APP_ID + "] Success " + (String)groupCreateFuture.get()));
        }
        catch (Exception e) {
            if (e.getCause() instanceof RedisBusyException) {
                log.warn((Object)("Stream [" + STREAM_KEY + "].group[" + APP_ID + "] has exists! " + e.getLocalizedMessage()));
            }
            try {
                RedisFuture createChannelFuture = streamPubCommands.xadd((Object)STREAM_KEY, new Object[]{"init", Event.EmptyEvent});
                streamPubCommands.xdel((Object)STREAM_KEY, new String[]{(String)createChannelFuture.get()});
                RedisFuture groupCreateFuture = streamPubCommands.xgroupCreate(XReadArgs.StreamOffset.latest((Object)STREAM_KEY), (Object)APP_ID);
                log.info((Object)("recreate Stream [" + STREAM_KEY + "].group[" + APP_ID + "] Success " + (String)groupCreateFuture.get()));
            }
            catch (Exception e1) {
                log.error((Object)("recreate Stream [" + STREAM_KEY + "].group[" + APP_ID + " Fail ] " + e1.getLocalizedMessage()));
                System.exit(-1);
            }
        }
    }

    public static RedisTemplate getConfigRedisTemplate() {
        RedisHandler.initializeIfNecessary();
        return configRedisTemplate;
    }

    public static RedisTemplate getDubboRedisTemplate() {
        RedisHandler.initializeIfNecessary();
        return dubboRedisTemplate;
    }

    public static RedisTemplate getMessageRedisTemplate() {
        RedisHandler.initializeIfNecessary();
        return messageRedisTemplate;
    }

    public static boolean isReadOnly(Class clazz) {
        return RedisHandler.isReadOnly(clazz.getCanonicalName());
    }

    public static boolean isReadOnly(String groupName) {
        RedisHandler.initializeIfNecessary();
        return readOnlyGoupNames.containsKey(groupName) && forceSave.get() == null;
    }

    public static boolean isRedisEnabled() {
        RedisHandler.initializeIfNecessary();
        return redisEnabled;
    }

    public static <V extends Serializable, K extends Serializable> V get(String group, String name, K key) {
        return (V)((Serializable)redisTemplate.opsForHash().get((Object)("Map:" + group + ":" + name), key));
    }

    public static <V extends Serializable, K extends Serializable> Map<K, V> getAll(String group, String name, Collection<K> keys) {
        LinkedHashMap<Serializable, V> map = new LinkedHashMap<Serializable, V>();
        for (Serializable key : keys) {
            map.put(key, RedisHandler.get(group, name, key));
        }
        return map;
    }

    public static <K extends Serializable> boolean contains(String group, String name, K key) {
        return redisTemplate.opsForHash().hasKey((Object)("Map:" + group + ":" + name), key);
    }

    public static Map toMap(String group, String name) {
        return redisTemplate.opsForHash().entries((Object)("Map:" + group + ":" + name));
    }

    public static <K extends Serializable> Set keySet(String group, String name) {
        return redisTemplate.opsForHash().keys((Object)("Map:" + group + ":" + name));
    }

    public static <V extends Serializable> Collection values(String group, String name) {
        return redisTemplate.opsForHash().values((Object)("Map:" + group + ":" + name));
    }

    public static int sizeOfMap(String group, String name) {
        return redisTemplate.opsForHash().size((Object)("Map:" + group + ":" + name)).intValue();
    }

    public static boolean isEmptyMap(String group, String name) {
        return redisTemplate.opsForHash().size((Object)("Map:" + group + ":" + name)) == 0L;
    }

    public static <K extends Serializable, V extends Serializable> void put(String group, String name, K key, V value) {
        redisTemplate.opsForHash().put((Object)("Map:" + group + ":" + name), key, value);
        RedisHandler.publishCacheChange(group, name, key, null, CacheNotification.Action.Put);
    }

    public static <K extends Serializable> void zadd(String group, String name, K key) {
        double sequence = redisTemplate.opsForValue().increment((Object)("Seq:" + group + ":" + name), 1.0);
        redisTemplate.opsForZSet().add((Object)("ZSet:" + group + ":" + name), key, sequence);
    }

    public static <K extends Serializable> void zrem(String group, String name, K key) {
        redisTemplate.opsForZSet().remove((Object)("ZSet:" + group + ":" + name), new Object[]{key});
    }

    public static <K extends Serializable> void zrem(String group, String name, Object[] key) {
        redisTemplate.opsForZSet().remove((Object)("ZSet:" + group + ":" + name), key);
    }

    public static <K extends Serializable> void zrem(String group, String name) {
        redisTemplate.opsForZSet().removeRange((Object)("ZSet:" + group + ":" + name), 0L, -1L);
    }

    public static Set zkeys(String group, String name) {
        return redisTemplate.opsForZSet().range((Object)("ZSet:" + group + ":" + name), 0L, -1L);
    }

    public static <K extends Serializable, V extends Serializable> void putAll(String group, String name, Map<? extends K, ? extends V> map) {
        redisTemplate.opsForHash().putAll((Object)("Map:" + group + ":" + name), map);
        RedisHandler.publishCacheChange(group, name, null, new HashSet<K>(map.keySet()), CacheNotification.Action.PutAll);
    }

    public static <K extends Serializable, V extends Serializable> void replaceAll(String group, String name, Map<? extends K, ? extends V> map) {
        redisTemplate.opsForHash().putAll((Object)("Map:" + group + ":" + name), map);
        RedisHandler.publishCacheChange(group, name, null, new HashSet<K>(map.keySet()), CacheNotification.Action.ReplaceAll);
    }

    public static <V extends Serializable, K extends Serializable> void remove(String group, String name, K key) {
        redisTemplate.opsForHash().delete((Object)("Map:" + group + ":" + name), new Object[]{key});
        RedisHandler.publishCacheChange(group, name, key, null, CacheNotification.Action.Remove);
    }

    public static void clear(String group, String name) {
        redisTemplate.delete((Object)("Map:" + group + ":" + name));
        RedisHandler.publishCacheChange(group, name, null, null, CacheNotification.Action.Clear);
    }

    public static <K extends Serializable> void removeAll(String group, String name, Collection<K> keys) {
        for (Serializable key : keys) {
            redisTemplate.opsForHash().delete((Object)("Map:" + group + ":" + name), new Object[]{key});
        }
        RedisHandler.publishCacheChange(group, name, null, new HashSet<K>(keys), CacheNotification.Action.RemoveAll);
    }

    public static <E extends Serializable> void setObject(String group, String name, E o) {
        redisTemplate.opsForValue().set((Object)("Object:" + group + ":" + name), o);
        RedisHandler.publishCacheChange(group, name, o, null, CacheNotification.Action.Set);
    }

    public static void clearObject(String group, String name) {
        redisTemplate.delete((Object)("Object:" + group + ":" + name));
        RedisHandler.publishCacheChange(group, name, null, null, CacheNotification.Action.Clear);
    }

    public static <E extends Serializable> void add(String group, String name, E o) {
        redisTemplate.opsForSet().add((Object)("Set:" + group + ":" + name), new Object[]{o});
        RedisHandler.publishCacheChange(group, name, o, null, CacheNotification.Action.Add);
    }

    public static <E extends Serializable> void removeSet(String group, String name, E o) {
        redisTemplate.opsForSet().remove((Object)("Set:" + group + ":" + name), new Object[]{o});
        RedisHandler.publishCacheChange(group, name, o, null, CacheNotification.Action.Remove);
    }

    public static <E extends Serializable> void addAll(String group, String name, Collection<? extends E> c) {
        for (Serializable e : c) {
            redisTemplate.opsForSet().add((Object)("Set:" + group + ":" + name), new Object[]{e});
        }
        RedisHandler.publishCacheChange(group, name, null, c, CacheNotification.Action.AddAll);
    }

    public static <E extends Serializable> void replaceAllSet(String group, String name, Collection<? extends E> c) {
        RedisHandler.addAll(group, name, c);
    }

    public static <E extends Serializable> void removeAllSet(String group, String name, Collection<? extends E> c) {
        for (Serializable e : c) {
            redisTemplate.opsForSet().remove((Object)("Set:" + group + ":" + name), new Object[]{e});
        }
        RedisHandler.publishCacheChange(group, name, null, c, CacheNotification.Action.RemoveAll);
    }

    public static void clearSet(String group, String name) {
        redisTemplate.delete((Object)("Set:" + group + ":" + name));
        RedisHandler.publishCacheChange(group, name, null, null, CacheNotification.Action.Clear);
    }

    public static void initCacheFromRedis(GroupCacheable cache) {
        try {
            forceSave.set(true);
            RedisHandler.stopDispatch();
            if (cache instanceof CacheMap) {
                RedisHandler.loadCacheMapFromRedis((CacheMap)cache);
                return;
            }
            if (cache instanceof CacheSet) {
                RedisHandler.loadCacheSetFromRedis((CacheSet)cache);
                return;
            }
            if (cache instanceof CacheObject) {
                RedisHandler.loadCacheObjectFromRedis((CacheObject)cache);
                return;
            }
        }
        finally {
            forceSave.remove();
            RedisHandler.continueDispatch();
        }
    }

    public static <K> Serializable getMapItemValueFromRedis(CacheMap cacheMap, K key) {
        String cacheKey = "Map:" + cacheMap.getGroup() + ":" + cacheMap.getName();
        return (Serializable)redisTemplate.opsForHash().get((Object)cacheKey, key);
    }

    private static void loadCacheMapFromRedis(CacheMap cacheMap) {
        if (cacheMap instanceof RedisLinkedCacheMap) {
            String cacheKey = "Map:" + cacheMap.getGroup() + ":" + cacheMap.getName();
            Set keys = RedisHandler.zkeys(cacheMap.getGroup(), cacheMap.getName());
            Map dataMap = redisTemplate.opsForHash().entries((Object)cacheKey);
            for (Object k : keys) {
                cacheMap.put((Serializable)k, (Serializable)dataMap.get(k));
            }
        } else if (cacheMap instanceof RedisCacheMap) {
            String key = "Map:" + cacheMap.getGroup() + ":" + cacheMap.getName();
            Map dataMap = redisTemplate.opsForHash().entries((Object)key);
            cacheMap.putAll(dataMap);
        }
    }

    private static void loadCacheSetFromRedis(CacheSet cacheSet) {
        if (cacheSet instanceof RedisCacheSet) {
            String key = "Set:" + cacheSet.getGroup() + ":" + cacheSet.getName();
            Set dataSet = redisTemplate.opsForSet().members((Object)key);
            cacheSet.addAll(dataSet);
        }
    }

    private static void loadCacheObjectFromRedis(CacheObject cacheObject) {
        if (cacheObject instanceof RedisCacheObject) {
            cacheObject.set((Serializable)redisTemplate.opsForValue().get((Object)("Object:" + cacheObject.getGroup() + ":" + cacheObject.getName())));
        }
    }

    public static void initDataFromCache(CacheMap cacheMap) {
        for (Object key : cacheMap.keySet()) {
            cacheMap.put((Serializable)key, cacheMap.get((Serializable)key));
        }
    }

    private static void initReadOnlyGroupNames() {
        File readOnlyConfigFile = new File(SystemEnvironment.getBaseFolder() + File.separator + "conf", "cache_readonly");
        if (readOnlyConfigFile.exists()) {
            List<String> groupNameList = RedisHandler.loadGroupNamesFromFile(readOnlyConfigFile);
            for (String groupName : groupNameList) {
                readOnlyGoupNames.put(groupName, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadGroupNamesFromFile(File file) {
        ArrayList<String> groupNames = new ArrayList<String>();
        FileInputStream in = null;
        BufferedReader reader = null;
        try {
            in = new FileInputStream(file);
            if (in != null) {
                String line = null;
                reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    groupNames.add(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        return groupNames;
    }

    private static void publishCacheChange(String group, String name, Serializable key, Collection keys, CacheNotification.Action action) {
        if (!canPublishCacheChange) {
            return;
        }
        CacheNotification notification = new CacheNotification();
        notification.setGroup(group);
        notification.setCacheName(name);
        notification.setKey(key);
        notification.setValue((Serializable)((Object)keys));
        notification.setAction(action.ordinal());
        Notification n = new Notification();
        n.setType(NotificationType.CacheChanged);
        n.setContent(notification);
        RedisHandler.pubNotification(n);
    }

    public static void publishMapChange(String group, String name, Serializable key, Serializable updateKey, CacheNotification.Action action, Serializable content) {
        if (!canPublishCacheChange) {
            return;
        }
        CacheNotification notification = new CacheNotification();
        notification.setGroup(group);
        notification.setCacheName(name);
        notification.setKey(key);
        CacheMapChange cacheMapChange = new CacheMapChange(name, key, updateKey, action, content);
        notification.setValue(cacheMapChange);
        notification.setAction(action.ordinal());
        notification.setMapUpdate(true);
        Notification n = new Notification();
        n.setType(NotificationType.CacheChanged);
        n.setContent(notification);
        RedisHandler.pubNotification(n);
    }

    public static void pubSeeyonEvent(Event event) {
        try {
            Enumeration pNames;
            HttpServletRequest request;
            HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
            if (session != null) {
                event.setSessionId(session.getId());
            }
            if (RedisHandler.needPassRequestAttributes(event) && (request = AppContext.getRawRequest()) != null && (pNames = request.getAttributeNames()) != null && pNames.hasMoreElements()) {
                ConcurrentHashMap<String, Object> requestAttributesMap = new ConcurrentHashMap<String, Object>();
                while (pNames.hasMoreElements()) {
                    String paramName = (String)pNames.nextElement();
                    if (paramName.startsWith("org.") || paramName.startsWith("com.")) continue;
                    requestAttributesMap.put(paramName, request.getAttribute(paramName));
                }
                if (requestAttributesMap.size() > 0) {
                    event.setRequestAttributesMap(requestAttributesMap);
                }
            }
            streamPubCommands.xadd((Object)STREAM_KEY, XAddArgs.Builder.maxlen((long)10000L), new Object[]{MSG_KEY, event});
        }
        catch (Throwable e) {
            log.error((Object)"\u53d1\u9001\u5206\u5e03\u5f0f\u4e8b\u4ef6\u51fa\u9519", e);
        }
    }

    private static boolean needPassRequestAttributes(Event event) {
        return needPassReqEvents.contains(event.getClass().getSimpleName());
    }

    public static void pubEvent(String channelName, Serializable eventObj) {
        redisTemplate.convertAndSend(channelName, (Object)eventObj);
    }

    public static void pubNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        nPubCommands.publish((Object)notification.getType().name(), (Object)new RedisNotification(notification, ENDPOINT_ID));
    }

    private static void subAllNotifications() {
        if (!redisEnabled) {
            return;
        }
        try {
            NotificationType[] nTypes = (NotificationType[])NotificationType.class.getEnumConstants();
            Object[] channels = new String[nTypes.length];
            for (int i = 0; i < nTypes.length; ++i) {
                channels[i] = nTypes[i].name();
            }
            log.info((Object)" \u4eceRedis\u8ba2\u9605Notification\u6d88\u606f...");
            nSubCommands.subscribe(channels);
        }
        catch (Throwable t) {
            log.error((Object)" \u4eceRedis\u8ba2\u9605Notification\u6d88\u606f\u5931\u8d25", t);
        }
    }

    public static void subSeeyonEvent(final DistributedEventHandler handler) {
        if (!redisEnabled) {
            return;
        }
        try {
            subscribeService.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)" \u4eceRedis\u8ba2\u9605Event\u6d88\u606f ...");
                    while (initialized.get()) {
                        RedisFuture future = streamSubCommands.xreadgroup(Consumer.from((Object)APP_ID, (Object)ENDPOINT_ID), XReadArgs.Builder.block((long)0L).count(1L).noack(true), new XReadArgs.StreamOffset[]{XReadArgs.StreamOffset.lastConsumed((Object)STREAM_KEY)});
                        try {
                            for (StreamMessage sMsg : (List)future.get()) {
                                Event event = (Event)sMsg.getBody().get(RedisHandler.MSG_KEY);
                                if (event == null || APP_ID.equals(event.getAppId())) continue;
                                RedisHandler.asynProcessEvent(handler, event);
                            }
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"receive event error ", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            log.error((Object)"receive event error ", (Throwable)e);
                        }
                        catch (Throwable t) {
                            log.error((Object)("receive event error " + t.getLocalizedMessage()));
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            log.error((Object)" \u4eceRedis\u8ba2\u9605Event\u6d88\u606f\u5931\u8d25", t);
        }
    }

    private static void asynProcessEvent(final DistributedEventHandler handler, final Event event) {
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                User currentUser = null;
                try {
                    Map<String, Object> attributesMap;
                    String sessionId;
                    currentUser = event.getCurrentUser();
                    if (currentUser != null) {
                        AppContext.putThreadContext("SESSION_CONTEXT_USERINFO_KEY", event.getCurrentUser());
                    }
                    if ((sessionId = event.getSessionId()) != null) {
                        AppContext.putThreadContext("THREAD_CONTEXT_SESSION_KEY", CTPDelegatingFilterProxy.getSession(sessionId));
                    }
                    if ((attributesMap = event.getRequestAttributesMap()) != null) {
                        AppContext.putThreadContext("THREAD_CONTEXT_REQUEST_KEY", new SeeyonRemoteRequest(attributesMap));
                    }
                    CtpDynamicDataSource.clearAll();
                    handler.fireEvent(event);
                }
                catch (Throwable t) {
                    log.error((Object)" error ", t);
                }
                finally {
                    HttpSession httpSession;
                    if (currentUser != null) {
                        AppContext.removeThreadContext("SESSION_CONTEXT_USERINFO_KEY");
                    }
                    if ((httpSession = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY")) != null) {
                        CTPDelegatingFilterProxy.saveSession(httpSession);
                        AppContext.removeThreadContext("THREAD_CONTEXT_SESSION_KEY");
                    }
                    AppContext.removeThreadContext("THREAD_CONTEXT_REQUEST_KEY");
                }
            }
        });
    }

    private static void asynProcessEvent(final DistributedEventHandler handler, final RedisNotification redisNotification) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleRedisNotification(redisNotification);
                }
                catch (Throwable t) {
                    log.error((Object)"error ", t);
                }
            }
        });
    }

    public static void subEvent(MessageListener listener, String channel, boolean isPattern) {
        if (StringUtils.isEmpty((Object)channel)) {
            return;
        }
        HashSet<String> channelSet = new HashSet<String>();
        channelSet.add(channel);
        RedisHandler.subEvent(listener, channelSet, isPattern);
    }

    public static void subEvent(final MessageListener listener, Set<String> channels, final boolean isPattern) {
        if (CollectionUtils.isEmpty(channels)) {
            return;
        }
        final byte[][] channelBytes = new byte[channels.size()][];
        int inex = 0;
        for (String channel : channels) {
            channelBytes[inex++] = channel.getBytes();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (isPattern) {
                    redisTemplate.getConnectionFactory().getConnection().pSubscribe(listener, channelBytes);
                } else {
                    redisTemplate.getConnectionFactory().getConnection().subscribe(listener, channelBytes);
                }
            }
        }).start();
    }

    public static RedisSerializer getValueSerializer() {
        return redisTemplate.getValueSerializer();
    }

    public static SessionRepository buildSessionRepository() {
        RedisOperationsSessionRepository repository = null;
        if (factory != null) {
            repository = new RedisOperationsSessionRepository((RedisConnectionFactory)factory);
        }
        return repository;
    }

    public static void stopDispatch() {
        canDispatching.set(false);
    }

    public static void continueDispatch() {
        canDispatching.remove();
    }

    public static void stopCacheReadOnly() {
        forceSave.set(true);
    }

    public static void recoverCacheReadonly() {
        forceSave.remove();
    }

    public static boolean canDispatch() {
        return canDispatching.get() == null;
    }

    public static void activePublishCacheChange() {
        canPublishCacheChange = true;
    }

    public static void register(NotificationType type, NotificationListener listener) {
        if (listener == null) {
            return;
        }
        notificationListener.register(type, listener);
    }

    public static void handleNotify(Notification n) {
        notificationListener.handleNotify(n.getType(), n);
    }

    public static RedisConfig getRedisConfigForCAP() {
        RedisHandler.initializeIfNecessary();
        RedisConfig redisConfig = null;
        if (redisEnabled) {
            String hostName = SystemProperties.getInstance().getProperty("redis.host", "127.0.0.1");
            int port = SystemProperties.getInstance().getIntegerProperty("redis.port", 6379);
            String password = SystemProperties.getInstance().getProperty("redis.password", "");
            redisConfig = new RedisConfig();
            redisConfig.setIpAddress(hostName);
            redisConfig.setPassword(password);
            redisConfig.setPort(port);
            redisConfig.setDbIndex(4);
        }
        return redisConfig;
    }

    public static void initializeIfNecessary() {
        if (!initialized.get()) {
            RedisHandler.initialize();
        }
    }
}

