/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.cache.redis;

import com.seeyon.ctp.common.cache.CacheConfiguration;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.redis.RedisCacheMap;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RedisLinkedCacheMap<K extends Serializable, V extends Serializable>
extends RedisCacheMap<K, V>
implements CacheMap<K, V> {
    public RedisLinkedCacheMap(CacheMap<K, V> originMap, CacheConfiguration.CacheScope scope) {
        super(originMap, scope);
    }

    @Override
    public void put(K key, V value) {
        if (RedisHandler.canDispatch() && !this.contains(key)) {
            RedisHandler.zadd(this.getGroup(), this.getName(), key);
        }
        super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (RedisHandler.canDispatch()) {
            Set<K> keys = map.keySet();
            LinkedHashSet<K> newItemKeySet = new LinkedHashSet<K>();
            for (Object key : keys) {
                if (this.contains((Serializable)key)) continue;
                newItemKeySet.add(key);
            }
            for (Object key : newItemKeySet) {
                RedisHandler.zadd(this.getGroup(), this.getName(), (Serializable)key);
            }
        }
        super.putAll(map);
    }

    @Override
    public V remove(K key) {
        RedisHandler.zrem(this.getGroup(), this.getName(), key);
        return super.remove(key);
    }

    @Override
    public boolean removeAll(Collection<K> keys) {
        RedisHandler.zrem(this.getGroup(), this.getName(), keys.toArray());
        return super.removeAll(keys);
    }

    @Override
    public void clear() {
        RedisHandler.zrem(this.getGroup(), this.getName());
        super.clear();
    }
}

