/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.constants;

import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import org.apache.commons.logging.Log;

public enum ProductEditionEnum {
    a6(0, "A6V5-1", "edition.a6.product", ""),
    enterprise(1, "A8V5-1", "edition.enterprise.product", ""),
    entgroup(2, "A8V5-2", "edition.entgroup.product", ""),
    government(3, "G6V5-1", "edition.government.product", ".gov"),
    governmentgroup(4, "G6V5-2", "edition.governmentgroup.product", ".gov"),
    ufidanc(5, "NCV5-1", "edition.ufidanc.product", ""),
    ufidau8(6, "U8V5-1", "edition.ufidau8.product", ""),
    a6s(7, "A6V5-2", "edition.a6s.product", ""),
    a6u8(8, "U8+A6V5-1", "edition.ufidanc.A6.product", ""),
    a8u8(9, "U8+A8V5-1", "edition.ufidanc.A8.product", ""),
    a8nc(10, "NCA8V5-2", "edition.ufidanc.A8.product", ""),
    cwork(11, "CWORK-1", "edition.a6.product", ""),
    a6p(12, "A6PV5-1", "edition.a6p.product", "");

    private int key;
    private String value;
    private String name;
    private String i18nSuffix;
    private static Log log;
    private static ProductEditionEnum currentProductEdition;
    private static Boolean isU8OEM;
    private static Boolean isNCOEM;
    private static final Class<?> c1;

    private ProductEditionEnum(int key, String value, String name, String i18nSuffix) {
        this.key = key;
        this.value = value;
        this.name = name;
        this.i18nSuffix = i18nSuffix;
    }

    public int getKey() {
        return this.key;
    }

    public int key() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public String getName() {
        if (ProductEditionEnum.isU8OEM()) {
            if (this.equals((Object)a6)) {
                return a6u8.getName();
            }
            if (this.equals((Object)enterprise)) {
                return a8u8.getName();
            }
        }
        return this.name;
    }

    public String getI18nSuffix() {
        return this.i18nSuffix;
    }

    public static ProductEditionEnum valueOf(int key) {
        ProductEditionEnum[] enums = ProductEditionEnum.values();
        if (enums != null) {
            for (ProductEditionEnum enum1 : enums) {
                if (enum1.key() != key) continue;
                return enum1;
            }
        }
        return null;
    }

    public static ProductEditionEnum valueOfKey(String value) {
        ProductEditionEnum[] enums = ProductEditionEnum.values();
        if (enums != null) {
            for (ProductEditionEnum enum1 : enums) {
                if (!enum1.value().equals(value)) continue;
                return enum1;
            }
        }
        return null;
    }

    public static void initCurrentProductEdition(ProductEditionEnum edition) {
        currentProductEdition = edition;
    }

    public static ProductEditionEnum getCurrentProductEditionEnum() {
        if (currentProductEdition == null) {
            throw new InfrastructureException("\u5f53\u524d\u4ea7\u54c1\u7248\u672c\u672a\u6210\u529f\u521d\u59cb\u5316\uff01");
        }
        return currentProductEdition;
    }

    public static boolean isU8OEM() {
        if (isU8OEM == null) {
            try {
                isU8OEM = (Boolean)MclclzUtil.invoke(c1, (String)"isU8OEM", null, null, null);
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (isU8OEM == null) {
                isU8OEM = false;
            }
        }
        return isU8OEM;
    }

    public static boolean isNCOEM() {
        if (isNCOEM == null) {
            try {
                isNCOEM = (Boolean)MclclzUtil.invoke(c1, (String)"isNCOEM", null, null, null);
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (isNCOEM == null) {
                isNCOEM = false;
            }
        }
        return isNCOEM;
    }

    public static boolean isCworkInner() {
        try {
            Boolean o = (Boolean)MclclzUtil.invoke(c1, (String)"isCworkInner", null, null, null);
            if (o == null) {
                return false;
            }
            return o;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isCworkOuter() {
        try {
            Boolean o = (Boolean)MclclzUtil.invoke(c1, (String)"isCworkOuter", null, null, null);
            if (o == null) {
                return false;
            }
            return o;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    static {
        log = CtpLogFactory.getLog(ProductEditionEnum.class);
        currentProductEdition = null;
        isU8OEM = null;
        isNCOEM = null;
        c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.product.ProductInfo");
    }
}

