/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao.paginate;

import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.web.util.WebUtil;
import javax.servlet.http.HttpServletRequest;

public class Pagination {
    private static ThreadLocal<Boolean> _isPagination = new ThreadLocal();
    private static ThreadLocal<Integer> _maxResults = new ThreadLocal();
    private static ThreadLocal<Integer> _firstResult = new ThreadLocal();
    private static ThreadLocal<Integer> _rowCount = new ThreadLocal();
    private static ThreadLocal<Boolean> _needCount = new ThreadLocal();
    private static int PAGE_SIZE = PerformanceConfig.getInstance().getIntegerConfig("paginate.page.size", 20);

    public static void withPagination(Class clazz) {
        _isPagination.set(Boolean.TRUE);
    }

    public static void withoutPagination(Class clazz) {
        _isPagination.set(Boolean.FALSE);
    }

    public static boolean isPagination() {
        Boolean value = _isPagination.get();
        if (value != null) {
            return value;
        }
        return true;
    }

    public static void setRowCount(int rowCount) {
        _rowCount.set(rowCount);
    }

    public static int getRowCount() {
        return Pagination.getRowCount(true);
    }

    public static int getRowCount(boolean isRemove) {
        Integer rowCount = _rowCount.get();
        if (isRemove) {
            _rowCount.remove();
        }
        if (rowCount == null) {
            rowCount = 0;
        }
        return rowCount;
    }

    public static Boolean isNeedCount() {
        if (_needCount.get() != null) {
            boolean b = _needCount.get();
            _needCount.remove();
            return b;
        }
        return Boolean.TRUE;
    }

    public static int getFirstResult() {
        if (_firstResult.get() != null) {
            int i = _firstResult.get();
            _firstResult.remove();
            return i;
        }
        HttpServletRequest request = WebUtil.getRequest();
        int page = 0;
        try {
            page = Integer.parseInt(request.getParameter("page"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (page < 2) {
            return 0;
        }
        int pageSize = Pagination.getMaxResults();
        int firstResult = (page - 1) * pageSize;
        return firstResult;
    }

    public static int getMaxResults() {
        if (_maxResults.get() != null) {
            int i = _maxResults.get();
            _maxResults.remove();
            return i;
        }
        HttpServletRequest request = WebUtil.getRequest();
        int pageSize = 0;
        try {
            pageSize = Integer.parseInt(request.getParameter("pageSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pageSize > 0) {
            return pageSize;
        }
        return PerformanceConfig.getInstance().getIntegerConfig("paginate.page.size", 20);
    }

    public static void setFirstResult(Integer firstResult) {
        _firstResult.set(firstResult);
    }

    public static void setMaxResults(Integer maxResults) {
        _maxResults.set(maxResults);
    }

    public static void setNeedCount(boolean needCount) {
        _needCount.set(needCount);
    }

    public static String getOrderByColumn() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return "";
        }
        return request.getParameter("orderByColumn");
    }

    public static String getOrderByDESC() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return "";
        }
        String orderByDESC = request.getParameter("orderByDESC");
        return orderByDESC == null ? "ASC" : orderByDESC;
    }

    public static void removeAll() {
        _isPagination.remove();
        _maxResults.remove();
        _firstResult.remove();
        _rowCount.remove();
        _needCount.remove();
    }
}

