/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao.support.page;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.dao.support.page.Page;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;

public class HqlPage {
    public static Page getPageInstance(Query query, int pageNo, int pageSize) {
        return HqlPage.getPageInstance(query, pageNo, pageSize, BaseHibernateDao.SCROLL_MODE);
    }

    public static Page getPageInstance(Query query, int pageNo, int pageSize, int mode) {
        if (mode == BaseHibernateDao.SCROLL_MODE) {
            return HqlPage.getPageInstanceByScroll(query, pageNo, pageSize);
        }
        if (mode == BaseHibernateDao.LIST_MODE) {
            return HqlPage.getPageInstanceByList(query, pageNo, pageSize);
        }
        if (mode == BaseHibernateDao.COUNT_MODE) {
            throw new IllegalArgumentException("Error Mode,you should use getPageInstance(Query query, int pageNo, int pageSize, int mode,int totalCount)");
        }
        return null;
    }

    public static Page getPageInstanceByCount(Query query, int pageNo, int pageSize, int totalCount) {
        return HqlPage.getPageResult(query, totalCount, pageNo, pageSize);
    }

    protected static Page getPageInstanceByScroll(Query query, int pageNo, int pageSize) {
        ScrollableResults scrollableResults = query.scroll(ScrollMode.SCROLL_SENSITIVE);
        scrollableResults.last();
        int totalCount = scrollableResults.getRowNumber() + 1;
        return HqlPage.getPageResult(query, totalCount + 1, pageNo, pageSize);
    }

    protected static Page getPageInstanceByList(Query query, int pageNo, int pageSize) {
        query.scroll(ScrollMode.FORWARD_ONLY);
        int totalCount = query.list().size();
        return HqlPage.getPageResult(query, totalCount, pageNo, pageSize);
    }

    private static Page getPageResult(Query q, int totalCount, int pageNo, int pageSize) {
        if (totalCount < 1) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage(pageNo, pageSize);
        List list = q.setFirstResult(startIndex).setMaxResults(pageSize).list();
        return new Page(startIndex, totalCount, pageSize, list);
    }
}

