/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.datai18n.controller;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.datai18n.manager.DataI18nManager;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.expand.ResourceConsts;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import www.seeyon.com.utils.ReqUtil;

public class DataI18nController
extends BaseController {
    private DataI18nManager dataI18nManager;

    public ModelAndView singleSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/common/datai18n/singleSet");
        String dataI18nID = ReqUtil.getString((HttpServletRequest)request, (String)"dataI18nID");
        if (Strings.isLong(dataI18nID)) {
            Map<String, String> existedLocales = this.dataI18nManager.getAllDataI18nValueMap(Long.parseLong(dataI18nID));
            modelAndView.addObject("existedLocales", (Object)JSONUtil.toJSONString(existedLocales));
        } else {
            dataI18nID = String.valueOf(UUIDLong.negativeLongUUID());
            modelAndView.addObject("existedLocales", (Object)"{}");
        }
        modelAndView.addObject("dataI18nID", (Object)dataI18nID);
        modelAndView.addObject("allLocales", (Object)JSONUtil.toJSONString(this.getDataI18nManager().getAllLocales()));
        modelAndView.addObject("currentLocale", (Object)I18nUtil.getLocalAsString(AppContext.getLocale()));
        modelAndView.addObject("defaultLocale", (Object)I18nUtil.getLocalAsString(LocaleContext.getSysSetDefaultLocale()));
        return modelAndView;
    }

    public ModelAndView batchSet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/common/datai18n/batchSet");
        LinkedHashMap<String, String> allLocales = new LinkedHashMap<String, String>();
        Locale locale = AppContext.getLocale();
        AppContext.getLocale();
        String currentLocale = I18nUtil.getLocalAsString(locale);
        allLocales.put(currentLocale, ResourceConsts.getLanguageName(currentLocale));
        List<Locale> list = LocaleContext.getAllLocales();
        for (Locale l : list) {
            String strLocale = I18nUtil.getLocalAsString(l);
            if (allLocales.containsKey(strLocale)) continue;
            allLocales.put(strLocale, ResourceConsts.getLanguageName(strLocale));
        }
        modelAndView.addObject("allLocales", (Object)JSONUtil.toJSONString(allLocales));
        return modelAndView;
    }

    public DataI18nManager getDataI18nManager() {
        return this.dataI18nManager;
    }

    public void setDataI18nManager(DataI18nManager dataI18nManager) {
        this.dataI18nManager = dataI18nManager;
    }
}

