/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.dao;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.dao.AttachmentDAO;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

public class AttachmentDAOImpl
extends BaseHibernateDao<Attachment>
implements AttachmentDAO {
    private static final String HQL_UPDATE_REFSUBREF = "update " + Attachment.class.getName() + " a set  a." + "reference" + "=? , " + "subReference" + "=? where  a.fileUrl=? ";
    private static final String HQL_UPDATE_REF = "update " + Attachment.class.getName() + " a set  a." + "reference" + "=?  where  a.fileUrl=? ";

    @Override
    public void delete(Long id) {
        String[] columns = new String[]{"id"};
        Object[] values = new Object[]{id};
        super.delete(columns, values);
    }

    @Override
    public List<Attachment> findAll(Long reference) {
        String queryString = "from " + Attachment.class.getName() + " a where a." + "reference" + "=? order by " + "createdate" + "," + "sort";
        Object[] values = new Object[]{reference};
        return super.getHibernateTemplate().find(queryString, values);
    }

    @Override
    public List<Attachment> find(List<Long> parentids) {
        String queryString = "from " + Attachment.class.getName() + " a where a." + "fileUrl" + " in (:ids) ";
        HashMap<String, Object> namedParameterMap = new HashMap<String, Object>();
        namedParameterMap.put("ids", parentids);
        return super.find(queryString, -1, -1, namedParameterMap, new Object[0]);
    }

    @Override
    public List<Attachment> findAll(Long reference, Long subReference) {
        if (subReference == null) {
            return this.findAll(reference);
        }
        String queryString = "from " + Attachment.class.getName() + " a where a." + "reference" + "=? and " + "subReference" + "=? order by " + "createdate" + "," + "sort";
        Object[] values = new Object[]{reference, subReference};
        return super.getHibernateTemplate().find(queryString, values);
    }

    @Override
    public List<Object[]> findAll(Long reference, Integer type, FlipInfo flipInfo) {
        StringBuilder hql = new StringBuilder();
        HashMap<String, Number> params = new HashMap<String, Number>();
        hql.append("SELECT f.id,f.filename,f.size,f.mimeType,f.createDate, f.createMember");
        hql.append(" FROM Attachment as a,V3XFile as f");
        hql.append(" WHERE a.fileUrl=f.id  ");
        if (reference != null) {
            hql.append(" AND a.reference=:reference ");
            params.put("reference", reference);
        }
        if (type != null) {
            hql.append(" AND a.type=:type ");
            params.put("type", type);
        }
        hql.append(" ORDER BY a.createdate DESC");
        return DBAgent.find(hql.toString(), params, flipInfo);
    }

    @Override
    public List<Attachment> findAll(Long reference, Long ... subReference) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class).add((Criterion)Expression.eq((String)"reference", (Object)reference)).add(Expression.in((String)"subReference", (Object[])subReference)).addOrder(Order.asc((String)"sort")).addOrder(Order.asc((String)"createdate"));
        return super.executeCriteria(criteria, -1, -1);
    }

    @Override
    public Attachment get(Long id) {
        return (Attachment)super.get(id);
    }

    @Override
    public void save(Attachment attachment) {
        String fileName;
        if (attachment.getType().intValue() == Constants.ATTACHMENT_TYPE.FILE.ordinal() && (fileName = attachment.getFilename()).getBytes().length > 120) {
            int pointIndex = fileName.lastIndexOf(".");
            String ext = "";
            if (pointIndex > 0) {
                ext = fileName.substring(pointIndex);
                fileName = fileName.substring(0, pointIndex);
            }
            fileName = Strings.getLimitLengthString(fileName, 120, "..") + ext;
            attachment.setFilename(fileName);
        }
        super.getHibernateTemplate().merge((Object)attachment);
    }

    @Override
    public void deleteByReference(Long reference) {
        String[] columns = new String[]{"reference"};
        Object[] values = new Object[]{reference};
        super.delete(columns, values);
    }

    @Override
    public void deleteByReference(Long reference, Long subReference) {
        String[] columns = new String[]{"reference", "subReference"};
        Object[] values = new Object[]{reference, subReference};
        super.delete(columns, values);
    }

    @Override
    public List<Object[]> findAllFileUrl(Long reference) {
        String queryString = "select a.fileUrl,a.createdate from " + Attachment.class.getName() + " a where a." + "reference" + "=?";
        Object[] values = new Object[]{reference};
        return super.getHibernateTemplate().find(queryString, values);
    }

    @Override
    public List<Object[]> findAllFileUrl(Long reference, Long subReference) {
        String queryString = "select a.fileUrl,a.createdate from " + Attachment.class.getName() + " a where a." + "reference" + "=? and " + "subReference" + "=?";
        Object[] values = new Object[]{reference, subReference};
        return super.getHibernateTemplate().find(queryString, values);
    }

    @Override
    public boolean hasAttachments(Long reference, Long subReference) {
        String queryString = "select count(*) from " + Attachment.class.getName() + " a where a." + "reference" + "=? and " + "subReference" + "=?";
        Object[] values = new Object[]{reference, subReference};
        int number = ((Number)super.getHibernateTemplate().find(queryString, values).get(0)).intValue();
        return number > 0;
    }

    @Override
    public Attachment getFirst(Long reference, Long subReference, Constants.ATTACHMENT_TYPE type) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class).add((Criterion)Expression.eq((String)"reference", (Object)reference)).add((Criterion)Expression.eq((String)"subReference", (Object)subReference)).add((Criterion)Expression.eq((String)"type", (Object)type.ordinal())).addOrder(Order.asc((String)"createdate"));
        List attachments = super.executeCriteria(criteria, 0, 1);
        if (attachments != null && !attachments.isEmpty()) {
            return (Attachment)attachments.get(0);
        }
        return null;
    }

    @Override
    public Attachment getAttachmentByFileURL(Long fileURL) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class).add((Criterion)Expression.eq((String)"fileUrl", (Object)fileURL));
        Attachment attachment = (Attachment)super.executeUniqueCriteria(criteria);
        return attachment;
    }

    @Override
    public void update(Attachment attachment) {
        super.update(attachment);
    }

    @Override
    public void updateReferenceSubReference(Long fileUrl, Long referenceId, Long subReference) {
        super.getHibernateTemplate().bulkUpdate(HQL_UPDATE_REFSUBREF, new Object[]{referenceId, subReference, fileUrl});
    }

    @Override
    public void updateReference(Long fileUrl, Long referenceId) {
        super.getHibernateTemplate().bulkUpdate(HQL_UPDATE_REF, new Object[]{referenceId, fileUrl});
    }

    @Override
    public boolean checkIsLicitGenesis(Long referenceId, Long genesisId) {
        String queryString = "select count(*) from " + Attachment.class.getName() + " a where a." + "reference" + "=? and " + "genesisId" + "=?";
        Object[] values = new Object[]{referenceId, genesisId};
        Long number = (Long)super.getHibernateTemplate().find(queryString, values).get(0);
        return number > 0L;
    }

    @Override
    public void updateFileNameByAffairIds(String fileName, List<Long> affairIdList) {
        if (affairIdList != null && affairIdList.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fileName", fileName);
            if (affairIdList.size() > 999) {
                List<Long>[] idsList;
                for (List<Long> ids : idsList = Strings.splitList(affairIdList, 1000)) {
                    params.put("affairIds", ids);
                    DBAgent.bulkUpdate("update Attachment set fileName =:fileName where fileUrl in (:affairIds)", params);
                }
            } else {
                params.put("affairIds", affairIdList);
                DBAgent.bulkUpdate("update Attachment set fileName =:fileName where fileUrl in (:affairIds)", params);
            }
        }
    }

    @Override
    public List<Long> getBySubReference(Long subReference) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("subReference", subReference);
        return DBAgent.find("select fileUrl from " + Attachment.class.getName() + " where subReference=:subReference", params);
    }

    @Override
    public void deleteByIds(List<Long> attachmentIds) {
        if (Strings.isNotEmpty(attachmentIds)) {
            String hql = "delete from " + Attachment.class.getName() + " as a where a.id in(:id)";
            HashMap<String, Object> params = new HashMap<String, Object>();
            List<List> splistList = JDBCAgent.splitList(attachmentIds, null);
            for (List list : splistList) {
                params.put("id", list);
                this.bulkUpdate(hql, params, new Object[0]);
            }
        }
    }

    @Override
    public List<Attachment> getBySubReference(List<Long> subReferences) {
        String queryString = "from " + Attachment.class.getName() + " a where a." + "subReference" + " in (:subReferences) ";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subReferences", subReferences);
        return super.find(queryString, -1, -1, map, new Object[0]);
    }

    @Override
    public List<Attachment> getByReference(List<Long> references) {
        String queryString = "from " + Attachment.class.getName() + " a where a." + "reference" + " in (:references)  order by " + "createdate" + "," + "sort";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("references", references);
        return super.find(queryString, -1, -1, map, new Object[0]);
    }
}

