/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.filemanager.manager.ActionLog;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.EnumUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class AttachmentEditHelper {
    private static final String IS_EDITATT = "isEditAttachment";
    private static final String ATT_SIZE = "editAttachmentSize";
    private static final String LOG_ACTION = "logAction";
    private static final String LOG_CREATEDATE = "logCreateDate";
    private static final String LOG_DESC = "logDesc";
    private static final String REFID = "reference";
    private static final String SUB_REFID = "subReference";
    private Long reference;
    private Long subReference;
    private boolean hasEditAtt = false;
    private int attSize = 0;
    private List<ActionLog> logList = new ArrayList<ActionLog>();

    public AttachmentEditHelper(HttpServletRequest request) {
        String isEditAttachment = request.getParameter(IS_EDITATT);
        if (Strings.isNotBlank(isEditAttachment)) {
            this.hasEditAtt = true;
            String size = request.getParameter(ATT_SIZE);
            this.attSize = Integer.parseInt(size);
            this.reference = Long.parseLong(request.getParameter(REFID));
            this.subReference = Long.parseLong(request.getParameter(SUB_REFID));
            String[] logAction = request.getParameterValues(LOG_ACTION);
            String[] logCreateDate = request.getParameterValues(LOG_CREATEDATE);
            String[] logDesc = request.getParameterValues(LOG_DESC);
            List<ActionLog> logs = this.createLogs(logAction, logCreateDate, logDesc);
            this.logList = logs;
        }
    }

    private List<ActionLog> createLogs(String[] logAction, String[] logCreateDate, String[] logDesc) {
        ArrayList<ActionLog> result = new ArrayList<ActionLog>();
        int length = logAction.length;
        for (int i = 0; i < length; ++i) {
            ActionLog log = new ActionLog();
            log.setAction(EnumUtil.getEnumByOrdinal(ActionLog.ActionEnum.class, Integer.parseInt(logAction[i])));
            if (Strings.isNotBlank(logCreateDate[i])) {
                try {
                    log.setCreateDate(Datetimes.parseDatetimeWithoutSecond(logCreateDate[i]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            log.setDesc(logDesc[i]);
            result.add(log);
        }
        return result;
    }

    public static boolean hasEditAtt(HttpServletRequest request) {
        String isEditAttachment = request.getParameter(IS_EDITATT);
        return Strings.isNotBlank(isEditAttachment);
    }

    public boolean hasEditAtt() {
        return this.hasEditAtt;
    }

    public int attSize() {
        return this.attSize;
    }

    public List<ActionLog> getLogs() {
        return this.logList;
    }

    public Long getReference() {
        return this.reference;
    }

    public void setReference(Long reference) {
        this.reference = reference;
    }

    public Long getSubReference() {
        return this.subReference;
    }

    public void setSubReference(Long subReference) {
        this.subReference = subReference;
    }
}

