/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.NoSuchPartitionException;
import com.seeyon.ctp.common.filemanager.event.FileDownloadEvent;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.filemanager.manager.FileSecurityManager;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.common.fileupload.FileuploadManagerImpl;
import com.seeyon.ctp.common.fileupload.bean.FileProperties;
import com.seeyon.ctp.common.fileupload.bean.FileServicePartition;
import com.seeyon.ctp.common.fileupload.bean.FileServiceRequestBean;
import com.seeyon.ctp.common.fileupload.bean.FileServiceResponseBean;
import com.seeyon.ctp.common.fileupload.bean.StatusCode;
import com.seeyon.ctp.common.fileupload.bean.Thresholds;
import com.seeyon.ctp.common.fileupload.util.FileServiceUtil;
import com.seeyon.ctp.common.fileupload.util.FileUploadUtil;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.Partition;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.EnumUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.HttpClientUtil;
import com.seeyon.ctp.util.OperationControllable;
import com.seeyon.ctp.util.OperationCounter;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.NeedlessCheckLogin;
import com.seeyon.ctp.util.annotation.SetContentType;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class FileUploadController
extends BaseController {
    private static final Log log = CtpLogFactory.getLog(FileUploadController.class);
    private static Integer maxDownloadConnections = PerformanceConfig.getInstance().getIntegerConfig("fileDowload.maxConnections", 65535);
    private static OperationControllable downloadCounter = new OperationCounter(maxDownloadConnections.intValue());
    private static Map<String, String> RTE_type = new HashMap<String, String>();
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final long Etag_CacheDate = 302400000L;
    private FileManager fileManager;
    private AttachmentManager attachmentManager;
    private FileSecurityManager fileSecurityManager;
    private PartitionManager partitionManager;
    private String clientAbortExceptionName = "ClientAbortException";
    private String contentTypeCharset = "UTF-8";
    private String htmlSuffix;

    public void setFileSecurityManager(FileSecurityManager fileSecurityManager) {
        this.fileSecurityManager = fileSecurityManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    public void setHtmlSuffix(String htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    public void setClientAbortExceptionName(String clientAbortExceptionName) {
        this.clientAbortExceptionName = clientAbortExceptionName;
    }

    public ModelAndView processUpload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = null;
        String userAgent = request.getHeader("User-Agent");
        modelAndView = userAgent != null && (userAgent.toUpperCase().contains("IE") || userAgent.toUpperCase().contains("RV:11")) ? new ModelAndView("ctp/common/fileUpload/uploadForGeniues") : new ModelAndView("ctp/common/fileUpload/upload");
        String extensions = request.getParameter("extensions");
        String applicationCategory = request.getParameter("applicationCategory");
        String typeStr = request.getParameter("type");
        String firstSave = request.getParameter("firstSave") == null ? "" : request.getParameter("firstSave");
        String maxSizeStr = request.getParameter("maxSize");
        String from = request.getParameter("from");
        String serverTime = request.getParameter("serverTime");
        TimeZone serverTimeZone = TimeZone.getDefault();
        if ("true".equals(serverTime)) {
            modelAndView.addObject("timeZoneValue", (Object)serverTimeZone.getID());
        }
        Constants.ATTACHMENT_TYPE type = null;
        type = StringUtils.isNotBlank((CharSequence)typeStr) ? EnumUtil.getEnumByOrdinal(Constants.ATTACHMENT_TYPE.class, Integer.valueOf(typeStr)) : Constants.ATTACHMENT_TYPE.FILE;
        if (StringUtils.isBlank((CharSequence)firstSave)) {
            firstSave = "false";
        }
        ApplicationCategoryEnum category = null;
        if (StringUtils.isNotBlank((CharSequence)applicationCategory)) {
            category = ApplicationCategoryEnum.valueOf(Integer.valueOf(applicationCategory));
        } else {
            category = ApplicationCategoryEnum.global;
            log.warn((Object)"\u4e0a\u4f20\u6587\u4ef6\uff1av3x:fileUpload\u6ca1\u6709\u8bbe\u5b9aapplicationCategory\u5c5e\u6027\uff0c\u5c06\u8bbe\u7f6e\u4e3a\u2018\u5168\u5c40\u2019\u3002");
        }
        Long maxSize = Long.parseLong(PerformanceConfig.getInstance().getConfig("fileUpload.maxSize")) * 1024L * 1024L;
        if (StringUtils.isNotBlank((CharSequence)maxSizeStr)) {
            maxSize = Long.valueOf(maxSizeStr);
        }
        Map<String, V3XFile> v3xFiles = null;
        try {
            v3xFiles = this.fileManager.uploadFiles(request, extensions, maxSize);
            if (v3xFiles != null) {
                ArrayList<String> keys = new ArrayList<String>(v3xFiles.keySet());
                Collections.sort(keys, new FileFieldComparator());
                ArrayList<Attachment> atts = new ArrayList<Attachment>();
                for (String key : keys) {
                    Attachment att = new Attachment(v3xFiles.get(key), category, type);
                    atts.add(att);
                }
                if ("true".equalsIgnoreCase(firstSave)) {
                    this.attachmentManager.create(atts);
                }
                modelAndView.addObject("atts", atts);
                HttpSession session = request.getSession();
                session.setAttribute("repeat", (Object)request.getParameter("repeat"));
                if (from != null && "a8genius".equals(from)) {
                    response.setContentType("text/html;charset=UTF-8");
                    PrintWriter out = response.getWriter();
                    String jsonStr = JSONUtil.toJSONString(atts);
                    out.println(jsonStr);
                    out.flush();
                    return null;
                }
            }
        }
        catch (NoSuchPartitionException e) {
            log.error((Object)"", (Throwable)e);
            modelAndView.addObject("e", (Object)e);
        }
        catch (BusinessException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            modelAndView.addObject("e", (Object)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            modelAndView.addObject("e", (Object)new BusinessException("fileupload.exception.unknown", e.getMessage()));
        }
        return modelAndView;
    }

    public ModelAndView processUploadForCap4(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = null;
        String userAgent = request.getHeader("User-Agent");
        modelAndView = userAgent != null && (userAgent.toUpperCase().contains("IE") || userAgent.toUpperCase().contains("RV:11")) ? new ModelAndView("ctp/common/fileUpload/uploadForGeniues") : new ModelAndView("ctp/common/fileUpload/upload");
        String extensions = request.getParameter("extensions");
        String applicationCategory = request.getParameter("applicationCategory");
        String typeStr = request.getParameter("type");
        String firstSave = request.getParameter("firstSave") == null ? "" : request.getParameter("firstSave");
        String maxSizeStr = request.getParameter("maxSize");
        Constants.ATTACHMENT_TYPE type = null;
        type = StringUtils.isNotBlank((CharSequence)typeStr) ? EnumUtil.getEnumByOrdinal(Constants.ATTACHMENT_TYPE.class, Integer.valueOf(typeStr)) : Constants.ATTACHMENT_TYPE.FILE;
        if (StringUtils.isBlank((CharSequence)firstSave)) {
            firstSave = "false";
        }
        ApplicationCategoryEnum category = null;
        if (StringUtils.isNotBlank((CharSequence)applicationCategory)) {
            category = ApplicationCategoryEnum.valueOf(Integer.valueOf(applicationCategory));
        } else {
            category = ApplicationCategoryEnum.global;
            log.warn((Object)"\u4e0a\u4f20\u6587\u4ef6\uff1av3x:fileUpload\u6ca1\u6709\u8bbe\u5b9aapplicationCategory\u5c5e\u6027\uff0c\u5c06\u8bbe\u7f6e\u4e3a\u2018\u5168\u5c40\u2019\u3002");
        }
        Long maxSize = Long.parseLong(PerformanceConfig.getInstance().getConfig("fileUpload.maxSize")) * 1024L * 1024L;
        if (StringUtils.isNotBlank((CharSequence)maxSizeStr)) {
            maxSize = Long.valueOf(maxSizeStr);
        }
        Map<String, V3XFile> v3xFiles = null;
        try {
            v3xFiles = this.fileManager.uploadFiles(request, extensions, maxSize);
            if (v3xFiles != null) {
                ArrayList<String> keys = new ArrayList<String>(v3xFiles.keySet());
                Collections.sort(keys, new FileFieldComparator());
                ArrayList<Attachment> atts = new ArrayList<Attachment>();
                for (String key : keys) {
                    Attachment att = new Attachment(v3xFiles.get(key), category, type);
                    atts.add(att);
                }
                if ("true".equalsIgnoreCase(firstSave)) {
                    this.attachmentManager.create(atts);
                }
                modelAndView.addObject("atts", atts);
                HttpSession session = request.getSession();
                session.setAttribute("repeat", (Object)request.getParameter("repeat"));
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                String jsonStr = JSONUtil.toJSONString(atts);
                out.println(jsonStr);
                out.flush();
                return null;
            }
        }
        catch (NoSuchPartitionException e) {
            log.error((Object)"", (Throwable)e);
            modelAndView.addObject("e", (Object)e);
        }
        catch (BusinessException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            modelAndView.addObject("e", (Object)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            modelAndView.addObject("e", (Object)new BusinessException("fileupload.exception.unknown", e.getMessage()));
        }
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SetContentType
    @NeedlessCheckLogin
    public ModelAndView showRTE(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletOutputStream out;
        FileInputStream in;
        block17: {
            String mimeType;
            Long fileId = Long.valueOf(request.getParameter("fileId"));
            User user = AppContext.getCurrentUser();
            String ucFlag = request.getParameter("ucFlag");
            if (user == null) {
                boolean accessDenied = true;
                if (this.fileSecurityManager != null) {
                    boolean bl = accessDenied = !this.fileSecurityManager.isNeedlessLogin(fileId);
                }
                if (accessDenied) {
                    response.setStatus(404);
                    return null;
                }
            }
            String small = Strings.escapeNULL(request.getParameter("showType"), "");
            String smallPX = Strings.escapeNULL(request.getParameter("smallPX"), "");
            String etag = String.valueOf(fileId) + small + smallPX;
            if (WebUtil.checkEtag(request, response, etag)) {
                return null;
            }
            Date createDate = null;
            if (Strings.isNotBlank(request.getParameter("createDate"))) {
                createDate = Datetimes.parseDate(request.getParameter("createDate"));
            } else {
                V3XFile f = this.fileManager.getV3XFile(fileId);
                if (f == null) {
                    response.setStatus(404);
                    return null;
                }
                createDate = f.getCreateDate();
            }
            String type = request.getParameter("type");
            if (type != null && type.startsWith("flash")) {
                type = "flash";
            }
            if ((mimeType = RTE_type.get(type)) == null) {
                response.setStatus(404);
                return null;
            }
            WebUtil.writeETag(request, response, etag, 302400000L);
            response.setContentType(mimeType);
            File f = null;
            f = !"small".equals(small) ? ("yes".equals(ucFlag) ? this.fileManager.getFileForUC(fileId, createDate) : this.fileManager.getFile(fileId, createDate)) : (Strings.isNotBlank(smallPX) ? ("yes".equals(ucFlag) ? this.fileManager.getThumFileForUC(fileId, createDate, smallPX) : this.fileManager.getThumFile(fileId, createDate, Integer.parseInt(smallPX))) : ("yes".equals(ucFlag) ? this.fileManager.getThumFileForUC(fileId, createDate, smallPX) : this.fileManager.getThumFile(fileId, createDate)));
            if (f == null) {
                return null;
            }
            in = null;
            out = response.getOutputStream();
            try {
                in = new FileInputStream(f);
                if (in == null) break block17;
                CoderFactory.getInstance().download(in, (OutputStream)out);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)e);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (Exception e2) {
                block18: {
                    if (e2.getClass().getSimpleName().equals(this.clientAbortExceptionName)) {
                        log.debug((Object)("\u7528\u6237\u5173\u95ed\u4e0b\u8f7d\u7a97\u53e3: " + e2.getMessage()));
                        break block18;
                    }
                    log.error((Object)"", (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly((OutputStream)out);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return null;
    }

    public ModelAndView download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket;
        String remoteDownUrl;
        ModelAndView m = new ModelAndView("ctp/common/fileUpload/download");
        if (this.isRemoteDownload(request) && (remoteDownUrl = this.generateRemoteDownloadUrl(request, ticket = FileServiceUtil.generateDownloadTicket(Long.valueOf(request.getParameter("fileId"))))) != null) {
            response.sendRedirect(Strings.toHTML(remoteDownUrl));
            return null;
        }
        if (!downloadCounter.check()) {
            response.setContentType("text/html;charset=UTF-8");
            Object[] objectArray = new Object[1];
            objectArray[0] = maxDownloadConnections;
            response.getWriter().println("<script>alert('" + Strings.toHTML(ResourceUtil.getStringByParams("fileuoload.downoad.exceedConnection", objectArray)) + "');</script>");
            return null;
        }
        downloadCounter.start();
        Map<String, String> ps = this.getParameterMap(request);
        m.addObject("ps", ps);
        String filename = request.getParameter("filename");
        String suffix = FilenameUtils.getExtension((String)filename).toLowerCase();
        String from = request.getParameter("from");
        if (from != null && "a8geniues".equals(from)) {
            m.addObject("isHTML", (Object)Pattern.matches(this.htmlSuffix, suffix));
        } else if (Pattern.matches(this.htmlSuffix, suffix) && !"mobile".equals(from)) {
            m.addObject("isHTML", (Object)true);
        }
        return m;
    }

    private boolean isRemoteDownload(HttpServletRequest request) {
        int appType;
        String isSystemRecieveForm = request.getParameter("isSystemForm");
        String isSystemRedTemplete = request.getParameter("isSystemRedTemplete");
        String isInfoTemplate = request.getParameter("isInfoTemplate");
        String fileId = request.getParameter("fileId");
        if (!FileServiceUtil.isRemoteMode()) {
            return false;
        }
        if ("true".equals(request.getParameter("forceLocalDownload"))) {
            return false;
        }
        int n = appType = request.getParameter("appType") == null ? 0 : Integer.parseInt(request.getParameter("appType"));
        if ("true".equals(isSystemRecieveForm)) {
            return false;
        }
        if ("true".equals(isSystemRedTemplete)) {
            return false;
        }
        if ("true".equals(isInfoTemplate)) {
            return false;
        }
        return !"607151236662539448".equals(fileId) || appType != ApplicationCategoryEnum.info.key();
    }

    private Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> ps = new HashMap<String, String>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            if ("method".equalsIgnoreCase(name)) continue;
            String value = request.getParameter(name);
            ps.put(name, value);
        }
        return ps;
    }

    public ModelAndView doDownload4html(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new FileDownloader(request, response){

            @Override
            void setOutput() {
                String swf = this.request.getParameter("swf");
                if ("true".equals(swf)) {
                    this.setFlashContenttype();
                } else {
                    this.setDownloadContentType(this.response, this.filename, "attachment", "application/octet-stream");
                }
            }

            @Override
            void getInputstream() throws Exception {
                String comm = this.request.getParameter("comm");
                if ("byFileId".equals(comm)) {
                    V3XFile v3xfile = FileUploadController.this.fileManager.getV3XFile(this.fileId);
                    this.createDate = v3xfile.getCreateDate();
                    this.filename = v3xfile.getFilename();
                } else {
                    this.createDate = Datetimes.parseDate(this.request.getParameter("createDate"));
                    this.filename = this.request.getParameter("filename");
                    this.filename = new String(this.filename.getBytes(), "iso8859-1");
                }
                this.in = FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
            }
        }.download();
    }

    @SetContentType
    public ModelAndView doDownload4Office(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new FileDownloader(request, response){

            @Override
            void setOutput() {
                String type = this.request.getParameter("type");
                String fileName = FileUploadUtil.getOfficeName(this.fileId, type);
                String attachment = "true".equals(this.request.getParameter("isOpenFile")) ? "" : "attachment";
                this.setDownloadContentType(this.response, fileName, attachment, FileUploadUtil.getOfficeHeader(type));
            }

            @Override
            void getInputstream() throws Exception {
                String comm = this.request.getParameter("comm");
                if ("byFileId".equals(comm)) {
                    V3XFile v3xfile = FileUploadController.this.fileManager.getV3XFile(this.fileId);
                    this.createDate = v3xfile.getCreateDate();
                } else {
                    this.createDate = Datetimes.parseDate(this.request.getParameter("createDate"));
                }
                this.in = FileUploadController.this.fileManager.getStandardOfficeInputStream(this.fileId, this.createDate);
            }
        }.download();
    }

    @SetContentType
    public ModelAndView doDownload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new FileDownloader(request, response){

            @Override
            protected boolean beforeDownload() throws Exception {
                return true;
            }

            @Override
            void setOutput() {
                String swf = this.request.getParameter("swf");
                if ("true".equals(swf)) {
                    this.setFlashContenttype();
                } else {
                    if (!"mobile".equals(this.request.getParameter("from"))) {
                        this.contentType = "application/octet-stream";
                    }
                    this.setDownloadContentType(this.response, this.filename, "attachment", this.contentType);
                }
            }

            @Override
            void getInputstream() throws BusinessException {
                V3XFile v3xfile;
                String comm = this.request.getParameter("comm");
                if ("byFileId".equals(comm)) {
                    v3xfile = this.getFile();
                    this.createDate = v3xfile.getCreateDate();
                    this.filename = v3xfile.getFilename();
                    try {
                        this.filename = URLEncoder.encode(this.filename, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)e);
                    }
                } else if ("mobile".equals(this.request.getParameter("from"))) {
                    v3xfile = this.getFile();
                    this.contentType = v3xfile.getMimeType();
                    this.createDate = v3xfile.getCreateDate();
                    this.filename = FileUploadUtil.escapeFileName(v3xfile);
                } else {
                    this.createDate = Datetimes.parseDate(this.request.getParameter("createDate"));
                    this.filename = this.request.getParameter("filename");
                    this.filename = FileUtil.getDownloadFileName(this.request, this.filename);
                }
                this.in = this.appsPreHandle();
                if (this.in == null) {
                    long openfileStart = System.currentTimeMillis();
                    this.in = FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    if (this.in == null) {
                        V3XFile v3xfile2 = this.getFile();
                        this.createDate = v3xfile2.getCreateDate();
                        this.in = FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    }
                    if (this.in == null) {
                        this.response.addHeader("filestatus", "no");
                    }
                    if (System.currentTimeMillis() - openfileStart > 1000L) {
                        log.warn((Object)("\u6587\u4ef6\u7cfb\u7edf\u6253\u5f00\u9644\u4ef6\u8fc7\u6162\uff01\u8017\u65f6\uff1a" + (System.currentTimeMillis() - openfileStart)));
                    }
                }
            }

            private InputStream appsPreHandle() throws BusinessException {
                int appType;
                String isSystemRecieveForm = this.request.getParameter("isSystemForm");
                String isSystemRedTemplete = this.request.getParameter("isSystemRedTemplete");
                String isInfoTemplate = this.request.getParameter("isInfoTemplate");
                int n = appType = this.request.getParameter("appType") == null ? 0 : Integer.parseInt(this.request.getParameter("appType"));
                if ("true".equals(isSystemRecieveForm)) {
                    try {
                        String formType = this.request.getParameter("formType");
                        String systemFormId = "-2921628185995099164";
                        String folder = "edoc.folder";
                        if (appType == ApplicationCategoryEnum.info.key()) {
                            folder = "govform.folder";
                            systemFormId = "607151236662539448";
                        } else {
                            folder = "edoc.folder";
                            systemFormId = "0".equals(formType) ? "6071519916662539448" : ("1".equals(formType) ? "-2921628185995099164" : ("10".equals(formType) ? "-2921628185995099166" : "-1766191165740134579"));
                        }
                        return new FileInputStream(new File(SystemProperties.getInstance().getProperty(folder) + File.separator + "form" + File.separator + systemFormId));
                    }
                    catch (Exception e) {
                        return FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    }
                }
                if ("true".equals(isSystemRedTemplete)) {
                    try {
                        return new FileInputStream(new File(SystemProperties.getInstance().getProperty("edoc.folder") + File.separator + "template" + File.separator + "-6001972826857714844"));
                    }
                    catch (Exception e) {
                        return FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    }
                }
                if ("true".equals(isInfoTemplate)) {
                    try {
                        StringBuffer filePathBuff = new StringBuffer(SystemProperties.getInstance().getProperty("infosend.folder"));
                        String subPath = "";
                        String tempType = this.request.getParameter("tempType");
                        if ("0".equals(tempType)) {
                            subPath = "template/5282854121826306408";
                        }
                        filePathBuff.append(File.separator);
                        filePathBuff.append(subPath);
                        return new FileInputStream(new File(filePathBuff.toString()));
                    }
                    catch (Exception e) {
                        return FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    }
                }
                if ("607151236662539448".equals(this.fileId.toString()) && appType == ApplicationCategoryEnum.info.key()) {
                    String folder = "govform.folder";
                    String systemFormId = "607151236662539447";
                    try {
                        return new FileInputStream(new File(SystemProperties.getInstance().getProperty(folder) + File.separator + "form" + File.separator + systemFormId));
                    }
                    catch (FileNotFoundException e) {
                        return FileUploadController.this.fileManager.getFileInputStream(this.fileId, this.createDate);
                    }
                }
                return null;
            }
        }.download();
    }

    private static void showError(String error, BusinessException e, ServletOutputStream out, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        String message = null;
        if (error != null) {
            message = ResourceUtil.getString("fileupload.document." + error);
        }
        if (e != null) {
            message = ResourceUtil.getString("fileupload.document.Exception");
        }
        response.addHeader("Rang", "-1");
        if (message != null) {
            String encode;
            PrintWriter writer = new PrintWriter((OutputStream)out);
            writer.println("<script type=\"text/javascript\">");
            String str = Strings.escapeJavascript(message);
            try {
                encode = URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                encode = URLEncoder.encode(str);
            }
            writer.println("alert(decodeURI(\"" + encode + "\"));");
            if ("blank".equals(request.getParameter("from"))) {
                writer.println("window.open(\"/closeIE7.htm\", \"_self\");");
            }
            writer.println("</script>");
            if ("mobile".equals(request.getParameter("from"))) {
                writer.println(message);
                writer.println("<html><head>");
                writer.println("<meta http-equiv=\"Refresh\" content=\"3;url=mob.do?method=showAffairs\">");
                writer.println("</head></html>");
            }
            writer.flush();
            writer.close();
        }
    }

    public ModelAndView deleteFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/common/fileUpload/upload");
        try {
            Long fileId = Long.parseLong(request.getParameter("fileId"));
            Date createDate = Datetimes.parseDatetime(request.getParameter("createDate"));
            this.fileManager.deleteFile(fileId, createDate, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelAndView;
    }

    @Override
    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = null;
        User user = AppContext.getCurrentUser();
        String userAgent = request.getHeader("User-Agent");
        modelAndView = user.isV5Member() && userAgent != null && (userAgent.toUpperCase().contains("IE") || userAgent.toUpperCase().contains("RV:11")) ? new ModelAndView("ctp/common/fileUpload/uploadForGeniues") : new ModelAndView("ctp/common/fileUpload/upload");
        String isA8geniusAdded = "false";
        String quantity = request.getParameter("quantity");
        if (!"1".equals(quantity)) {
            isA8geniusAdded = request.getParameter("isA8geniusAdded");
        }
        modelAndView.addObject("isA8geniusAdded", (Object)isA8geniusAdded);
        String str = FileuploadManagerImpl.getMaxSizeStr();
        modelAndView.addObject("maxSize", (Object)str);
        return modelAndView;
    }

    public ModelAndView indexforForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/common/fileUpload/uploadForForm");
        String isA8geniusAdded = request.getParameter("isA8geniusAdded");
        modelAndView.addObject("isA8geniusAdded", (Object)isA8geniusAdded);
        String str = FileuploadManagerImpl.getMaxSizeStr();
        modelAndView.addObject("maxSize", (Object)str);
        return modelAndView;
    }

    public ModelAndView indexforFormImage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/common/fileUpload/upLoadImage");
        String isA8geniusAdded = request.getParameter("isA8geniusAdded");
        modelAndView.addObject("isA8geniusAdded", (Object)isA8geniusAdded);
        String str = FileuploadManagerImpl.getMaxSizeStr();
        modelAndView.addObject("maxSize", (Object)str);
        return modelAndView;
    }

    public ModelAndView getFileServiceCofig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = AppContext.getCurrentUser();
        if (user != null && !user.isSystemAdmin() && !user.isAdministrator()) {
            StringBuilder sb = new StringBuilder(ResourceUtil.getStringByParams("loginUserState.wuquanfangwen", new Object[0]));
            BusinessException be = new BusinessException(sb.toString());
            be.setCode("invalid_resource_code");
            be.setFullPage(true);
            throw be;
        }
        ModelAndView modelAndView = new ModelAndView("ctp/common/fileUpload/serviceConfig");
        this.loadOriginConfig(modelAndView);
        return modelAndView;
    }

    public ModelAndView updateFileServiceCofig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int maxDownloadNum;
        ModelAndView modelAndView = new ModelAndView("ctp/common/fileUpload/serviceConfig");
        String flag = request.getParameter("flag");
        String serverIp = request.getParameter("serverIp");
        int serverPort = Integer.parseInt(request.getParameter("serverPort"));
        String maxDownloadNumStr = request.getParameter("maxDownloadNum");
        boolean originRemoteMode = FileServiceUtil.isRemoteMode();
        FileServiceUtil.switchToMode("on".equals(flag) ? FileServiceUtil.ModeEnum.REMOTE : FileServiceUtil.ModeEnum.LOCAL);
        FileServiceUtil.ip = serverIp;
        FileServiceUtil.port = serverPort;
        modelAndView.addObject("flag", (Object)flag);
        modelAndView.addObject("serverIp", (Object)serverIp);
        modelAndView.addObject("serverPort", (Object)serverPort);
        if (StringUtils.isNotEmpty((CharSequence)maxDownloadNumStr)) {
            maxDownloadNum = Integer.parseInt(maxDownloadNumStr);
            modelAndView.addObject("maxDownloadNum", (Object)maxDownloadNum);
        }
        modelAndView.addObject("showMsg", (Object)"menu.system.service.file.setting.ok");
        modelAndView.addObject("localMaxDownloadNum", (Object)PerformanceConfig.getInstance().getIntegerConfig("fileDowload.maxConnections"));
        if (FileServiceUtil.isRemoteMode() && StringUtils.isNotEmpty((CharSequence)serverIp)) {
            if (StringUtils.isNotEmpty((CharSequence)maxDownloadNumStr)) {
                maxDownloadNum = Integer.parseInt(maxDownloadNumStr);
                modelAndView.addObject("maxDownloadNum", (Object)maxDownloadNum);
                Thresholds thresholds = new Thresholds();
                thresholds.setDownloadNum(maxDownloadNum);
                try {
                    int status = 0;
                    status = originRemoteMode ? this.setFileServiceThresholds(FileServiceUtil.getRequestUrl(FileServiceUtil.RequestTypeEnum.SET_THRESHOLD), thresholds) : this.updateFileServiceConfig(thresholds);
                    if (status != 0) {
                        modelAndView.addObject("showMsg", (Object)StatusCode.getDesc(status));
                        FileServiceUtil.loadProperties();
                        this.loadOriginConfig(modelAndView);
                        return modelAndView;
                    }
                }
                catch (IOException e) {
                    modelAndView.addObject("showMsg", (Object)"menu.system.service.file.connect.fail.hint");
                    FileServiceUtil.loadProperties();
                    this.loadOriginConfig(modelAndView);
                    return modelAndView;
                }
            }
        } else {
            FileServiceUtil.switchToMode(FileServiceUtil.ModeEnum.LOCAL);
        }
        if (!FileServiceUtil.saveToProperties()) {
            modelAndView.addObject("showMsg", (Object)"menu.system.service.file.connect.fail.hint");
            FileServiceUtil.loadProperties();
            this.loadOriginConfig(modelAndView);
            return modelAndView;
        }
        return modelAndView;
    }

    private void loadOriginConfig(ModelAndView modelAndView) {
        modelAndView.addObject("flag", (Object)(FileServiceUtil.isRemoteMode() ? "on" : "off"));
        modelAndView.addObject("serverIp", (Object)FileServiceUtil.ip);
        modelAndView.addObject("serverPort", (Object)FileServiceUtil.port);
        modelAndView.addObject("localMaxDownloadNum", (Object)PerformanceConfig.getInstance().getIntegerConfig("fileDowload.maxConnections"));
        if (FileServiceUtil.isRemoteMode()) {
            try {
                Thresholds thretholds = this.getFileServiceThresholds(FileServiceUtil.getRequestUrl(FileServiceUtil.RequestTypeEnum.GET_THRESHOLD));
                if (thretholds != null) {
                    int maxDownloadNum = thretholds.getDownloadNum();
                    modelAndView.addObject("maxDownloadNum", (Object)maxDownloadNum);
                } else {
                    modelAndView.addObject("showMsg", (Object)"menu.system.service.file.connect.fail.hint");
                    FileServiceUtil.switchToMode(FileServiceUtil.ModeEnum.LOCAL);
                }
            }
            catch (IOException e) {
                modelAndView.addObject("showMsg", (Object)"menu.system.service.file.connect.fail.hint");
                FileServiceUtil.switchToMode(FileServiceUtil.ModeEnum.LOCAL);
            }
        }
    }

    private Thresholds getFileServiceThresholds(String reqUrl) throws IOException {
        FileServiceResponseBean resBean;
        block6: {
            resBean = null;
            HttpClientUtil httpClient = new HttpClientUtil(5000);
            try {
                httpClient.openGet(reqUrl);
                int status = httpClient.send();
                if (status == 200) {
                    resBean = httpClient.getResponseJsonAsObject(FileServiceResponseBean.class);
                    break block6;
                }
                Thresholds thresholds = null;
                return thresholds;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                httpClient.close();
            }
        }
        return resBean != null ? resBean.getThresholds() : null;
    }

    private int setFileServiceThresholds(String reqUrl, Thresholds thresholds) throws IOException {
        block8: {
            FileServiceRequestBean reqBean = new FileServiceRequestBean();
            reqBean.setThresholds(thresholds);
            HttpClientUtil httpClient = new HttpClientUtil(5000);
            try {
                httpClient.openPost(reqUrl);
                httpClient.setRequestBodyJson(reqBean);
                int status = httpClient.send();
                if (status == 200) {
                    FileServiceResponseBean resBean = httpClient.getResponseJsonAsObject(FileServiceResponseBean.class);
                    if (resBean.getStatus() != 0) {
                        int n = resBean.getStatus();
                        return n;
                    }
                    break block8;
                }
                int n = status;
                return n;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                httpClient.close();
            }
        }
        return 0;
    }

    private void addRemoteDownloadTicket(String reqUrl, String ticket, FileProperties fileProperties) throws IOException {
        FileServiceRequestBean reqBean = new FileServiceRequestBean();
        reqBean.setTicket(ticket);
        reqBean.setFileProperties(fileProperties);
        HttpClientUtil httpClient = new HttpClientUtil(5000);
        try {
            httpClient.openPost(reqUrl);
            httpClient.setRequestBodyJson(reqBean);
            int status = httpClient.send();
            if (status == 200) {
                // empty if block
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpClient.close();
        }
    }

    private String generateRemoteDownloadUrl(HttpServletRequest request, String ticket) throws BusinessException {
        V3XFile v3xfile;
        String downUrl = FileServiceUtil.getRequestUrl(FileServiceUtil.RequestTypeEnum.FILE_DOWNLOAD);
        String comm = request.getParameter("comm");
        long fileId = Long.valueOf(request.getParameter("fileId"));
        Date createDate = null;
        String filename = null;
        if ("byFileId".equals(comm)) {
            v3xfile = this.fileManager.getV3XFile(fileId);
            createDate = v3xfile.getCreateDate();
            filename = v3xfile.getFilename();
            try {
                filename = URLEncoder.encode(filename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        } else if ("mobile".equals(request.getParameter("from"))) {
            v3xfile = this.fileManager.getV3XFile(fileId);
            createDate = v3xfile.getCreateDate();
            filename = FileUploadUtil.escapeFileName(v3xfile);
        } else {
            createDate = Datetimes.parseDate(request.getParameter("createDate"));
            filename = FileUtil.getDownloadFileName(request, request.getParameter("filename"));
        }
        downUrl = downUrl + "/" + DateFormatUtils.format((Date)createDate, (String)"yyyy/MM/dd") + "/" + fileId;
        FileProperties fileProperties = new FileProperties();
        fileProperties.setFileId(fileId);
        fileProperties.setFileName(filename);
        try {
            this.addRemoteDownloadTicket(FileServiceUtil.getRequestUrl(FileServiceUtil.RequestTypeEnum.ADD_TICKET), ticket, fileProperties);
        }
        catch (IOException e) {
            return null;
        }
        downUrl = downUrl + "?ticket=" + ticket;
        return downUrl;
    }

    private int updateFileServiceConfig(Thresholds thresholds) throws IOException {
        block9: {
            FileServiceRequestBean reqBean = new FileServiceRequestBean();
            reqBean.setThresholds(thresholds);
            ArrayList<FileServicePartition> partitions = new ArrayList<FileServicePartition>();
            List<Partition> partitionlist = this.partitionManager.getAllPartitions();
            for (Partition originPartition : partitionlist) {
                partitions.add(new FileServicePartition(originPartition));
            }
            reqBean.setPartitionList(partitions);
            HttpClientUtil httpClient = new HttpClientUtil(5000);
            try {
                httpClient.openPost(FileServiceUtil.getRequestUrl(FileServiceUtil.RequestTypeEnum.SET_SERVER_CONFIG));
                httpClient.setRequestBodyJson(reqBean);
                int status = httpClient.send();
                if (status == 200) {
                    FileServiceResponseBean resBean = httpClient.getResponseJsonAsObject(FileServiceResponseBean.class);
                    if (resBean.getStatus() != 0) {
                        int n = resBean.getStatus();
                        return n;
                    }
                    break block9;
                }
                int n = status;
                return n;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                httpClient.close();
            }
        }
        return 0;
    }

    static {
        RTE_type.put("image", "image/jpeg");
        RTE_type.put("flash", "application/x-shockwave-flash");
    }

    private static class FileFieldComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -1350845417478340152L;

        private FileFieldComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            try {
                String keyO1 = o1.substring(4);
                String keyO2 = o2.substring(4);
                String[] indexArrayO1 = keyO1.split("_");
                String[] indexArrayO2 = keyO2.split("_");
                int inputIndexO1 = Integer.valueOf(indexArrayO1[0]);
                int fileIndexO1 = Integer.valueOf(indexArrayO1[1]);
                int inputIndexO2 = Integer.valueOf(indexArrayO2[0]);
                int fileIndexO2 = Integer.valueOf(indexArrayO2[1]);
                if (inputIndexO1 != inputIndexO2) {
                    return inputIndexO1 - inputIndexO2;
                }
                return fileIndexO1 - fileIndexO2;
            }
            catch (Exception e) {
                return o1.compareTo(o2);
            }
        }
    }

    abstract class FileDownloader {
        protected final HttpServletRequest request;
        protected final HttpServletResponse response;
        protected Long fileId = null;
        protected Date createDate = null;
        protected InputStream in = null;
        protected ServletOutputStream out;
        protected String filename = null;
        protected String contentType;
        private V3XFile v3xFile;

        public FileDownloader(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        protected V3XFile getFile() throws BusinessException {
            if (this.v3xFile == null) {
                this.v3xFile = FileUploadController.this.fileManager.getV3XFile(this.fileId);
            }
            return this.v3xFile;
        }

        public ModelAndView download() throws Exception {
            block16: {
                this.request.setCharacterEncoding(FileUploadController.this.contentTypeCharset);
                this.fileId = Long.valueOf(this.request.getParameter("fileId"));
                if (!this.beforeDownload()) {
                    return null;
                }
                this.out = this.response.getOutputStream();
                try {
                    this.contentType = "application/octet-stream";
                    this.getInputstream();
                    if (this.in == null) {
                        if ("m1".equals(this.request.getParameter("from"))) {
                            throw new Exception("FileNoFound");
                        }
                        FileDownloadEvent event = new FileDownloadEvent(this, null, this.fileId, this.request, this.response, FileUploadController.this.fileManager);
                        event.setInputStream(this.in);
                        EventDispatcher.fireEventWithException(event);
                        if (event.getInputStream() == null) {
                            FileUploadController.showError("FileNoFound", null, this.out, this.request, this.response);
                        } else {
                            CoderFactory.getInstance().download(event.getInputStream(), (OutputStream)this.out);
                        }
                        ModelAndView modelAndView = null;
                        return modelAndView;
                    }
                    this.setOutput();
                    FileDownloadEvent event = new FileDownloadEvent(this, this.getFile(), this.fileId, this.request, this.response, FileUploadController.this.fileManager);
                    event.setInputStream(this.in);
                    EventDispatcher.fireEventWithException(event);
                    CoderFactory.getInstance().download(event.getInputStream(), (OutputStream)this.out);
                }
                catch (NoSuchPartitionException e) {
                    log.error((Object)"\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519\uff0c\u5206\u533a\u5f02\u5e38\uff1a", (Throwable)e);
                    FileUploadController.showError(null, e, this.out, this.request, this.response);
                    ModelAndView modelAndView = null;
                    return modelAndView;
                }
                catch (Throwable e) {
                    log.error((Object)"\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519\uff1a", e);
                    if (e.getClass().getSimpleName().equals(FileUploadController.this.clientAbortExceptionName)) {
                        log.debug((Object)("\u7528\u6237\u5173\u95ed\u4e0b\u8f7d\u7a97\u53e3: " + e.getMessage()));
                        break block16;
                    }
                    if ("m1".equals(this.request.getParameter("from"))) {
                        log.error((Object)e.getLocalizedMessage(), e);
                        throw new Exception("FileNoFound");
                    }
                    FileUploadController.showError("Exception", null, this.out, this.request, this.response);
                    ModelAndView modelAndView = null;
                    return modelAndView;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)this.in);
                    IOUtils.closeQuietly((OutputStream)this.out);
                    if ("true".equalsIgnoreCase(this.request.getParameter("deleteFile"))) {
                        log.info((Object)("deleteFile \u9644\u4ef6\u5df2\u88ab\u5220\u9664,\u9644\u4ef6ID===" + this.fileId));
                        FileUploadController.this.fileManager.deleteFile(this.fileId, this.createDate, true);
                    }
                    downloadCounter.end();
                }
            }
            return null;
        }

        protected void setDownloadContentType(HttpServletResponse response, String filename, String mode, String contentType1) {
            boolean isIe7;
            String name = filename.replace(";", "");
            String userAgent = this.request.getHeader("User-Agent");
            boolean bl = isIe7 = userAgent != null && userAgent.toLowerCase().contains("msie 7");
            if (isIe7) {
                response.setContentType(contentType1);
            } else {
                response.setContentType(contentType1 + "; charset=" + FileUploadController.this.contentTypeCharset);
            }
            String fname = name.startsWith("filename=") || name.startsWith("filename*=") ? ";" + name : ";filename=\"" + name + "\"";
            response.setHeader("Content-disposition", mode + fname);
        }

        protected void setFlashContenttype() {
            this.setDownloadContentType(this.response, this.filename, "inline", "application/x-shockwave-flash");
        }

        protected boolean beforeDownload() throws Exception {
            return true;
        }

        abstract void setOutput();

        abstract void getInputstream() throws Exception;
    }
}

