/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload.bean;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.po.filemanager.Partition;
import com.seeyon.ctp.util.Strings;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class FileServicePartition {
    private Long id;
    private String name;
    private String path;
    private Date startDate;
    private Date endDate;
    private Integer state;
    private String localPath;

    public FileServicePartition() {
    }

    public FileServicePartition(Partition originPartition) {
        this.setId(originPartition.getId());
        this.setName(originPartition.getName());
        this.setPath(originPartition.getPath());
        this.setLocalPath(StringUtils.isEmpty((CharSequence)originPartition.getFileServiceSharePath()) ? this.toCanonicalPath(originPartition.getPath()) : originPartition.getFileServiceSharePath());
        this.setStartDate(originPartition.getStartDate());
        this.setEndDate(originPartition.getEndDate());
        this.setState(originPartition.getState());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    private String toCanonicalPath(String path) {
        String p = path;
        p = SystemProperties.interpolateHelper(p, SystemProperties.getInstance().getAllProperties());
        p = Strings.getCanonicalPath(p);
        return p;
    }
}

