/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.formula;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.formula.enums.CATEGORY;
import com.seeyon.ctp.common.formula.enums.DataType;
import com.seeyon.ctp.common.formula.enums.FormulaType;
import com.seeyon.ctp.common.formula.enums.State;
import com.seeyon.ctp.common.formula.manager.FormulaManager;
import com.seeyon.ctp.common.function.CtpFunction;
import com.seeyon.ctp.common.function.CtpFunctionParameter;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.formula.Formula;
import com.seeyon.ctp.common.po.formula.FormulaParam;
import com.seeyon.ctp.common.script.ScriptEvaluator;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormulaUtil {
    private static final Log LOG = LogFactory.getLog(FormulaUtil.class);
    private static final Log SCRIPTLOG = LogFactory.getLog((String)"scriptcompile");
    private static FormulaManager formulaManager;
    public static List<Formula> formulas;
    private static Set<String> SCRIPT_BLACKLIST;
    private static Map<String, Object> realValues;

    public static FormulaManager getFormulaManager() {
        if (formulaManager == null) {
            formulaManager = (FormulaManager)AppContext.getBean("formulaManager");
        }
        return formulaManager;
    }

    public static Map getFormulaContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        if (FormulaUtil.getFormulaManager() != null) {
            List<Formula> allVariable = FormulaUtil.getFormulaManager().getAllVariable();
            for (Formula formula : allVariable) {
                if (FormulaType.Constant.ordinal() != formula.getFormulaType().intValue()) continue;
                context.put(formula.getFormulaName(), formula.getFormulaExpression());
            }
        }
        return context;
    }

    public static void compileFormulas() {
    }

    public static void compileFormulas(Collection<Formula> formulas) throws BusinessException {
        StringBuilder script = new StringBuilder("package com.seeyon.ctp.common.formula.runtime;");
        script.append("import com.seeyon.ctp.common.AppContext;");
        script.append("public class CtpFormula{\n");
        for (Formula formula : formulas) {
            Integer formulaType = formula.getFormulaType();
            if (formulaType.intValue() != FormulaType.GroovyFunction.getKey() && formulaType.intValue() != FormulaType.Variable.getKey()) continue;
            script.append(formula.toString()).append("\n");
        }
        script.append(" def static getVar(name){com.seeyon.ctp.common.formula.FormulaUtil.getVar(name)}");
        script.append("}");
        try {
            String s = script.toString();
            LOG.debug((Object)("\u7f16\u8bd1\u516c\u5f0f\u51fd\u6570\uff1a" + s));
            ScriptEvaluator.getInstance().compile(s);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
    }

    public static boolean isValidate(String script) {
        return false;
    }

    public static Object getVar(String variableName) throws ScriptException, BusinessException {
        FormulaType[] types = new FormulaType[]{FormulaType.Variable, FormulaType.Constant, FormulaType.GroovyFunction};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", types);
        List<Formula> formulaList = FormulaUtil.getFormulaManager().findFormulas(params);
        for (Formula formulaPo : formulaList) {
            if (!formulaPo.getFormulaName().equals(variableName)) continue;
            if (formulaPo.getFormulaType().intValue() == FormulaType.Constant.ordinal()) {
                return FormulaUtil.calculateExpressionValue(formulaPo);
            }
            if (formulaPo.getFormulaType().intValue() != FormulaType.Variable.ordinal() && (formulaPo.getFormulaType().intValue() != FormulaType.GroovyFunction.ordinal() || !Strings.isEmpty(formulaPo.getParams()))) continue;
            return FormulaUtil.calculateExpressionValue(formulaPo);
        }
        return null;
    }

    public static Object calculateExpressionValue(Formula formula) throws ScriptException, BusinessException {
        if (null == formula) {
            return null;
        }
        String expr = formula.getFormulaExpression();
        DataType dataType = DataType.getEnum(formula.getDataType());
        if (FormulaType.Constant.getKey() == formula.getFormulaType().intValue()) {
            switch (dataType) {
                case String: {
                    return expr;
                }
                case Numberic: {
                    return FormulaUtil.eval(expr, Collections.emptyMap());
                }
                case DateTime: {
                    return Datetimes.parse(expr, "yyyy-MM-dd HH:mm");
                }
                case Date: {
                    return Datetimes.parse(expr, "yyyy-MM-dd");
                }
                case Bool: {
                    return Boolean.parseBoolean(expr);
                }
            }
            return null;
        }
        if (FormulaType.Variable.getKey() == formula.getFormulaType().intValue() || FormulaType.GroovyFunction.getKey() == formula.getFormulaType().intValue() && Strings.isEmpty(formula.getParams())) {
            return FormulaUtil.eval(expr, Collections.emptyMap());
        }
        return null;
    }

    public static void updateRealValue(Formula formulaPo) throws ScriptException, BusinessException {
        Object value;
        if (formulaPo.getFormulaType().intValue() == FormulaType.Constant.ordinal() && (value = FormulaUtil.calculateExpressionValue(formulaPo)) != null) {
            realValues.put(formulaPo.getFormulaName(), value);
        }
    }

    public static Formula getVarFormulaByName(String variableName) {
        List<Formula> allVariable = FormulaUtil.getFormulaManager().getAllVariable();
        for (Formula formulaPo : allVariable) {
            if (!formulaPo.getFormulaName().equals(variableName)) continue;
            return formulaPo;
        }
        return null;
    }

    public static boolean isGroovyFunction(Formula formula) throws BusinessException {
        return FormulaType.GroovyFunction.getKey() == formula.getFormulaType().intValue();
    }

    public static boolean isJavaFunction(Formula formula) throws BusinessException {
        return FormulaType.JavaFunction.getKey() == formula.getFormulaType().intValue();
    }

    public static boolean isVaraible(Formula formula) throws BusinessException {
        if (FormulaUtil.isJavaFunction(formula) || FormulaUtil.isGroovyFunction(formula)) {
            return false;
        }
        return !FormulaUtil.isConstant(formula);
    }

    public static boolean isConstant(Formula formula) throws BusinessException {
        if (FormulaUtil.isJavaFunction(formula) || FormulaUtil.isGroovyFunction(formula)) {
            return false;
        }
        try {
            String expr = formula.getFormulaExpression();
            Object value = FormulaUtil.eval(expr, new HashMap());
            return expr.equals(String.valueOf(value)) || expr.equals("\"" + value + "\"");
        }
        catch (ScriptException e) {
            LOG.error((Object)"\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25:", (Throwable)e);
            throw new BusinessException("\u8868\u8fbe\u5f0f\u6821\u9a8c\u5931\u8d25,\u8bf7\u68c0\u67e5\uff01" + e.getLocalizedMessage());
        }
    }

    public static Formula transform(CtpFunction func) {
        Formula formula = new Formula();
        formula.setIdIfNew();
        formula.setFormulaName(func.getAliases());
        formula.setFormulaAlias(func.getTitle());
        formula.setFormulaType(FormulaType.JavaFunction.getKey());
        formula.setReturnType(func.getMethod().getReturnType());
        formula.setDataType(formula.getReturnType());
        formula.setCategory(CATEGORY.Global.getKey());
        formula.setDescription(func.getDescription());
        formula.setState(State.Normal.getKey());
        ArrayList<FormulaParam> params = new ArrayList<FormulaParam>();
        for (CtpFunctionParameter funcParam : func.getParameters()) {
            FormulaParam param = new FormulaParam();
            param.setDescription("");
            param.setName(funcParam.getName());
            params.add(param);
        }
        formula.setParams(params);
        return formula;
    }

    public static void initFunctions(Collection<CtpFunction> functions) {
        for (CtpFunction func : functions) {
            formulas.add(FormulaUtil.transform(func));
        }
    }

    public static void validateFormula(Formula formula) throws BusinessException {
        try {
            if (FormulaType.Variable.getKey() != formula.getFormulaType().intValue()) {
                throw new BusinessException("ctp.formulas.error.notFormualType");
            }
            String expr = formula.getFormulaExpression();
            Object value = FormulaUtil.eval(expr, Collections.emptyMap());
            FormulaUtil.validateReturnType(formula, value);
        }
        catch (ScriptException e) {
            LOG.error((Object)ResourceUtil.getString("ctp.formulas.error.chekcFailed"), (Throwable)e);
            throw new BusinessException("ctp.formulas.error.chekcFailed");
        }
    }

    public static void validateConstant(Formula formula) throws BusinessException {
        if (FormulaType.Constant.getKey() != formula.getFormulaType().intValue()) {
            throw new BusinessException("ctp.formulas.error.notConstantType");
        }
        String expr = formula.getFormulaExpression();
        FormulaUtil.log(expr);
        DataType dataType = DataType.getEnum(formula.getDataType());
        switch (dataType) {
            case String: {
                break;
            }
            case Numberic: {
                String regStr = "^(-?\\d+)(\\.\\d+)?$";
                Pattern pattern = Pattern.compile(regStr);
                Matcher matcher = pattern.matcher(expr);
                if (!matcher.matches()) {
                    throw new BusinessException("ctp.formulas.error.notNumericType");
                }
                try {
                    Object value = FormulaUtil.eval(expr, Collections.emptyMap());
                    if (!(value instanceof Number)) {
                        throw new BusinessException("ctp.formulas.error.notNumericType");
                    }
                    break;
                }
                catch (ScriptException e) {
                    throw new BusinessException("ctp.formulas.error.notNumericType");
                }
            }
            case DateTime: {
                String errInfo = ResourceUtil.getString("ctp.formulas.error.notDatetimeType") + ResourceUtil.getString("ctp.formulas.error.datetimeExample");
                String regStr = "^\\d{4}-\\d{2}-\\d{2}\\s{1,2}\\d{2}:\\d{2}$";
                Pattern pattern = Pattern.compile(regStr);
                Matcher matcher = pattern.matcher(expr);
                if (!matcher.matches()) {
                    throw new BusinessException(errInfo);
                }
                if (null != Datetimes.parse(expr, "yyyy-MM-dd HH:mm")) break;
                throw new BusinessException(errInfo);
            }
            case Date: {
                String errInfo = ResourceUtil.getString("ctp.formulas.error.notDateType") + ResourceUtil.getString("ctp.formulas.error.dateExample");
                String regStr = "^\\d{4}-\\d{2}-\\d{2}$";
                Pattern pattern = Pattern.compile(regStr);
                Matcher matcher = pattern.matcher(expr);
                if (!matcher.matches()) {
                    throw new BusinessException(errInfo);
                }
                if (null != Datetimes.parse(expr, "yyyy-MM-dd")) break;
                throw new BusinessException(errInfo);
            }
            case Bool: {
                String regStr = "^(true)|(false)$";
                Pattern pattern = Pattern.compile(regStr);
                Matcher matcher = pattern.matcher(expr);
                if (matcher.matches()) break;
                throw new BusinessException("ctp.formulas.error.notBooleanType");
            }
            case Object: {
                throw new BusinessException("ctp.formulas.error.unallowedDataType");
            }
            default: {
                throw new BusinessException("ctp.formulas.error.unknownDataType");
            }
        }
    }

    public static boolean validate(Formula formula, String expression, Map context, boolean isSave) throws BusinessException {
        block10: {
            Object obj = null;
            if (formula.getFormulaType().intValue() != FormulaType.GroovyFunction.getKey() && formula.getFormulaType().intValue() != FormulaType.Variable.getKey()) {
                return false;
            }
            try {
                String script = formula.toString() + ";" + expression;
                obj = FormulaUtil.eval(script, context);
                FormulaUtil.validateReturnType(formula, obj);
            }
            catch (ScriptException e) {
                LOG.error((Object)ResourceUtil.getString("ctp.formulas.error.chekcFailed"), (Throwable)e);
                throw new BusinessException("ctp.formulas.error.chekcFailed");
            }
            catch (StackOverflowError e) {
                LOG.error((Object)"\u6821\u9a8cGroovy\u51fd\u6570\u9519\u8bef:", (Throwable)e);
                throw new BusinessException("\u5806\u6808\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u9012\u5f52\u8c03\u7528\u3002");
            }
            if (!isSave && null != formula.getExpectValue()) {
                if (formula.getReturnType().intValue() == DataType.DateTime.getKey() || formula.getReturnType().intValue() == DataType.Date.getKey()) {
                    try {
                        if (!DateUtil.parse(formula.getExpectValue()).equals(obj)) {
                            throw new BusinessException("\u793a\u4f8b\u6821\u9a8c\u6210\u529f,\u68c0\u9a8c\u7ed3\u679c\u4e0e\u671f\u671b\u503c\u4e0d\u7b26,\u8bf7\u68c0\u67e5!");
                        }
                        break block10;
                    }
                    catch (ParseException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        throw new BusinessException("\u793a\u4f8b\u6821\u9a8c\u6210\u529f,\u68c0\u9a8c\u7ed3\u679c\u4e0e\u671f\u671b\u503c\u4e0d\u7b26,\u8bf7\u68c0\u67e5!");
                    }
                }
                if (!obj.toString().equals(formula.getExpectValue())) {
                    throw new BusinessException("\u793a\u4f8b\u6821\u9a8c\u6210\u529f,\u68c0\u9a8c\u7ed3\u679c\u4e0e\u671f\u671b\u503c\u4e0d\u7b26,\u8bf7\u68c0\u67e5!");
                }
            }
        }
        return true;
    }

    private static void validateReturnType(Formula formula, Object result) throws BusinessException {
        DataType dataType = DataType.getEnum(formula.getDataType());
        switch (dataType) {
            case String: {
                if (result instanceof String) break;
                throw new BusinessException("ctp.formulas.error.notTextType");
            }
            case Numberic: {
                if (result instanceof Number) break;
                throw new BusinessException("ctp.formulas.error.notNumericType");
            }
            case DateTime: {
                if (result instanceof Date) break;
                throw new BusinessException("ctp.formulas.error.notDatetimeType");
            }
            case Date: {
                if (result instanceof Date) break;
                throw new BusinessException("ctp.formulas.error.notDateType");
            }
            case Bool: {
                if (result instanceof Boolean) break;
                throw new BusinessException("ctp.formulas.error.notBooleanType");
            }
            case Object: {
                if (result instanceof Object) break;
                throw new BusinessException("ctp.formulas.error.notObjectType");
            }
            default: {
                throw new BusinessException("ctp.formulas.error.unknownDataType");
            }
        }
    }

    private static void log(String script) throws BusinessException {
        for (String keyword : SCRIPT_BLACKLIST) {
            if (script.indexOf(keyword) <= -1) continue;
            throw new BusinessException("\u811a\u672c\u4e2d\u4e0d\u5141\u8bb8\u4f7f\u7528\uff1a" + keyword);
        }
        SCRIPTLOG.info((Object)(Strings.getRemoteAddr(WebUtil.getRequest()) + "," + AppContext.currentUserLoginName() + "," + script));
    }

    public static boolean validate(Formula formula) throws BusinessException {
        if (formula.getFormulaType().intValue() == FormulaType.GroovyFunction.getKey()) {
            return FormulaUtil.validate(formula, formula.getSample(), new HashMap(), false);
        }
        if (formula.getFormulaType().intValue() == FormulaType.Variable.getKey()) {
            Object value;
            String expr = formula.getFormulaExpression();
            try {
                FormulaUtil.log(expr);
                value = ScriptEvaluator.getInstance().eval(expr, new HashMap<String, Object>());
            }
            catch (ScriptException e) {
                LOG.error((Object)"\u6821\u9a8cGroovy\u51fd\u6570\u9519\u8bef:", (Throwable)e);
                throw new BusinessException("\u516c\u5f0f\u6821\u9a8c\u5931\u8d25,\u8bf7\u68c0\u67e5\uff01" + e.getLocalizedMessage());
            }
            catch (StackOverflowError e) {
                LOG.error((Object)"\u6821\u9a8cGroovy\u51fd\u6570\u9519\u8bef:", (Throwable)e);
                throw new BusinessException("\u5806\u6808\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u9012\u5f52\u8c03\u7528\u3002");
            }
            return expr.equals(String.valueOf(value)) || expr.equals("\"" + value + "\"");
        }
        return false;
    }

    public static Object eval(String scriptText, Map context) throws ScriptException, BusinessException {
        FormulaUtil.log(scriptText);
        HashMap<String, Object> ctx = new HashMap<String, Object>(FormulaUtil.getFormulaContext());
        ctx.putAll(context);
        return ScriptEvaluator.getInstance().eval("import com.seeyon.ctp.common.AppContext;import static com.seeyon.ctp.common.formula.runtime.CtpFormula.*;" + scriptText, ctx);
    }

    public static String evalString(String text, Map context) throws ScriptException, BusinessException {
        FormulaUtil.log(text);
        HashMap<String, Object> ctx = new HashMap<String, Object>(FormulaUtil.getFormulaContext());
        ctx.putAll(context);
        return ScriptEvaluator.getInstance().eval("import com.seeyon.ctp.common.AppContext;import static com.seeyon.ctp.common.formula.runtime.CtpFormula.*;\"" + text + "\"", ctx).toString();
    }

    static {
        formulas = new ArrayList<Formula>();
        SCRIPT_BLACKLIST = new HashSet<String>();
        realValues = new ConcurrentHashMap<String, Object>();
        SCRIPT_BLACKLIST.add("System.exit");
        SCRIPT_BLACKLIST.add("Runtime");
        SCRIPT_BLACKLIST.add("ClassLoader");
        SCRIPT_BLACKLIST.add("delete");
        SCRIPT_BLACKLIST.add("JDBCAgent");
        SCRIPT_BLACKLIST.add("Socket");
    }
}

