/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

public class CustomSaver {
    private static final Log log = CtpLogFactory.getLog(CustomSaver.class);
    private Object fileLock = new Object();
    private String customFilePath;
    private Map<Locale, Properties> propFiles = new HashMap<Locale, Properties>();
    private static CustomSaver instance = null;

    private void init() {
        try {
            this.customFilePath = SystemEnvironment.getPartitionPublicFolder() + File.separator + "i18n" + File.pathSeparatorChar;
        }
        catch (BusinessException e) {
            log.error((Object)("\u83b7\u53d6\u5171\u4eab\u76ee\u5f55\u4f4d\u7f6e\u51fa\u9519" + e.getMessage()));
        }
        File customFileDir = new File(this.customFilePath);
        if (!customFileDir.exists()) {
            customFileDir.mkdirs();
        }
        List<Locale> allLocales = LocaleContext.getAllLocales();
        for (Locale locale : allLocales) {
            File propFile = this.getCustomFile(locale);
            if (!propFile.exists() || !propFile.isFile()) continue;
            Properties prop = PropertiesUtil.getFromFile(propFile);
            SortedProperties sortedProp = new SortedProperties();
            sortedProp.putAll((Map<?, ?>)prop);
            this.propFiles.put(locale, sortedProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Locale locale, String key, String value, ResourceInfo info) {
        Object object = this.fileLock;
        synchronized (object) {
            Properties prop = this.propFiles.get(locale);
            if (prop == null) {
                prop = new Properties();
                this.propFiles.put(locale, prop);
            }
            prop.put(key, value);
            File propFile = this.getCustomFile(locale);
            PropertiesUtil.saveToFile(this.propFiles.get(locale), propFile, "");
            info.setFilePath(propFile.getAbsolutePath());
            info.setLevelType("custom");
            info.setRelativePath(this.getRelativePath(locale));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Locale locale, Properties prop) {
        Object object = this.fileLock;
        synchronized (object) {
            this.propFiles.put(locale, prop);
            File propFile = this.getCustomFile(locale);
            PropertiesUtil.saveToFile(prop, propFile, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Locale locale, String key) {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.propFiles.get(locale) != null) {
                this.propFiles.get(locale).remove(key);
                File propFile = this.getCustomFile(locale);
                PropertiesUtil.saveToFile(this.propFiles.get(locale), propFile, "");
            }
        }
    }

    public boolean containsKey(Locale locale, String key) {
        boolean contains = false;
        if (this.propFiles.get(locale) != null) {
            contains = this.propFiles.get(locale).containsKey(key);
        }
        return contains;
    }

    public Set<Map.Entry<Object, Object>> getCustomKey(Locale locale) {
        Map map = this.propFiles.get(locale);
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        return set;
    }

    public File getCustomFile(Locale locale) {
        return new File(this.getCustomPath(locale));
    }

    public String getCustomPath(Locale locale) {
        String path = "";
        try {
            path = SystemEnvironment.getPartitionPublicFolder() + this.getRelativePath(locale);
            File file = new File(path);
            if (!file.exists() && !file.isDirectory()) {
                new File(file.getParent()).mkdirs();
                file.createNewFile();
            }
        }
        catch (BusinessException e) {
            log.error((Object)("\u83b7\u53d6\u5171\u4eab\u76ee\u5f55\u4f4d\u7f6e\u51fa\u9519" + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("\u76ee\u5f55\u4e0d\u5b58\u5728" + e.getMessage()));
        }
        return path;
    }

    public String getRelativePath(Locale locale) {
        return File.separator + "i18n" + File.separator + "custom_" + I18nUtil.getLocalAsString(locale) + ".properties";
    }

    public String getCustomRoot() {
        return this.customFilePath;
    }

    public static CustomSaver getInstance() {
        if (instance == null) {
            instance = new CustomSaver();
            instance.init();
        }
        return instance;
    }

    private CustomSaver() {
    }

    private final class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

