/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.expand.Loader;
import com.seeyon.ctp.common.init.DirOnlyFilter;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.plugin.PluginDefinition;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FileResourceLoader
extends Loader {
    private static final Class c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.common.plugin.PluginSystemInit");
    private static final String LEVEL_TYPE = "plugin";

    public FileResourceLoader(Map<String, ResourceInfo> resourceMap, Locale locale, Set<String> exportJSKeyList, Map<String, List<String>> pluginResourceMap) {
        this.setResourceMap(resourceMap);
        this.setLocale(locale);
        FileResourceLoader.setExportJSKeyList(exportJSKeyList);
        FileResourceLoader.setPluginResourceMap(pluginResourceMap);
    }

    @Override
    public void loadResource() {
        this.loadI18nResources("default", AppContext.getCfgHome(), this.getResourceMap(), null);
        try {
            Method mainMethod = c1.getMethod("getInstance", new Class[0]);
            Object obj = mainMethod.invoke(null, null);
            Method initMethod = c1.getMethod("getPluginDefinitions", new Class[0]);
            List defs = (List)initMethod.invoke(obj, null);
            for (PluginDefinition def : defs) {
                this.loadI18nResources(LEVEL_TYPE, def.getPluginFoler(), this.getResourceMap(), def.getId());
            }
            if ("true".equals(System.getProperty("ctp.mode.test"))) {
                File dir = new File("src/main/webapp/WEB-INF/cfgHome/plugin");
                String[] fs = dir.list();
                for (int i = 0; i < fs.length; ++i) {
                    this.loadI18nResources(LEVEL_TYPE, new File(dir + "/" + fs[i]), this.getResourceMap(), fs[i]);
                }
            }
        }
        catch (Exception e) {
            throw new InfrastructureException(e);
        }
        File componentHome = new File(AppContext.getCfgHome() + "/component");
        if (componentHome.exists()) {
            File[] components;
            for (File file : components = componentHome.listFiles((FileFilter)new DirOnlyFilter())) {
                this.loadI18nResources(LEVEL_TYPE, file, this.getResourceMap(), null);
            }
        }
    }

    @Override
    protected File getI18nBase(File i18nBase) {
        return new File(i18nBase, "i18n");
    }
}

