/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.expand.Loader;
import com.seeyon.ctp.common.i18n.manager.I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class JsI18nLoader
extends Loader {
    private final String DEF_KEY_PATH = "path";
    private final String DEF_KEY_MODULE = "module";
    private final String DEF_KEY_FORMAT = "format";
    private final String DEF_KEY_NAME = "name";
    private final String FORMAT_PARAM_FORMAT = "${format}";
    private static final String LEVEL_TYPE = "default";
    private static final Log log = CtpLogFactory.getLog(JsI18nLoader.class);
    private Locale locale = null;
    private static List<Object> defs = null;

    public JsI18nLoader(Locale locale) {
        this.locale = locale;
    }

    @Override
    protected void loadResource() {
        this.loadJsI18nDefinition();
        if (defs != null) {
            try {
                for (Object def : defs) {
                    String srcRelativePath;
                    Map pathMap = (Map)def;
                    String path = (String)pathMap.get("path");
                    String format = (String)pathMap.get("format");
                    String module = (String)pathMap.get("module");
                    String name = (String)pathMap.get("name");
                    format = this.formatFileName(format, this.locale);
                    String relativePath = path + "/" + name.replace("${format}", format);
                    Map<String, String> items = this.readJSFile(relativePath, srcRelativePath = relativePath + ".src.bak.byauto");
                    if (items.isEmpty()) continue;
                    this.cacheI18n(items, path, relativePath, module, this.locale);
                }
                this.loadCustomJs(this.locale);
            }
            catch (Exception e) {
                log.error((Object)"\u5bfc\u5165js\u56fd\u9645\u5316\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private void loadCustomJs(Locale locale) {
        try {
            String relativePath = File.separator + "i18n" + File.separator + "custom_js_" + I18nUtil.getLocalAsString(locale);
            File path = new File(SystemEnvironment.getPartitionPublicFolder(), relativePath);
            HashMap jsFileData = new HashMap();
            Map<String, String> items = I18nUtil.readCustomJs(path);
            if (!items.isEmpty()) {
                Set<String> keys = items.keySet();
                for (String key : keys) {
                    ResourceInfo oldInfo = I18nResourceCacheHolder.getResourceInfo(locale, key);
                    if (oldInfo == null) continue;
                    String value = items.get(key);
                    String[] keyDivide = key.split("[|]");
                    ResourceInfo info = new ResourceInfo();
                    info.setKey(keyDivide[1]);
                    info.setUniqueKey(key);
                    info.setValue(value);
                    info.setLocale(locale);
                    info.setLevelType("custom");
                    info.setJs(true);
                    info.setFilePath(path.getAbsolutePath());
                    info.setRelativePath(relativePath);
                    I18nResourceCacheHolder.saveOrUpdateResourceInfo(locale, info, false);
                    String srcRelativePath = info.getSrcRelativePath();
                    HashMap<String, String> fileData = (HashMap<String, String>)jsFileData.get(srcRelativePath);
                    if (fileData == null) {
                        fileData = new HashMap<String, String>();
                    }
                    fileData.put(info.getKey(), I18nUtil.escapeJavascript(info.getValue()));
                }
            }
        }
        catch (BusinessException e) {
            log.error((Object)("\u83b7\u53d6\u516c\u5171\u8d44\u6e90\u76ee\u5f55\u5931\u8d25" + e.getMessage()));
        }
    }

    @Override
    protected File getI18nBase(File i18nBase) {
        return null;
    }

    private void cacheI18n(Map<String, String> items, String path, String relativePath, String module, Locale locale) {
        Set<String> keys = items.keySet();
        for (String key : keys) {
            ResourceInfo info = new ResourceInfo();
            info.setKey(key);
            info.setUniqueKey(path + "|" + key);
            info.setValue(items.get(key));
            info.setLocale(locale);
            info.setLevelType(LEVEL_TYPE);
            info.setModule(module);
            info.setModuleName(module);
            info.setJs(true);
            info.setFilePath(SystemEnvironment.getApplicationFolder() + relativePath);
            info.setRelativePath(relativePath);
            I18nResourceCacheHolder.saveOrUpdateResourceInfo(locale, info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readJSFile(String relativePath, String srcRelativePath) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        File srcJsFile = new File(SystemEnvironment.getApplicationFolder(), srcRelativePath);
        File jsFile = new File(SystemEnvironment.getApplicationFolder(), relativePath);
        if (srcJsFile.exists()) {
            if (jsFile.exists()) {
                jsFile.delete();
            }
            FileUtil.copyFile(srcJsFile, jsFile);
        }
        if (jsFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsFile), "UTF-8"));
                String line = null;
                boolean isMultiComment = false;
                boolean isScript = false;
                boolean isInString = false;
                boolean restLast = false;
                char strChar = '\u0000';
                String nameChar = "._$ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
                int level = 0;
                StringBuilder key = new StringBuilder();
                StringBuilder value = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    int last = 32;
                    if (line.length() <= 0) continue;
                    for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (isMultiComment) {
                            if (c == '/' && last == 42) {
                                isMultiComment = false;
                            }
                        } else if (isScript) {
                            if (c == ')') {
                                isScript = false;
                            }
                        } else if (isInString) {
                            if (c == strChar && last != 92) {
                                isInString = false;
                                itemMap.put(key.toString(), value.toString());
                                value.delete(0, value.length());
                                if (level == 0) {
                                    key.delete(0, key.length());
                                } else {
                                    int lastDot = key.lastIndexOf(".");
                                    if (lastDot == -1) {
                                        key.delete(0, key.length());
                                    } else {
                                        key.delete(lastDot + 1, key.length());
                                    }
                                }
                            } else {
                                if (last == 92) {
                                    if (c == '\\') {
                                        restLast = true;
                                    }
                                    value.delete(value.length() - 1, value.length());
                                }
                                value.append(c);
                            }
                        } else if (c == '*' && last == 47) {
                            isMultiComment = true;
                        } else {
                            if (c == '/' && last == 47) {
                                last = 32;
                                continue;
                            }
                            if (c == '(') {
                                isScript = true;
                            } else if (c == '\"' || c == '\'') {
                                isInString = true;
                                strChar = c;
                            } else if (nameChar.indexOf(c) != -1) {
                                key.append(c);
                            } else if (c == ' ' && "var".equals(key.toString())) {
                                key.delete(0, key.length());
                            } else {
                                switch (c) {
                                    case '{': {
                                        ++level;
                                        key.append(".");
                                        break;
                                    }
                                    case '}': {
                                        if (--level == 0) {
                                            key.delete(0, key.length());
                                            break;
                                        }
                                        key.delete(key.length() - 1, key.length());
                                        break;
                                    }
                                }
                            }
                        }
                        if (restLast) {
                            last = 32;
                            restLast = false;
                            continue;
                        }
                        last = c;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
            }
        }
        return itemMap;
    }

    private String formatFileName(String format, Locale loc) {
        String language = loc.getLanguage();
        String country = loc.getCountry();
        String variant = loc.getVariant();
        StringBuilder ret = new StringBuilder(language);
        if (StringUtils.isNotBlank((CharSequence)country)) {
            ret.append(format).append(country);
        }
        if (StringUtils.isNotBlank((CharSequence)variant)) {
            ret.append(format).append(variant);
        }
        return ret.toString().toLowerCase();
    }

    private void loadJsI18nDefinition() {
        if (defs != null) {
            return;
        }
        File defFile = new File(AppContext.getCfgHome(), "/i18n/js_i18n_file_path_def.json");
        Map<String, Object> jsonData = I18nUtil.parseJSONFile(defFile);
        if (jsonData != null) {
            defs = (List)jsonData.get("paths");
        }
    }
}

