/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.config.PropertiesLoader;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.manager.I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.manager.I18nResourceManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public abstract class Loader {
    protected static final Log log = CtpLogFactory.getLog(Loader.class);
    protected static Set<String> exportJSKeyList;
    protected Map<String, ResourceInfo> resourceMap;
    protected static Map<String, List<String>> pluginResourceMap;
    protected static Locale locale;

    protected Locale getLocale() {
        return locale;
    }

    protected void setLocale(Locale locale) {
        Loader.locale = locale;
    }

    protected static Set<String> getExportJSKeyList() {
        return exportJSKeyList;
    }

    protected static void setExportJSKeyList(Set<String> exportJSKeyList) {
        Loader.exportJSKeyList = exportJSKeyList;
    }

    protected static Map<String, List<String>> getPluginResourceMap() {
        return pluginResourceMap;
    }

    protected static void setPluginResourceMap(Map<String, List<String>> pluginResourceMap) {
        Loader.pluginResourceMap = pluginResourceMap;
    }

    protected Map<String, ResourceInfo> getResourceMap() {
        return this.resourceMap;
    }

    protected void setResourceMap(Map<String, ResourceInfo> resourceMap) {
        this.resourceMap = resourceMap;
    }

    protected void loadI18nResources(String levelType, File i18nBase, Map<String, ResourceInfo> resourceMap, String pluginId) {
        String resKey;
        StringTokenizer st;
        String exportJSCfg;
        Properties props;
        ArrayList<String> pluginJSKeyList;
        String prefix = pluginId + ".";
        File i18nBaseHome = this.getI18nBase(i18nBase);
        List<File> listJsFile = Loader.getExportToJsPath(i18nBaseHome, new ArrayList<File>());
        List<String> resources = this.getResources(i18nBaseHome);
        CTPResourceBundleControl control = new CTPResourceBundleControl(i18nBaseHome);
        for (int j = 0; j < resources.size(); ++j) {
            ResourceBundle b;
            String baseName = resources.get(j);
            try {
                b = ResourceBundle.getBundle(baseName, locale, control);
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            String resourceName = control.toResourceName(control.toBundleName(baseName, locale), "properties");
            File f = new File(i18nBaseHome, resourceName);
            if (!f.exists()) continue;
            Iterator<String> iterator = b.keySet().iterator();
            if ("LocaleSelectorResources_zh_CN.properties".equals(f.getName())) {
                HashMap<String, String> resouceLocaleType = new HashMap<String, String>();
                while (iterator.hasNext()) {
                    String resourceKey = iterator.next();
                    String value = b.getString(resourceKey);
                    if (!resourceKey.contains("localeselector.locale")) continue;
                    String rk = resourceKey.substring(resourceKey.lastIndexOf(".") + 1, resourceKey.length());
                    resouceLocaleType.put(rk, value);
                }
                I18nResourceCacheHolder.setResouceLocaleType(resouceLocaleType);
            }
            for (String resourceKey : b.keySet()) {
                ResourceInfo info;
                if (resourceMap.containsKey(resourceKey)) {
                    log.debug((Object)("**** \u91cd\u590d\u5b9a\u4e49\u8d44\u6e90\uff1a" + baseName + "(" + locale + ") -- " + resourceKey));
                }
                String value = b.getString(resourceKey);
                I18nResourceManager i18resourceManager = (I18nResourceManager)AppContext.getBean("i18nResourceManager");
                String basePath = i18nBaseHome.getAbsolutePath();
                if (!basePath.endsWith("/") && !basePath.endsWith("\\")) {
                    basePath = basePath + File.separator;
                }
                if ((info = i18resourceManager.resourceLoaded(locale, levelType, basePath + resourceName, resourceName, resourceKey, value)) == null) continue;
                resourceMap.put(resourceKey, info);
            }
        }
        if (null == pluginId) {
            for (File exportJSConfigFile : listJsFile) {
                pluginJSKeyList = new ArrayList<String>();
                props = PropertiesLoader.load(exportJSConfigFile);
                exportJSCfg = props.getProperty("resKey");
                if (exportJSCfg == null || "".equals(exportJSCfg)) continue;
                st = new StringTokenizer(exportJSCfg.trim(), "|");
                while (st.hasMoreTokens()) {
                    resKey = st.nextToken().trim();
                    if (!exportJSKeyList.contains(resKey)) {
                        exportJSKeyList.add(resKey);
                    }
                    if (pluginJSKeyList.contains(resKey)) continue;
                    pluginJSKeyList.add(resKey);
                }
                pluginId = null == pluginId && "i18n".equals(exportJSConfigFile.getParentFile().getName()) ? "common" : exportJSConfigFile.getParentFile().getName();
                pluginResourceMap.put(pluginId, pluginJSKeyList);
            }
        } else {
            for (File exportJSConfigFile : listJsFile) {
                pluginJSKeyList = new ArrayList();
                props = PropertiesLoader.load(exportJSConfigFile);
                exportJSCfg = props.getProperty("resKey");
                if (exportJSCfg == null || "".equals(exportJSCfg)) continue;
                st = new StringTokenizer(exportJSCfg.trim(), "|");
                while (st.hasMoreTokens()) {
                    resKey = st.nextToken().trim();
                    if (!exportJSKeyList.contains(resKey)) {
                        exportJSKeyList.add(resKey);
                    }
                    if (pluginJSKeyList.contains(resKey)) continue;
                    pluginJSKeyList.add(resKey);
                }
                pluginResourceMap.put(pluginId, pluginJSKeyList);
            }
        }
    }

    protected static List<File> getExportToJsPath(File dir, List<File> list) {
        String fname;
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                String fname2;
                File f = fs[i];
                if (f.isDirectory()) {
                    Loader.getExportToJsPath(f, list);
                    continue;
                }
                if (!f.isFile() || !"export_to_js.xml".equals(fname2 = f.getName())) continue;
                list.add(f);
            }
        } else if (dir.isFile() && "export_to_js.xml".equals(fname = dir.getName())) {
            list.add(dir);
        }
        return list;
    }

    protected List<String> getResources(File i18nHome) {
        List<String> resources;
        if (i18nHome.exists() && i18nHome.isDirectory()) {
            int base = i18nHome.getAbsolutePath().length();
            resources = Loader.searchDirectory(i18nHome, base);
        } else {
            resources = new ArrayList<String>();
        }
        return resources;
    }

    protected static List<String> searchDirectory(File dir, int base) {
        String baseKey = dir.getAbsolutePath().substring(base);
        if (baseKey.length() > 0) {
            baseKey = baseKey + '/';
        }
        ArrayList<String> resources = new ArrayList<String>();
        File[] fs = dir.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            String resKey;
            String fname;
            File f = fs[i];
            if (f.isDirectory()) {
                if (f.getName().compareTo("_ctp_i18n") == 0) continue;
                resources.addAll(Loader.searchDirectory(f, base));
                continue;
            }
            if (!f.isFile() || !(fname = f.getName()).endsWith(".properties")) continue;
            int idx = fname.indexOf(95);
            if (idx == -1) {
                idx = fname.indexOf(46);
            }
            if (resources.contains(resKey = baseKey + fname.substring(0, idx))) continue;
            resources.add(resKey);
        }
        return resources;
    }

    protected abstract void loadResource();

    protected abstract File getI18nBase(File var1);

    protected static class CTPResourceBundleControl
    extends ResourceBundle.Control {
        private File bundleBase;

        public CTPResourceBundleControl(File bundleBase) {
            this.bundleBase = bundleBase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block2: {
                String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
                File f = new File(this.bundleBase, resourceName);
                if (!f.exists()) break block2;
                FileInputStream is = null;
                PropertyResourceBundle bundle = null;
                try {
                    is = new FileInputStream(f);
                    bundle = new PropertyResourceBundle(is);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                return bundle;
            }
            return null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return -1L;
        }
    }
}

