/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.i18n.ResourceCache;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class I18nResourceCacheHolder {
    private static Set<String> moduleCache = new HashSet<String>();
    private static Map<String, String> resouceLocaleType = new ConcurrentHashMap<String, String>();
    private static Map<String, List<Map<Locale, ResourceInfo>>> pcResourceInfo = new ConcurrentHashMap<String, List<Map<Locale, ResourceInfo>>>();
    private static Map<String, String> m3Module2Name = new HashMap<String, String>();

    public static boolean containsKey(String i18nKey) {
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(AppContext.getLocale());
        return map.containsKey(i18nKey);
    }

    public static Map<String, String> getResouceLocaleType() {
        return new HashMap<String, String>(resouceLocaleType);
    }

    public static void setResouceLocaleType(Map<String, String> resouceLocaleType) {
        I18nResourceCacheHolder.resouceLocaleType = resouceLocaleType;
    }

    public static String getLanguageName(String lang) {
        return resouceLocaleType.get(lang);
    }

    public static void saveOrUpdateResourceInfo(Locale locale, ResourceInfo info, boolean isSave) {
        ResourceInfo oldInfo = ResourceCache.getInstance().getResourceInfo(locale, info.getUniqueKey());
        if (oldInfo != null) {
            oldInfo.setValue(info.getValue());
        } else {
            info.setSrcRelativePath(info.getRelativePath());
            I18nResourceCacheHolder.setModuleInfo(info, locale);
            ResourceCache.getInstance().put(locale, info.getUniqueKey(), info);
            info.setLocale(locale);
        }
        if (info.isM3()) {
            m3Module2Name.put(info.getModule(), info.getModuleName());
        } else {
            moduleCache.add(info.getModule());
        }
        if ((ClusterConfigBean.getInstance().isClusterEnabled() || SystemEnvironment.isDistributedMode()) && isSave) {
            NotificationManager.getInstance().send(NotificationType.I18nResourceUpdate, info);
        }
    }

    private static void setModuleInfo(ResourceInfo info, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)info.getModule()) && StringUtils.isNotBlank((CharSequence)info.getModuleName())) {
            return;
        }
        String module = null;
        if ("custom".equals(info.getLevelType())) {
            module = "custom";
        } else {
            String filePath = info.getFilePath();
            String newFilePath = filePath.replace("\\", "/");
            int lastIndex = newFilePath.lastIndexOf("/");
            if (newFilePath.indexOf("_ctp_i18n") != -1) {
                module = "custom";
            } else {
                String suffix;
                module = newFilePath;
                if (lastIndex != -1 && (module = newFilePath.substring(lastIndex + 1, newFilePath.length())).endsWith(suffix = I18nUtil.getLocalAsString(locale) + ".properties")) {
                    module = module.substring(0, module.length() - suffix.length() - 1);
                }
                if (module.startsWith("applog-")) {
                    module = "applog";
                }
            }
        }
        info.setModule(module);
        info.setModuleName(I18nResourceCacheHolder.getModuleName(module));
    }

    public static void removeResourceInfo(Locale locale, ResourceInfo info) {
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(locale);
        if (map != null) {
            map.remove(info.getUniqueKey());
        }
    }

    public static int getResourceSize() {
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(AppContext.getLocale());
        return map.size();
    }

    private static String getModuleName(String module) {
        String name = ResourceUtil.getString("plugin.module2Name." + module);
        if (null != name && name.equals("plugin.module2Name." + module)) {
            name = ResourceUtil.getString("plugin.module2Name.custom");
        }
        return name;
    }

    public static Map<String, String> getAllModule() {
        HashMap<String, String> nameMap = new HashMap<String, String>(moduleCache.size());
        for (String module : moduleCache) {
            nameMap.put(module, I18nResourceCacheHolder.getModuleName(module));
        }
        return nameMap;
    }

    public static ResourceInfo getResourceInfo(Locale locale, String uniqueKey) {
        Assert.notNull((Object)locale, (String)"locale param is null");
        Assert.notNull((Object)uniqueKey, (String)"key param is null");
        return ResourceCache.getInstance().getResourceInfo(locale, uniqueKey);
    }

    public static boolean isM3(String uniqueKye) {
        Assert.notNull((Object)uniqueKye, (String)"key param is null");
        ResourceInfo ret = null;
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(AppContext.getLocale());
        if (map != null) {
            ret = map.get(Integer.toString(0));
        }
        if (ret == null) {
            return false;
        }
        return ret.isM3();
    }

    public static List<ResourceInfo> getResource(Locale locale, boolean m3) {
        ArrayList<ResourceInfo> ret = null;
        ret = new ArrayList<ResourceInfo>(10000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(locale);
        for (String key : map.keySet()) {
            ResourceInfo i = map.get(key);
            if (m3 && i.isM3()) {
                ret.add(i);
                continue;
            }
            if (m3 || i.isM3()) continue;
            ret.add(i);
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> queryResourceByValue(String value, String resourceKey, boolean m3) {
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Set<Locale> locSet = resourceCache.keySet();
        for (Locale locale : locSet) {
            Map<String, ResourceInfo> map = resourceCache.get(locale);
            ResourceInfo s = map.get(resourceKey);
            HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
            item.put(locale, s);
            if (s.getValue().toLowerCase().indexOf(value.toLowerCase()) == -1 && !s.getValue().contains(value)) continue;
            if (m3 && s.isM3()) {
                ret.add(item);
                break;
            }
            if (m3 || s.isM3()) break;
            ret.add(item);
            break;
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> queryResourceByModule(String module, boolean m3) {
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Set<Locale> locSet = resourceCache.keySet();
        for (Locale locale : locSet) {
            HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
            Map<String, ResourceInfo> map = resourceCache.get(locale);
            Iterator<ResourceInfo> iterator = map.values().iterator();
            if (!iterator.hasNext()) continue;
            ResourceInfo s = iterator.next();
            item.put(locale, s);
            if (!module.equals(s.getModule())) continue;
            if (m3 && s.isM3()) {
                ret.add(item);
                continue;
            }
            if (m3 || s.isM3()) continue;
            ret.add(item);
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> queryPCResourceByLevelType(String levelType) {
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Set<Locale> locSet = resourceCache.keySet();
        for (Locale locale : locSet) {
            Map<String, ResourceInfo> map = resourceCache.get(locale);
            for (ResourceInfo s : map.values()) {
                HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
                if (!s.getLevelType().equals(levelType)) continue;
                if (!s.isM3()) {
                    item.put(locale, s);
                }
                ret.add(item);
            }
        }
        return ret;
    }

    public static List<ResourceInfo> queryJsResourceByLevelType(String levelType, Locale locale) {
        ArrayList<ResourceInfo> ret = new ArrayList<ResourceInfo>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(locale);
        for (ResourceInfo s : map.values()) {
            if (s == null || !s.isJs() || !s.getLevelType().equals(levelType)) continue;
            ret.add(s);
        }
        return ret;
    }

    public static List<ResourceInfo> queryM3ResourceByLevelType(String levelType, Locale locale) {
        ArrayList<ResourceInfo> ret = new ArrayList<ResourceInfo>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        Map<String, ResourceInfo> map = resourceCache.get(locale);
        for (ResourceInfo s : map.values()) {
            if (s == null || !s.isM3() || !s.getLevelType().equals(levelType)) continue;
            ret.add(s);
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> queryResourceByKey(String paramKey, boolean m3) {
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        for (Locale loc : resourceCache.keySet()) {
            Map<String, ResourceInfo> map = resourceCache.get(loc);
            HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
            for (String key : map.keySet()) {
                if (paramKey != null && key.toLowerCase().indexOf(paramKey.toLowerCase()) == -1) continue;
                ResourceInfo s = map.get(key);
                item.put(loc, s);
                if (m3 && s.isM3()) {
                    ret.add(item);
                    continue;
                }
                if (m3 || s.isM3()) continue;
                ret.add(item);
            }
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> queryAccurateResourceByKey(String paramKey, boolean m3) {
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>(1000);
        ResourceCache resourceCache = ResourceCache.getInstance();
        for (Locale loc : resourceCache.keySet()) {
            Map<String, ResourceInfo> map = resourceCache.get(loc);
            HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
            for (String key : map.keySet()) {
                ResourceInfo info = map.get(key);
                if (!key.toLowerCase().equals(paramKey.toLowerCase())) continue;
                item.put(loc, info);
                ret.add(item);
            }
        }
        return ret;
    }

    public static List<Map<Locale, ResourceInfo>> listAllResource(boolean m3) {
        ResourceCache resourceCache = ResourceCache.getInstance();
        ArrayList<Map<Locale, ResourceInfo>> ret = new ArrayList<Map<Locale, ResourceInfo>>();
        for (Locale loc : resourceCache.keySet()) {
            Map<String, ResourceInfo> map = resourceCache.get(loc);
            HashMap<Locale, ResourceInfo> item = new HashMap<Locale, ResourceInfo>();
            for (String key : map.keySet()) {
                ResourceInfo info = map.get(key);
                if (m3 && info.isM3()) {
                    item.put(loc, info);
                    ret.add(item);
                    continue;
                }
                if (m3 || info.isM3()) continue;
                item.put(loc, info);
                ret.add(item);
            }
        }
        return ret;
    }

    public static Map<String, Integer> getAllPCResource() {
        Iterator key;
        pcResourceInfo.clear();
        ResourceCache resourceCache = ResourceCache.getInstance();
        Set<Locale> langs = ResourceCache.getInstance().keySet();
        HashMap langI18ns = Maps.newHashMap();
        HashMap i18nMap = Maps.newHashMap();
        for (Locale lang : langs) {
            Map<String, ResourceInfo> cache = resourceCache.get(lang);
            if (!MapUtils.isNotEmpty(cache)) continue;
            for (Map.Entry<String, ResourceInfo> entry : cache.entrySet()) {
                ResourceInfo info = entry.getValue();
                if (info.isM3() || info.isJs()) continue;
                key = info.getKey();
                if (i18nMap.containsKey(key)) {
                    ((Map)i18nMap.get(key)).put(lang, info);
                    continue;
                }
                HashMap map = Maps.newHashMap();
                map.put(lang, info);
                i18nMap.put(key, map);
            }
        }
        HashMap moduleMap = Maps.newHashMap();
        ArrayList<Map> allList = new ArrayList<Map>();
        if (MapUtils.isNotEmpty((Map)i18nMap)) {
            for (Map.Entry entry : i18nMap.entrySet()) {
                Map map = (Map)entry.getValue();
                String module = "";
                key = map.keySet().iterator();
                if (key.hasNext()) {
                    Locale local = (Locale)key.next();
                    module = ((ResourceInfo)map.get(local)).getModule();
                }
                String moduleName = ResourceUtil.getString("plugin.module2Name." + module);
                if (("plugin.module2Name." + module).equals(moduleName) && i18nMap.get(moduleName) == null) {
                    moduleName = ResourceUtil.getString("plugin.module2Name.other");
                }
                if (pcResourceInfo.containsKey(moduleName)) {
                    pcResourceInfo.get(moduleName).add(map);
                    moduleMap.put(moduleName, (Integer)moduleMap.get(moduleName) + 1);
                } else {
                    ArrayList lists = Lists.newArrayList();
                    lists.add(map);
                    pcResourceInfo.put(moduleName, lists);
                    moduleMap.put(moduleName, 1);
                }
                allList.add(map);
            }
            pcResourceInfo.put(ResourceUtil.getString("plugin.module2Name.all"), allList);
            moduleMap.put(ResourceUtil.getString("plugin.module2Name.all"), allList.size());
        }
        return moduleMap;
    }

    public static Map<String, List<Map<Locale, ResourceInfo>>> getPcResourceInfo() {
        return pcResourceInfo;
    }

    public static void setPcResourceInfo(Map<String, List<Map<Locale, ResourceInfo>>> pcResourceInfo) {
        I18nResourceCacheHolder.pcResourceInfo = pcResourceInfo;
    }
}

