/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.log;

import com.seeyon.ctp.common.AppContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class Log4j2XMLConfig {
    private static Log4j2XMLConfig instance = new Log4j2XMLConfig();
    private Map<String, String> defaultLogMap = new LinkedHashMap<String, String>();

    private Log4j2XMLConfig() {
        this.readConfig();
    }

    public static Log4j2XMLConfig getInstance() {
        return instance;
    }

    public Map<String, String> getDefaultLogMap() {
        return this.defaultLogMap;
    }

    private void readConfig() {
        try {
            this.parseLogger();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private void parseLogger() throws ConfigurationException {
        XMLConfiguration config = Log4j2XMLConfig.loadLog4jXML(AppContext.getCfgHome().getAbsolutePath() + "/base/log4j2_sys_running.xml");
        Object logName = config.getProperty("Loggers.AsyncLogger[@name]");
        Object logLevel = config.getProperty("Loggers.AsyncLogger[@level]");
        if (logName instanceof Collection && logLevel instanceof Collection) {
            ArrayList logNameList = (ArrayList)logName;
            ArrayList logLevelList = (ArrayList)logLevel;
            for (int i = 0; i < logNameList.size(); ++i) {
                this.defaultLogMap.put((String)logNameList.get(i), (String)logLevelList.get(i));
            }
        }
    }

    private static XMLConfiguration loadLog4jXML(String fileName) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.setFileName(fileName);
        config.load();
        return config;
    }
}

