/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.controller;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.metadata.MetadataOldUtil;
import com.seeyon.ctp.common.metadata.manager.MetadataColumnManager;
import com.seeyon.ctp.util.ParamUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class MetadataController
extends BaseController {
    private static final String RESPONSE_ENCODING = "UTF-8";
    private MetadataColumnManager metadataColumnManager;

    @Override
    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/plain; charset=UTF-8");
        response.setStatus(200);
        String outStr = "var serverMetadata = " + MetadataOldUtil.toJSON() + ";";
        ServletOutputStream out = response.getOutputStream();
        if (outStr != null) {
            byte[] bout = outStr.getBytes(RESPONSE_ENCODING);
            response.setIntHeader("Content-Length", bout.length);
            out.write(bout);
            out.flush();
            out.close();
        }
        return null;
    }

    public ModelAndView metadataConfig(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("ctp/common/metadata/metadataConfig");
        boolean hasPermission = false;
        String moudleType = request.getParameter("moudleType");
        if ("14".equals(moudleType)) {
            User user = AppContext.getCurrentUser();
            Set userRoles = (Set)user.getProperty("userRoles");
            hasPermission = userRoles != null && (userRoles.contains("AccountAdministrator") || userRoles.contains("GroupAdmin"));
            mav = new ModelAndView("ctp/common/metadata/addressBookMetadataConfig");
        }
        if (!hasPermission) {
            StringBuilder sb = new StringBuilder(ResourceUtil.getStringByParams("loginUserState.wuquanfangwen", new Object[0]));
            BusinessException be = new BusinessException(sb.toString());
            be.setCode("invalid_resource_code");
            be.setFullPage(true);
            throw be;
        }
        return mav;
    }

    public ModelAndView createMetadataColumn(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        Map params = ParamUtil.getJsonDomain("domain_metadata_column");
        Boolean bool = this.metadataColumnManager.createMetadataColumn(params);
        try {
            response.getWriter().print(bool);
        }
        catch (IOException e) {
            throw new BusinessException(e);
        }
        return null;
    }

    public ModelAndView updateMetadataColumn(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        Map params = ParamUtil.getJsonDomain("domain_metadata_column");
        Boolean bool = this.metadataColumnManager.updateCtpMetadataColumn(params);
        try {
            response.getWriter().print(bool);
        }
        catch (IOException e) {
            throw new BusinessException(e);
        }
        return null;
    }

    public ModelAndView memberMetadataColumn(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("ctp/common/metadata/memberMetadataColumn");
        return mav;
    }

    public void setMetadataColumnManager(MetadataColumnManager metadataColumnManager) {
        this.metadataColumnManager = metadataColumnManager;
    }
}

