/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.dao;

import com.seeyon.ctp.common.dao.AbstractHibernateDao;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.dao.MetadataTableDao;
import com.seeyon.ctp.common.metadata.util.HqlBuildUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataTable;
import com.seeyon.ctp.util.DBAgent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MetadataTableDaoImpl
extends AbstractHibernateDao<CtpMetadataTable>
implements MetadataTableDao {
    public static final String CTP_METADATA_TABLE_ALIAS = "cmt";

    @Override
    public CtpMetadataTable getCtpMetadataTableById(Long id) throws BusinessException {
        return (CtpMetadataTable)DBAgent.get(this.entityClass, id);
    }

    @Override
    public CtpMetadataTable findCtpMetadataTableByTableName(String tableName) throws BusinessException {
        CtpMetadataTable ctpMetadataTable = null;
        List<CtpMetadataTable> ctpMetadataTableList = this.findCtpMetadataTableList(tableName, null);
        if (CollectionUtils.isNotEmpty(ctpMetadataTableList)) {
            ctpMetadataTable = ctpMetadataTableList.get(0);
        }
        return ctpMetadataTable;
    }

    @Override
    public List<CtpMetadataTable> findCtpMetadataTableListByApplicationCategory(Integer applicationCategory) throws BusinessException {
        return this.findCtpMetadataTableList(null, applicationCategory);
    }

    @Override
    public List<CtpMetadataTable> findCtpMetadataTableList(String tableName, Integer applicationCategory) throws BusinessException {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            sqlParams.put("tableName", tableName);
        }
        if (applicationCategory != null) {
            sqlParams.put("applicationCategory", applicationCategory);
        }
        return this.findCtpMetadataTableList(sqlParams);
    }

    @Override
    public List<CtpMetadataTable> findCtpMetadataTableList(Map<String, Object> sqlParams) throws BusinessException {
        StringBuilder hqlStr = new StringBuilder();
        hqlStr.append(this.getQueryCtpMetadataTableHql());
        this.buildQueryCtpMetadataTableConditionHql(hqlStr, sqlParams);
        hqlStr.append(" order by createTime asc");
        List ctpMetadataTableList = DBAgent.find(hqlStr.toString(), sqlParams);
        return ctpMetadataTableList;
    }

    @Override
    public List<CtpMetadataTable> findAllCtpMetadataTableList() throws BusinessException {
        StringBuilder hqlStr = new StringBuilder();
        hqlStr.append(this.getQueryCtpMetadataTableHql());
        hqlStr.append(" order by createTime asc");
        List ctpMetadataTableList = DBAgent.find(hqlStr.toString());
        return ctpMetadataTableList;
    }

    private void buildQueryCtpMetadataTableConditionHql(StringBuilder hqlStr, Map<String, Object> sqlParams) {
        if (hqlStr != null && hqlStr.length() != 0 && sqlParams != null && !sqlParams.isEmpty()) {
            for (String key : sqlParams.keySet()) {
                boolean isWhere = hqlStr.toString().indexOf("where") < 0;
                hqlStr.append(HqlBuildUtil.buildConditionHql(isWhere, CTP_METADATA_TABLE_ALIAS, "=", key));
            }
        }
    }

    private String getQueryCtpMetadataTableHql() {
        return HqlBuildUtil.getTableQueryHql(CtpMetadataTable.class.getName(), null, CTP_METADATA_TABLE_ALIAS, null);
    }

    private String getQueryCtpMetadataTableIdHql() {
        String columnName = "id";
        return HqlBuildUtil.getTableQueryHql(CtpMetadataTable.class.getName(), columnName, CTP_METADATA_TABLE_ALIAS, null);
    }
}

