/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.util;

import com.seeyon.ctp.util.Strings;
import org.apache.commons.lang3.StringUtils;

public class HqlBuildUtil {
    public static String buildConditionHql(boolean isWhere, String alias, String connector, String columnStr) {
        StringBuilder condSbr = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)columnStr)) {
            String condJoinStr = isWhere ? " where " : " and ";
            condSbr.append(condJoinStr);
            condSbr.append(alias).append(".").append(columnStr).append(" ");
            condSbr.append(connector);
            if ("in".equals(connector)) {
                condSbr.append(" (:").append(columnStr).append(")");
            } else {
                condSbr.append(" :").append(columnStr);
            }
        }
        return condSbr.toString();
    }

    public static String buildSubqueryHql(String primaryTableHql, String ChildTableHql, String condColumnName) {
        StringBuilder hqlSbr = new StringBuilder();
        hqlSbr.append(primaryTableHql);
        String condJoinStr = primaryTableHql.indexOf("where") > -1 ? " and " : " where ";
        hqlSbr.append(condJoinStr);
        hqlSbr.append(condColumnName);
        hqlSbr.append(" in (");
        hqlSbr.append(ChildTableHql);
        hqlSbr.append(")");
        return hqlSbr.toString();
    }

    public static String getTableQueryHql(String tableName, String columnName, String aliasStr, String funcNames) {
        StringBuilder hqlSbr = new StringBuilder();
        StringBuilder columnStr = new StringBuilder();
        HqlBuildUtil.buildQueryColumn(columnName, aliasStr, columnStr, funcNames);
        HqlBuildUtil.buildQueryHql(columnStr.toString(), tableName, aliasStr, hqlSbr);
        return hqlSbr.toString();
    }

    private static void buildQueryHql(String columnStr, String tableName, String aliasStr, StringBuilder hqlSbr) {
        if (hqlSbr.length() > 0) {
            hqlSbr.delete(0, hqlSbr.length());
        }
        hqlSbr.append("select ");
        hqlSbr.append(columnStr);
        hqlSbr.append(" from ");
        hqlSbr.append(tableName + " ");
        hqlSbr.append(aliasStr);
    }

    private static void buildQueryColumn(String columnName, String aliasStr, StringBuilder columnSbr, String funcNames) {
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            columnSbr.append(aliasStr);
        } else {
            StringBuilder columnStr = new StringBuilder();
            String[] columnNames = columnName.split(",");
            String[] funcNameArray = new String[]{};
            if (Strings.isNotEmpty(funcNames)) {
                funcNameArray = funcNames.split(",");
            }
            for (int i = 0; i < columnNames.length; ++i) {
                StringBuilder columnTempSbr = new StringBuilder();
                columnTempSbr.append(aliasStr);
                columnTempSbr.append(".");
                columnTempSbr.append(columnNames[i]);
                if (funcNameArray.length > 0 && funcNameArray.length > i) {
                    columnStr.append(funcNameArray[i]);
                    columnStr.append("(");
                    columnStr.append(columnTempSbr.toString());
                    columnStr.append(")");
                } else {
                    columnStr.append(columnTempSbr.toString());
                }
                columnStr.append(",");
            }
            columnSbr.append(columnStr.substring(0, columnStr.lastIndexOf(",")));
        }
    }
}

