/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.microserver;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.util.TextEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.support.JdbcUtils;

public class DataTransferServiceUtil {
    private static Log logger = LogFactory.getLog(DataTransferServiceUtil.class);
    private static String servicesConfigFilePath = AppContext.getCfgHome().getAbsolutePath() + File.separator + "base" + File.separator + "services_config.properties";
    private static boolean isLoaded = false;
    public static boolean isOpen = false;
    public static String mainDBVersion = null;
    public static String slaveDBVersion = null;
    public static String ip;
    public static int port;
    public static String frequence;
    public static String startTime;
    public static String endTime;
    public static String dateBefore;
    private static String mainDBUrl;
    private static String mainDBUser;
    private static String mainDBPassword;
    private static String mainDBDirverClassName;
    private static String slaveDBUrl;
    private static String slaveDBUser;
    private static String slaveDBPassword;
    private static String slaveDBDirverClassName;
    private static boolean slaveDBIsOk;
    private static boolean hasLoadDataSourceProperties;

    public static synchronized String getMainDBUrl() {
        if (!hasLoadDataSourceProperties) {
            DataTransferServiceUtil.loadDataSourceProperties();
        }
        return mainDBUrl;
    }

    public static String getMainDBUser() {
        return mainDBUser;
    }

    public static String getMainDBPassword() {
        return mainDBPassword;
    }

    public static String getMainDBDirverClassName() {
        return mainDBDirverClassName;
    }

    public static synchronized String getSlaveDBUrl() {
        if (!hasLoadDataSourceProperties) {
            DataTransferServiceUtil.loadDataSourceProperties();
        }
        return slaveDBUrl;
    }

    public static String getSlaveDBUser() {
        return slaveDBUser;
    }

    public static String getSlaveDBPassword() {
        return slaveDBPassword;
    }

    public static String getSlaveDBDirverClassName() {
        return slaveDBDirverClassName;
    }

    public static boolean fkIsOk() {
        return slaveDBIsOk;
    }

    public static String getRequestUrl() {
        if (!isLoaded) {
            DataTransferServiceUtil.loadProperties();
        }
        return "http://" + (ip.contains(":") ? "[" + ip + "]" : ip) + ":" + port + "/seeyon/dataTransfer/updateConfig";
    }

    public static String getUpgradeRequestUrl() {
        if (!isLoaded) {
            DataTransferServiceUtil.loadProperties();
        }
        return "http://" + (ip.contains(":") ? "[" + ip + "]" : ip) + ":" + port + "/seeyon/dataTransfer/upgradeSlaveDB";
    }

    public static String getRequestVersionUrl() {
        if (!isLoaded) {
            DataTransferServiceUtil.loadProperties();
        }
        return "http://" + (ip.contains(":") ? "[" + ip + "]" : ip) + ":" + port + "/seeyon/dataTransfer/updateConfig";
    }

    public static boolean saveToProperties() {
        boolean success = false;
        FileSystemResource resource = new FileSystemResource(servicesConfigFilePath);
        try {
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            props.setProperty("datatransfer.switch", isOpen ? "on" : "off");
            props.setProperty("datatransfer.service.ip", ip);
            props.setProperty("datatransfer.service.port", String.valueOf(port));
            props.setProperty("datatransfer.strategy.startTime", startTime);
            props.setProperty("datatransfer.strategy.endTime", endTime);
            props.setProperty("datatransfer.strategy.dateBefore", dateBefore);
            props.setProperty("datatransfer.strategy.frequence", frequence);
            props.store(new FileOutputStream(resource.getFile()), "ctp system user update config");
            success = true;
        }
        catch (IOException e) {
            logger.error((Object)"\u4fdd\u5b58\u6570\u636e\u8fc1\u79fb\u914d\u7f6e\u51fa\u9519", (Throwable)e);
        }
        return success;
    }

    public static void loadProperties() {
        FileSystemResource resource = new FileSystemResource(servicesConfigFilePath);
        try {
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            isOpen = "on".equals(props.getProperty("datatransfer.switch"));
            ip = props.getProperty("datatransfer.service.ip");
            port = Integer.parseInt(props.getProperty("datatransfer.service.port"));
            startTime = props.getProperty("datatransfer.strategy.startTime");
            endTime = props.getProperty("datatransfer.strategy.endTime");
            dateBefore = props.getProperty("datatransfer.strategy.dateBefore");
            frequence = props.getProperty("datatransfer.strategy.frequence");
            isLoaded = true;
        }
        catch (IOException e) {
            logger.error((Object)"\u52a0\u8f7d\u6570\u636e\u8fc1\u79fb\u914d\u7f6e\u51fa\u9519", (Throwable)e);
        }
    }

    private static void loadDataSourceProperties() {
        String filepath = System.getProperty("A8.datasource.properies.filepath");
        if (filepath == null) {
            return;
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filepath);
            props.load(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        mainDBUrl = props.getProperty("ctpDataSource.url");
        mainDBUser = props.getProperty("ctpDataSource.username");
        mainDBPassword = TextEncoder.decode(props.getProperty("ctpDataSource.password"));
        mainDBDirverClassName = props.getProperty("ctpDataSource.driverClassName");
        slaveDBUrl = SystemProperties.getInstance().getProperty("fk.db.url");
        slaveDBUser = SystemProperties.getInstance().getProperty("fk.db.username");
        slaveDBPassword = TextEncoder.decode(SystemProperties.getInstance().getProperty("fk.db.password"));
        slaveDBDirverClassName = SystemProperties.getInstance().getProperty("fk.db.driverClassName");
        if (slaveDBDirverClassName == null || "".equals(slaveDBDirverClassName)) {
            slaveDBDirverClassName = "oracle.jdbc.driver.OracleDriver";
        }
        slaveDBIsOk = "on".equals(SystemProperties.getInstance().getProperty("fk.enable"));
        hasLoadDataSourceProperties = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void initialize() {
        if (!hasLoadDataSourceProperties) {
            DataTransferServiceUtil.loadDataSourceProperties();
        }
        Connection conn = null;
        try {
            Class.forName(slaveDBDirverClassName).newInstance();
            conn = DriverManager.getConnection(slaveDBUrl, slaveDBUser, slaveDBPassword);
            String databaseType = conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (databaseType.contains("SQL SERVER")) {
                databaseType = "SQLSERVER";
            }
            ClassPathResource createTalbeSqlRes = new ClassPathResource("sql_fk/" + databaseType + "_CREATE.SQL");
            ClassPathResource createIndexSqlRes = new ClassPathResource("sql_fk/" + databaseType + "_INDEX.SQL");
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            populator.setContinueOnError(true);
            populator.setSqlScriptEncoding("UTF-8");
            populator.addScript((Resource)createTalbeSqlRes);
            populator.addScript((Resource)createIndexSqlRes);
            populator.populate(conn);
        }
        catch (SQLException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            JdbcUtils.closeConnection((Connection)conn);
        }
        catch (Exception e2) {
            logger.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeConnection(conn);
                    throw throwable;
                }
            }
            JdbcUtils.closeConnection((Connection)conn);
        }
        JdbcUtils.closeConnection((Connection)conn);
        mainDBVersion = DataTransferServiceUtil.loadDBVersion(true);
        slaveDBVersion = DataTransferServiceUtil.loadDBVersion(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String loadDBVersion(boolean isMain) {
        String version;
        block17: {
            if (!hasLoadDataSourceProperties) {
                DataTransferServiceUtil.loadDataSourceProperties();
            }
            String sql = "select CONFIG_VALUE from CTP_CONFIG where ID = 5003";
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            version = null;
            try {
                Class.forName(isMain ? mainDBDirverClassName : slaveDBDirverClassName).newInstance();
                conn = isMain ? DriverManager.getConnection(mainDBUrl, mainDBUser, mainDBPassword) : DriverManager.getConnection(slaveDBUrl, slaveDBUser, slaveDBPassword);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                boolean hasRecord = false;
                if (rs.next()) {
                    hasRecord = true;
                    version = rs.getString(1);
                } else if (!isMain) {
                    try {
                        stmt.executeQuery("select count(SUMMARY_STATE) from CTP_AFFAIR");
                    }
                    catch (Exception e1) {
                        logger.warn((Object)"\u5206\u5e93\u7248\u672c\u4e3a6.1\uff0c\u9700\u8981\u5347\u7ea7");
                        version = "V6.1";
                        stmt.execute("insert into CTP_CONFIG(ID,CONFIG_VALUE)values(5003,'V6.1')");
                    }
                }
                if (!isMain && version == null) {
                    version = mainDBVersion;
                    logger.warn((Object)"\u5206\u5e93\u521d\u6b21\u5b89\u88c5\uff0c\u7248\u672c\u53f7\u8bbe\u7f6e\u4e3a\u4e3b\u5e93\u5bf9\u5e94\u7248\u672c\u53f7");
                    if (hasRecord) {
                        stmt.execute("update CTP_CONFIG set CONFIG_VALUE='" + mainDBVersion + "' where ID=5003");
                    } else {
                        stmt.execute("insert into CTP_CONFIG(ID,CONFIG_VALUE)values(5003,'" + mainDBVersion + "')");
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
            catch (SQLException e) {
                if (!isMain) {
                    version = "V6.1";
                    logger.warn((Object)"\u51fa\u73b0\u5f02\u5e38\uff0c\u5206\u5e93\u7248\u672c\u53f7\u8bbe\u7f6e\u4e3a6.1", (Throwable)e);
                }
                break block17;
            }
            catch (Exception e2) {
                logger.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection((Connection)conn);
                break block17;
            }
            finally {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(conn);
            }
            JdbcUtils.closeStatement((Statement)stmt);
            JdbcUtils.closeConnection((Connection)conn);
        }
        return version;
    }

    static {
        slaveDBIsOk = false;
        hasLoadDataSourceProperties = false;
        DataTransferServiceUtil.loadProperties();
    }
}

