/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.microserver;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.PlatformConfigItem;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.microserver.DataTransferServiceUtil;
import com.seeyon.ctp.common.microserver.MicroServiceResponseBean;
import com.seeyon.ctp.common.microserver.MicroServiceStatusCode;
import com.seeyon.ctp.common.microserver.datatransfer.DataSourceConfig;
import com.seeyon.ctp.common.microserver.datatransfer.DataTransferRequestBean;
import com.seeyon.ctp.common.microserver.datatransfer.TransferStrategy;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.HttpClientUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class MicroServiceController
extends BaseController {
    private static final Log log = CtpLogFactory.getLog(MicroServiceController.class);

    public ModelAndView getDataTransferCofig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = AppContext.getCurrentUser();
        if (user != null && !user.isSystemAdmin()) {
            StringBuilder sb = new StringBuilder(ResourceUtil.getStringByParams("loginUserState.wuquanfangwen", new Object[0]));
            BusinessException be = new BusinessException(sb.toString());
            be.setCode("invalid_resource_code");
            be.setFullPage(true);
            throw be;
        }
        ModelAndView modelAndView = new ModelAndView("ctp/common/serverconfig/datatransfer");
        this.loadOriginConfig(modelAndView);
        if (DataTransferServiceUtil.isOpen && !DataTransferServiceUtil.mainDBVersion.equals(DataTransferServiceUtil.slaveDBVersion)) {
            DataTransferServiceUtil.slaveDBVersion = DataTransferServiceUtil.loadDBVersion(false);
        }
        modelAndView.addObject("mainDBVersion", (Object)DataTransferServiceUtil.mainDBVersion);
        modelAndView.addObject("slaveDBVersion", (Object)DataTransferServiceUtil.slaveDBVersion);
        modelAndView.addObject("isSameVersion", (Object)DataTransferServiceUtil.mainDBVersion.equals(DataTransferServiceUtil.slaveDBVersion));
        modelAndView.addObject("lastDate", (Object)this.getLastDate());
        return modelAndView;
    }

    public ModelAndView upgradeSlaveDatabase(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = AppContext.getCurrentUser();
        if (user != null && !user.isSystemAdmin()) {
            StringBuilder sb = new StringBuilder(ResourceUtil.getStringByParams("loginUserState.wuquanfangwen", new Object[0]));
            BusinessException be = new BusinessException(sb.toString());
            be.setCode("invalid_resource_code");
            be.setFullPage(true);
            throw be;
        }
        ModelAndView modelAndView = new ModelAndView("ctp/common/serverconfig/datatransfer");
        DataTransferRequestBean reqBean = new DataTransferRequestBean();
        DataSourceConfig mainDataSourceConfig = new DataSourceConfig();
        mainDataSourceConfig.setUrl(DataTransferServiceUtil.getMainDBUrl());
        mainDataSourceConfig.setUserName(DataTransferServiceUtil.getMainDBUser());
        mainDataSourceConfig.setPassword(DataTransferServiceUtil.getMainDBPassword());
        mainDataSourceConfig.setDriverClassName(DataTransferServiceUtil.getMainDBDirverClassName());
        reqBean.setMainDataSourceConfig(mainDataSourceConfig);
        DataSourceConfig slaveDataSourceConfig = new DataSourceConfig();
        slaveDataSourceConfig.setUrl(DataTransferServiceUtil.getSlaveDBUrl());
        slaveDataSourceConfig.setUserName(DataTransferServiceUtil.getSlaveDBUser());
        slaveDataSourceConfig.setPassword(DataTransferServiceUtil.getSlaveDBPassword());
        slaveDataSourceConfig.setDriverClassName(DataTransferServiceUtil.getSlaveDBDirverClassName());
        reqBean.setSlaveDataSourceConfig(slaveDataSourceConfig);
        try {
            int status = this.notifyUpgradeSlaveDB(DataTransferServiceUtil.getUpgradeRequestUrl(), reqBean);
            if (status != 0) {
                modelAndView.addObject("showMsg", (Object)MicroServiceStatusCode.getDesc(status));
            } else {
                modelAndView.addObject("showMsg", (Object)"menu.system.microservice.datatransfer.up.success");
                DataTransferServiceUtil.slaveDBVersion = DataTransferServiceUtil.mainDBVersion;
            }
        }
        catch (IOException e) {
            modelAndView.addObject("showMsg", (Object)"menu.system.service.datatransfer.connect.fail");
            log.warn((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u6570\u636e\u8fc1\u79fb\u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
        }
        this.loadOriginConfig(modelAndView);
        modelAndView.addObject("mainDBVersion", (Object)DataTransferServiceUtil.mainDBVersion);
        modelAndView.addObject("slaveDBVersion", (Object)DataTransferServiceUtil.slaveDBVersion);
        modelAndView.addObject("isSameVersion", (Object)DataTransferServiceUtil.mainDBVersion.equals(DataTransferServiceUtil.slaveDBVersion));
        modelAndView.addObject("lastDate", (Object)this.getLastDate());
        return modelAndView;
    }

    public ModelAndView updateDataTransferCofig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView;
        block15: {
            modelAndView = new ModelAndView("ctp/common/serverconfig/datatransfer");
            String flag = request.getParameter("flag");
            String serverIp = request.getParameter("serverIp");
            int serverPort = Integer.parseInt(request.getParameter("serverPort"));
            String dailyFlag = request.getParameter("dailyFlag");
            String startHour = request.getParameter("startHour");
            String startMinute = request.getParameter("startMinute");
            String endHour = request.getParameter("endHour");
            String endMinute = request.getParameter("endMinute");
            String dateBefore = request.getParameter("dateBefore");
            modelAndView.addObject("flag", (Object)flag);
            modelAndView.addObject("serverIp", (Object)serverIp);
            modelAndView.addObject("serverPort", (Object)serverPort);
            modelAndView.addObject("dailyFlag", (Object)dailyFlag);
            modelAndView.addObject("startHour", (Object)startHour);
            modelAndView.addObject("startMinute", (Object)startMinute);
            modelAndView.addObject("endHour", (Object)endHour);
            modelAndView.addObject("endMinute", (Object)endMinute);
            modelAndView.addObject("dateBefore", (Object)dateBefore);
            modelAndView.addObject("lastDate", (Object)this.getLastDate());
            modelAndView.addObject("showMsg", (Object)"menu.system.service.setting.ok");
            modelAndView.addObject("mainDBVersion", (Object)DataTransferServiceUtil.mainDBVersion);
            modelAndView.addObject("slaveDBVersion", (Object)DataTransferServiceUtil.slaveDBVersion);
            modelAndView.addObject("isSameVersion", (Object)DataTransferServiceUtil.mainDBVersion.equals(DataTransferServiceUtil.slaveDBVersion));
            if (!"on".equals(flag) && StringUtils.isEmpty((CharSequence)serverIp)) {
                return modelAndView;
            }
            log.info((Object)("\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\uff0c\u670d\u52a1\u5730\u5740\uff1a" + serverIp + ":" + serverPort + " \u72b6\u6001\uff1a" + ("on".equals(flag) ? "\u5f00\u542f" : "\u5173\u95ed") + " \u5468\u671f\uff1a" + ("off".equals(dailyFlag) ? "\u7acb\u5373\u6267\u884c" : "\u6bcf\u5929\u6267\u884c") + "..."));
            DataTransferServiceUtil.isOpen = "on".equals(flag);
            DataTransferServiceUtil.ip = serverIp;
            DataTransferServiceUtil.port = serverPort;
            DataTransferServiceUtil.frequence = "off".equals(dailyFlag) ? "immediatly" : "daily";
            DataTransferServiceUtil.startTime = startHour + ":" + startMinute;
            DataTransferServiceUtil.endTime = endHour + ":" + endMinute;
            DataTransferServiceUtil.dateBefore = dateBefore;
            if (StringUtils.isNotEmpty((CharSequence)serverIp)) {
                DataTransferRequestBean reqBean = new DataTransferRequestBean();
                DataSourceConfig mainDataSourceConfig = new DataSourceConfig();
                mainDataSourceConfig.setUrl(DataTransferServiceUtil.getMainDBUrl());
                mainDataSourceConfig.setUserName(DataTransferServiceUtil.getMainDBUser());
                mainDataSourceConfig.setPassword(DataTransferServiceUtil.getMainDBPassword());
                mainDataSourceConfig.setDriverClassName(DataTransferServiceUtil.getMainDBDirverClassName());
                reqBean.setMainDataSourceConfig(mainDataSourceConfig);
                DataSourceConfig slaveDataSourceConfig = new DataSourceConfig();
                slaveDataSourceConfig.setUrl(DataTransferServiceUtil.getSlaveDBUrl());
                slaveDataSourceConfig.setUserName(DataTransferServiceUtil.getSlaveDBUser());
                slaveDataSourceConfig.setPassword(DataTransferServiceUtil.getSlaveDBPassword());
                slaveDataSourceConfig.setDriverClassName(DataTransferServiceUtil.getSlaveDBDirverClassName());
                reqBean.setSlaveDataSourceConfig(slaveDataSourceConfig);
                TransferStrategy transferStrategy = new TransferStrategy();
                transferStrategy.setStop(!DataTransferServiceUtil.isOpen);
                transferStrategy.setAbsoluteTime(true);
                transferStrategy.setDateBefore(DataTransferServiceUtil.dateBefore);
                if ("immediatly".equals(DataTransferServiceUtil.frequence)) {
                    transferStrategy.setExecuteImmediately(true);
                } else {
                    transferStrategy.setExecuteImmediately(false);
                    transferStrategy.setStartCron(this.convertTimeToCronStr(DataTransferServiceUtil.startTime));
                    transferStrategy.setEndCron(this.convertTimeToCronStr(DataTransferServiceUtil.endTime));
                }
                reqBean.setTransferStrategy(transferStrategy);
                try {
                    int status = this.notifyDataTransfer(DataTransferServiceUtil.getRequestUrl(), reqBean);
                    if (status != 0) {
                        if (status == 404) {
                            log.info((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u8bbe\u7f6e\u5931\u8d25\uff01\u6570\u636e\u8fc1\u79fb\u670d\u52a1\u8bbe\u7f6e\u9519\u8bef");
                        } else if (status == 601) {
                            log.info((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u8bbe\u7f6e\u5931\u8d25\uff01 \u6570\u636e\u8fc1\u79fb\u670d\u52a1\u8fde\u63a5\u4e3b\u6216\u5206\u5e93\u5f02\u5e38\uff0c\u5177\u4f53\u89c1\u6570\u636e\u8fc1\u79fb\u670d\u52a1\u65e5\u5fd7");
                        } else {
                            log.info((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u8bbe\u7f6e\u5931\u8d25\uff01 \u672a\u77e5\u9519\u8bef\uff0c\u5177\u4f53\u89c1\u6570\u636e\u8fc1\u79fb\u670d\u52a1\u65e5\u5fd7");
                        }
                        if (status == 602) {
                            modelAndView.addObject("confirmMsg", (Object)MicroServiceStatusCode.getDesc(status));
                            modelAndView.addObject("showMsg", null);
                        } else {
                            modelAndView.addObject("showMsg", (Object)MicroServiceStatusCode.getDesc(status));
                        }
                        DataTransferServiceUtil.loadProperties();
                        this.loadOriginConfig(modelAndView);
                        return modelAndView;
                    }
                    break block15;
                }
                catch (IOException e) {
                    modelAndView.addObject("showMsg", (Object)"menu.system.service.datatransfer.connect.fail");
                    log.warn((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u6570\u636e\u8fc1\u79fb\u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
                    DataTransferServiceUtil.loadProperties();
                    this.loadOriginConfig(modelAndView);
                    return modelAndView;
                }
            }
            DataTransferServiceUtil.isOpen = false;
        }
        if (!DataTransferServiceUtil.saveToProperties()) {
            modelAndView.addObject("showMsg", (Object)"menu.system.service.properties.update.fail");
            log.info((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u66f4\u65b0\u7b56\u7565\u5931\u8d25\uff01");
            DataTransferServiceUtil.loadProperties();
            this.loadOriginConfig(modelAndView);
        } else {
            log.info((Object)"\u8bbe\u7f6e\u6570\u636e\u8fc1\u79fb\u4efb\u52a1,\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        return modelAndView;
    }

    public ModelAndView getPlatformConfig(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView("ctp/common/serverconfig/unite_config");
        Map<String, List<PlatformConfigItem>> configMap = PlatformConfigUtil.getAllPlatformConfig();
        modelAndView.addObject("configMap", configMap);
        return modelAndView;
    }

    public synchronized ModelAndView updatePlatformConfig(HttpServletRequest request, HttpServletResponse response) {
        Properties props = new Properties();
        Enumeration paramKeys = request.getParameterNames();
        while (paramKeys.hasMoreElements()) {
            String key = (String)paramKeys.nextElement();
            if (!this.isConfigKey(key)) continue;
            String[] typeAndId = key.split("-");
            props.put(typeAndId[1], request.getParameter(key));
        }
        if (PlatformConfigUtil.isNeedPublishConfig()) {
            PlatformConfigUtil.publishConfig();
        }
        ModelAndView modelAndView = new ModelAndView("ctp/common/serverconfig/unite_config");
        Map<String, List<PlatformConfigItem>> configMap = PlatformConfigUtil.getAllPlatformConfig();
        for (Map.Entry<String, List<PlatformConfigItem>> entry : configMap.entrySet()) {
            for (PlatformConfigItem configItem : entry.getValue()) {
                if (!props.containsKey(configItem.getKey())) continue;
                configItem.setValue(props.getProperty(configItem.getKey()));
            }
        }
        PlatformConfigUtil.saveConfig(configMap);
        modelAndView.addObject("configMap", configMap);
        modelAndView.addObject("save_flag", (Object)"1");
        return modelAndView;
    }

    private boolean isConfigKey(String key) {
        String[] kArray = key.split("-");
        if (kArray.length == 2) {
            try {
                int appTypeInt = Integer.parseInt(kArray[0]);
                if (appTypeInt > 0 && appTypeInt < 65535) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void loadOriginConfig(ModelAndView modelAndView) {
        String[] endHourMinute;
        String[] startHourMinute;
        modelAndView.addObject("flag", (Object)(DataTransferServiceUtil.isOpen ? "on" : "off"));
        modelAndView.addObject("serverIp", (Object)DataTransferServiceUtil.ip);
        modelAndView.addObject("serverPort", (Object)DataTransferServiceUtil.port);
        modelAndView.addObject("dailyFlag", (Object)("immediatly".equals(DataTransferServiceUtil.frequence) ? "off" : "on"));
        if (DataTransferServiceUtil.startTime != null && (startHourMinute = DataTransferServiceUtil.startTime.split(":")).length == 2) {
            modelAndView.addObject("startHour", (Object)startHourMinute[0]);
            modelAndView.addObject("startMinute", (Object)startHourMinute[1]);
        }
        if (DataTransferServiceUtil.endTime != null && (endHourMinute = DataTransferServiceUtil.endTime.split(":")).length == 2) {
            modelAndView.addObject("endHour", (Object)endHourMinute[0]);
            modelAndView.addObject("endMinute", (Object)endHourMinute[1]);
        }
        modelAndView.addObject("dateBefore", (Object)DataTransferServiceUtil.dateBefore);
    }

    private int notifyDataTransfer(String reqUrl, DataTransferRequestBean dataTransferBean) throws IOException {
        block8: {
            HttpClientUtil httpClient = new HttpClientUtil(10000);
            try {
                httpClient.openPost(reqUrl);
                httpClient.setRequestBodyJson(dataTransferBean);
                int status = httpClient.send();
                if (status == 200) {
                    MicroServiceResponseBean resBean = httpClient.getResponseJsonAsObject(MicroServiceResponseBean.class);
                    if (resBean.getStatus() != 0) {
                        int n = resBean.getStatus();
                        return n;
                    }
                    break block8;
                }
                int n = status;
                return n;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                httpClient.close();
            }
        }
        return 0;
    }

    private int notifyUpgradeSlaveDB(String reqUrl, DataTransferRequestBean dataTransferBean) throws IOException {
        block8: {
            HttpClientUtil httpClient = new HttpClientUtil(10000, 0);
            try {
                httpClient.openPost(reqUrl);
                httpClient.setRequestBodyJson(dataTransferBean);
                int status = httpClient.send();
                if (status == 200) {
                    MicroServiceResponseBean resBean = httpClient.getResponseJsonAsObject(MicroServiceResponseBean.class);
                    if (resBean.getStatus() != 0) {
                        int n = resBean.getStatus();
                        return n;
                    }
                    break block8;
                }
                int n = status;
                return n;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                httpClient.close();
            }
        }
        return 0;
    }

    private String convertTimeToCronStr(String time) {
        String[] timeArray = time.split(":");
        return "0 " + timeArray[1] + " " + timeArray[0] + " * * ?";
    }

    private String getLastDate() {
        return Datetimes.format(Datetimes.addYear(new Date(), -2), "yyyy-MM-dd");
    }
}

