/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.monitor;

import com.seeyon.ctp.common.log.RollingDailyFileAppender;
import com.seeyon.ctp.common.monitor.DuplicateSqlInfo;
import com.seeyon.ctp.common.monitor.MonitorBuffer;
import com.seeyon.ctp.util.UUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

public class DuplicateSqlMonitorBuffer
implements MonitorBuffer {
    private static final Log logger = LogFactory.getLog(DuplicateSqlMonitorBuffer.class);
    public static String BufferType_DuplicateSQL = "Monitor_DuplicateSQL";
    private Map<String, List<DuplicateSqlInfo>> buffer = new ConcurrentHashMap<String, List<DuplicateSqlInfo>>();
    private static DuplicateSqlMonitorBuffer instance = new DuplicateSqlMonitorBuffer();

    public static DuplicateSqlMonitorBuffer getInstnace() {
        return instance;
    }

    private DuplicateSqlMonitorBuffer() {
        RollingDailyFileAppender appender = (RollingDailyFileAppender)Logger.getLogger((String)"monitor.sql").getAppender("sqlmonitor");
        try {
            String fileName = appender.getFile();
            appender.setFile(fileName.substring(0, fileName.length() - 4) + "_" + UUIDGenerator.currentDateTime() + ".log", true, false, appender.getBufferSize());
            File f = new File(fileName);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u5207\u6362\u65e5\u5fd7\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef" + e));
        }
    }

    @Override
    public String getBufferType() {
        return BufferType_DuplicateSQL;
    }

    @Override
    public int addBuffer(String key, String ... value) {
        List<DuplicateSqlInfo> list = this.buffer.get(key);
        String[] values = value;
        if (list != null) {
            for (DuplicateSqlInfo info : list) {
                if (info.getSqlInfo().length() != values[0].length() || info.getSqlInfo().compareTo(values[0]) != 0) continue;
                info.setDuplicateNumber(info.getDuplicateNumber() + 1);
                return -1;
            }
            list.add(new DuplicateSqlInfo(values[0], values[1]));
            return list.size();
        }
        list = new ArrayList<DuplicateSqlInfo>();
        list.add(new DuplicateSqlInfo(values[0], values[1]));
        this.buffer.put(key, list);
        return list.size();
    }

    @Override
    public List<DuplicateSqlInfo> getBuffer(String key) {
        return this.buffer.get(key);
    }
}

