/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.manager;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.filemanager.manager.Util;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@ProcessInDataSource(name=DataSourceName.BASE)
public class SeeyonOfficeTransManagerImpl {
    private static final Log log = CtpLogFactory.getLog(SeeyonOfficeTransManagerImpl.class);
    private OfficeTransManager officeTransManager;
    private FileManager fileManager;

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public OfficeTransManager getOfficeTransManager() {
        return this.officeTransManager;
    }

    public void setOfficeTransManager(OfficeTransManager officeTransManager) {
        this.officeTransManager = officeTransManager;
    }

    public boolean isExistForNewOfficeTrans(long id, String date) throws BusinessException {
        File targetFile = this.getFileForNewOfficeTrans(id, date);
        File parentDir = targetFile.getParentFile();
        String transedFileName = targetFile.getName() + ".pdf.seeyon";
        String transedSwfFileName = targetFile.getName() + ".swf.seeyon";
        String transedPageFileName = targetFile.getName() + "_1.swf.seeyon";
        boolean isPdfFileExist = new File(parentDir, transedFileName).exists();
        boolean isSwfFileExist = new File(parentDir, transedSwfFileName).exists();
        boolean isPageSwfFileExist = new File(parentDir, transedPageFileName).exists();
        boolean isExist = isPdfFileExist && (isSwfFileExist || isPageSwfFileExist);
        String targetFileName = targetFile.getName();
        boolean isExcelHtmlExist = false;
        if (targetFileName.toLowerCase().endsWith("xls") || targetFileName.toLowerCase().endsWith("xlsx")) {
            isExcelHtmlExist = new File(parentDir, id + ".html").exists();
        }
        return isExist || isExcelHtmlExist;
    }

    public File getFileForNewOfficeTrans(long id, String date) throws BusinessException {
        String outputPath = this.officeTransManager.getOfficeTransCacheFolder();
        File cacheFile = null;
        File fileInTemp = this.fileManager.getFile(id);
        File outPutCacheDir = new File(outputPath + File.separator + date + File.separator + id);
        boolean jingeFlag = false;
        if (fileInTemp != null && fileInTemp.exists()) {
            V3XFile v3xFile = this.fileManager.getV3XFile(id);
            String miniType = v3xFile.getMimeType();
            String realFileName = v3xFile.getFilename();
            String realFileNameLowerCase = realFileName.toLowerCase();
            String fileName = new Long(id).toString();
            if (realFileNameLowerCase.endsWith(".doc")) {
                fileName = fileName + ".doc";
            } else if (realFileNameLowerCase.endsWith(".docx")) {
                fileName = fileName + ".docx";
            } else if (realFileNameLowerCase.endsWith(".xls")) {
                fileName = fileName + ".xls";
            } else if (realFileNameLowerCase.endsWith(".xlsx")) {
                fileName = fileName + ".xlsx";
            } else if (realFileNameLowerCase.endsWith(".ppt")) {
                fileName = fileName + ".ppt";
            } else if (realFileNameLowerCase.endsWith(".pptx")) {
                fileName = fileName + ".pptx";
            } else if (!realFileNameLowerCase.contains(".")) {
                if ("application/msword".equals(miniType)) {
                    fileName = fileName + ".doc";
                    jingeFlag = true;
                } else if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(miniType)) {
                    fileName = fileName + ".docx";
                    jingeFlag = true;
                } else if ("application/vnd.ms-excel".equals(miniType)) {
                    fileName = fileName + ".xls";
                    jingeFlag = true;
                } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(miniType)) {
                    fileName = fileName + ".xlsx";
                    jingeFlag = true;
                } else if ("application/vnd.openxmlformats-officedocument.presentationml.presentation".equals(miniType)) {
                    fileName = fileName + ".pptx";
                    jingeFlag = true;
                } else if ("application/vnd.ms-powerpoint".equals(miniType)) {
                    fileName = fileName + ".ppt";
                    jingeFlag = true;
                } else {
                    log.info((Object)("fileId=" + id + ",\u540e\u7f00\u540d\u65e0\u6cd5\u5339\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u8f6c\u6362\uff01\uff01"));
                }
            }
            cacheFile = new File(outPutCacheDir, fileName);
            if (!cacheFile.exists()) {
                try {
                    FileUtils.copyFile((File)fileInTemp, (File)cacheFile);
                    if (jingeFlag) {
                        Util.jinge2StandardOffice(fileInTemp.getAbsolutePath(), cacheFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.fillInStackTrace());
                    cacheFile = null;
                }
            }
        }
        return cacheFile;
    }

    public String getShowUrlForNewOfficeTrans(File file, Long fileId, String date) {
        String host = this.officeTransManager.getOfficeTransHost();
        int port = this.officeTransManager.getOfficeTransPort();
        String outPutPath = this.officeTransManager.getOfficeTransCacheFolder();
        StringBuffer buffer = new StringBuffer("http://");
        buffer.append(host).append(":").append(port).append("/JLibrary/ConvertServlet?filePath=");
        String filePathUTF8 = "";
        try {
            String filePath = outPutPath + ";" + date + ";" + fileId + ";" + file.getName();
            filePathUTF8 = URLEncoder.encode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.fillInStackTrace());
        }
        buffer.append(filePathUTF8);
        log.info((Object)("\u5f00\u59cb\u8fdb\u884c\u6587\u4ef6\u8f6c\u6362\uff1a" + buffer.toString()));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransToServer(long fileId, long datenumber) throws BusinessException {
        Date d = new Date(datenumber);
        File targetFile = this.getFileForNewOfficeTrans(fileId, Datetimes.format(d, "yyyyMMdd"));
        if (targetFile != null) {
            String url = this.getShowUrlForNewOfficeTrans(targetFile, fileId, Datetimes.format(d, "yyyyMMdd"));
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = null;
            try {
                StatusLine statusLine;
                response = httpClient.execute((HttpUriRequest)httpGet);
                if (response != null && (statusLine = response.getStatusLine()).getStatusCode() != 200) {
                    log.info((Object)("\u5f02\u6b65\u8fdb\u884coffice\u8f6c\u6362\uff0cUrl\u4e3a" + url + ";result=" + statusLine.getStatusCode()));
                }
            }
            catch (Exception e) {
                log.error((Object)e.fillInStackTrace());
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.fillInStackTrace());
                }
            }
        }
    }
}

