/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.manager;

import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.office.rmi.OfficeTransService;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.RMIUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

@ProcessInDataSource(name=DataSourceName.BASE)
public class YongZhongOfficeTransManagerImpl {
    private static final String ERR_MSG_DECRYPT_ERROR = "\u89e3\u5bc6\u6587\u4ef6\u51fa\u9519\u3002";
    private OfficeTransManager officeTransManager;
    private FileManager fileManager;
    private static final String serviceName = "ctpOfficeTransService";
    private static final Log log = CtpLogFactory.getLog(YongZhongOfficeTransManagerImpl.class);

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public OfficeTransManager getOfficeTransManager() {
        return this.officeTransManager;
    }

    public void setOfficeTransManager(OfficeTransManager officeTransManager) {
        this.officeTransManager = officeTransManager;
    }

    public boolean checkService() {
        return null != this.getService();
    }

    public boolean isExist(long id, String date) {
        String outputPath = this.officeTransManager.getOfficeTransCacheFolder();
        File dir = new File(outputPath);
        File file = new File(outputPath + File.separator + date + File.separator + id + File.separator + "OK");
        return FileUtil.inDirectory(file, dir) && file.exists();
    }

    public void doGenerate(List<Long[]> f, List<Long[]> l) throws Exception {
        OfficeTransService service = this.getService();
        if (service == null) {
            return;
        }
        ArrayList<String[]> firstOfficeURL = null;
        if (f != null && !f.isEmpty()) {
            firstOfficeURL = new ArrayList<String[]>(f.size());
            for (Long[] o : f) {
                String filepath = this.getFilePath(o[0]);
                if (!Strings.isNotBlank(filepath)) continue;
                firstOfficeURL.add(new String[]{filepath, this.makeOutputFile(o[0], o[1])});
            }
        }
        ArrayList<String[]> lastOfficeURL = null;
        if (l != null && !l.isEmpty()) {
            lastOfficeURL = new ArrayList<String[]>(l.size());
            for (Long[] o : l) {
                String filepath = this.getFilePath(o[0]);
                if (!Strings.isNotBlank(filepath)) continue;
                lastOfficeURL.add(new String[]{filepath, this.makeOutputFile(o[0], o[1])});
            }
        }
        service.officeToHtml(firstOfficeURL, lastOfficeURL);
    }

    public String document2Pdf(long v3xFileId, Long v3xFileCreateDate) throws Exception {
        String targetFileName = this.makeDocument2PdfOutputFile(v3xFileId, v3xFileCreateDate);
        if (this.isExistDocument2Pdf(v3xFileId, v3xFileCreateDate)) {
            return targetFileName;
        }
        OfficeTransService service = this.getService();
        if (service == null) {
            throw new BusinessException(ResourceUtil.getString("system.officeTrans.msg.OfficeTransService.null"));
        }
        String sourceFileName = this.getFilePath(v3xFileId);
        service.document2Pdf(sourceFileName, targetFileName);
        if (this.isExistDocument2Pdf(v3xFileId, v3xFileCreateDate)) {
            return targetFileName;
        }
        throw new BusinessException(ResourceUtil.getString("system.officeTrans.msg.createFile.fail"));
    }

    private OfficeTransService getService() {
        OfficeTransService service;
        String host = this.officeTransManager.getOfficeTransHost();
        int port = this.officeTransManager.getOfficeTransPort();
        Class<OfficeTransService> serviceInterface = OfficeTransService.class;
        try {
            service = RMIUtil.getProxy(host, port, serviceName, serviceInterface);
        }
        catch (Throwable e) {
            String msg = "\u8bbf\u95ee\u6587\u4ef6\u8f6c\u6362\u670d\u52a1\u51fa\u9519\uff1a" + host + ":" + port + "/" + serviceName;
            log.error((Object)msg, e);
            return null;
        }
        return service;
    }

    private String makeOutputFile(long v3xFileId, long v3xFileCreateDate) {
        String outputPath = this.officeTransManager.getOfficeTransCacheFolder();
        Date d = new Date(v3xFileCreateDate);
        return outputPath + File.separator + Datetimes.format(d, "yyyyMMdd") + File.separator + v3xFileId + File.separator + v3xFileId + ".html";
    }

    private String makeDocument2PdfOutputFile(long v3xFileId, long v3xFileCreateDate) {
        String outputPath = this.officeTransManager.getOfficeTransCacheFolder();
        Date d = new Date(v3xFileCreateDate);
        return outputPath + File.separator + Datetimes.format(d, "yyyyMMdd") + File.separator + v3xFileId + "_DOC2PDF" + File.separator + v3xFileId + ".pdf";
    }

    private boolean isExistDocument2Pdf(long v3xFileId, long v3xFileCreateDate) {
        String outputPath = this.officeTransManager.getOfficeTransCacheFolder();
        File dir = new File(outputPath);
        File file = new File(this.makeDocument2PdfOutputFile(v3xFileId, v3xFileCreateDate));
        return FileUtil.inDirectory(file, dir) && file.exists();
    }

    private String getFilePath(long id) throws Exception {
        V3XFile file = this.fileManager.getV3XFile(id);
        if (file == null) {
            return null;
        }
        String newfilePath = this.decrypt(file);
        return newfilePath;
    }

    private String decrypt(V3XFile file) {
        String host = this.officeTransManager.getOfficeTransHost();
        File outputTempDir = this.officeTransManager.getOfficeTransOutputTempDir();
        long id = file.getId();
        String newfilePath = null;
        try {
            boolean isJinge;
            File f = this.fileManager.getFile(id, file.getCreateDate());
            if (f == null) {
                return null;
            }
            String mimeType = file.getMimeType();
            boolean bl = isJinge = "application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType) || "application/msword".equals(mimeType) || "application/vnd.ms-excel".equals(mimeType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType) || "msoffice".equals(mimeType) || "application/vnd.openxmlformats-officedocument.presentationml.presentation".equals(mimeType) || "application/vnd.ms-powerpoint".equals(mimeType) || "application/octet-stream".equals(mimeType);
            if (isJinge) {
                File officeFile = this.fileManager.getStandardOffice(id, file.getCreateDate());
                newfilePath = officeFile.getAbsolutePath();
            } else {
                newfilePath = CoderFactory.getInstance().decryptFileToTemp(f.getAbsolutePath());
            }
        }
        catch (Exception e1) {
            log.error((Object)ERR_MSG_DECRYPT_ERROR, (Throwable)e1);
        }
        if (Strings.isNotBlank(newfilePath) && !"127.0.0.1".equals(host)) {
            try {
                File srcFile = new File(newfilePath);
                File tempFile = new File(outputTempDir, srcFile.getName());
                FileUtils.copyFile((File)srcFile, (File)tempFile);
                return tempFile.getPath();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
        return newfilePath;
    }
}

